<?php

declare(strict_types=1);

namespace App\Xielei\Admin\Http\Home;

use App\Xielei\Admin\Traits\ResponseTrait;
use App\Xielei\Admin\Traits\RestfulTrait;
use Psr\Http\Message\ResponseFactoryInterface;
use Psr\Http\Message\ResponseInterface;
use Xielei\ImageCaptcha;
use Xielei\Session;

class Captcha
{

    use RestfulTrait;
    use ResponseTrait;

    public function get(
        Session $session,
        ResponseFactoryInterface $responseFactory,
        ImageCaptcha $captcha
    ): ResponseInterface {
        $num = mt_rand(1, 50);
        $max = mt_rand($num, $num + 50);
        $session->set('admin_captcha', $num);
        $response = $responseFactory->createResponse(200);
        $response->getBody()->write($captcha->create(($max - $num) . '+?=' . $max));
        return $response->withHeader('Content-Type', 'image/png');
    }
}
