<?php

declare(strict_types=1);

namespace App\Xielei\Admin\Middleware;

use Ebcms\App;
use Ebcms\Router;
use Psr\Http\Message\ResponseFactoryInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Xielei\Session;

class Auth implements MiddlewareInterface
{
    public function process(
        ServerRequestInterface $request,
        RequestHandlerInterface $handler
    ): ResponseInterface {
        return App::getInstance()->execute(function (
            Router $router,
            Session $session,
            ResponseFactoryInterface $responseFactory
        ) use ($request, $handler): ResponseInterface {
            if (!$session->get('admin')) {
                $session->set('login_redirect', $_SERVER['REQUEST_URI']);
                $response = $responseFactory->createResponse(302);
                return $response->withHeader('Location', $router->buildUrl('/xielei/admin/home/login'));
            }
            return $handler->handle($request);
        });
    }
}
