<?php

declare(strict_types=1);

namespace Xielei\Database;

abstract class Model
{

    protected $db;

    public function __construct(
        Db $db
    ) {
        $this->db = $db;
    }

    public function get($field = '*', $options = [])
    {
        return $this->db->get($this->getTable(), $field, $options);
    }

    public function select($field = '*', $options = []): array
    {
        return $this->db->select($this->getTable(), $field, $options);
    }

    public function insert(array $data = []): int
    {
        $this->db->insert($this->getTable(), $data);
        return (int) $this->db->id();
    }

    public function update(array $data, $where = []): bool
    {
        $this->db->update($this->getTable(), $data, $where);
        return true;
    }

    public function delete($where = []): bool
    {
        $this->db->delete($this->getTable(), $where);
        return true;
    }

    public function count($options = [])
    {
        return $this->db->count($this->getTable(), $options);
    }

    abstract public function getTable(): string;
}
