<?php

declare(strict_types=1);

namespace Xielei\FormBuilder\Field;

use Xielei\FormBuilder\ItemInterface;
use Xielei\Template;

class Custom implements ItemInterface
{

    public function __construct(string $tpl)
    {
        $this->_tpl = $tpl;
    }

    public function set(string $name, $value): self
    {
        if ($name != '_tpl') {
            $this->$name = $value;
        }
        return $this;
    }

    public function __toString()
    {
        return (new Template())->renderFromString($this->_tpl, get_object_vars($this));
    }
}
