<?php

declare(strict_types=1);

namespace Xielei\FormBuilder\Field;

use Xielei\FormBuilder\ItemInterface;
use Xielei\Template;

class SelectMultiple implements ItemInterface
{
    public $options = [];

    public function __construct(string $label, string $name, array $value = [], array $options = [])
    {
        $this->label = $label;
        $this->name = $name;
        $this->value = $value;
        $this->options = $options;
    }

    public function set(string $name, $value): self
    {
        $this->$name = $value;
        return $this;
    }

    private function getTpl(): string
    {
        return <<<'str'
<div class="form-group">
    <label for="field_{:md5($name)}">{$label}</label>
    <div>
        <select multiple name="{$name}[]" id="field_{:md5($name)}" class="custom-select">
            {foreach $options as $vo}
            {if isset($vo['group'])}
            <optgroup label="{$vo.label}">
                {foreach $vo['group'] as $_sub}
                <option value="{$_sub.value}" {if isset($_sub['disabled']) && $_sub['disabled']}disabled{else}{:in_array($_sub['value'], $value)?'selected':''}{/if}>{$_sub.label}</option>
                {/foreach}
            </optgroup>
            {else}
            <option value="{$vo.value}" {if isset($vo['disabled']) && $vo['disabled']}disabled{else}{:in_array($vo['value'], $value)?'selected':''}{/if}>{$vo.label}</option>
            {/if}
            {/foreach}
        </select>
    </div>
    {if isset($help) && $help}
    <small id="help_{:md5($name)}" class="form-text text-muted">{$help}</small>
    {/if}
</div>
str;
    }

    public function __toString()
    {
        return (new Template())->renderFromString($this->getTpl(), get_object_vars($this));
    }
}
