<?php

declare(strict_types=1);

namespace App\Xielei\Installer\Http;

use App\Xielei\Installer\Model\Config;
use Ebcms\App;
use PDO;
use Rah\Danpu\Dump;
use Rah\Danpu\Import;
use Xielei\RequestFilter;
use Xielei\Template;

class Index extends Common
{

    public function get(
        RequestFilter $input,
        Template $template
    ) {
        return $this->html($template->renderFromFile('/step' . $input->get('step', 0, ['intval'])));
    }

    public function post(
        Template $template,
        Config $configModel,
        Dump $dump,
        App $app,
        RequestFilter $input
    ) {
        try {
            $dump
                ->file($app->getAppPath() . '/install.sql')
                ->dsn('mysql:dbname=' . $input->post('database_name') . ';host=' . $input->post('database_server'))
                ->user($input->post('database_username'))
                ->pass($input->post('database_password'))
                ->attributes([
                    PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,
                ])
                ->tmp($app->getAppPath() . '/config');
            new Import($dump);

            $configModel->save([
                'xielei' => [
                    'database' => [
                        'database' => [
                            'database_name' => $input->post('database_name'),
                            'server' => $input->post('database_server'),
                            'username' => $input->post('database_username'),
                            'password' => $input->post('database_password'),
                        ],
                    ],
                ],
            ]);

            $account = 'admin';
            $password = substr(md5(uniqid()), 10, 10);

            $configModel->save([
                'xielei' => [
                    'admin' => [
                        'managers' => [
                            $account => [
                                'password' => $password,
                            ]
                        ],
                    ],
                ],
            ]);

            $configModel->save([
                'xielei' => [
                    'installer' => [
                        'lock' => 1,
                    ],
                ],
            ]);
        } catch (\Throwable $th) {
            return $this->failure('发生错误：' . $th->getMessage());
        }

        return $this->html($template->renderFromFile('/success', [
            'account' => $account,
            'password' => $password,
        ]));
    }
}
