<?php

declare(strict_types=1);

namespace App\Xielei\Installer\Middleware;

use Ebcms\App;
use Ebcms\Config;
use Ebcms\Router;
use Psr\Http\Message\ResponseFactoryInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;

class JumpInstaller implements MiddlewareInterface
{
    public function process(
        ServerRequestInterface $request,
        RequestHandlerInterface $handler
    ): ResponseInterface {
        return App::getInstance()->execute(function (
            App $app,
            Router $router,
            Config $config,
            ResponseFactoryInterface $responseFactory
        ) use ($request, $handler): ResponseInterface {
            if (!$config->get('lock@xielei.installer')) {
                if (strpos($app->getRequestTargetClass(), 'App\\Xielei\\Installer\\Http\\') !== 0) {
                    $response = $responseFactory->createResponse(302);
                    return $response->withHeader('Location', $router->buildUrl('/xielei/installer/index'));
                }
            }
            return $handler->handle($request);
        });
    }
}
