@extends('theme.default.pc.frame')

@section('pageTitle',$doc['title'])
@section('pageDescription',$doc['summary'])

@section('headScript')
    <link rel="stylesheet" href="@assets('assets/editor.md/css/editormd.preview.mz.css')">
    <style type="text/css">
        body {margin:0;padding:0;font-family: 'Helvetica Neue',Arial,'Hiragino Sans GB',STHeiti,'Microsoft YaHei','WenQuanYi Micro Hei',SimSun,Song,sans-serif;background: #F6F6F6;}
        body.locked{overflow:hidden;}
        @media screen and (min-width:800px) {
            #markdown_sidebar {width:200px;height:100%;position:fixed;top:0;left:0;overflow:hidden;z-index:100;border:1px solid #ddd;border-top:none;border-bottom:none;background:#F6F6F6;padding:0 10px;box-sizing:border-box;}
            #markdown_sidebar:hover {overflow:auto;}
            #markdown_sidebar > .markdown-body{background:none;width:auto;margin-left:-40px;}
            #markdown_sidebar h1 {margin:0;padding:0;font-size:1.6em;text-align:center;font-weight:bold;color:#999;border-bottom:1px dashed #CCC;line-height:80px;}
            #markdown_sidebar_expand{display:none;}
            #markdown_title{padding:0 40px 0 260px;font-size:30px;line-height:80px;margin:0;width:auto;text-align:center;color:#2c3f51;border-bottom:1px solid #CCC;font-weight:bold;max-width:900px;background:#FFF;border-right:1px solid #EEE;  }
            #markdown_view {padding:40px 40px 40px 260px;margin:0;width:auto;max-width:900px;background:#FFF;border-right:1px solid #EEE;}
        }
        @media screen and (max-width:799px) {
            .body-container{max-width:800px;margin:0 auto;padding:0;border:1px solid #CCC;width:100%;overflow: hidden;box-sizing: border-box;}
            #markdown_sidebar{transition:1s right;z-index:100;width:200px;padding:0;border-left:1px solid #ddd;background:#F6F6F6;position:fixed;right:-200px;top:0;bottom:0;box-sizing:border-box;overflow:auto;}
            #markdown_sidebar.show{right:0px;transition:1s right;}
            #markdown_sidebar > .markdown-body{background:none;width:100%;padding:20px 0;}
            #markdown_sidebar h1 {margin:0;padding:0;font-size: 1.5em;text-align: center;font-weight: bold;color:#999;border-bottom:1px dashed #CCC;line-height:40px;}
            #markdown_sidebar_expand{z-index:99;position:fixed;right:0px;top:30px;width:50px;height:30px;text-align:center;line-height:30px;border:1px solid #EEE;border-radius:5px 0 0 5px;font-size:12px;background:#FFF;box-sizing:border-box;}
            #markdown_title{padding:20px 0;font-size:1.8em;margin:0;width:auto;text-align: center;color:#2c3f51;border-bottom:1px solid #CCC;font-weight:bold;max-width:900px;background: #FFF;border-right:1px solid #EEE;}
            #markdown_view {margin: 0;width:auto;background: #FFF;border-right:1px solid #EEE;padding:10px;}
            #markdown_view *{white-space:pre-wrap;}
        }
    </style>
    <style type="text/css">{!! $doc['style'] or '' !!}</style>
@endsection

@section('bodyScript')
    @parent
    <script src="@assets('assets/editor.md/lib/marked.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/prettify.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/raphael.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/underscore.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/sequence-diagram.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/flowchart.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/jquery.flowchart.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/marked.min.js')"></script>
    <script src="@assets('assets/editor.md/editormd.js')"></script>
    <script type="text/javascript">
        $(function () {
            var $sidebar = $('#markdown_sidebar');
            $('#markdown_sidebar_expand').on('click',function () {
                if($sidebar.hasClass('show')){
                    $sidebar.removeClass('show');
                    $('body').removeClass('locked');
                }else{
                    $sidebar.addClass('show');
                    $('body').addClass('locked');
                }
                return false;
            });
            $(document).on('click',function () {
                if($sidebar.hasClass('show')){
                    $sidebar.removeClass('show');
                    $('body').removeClass('locked');
                }
            });
            editormd.markdownToHTML("markdown_view", {
                htmlDecode : "style,script,iframe|on*",
                tocContainer: "#custom_toc_container",
                markdownSourceCode: false,
                emoji: false,
                taskList: true,
                tex: true,
                flowChart: true,
                sequenceDiagram: true,
                onload: function(div){
                    div.find('.sequence-diagram > svg, .flowchart > svg').each(function(i,o){
                        try{
                            var width = $(o).attr('width'),
                                    height = $(o).attr('height');
                            //$(o).attr('viewBox','0 0 '+height+' '+width);
                            o.setAttribute('viewBox','0 0 '+width+' '+height);
                        }catch(e){}
                    });
                }
            });
        });
    </script>
@endsection

@section('body')
    <div class="body-container">
        <div id="markdown_title">
            {{$doc['title']}}
        </div>
        <div id="markdown_view">
            <textarea style="display:none;">{{$doc['content']}}</textarea>
        </div>
        <div id="markdown_sidebar_expand">目录</div>
        <div id="markdown_sidebar">
            <h1>目录</h1>
            <div class="markdown-body editormd-preview-container" id="custom_toc_container" ></div>
        </div>
    </div>
@endsection