<?php
 namespace TechSoft\Laravel\Report; use TechOnline\Laravel\Dao\ModelUtil; class ReportUtil { public static function countDaily($tableName, $tableWhere, $fromDay, $toDay) { $startTimestamp = strtotime($fromDay); $toTimestamp = strtotime($toDay); $reports = []; for ($timestamp = $startTimestamp; $timestamp <= $toTimestamp; $timestamp += 24 * 3600) { $reports[date('Y-m-d', $timestamp)] = null; } $counts = ModelUtil::model('report_count_daily') ->where(['tableName' => $tableName, 'tableWhere' => json_encode($tableWhere)]) ->where('day', '>=', $fromDay) ->where('day', '<=', $toDay) ->get(); foreach ($counts as $count) { $reports[date('Y-m-d', strtotime($count->day))] = $count->cnt; } foreach ($reports as $reportDay => $reportCount) { if (null === $reportCount) { $reports[$reportDay] = self::countDayFromTable($tableName, $tableWhere, $reportDay); } } return [ 'time' => array_keys($reports), 'value' => array_values($reports), ]; } public static function countDayFromTable($tableName, $tableWhere, $day, $insert = true) { $count = ModelUtil::model($tableName) ->where('created_at', '>=', date('Y-m-d 00:00:00', strtotime($day))) ->where('created_at', '<=', date('Y-m-d 23:59:59', strtotime($day))) ->where($tableWhere) ->count(); if ($insert && strtotime($day) < strtotime(date('Y-m-d', time()))) { ModelUtil::insert('report_count_daily', [ 'tableName' => $tableName, 'tableWhere' => json_encode($tableWhere), 'day' => $day, 'cnt' => $count, ]); } return $count; } public static function countHourly($tableName, $tableWhere, $fromDay, $toDay) { $startTimestamp = strtotime($fromDay); $toTimestamp = strtotime($toDay); $reports = []; for ($timestamp = $startTimestamp; $timestamp <= $toTimestamp; $timestamp += 3600) { $reports[date('Y-m-d H:i:s', $timestamp)] = null; } $counts = ModelUtil::model('report_count_hourly') ->where(['tableName' => $tableName, 'tableWhere' => json_encode($tableWhere)]) ->where('daytime', '>=', $fromDay) ->where('daytime', '<=', $toDay) ->get(); foreach ($counts as $count) { $reports[date('Y-m-d H:i:s', strtotime($count->daytime))] = $count->cnt; } foreach ($reports as $reportDaytime => $reportCount) { if (null === $reportCount) { $reports[$reportDaytime] = self::countHourFromTable($tableName, $tableWhere, $reportDaytime); } } return [ 'time' => array_keys($reports), 'value' => array_values($reports), ]; } public static function countHourFromTable($tableName, $tableWhere, $daytime, $insert = true) { $count = ModelUtil::model($tableName) ->where('created_at', '>=', date('Y-m-d H:i:s', strtotime($daytime))) ->where('created_at', '<=', date('Y-m-d H:i:s', strtotime($daytime) + 3600 - 1)) ->where($tableWhere) ->count(); if ($insert && strtotime($daytime) < strtotime(date('Y-m-d H:00:00', time()))) { ModelUtil::insert('report_count_hourly', [ 'tableName' => $tableName, 'tableWhere' => json_encode($tableWhere), 'daytime' => $daytime, 'cnt' => $count, ]); } return $count; } }