@extends('admin::frame')

@section('pageTitle','应用管理')

@section('bodyContent')

    <div class="block">
        <div class="body">
            <table class="uk-table uk-table-hover">
                <thead>
                    <tr>
                        <th>模块</th>
                        <th>版本</th>
                        <th>说明</th>
                        <th>状态</th>
                        <th width="100">操作</th>
                    </tr>
                </thead>
                <tbody>
                    @if(empty($locals))
                        <tr>
                            <td colspan="5">
                                <div class="ub-empty">暂无应用</div>
                            </td>
                        </tr>
                    @endif
                    @foreach($locals as $local)
                        <tr>
                            <td>
                                {{$local['title']}}
                            </td>
                            <td>v{{$local['version']}}</td>
                            <td>{{$local['desc']}}</td>
                            <td>
                                @if(in_array($local['name'],$enables))
                                    <span class="ub-text-success" style="line-height:24px;">已安装</span>
                                @else
                                    <span class="ub-text-default" style="line-height:24px;">未安装</span>
                                @endif
                            </td>
                            <td>
                                @if(in_array($local['name'],$enables))
                                    <a class="btn btn-sm btn-danger" href="javascript:;" data-ajax-request-loading data-ajax-request="{{action('\TechSoft\Laravel\Mod\ModManageAdminController@uninstall',['mod'=>$local['name']])}}">卸载</a>
                                @else
                                    <a class="btn btn-sm btn-success" href="javascript:;" data-ajax-request-loading data-ajax-request="{{action('\TechSoft\Laravel\Mod\ModManageAdminController@install',['mod'=>$local['name']])}}">安装</a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

@endsection