<?php

namespace App\Http\Controllers\Admin;

use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\ModelHelper;

class DocController extends AdminCheckController
{
    protected $cmsConfigBasic = [
        'model' => 'doc',
        'pageTitle' => '文档列表',
        'group' => 'data',
        'canAdd' => false,
        'canEdit' => false,
        'canDelete' => true,
        'canView' => true,
        'fields' => [
            'title' => ['type' => FieldText::class, 'title' => '标题', 'list' => true, 'view' => true,],
            'content' => ['type' => FieldTextarea::class, 'title' => '内容', 'view' => true,],
        ]
    ];

    public function dataPostDelete(&$data)
    {
        ModelHelper::delete('doc_history', ['docId' => $data['id']]);
    }

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);;
    }

    public function dataDelete(BasicCms $basicCms)
    {
        return $basicCms->executeDelete($this, $this->cmsConfigBasic);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        return $basicCms->executeEdit($this, $this->cmsConfigBasic);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        return $basicCms->executeAdd($this, $this->cmsConfigBasic);
    }

    public function dataView(BasicCms $basicCms)
    {
        return $basicCms->executeView($this, $this->cmsConfigBasic);
    }

}