<?php

namespace App\Http\Controllers\Main;


use App\Http\Controllers\Support\BaseController;
use App\Types\DocVisit;
use Edwin404\Base\Support\MarkdownHelper;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;

class DocController extends BaseController
{
    public function index($docAlias)
    {
        $doc = ModelHelper::load('doc', ['alias' => $docAlias]);
        if (empty($doc)) {
            return Response::send(-1, '文档不存在', null, '/');
        }

        switch ($doc['visit']) {
            case DocVisit::VISIT_PUBLIC:
                break;
            case DocVisit::VISIT_PRIVATE:
                return Response::send(-1, '您访问的文档为私密文档');
            case DocVisit::VISIT_PASSWORD:
                if ($doc['visit'] == DocVisit::VISIT_PASSWORD) {
                    if (Request::isMethod('post')) {
                        $password = Input::get('password');
                        if ($doc['visitPassword'] != $password) {
                            return Response::send(-1, '密码不正确');
                        }
                        Session::put('docVisitPassword-' . $doc['id'], true);
                        return Response::send(0, null, null, '[reload]');
                    }
                    if (!Session::get('docVisitPassword-' . $doc['id'], false)) {
                        return $this->_view('doc.password', compact('doc'));
                    }
                }
        }

        $doc['content'] = MarkdownHelper::replaceImageSrcToCDN($doc['content']);

        return $this->_view('doc.index', compact('doc'));
    }

    public function download($docAlias)
    {
        if (!$this->memberUserId()) {
            return Response::send(-1, '请您登录', null, '/');
        }

        $doc = ModelHelper::load('doc', ['alias' => $docAlias]);
        if (empty($doc)) {
            return Response::send(-1, '文档不存在', null, '/');
        }
        if ($doc['memberUserId'] != $this->memberUserId()) {
            return Response::send(-1, '非法请求');
        }

        $doc['content'] = MarkdownHelper::replaceImageSrcToCDN($doc['content']);

        return $this->_view('doc.download', compact('doc'));
    }
}