<?php

namespace App\Http\Controllers\Main;

use App\Http\Controllers\Support\BaseController;
use Edwin404\Banner\Services\BannerService;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Forum\Services\ForumService;
use Edwin404\Tecmz\Traits\MemberAccountTrait;

class IndexController extends BaseController
{
    use MemberAccountTrait;

    public function index(BannerService $bannerService)
    {
        $banners = $bannerService->listByPositionWithCache('pcHome');
        return $this->_view('index', compact('banners'));
    }

    public function demo()
    {
        return $this->_view('demo');
    }
}