<?php

namespace App\Http\Controllers\Main;


use App\Constant\AppConstant;
use App\Http\Controllers\Support\BaseController;
use App\Types\DocVisit;
use Edwin404\Base\Support\InputHelper;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\PageHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Forum\Helpers\PostHelper;
use Edwin404\Forum\Services\ForumService;
use Edwin404\Member\Services\MemberService;
use Edwin404\Member\Support\MemberLoginCheck;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Str;

class MemberDocController extends BaseController implements MemberLoginCheck
{
    public function index()
    {
        return $this->_view('member.doc.index');
    }

    public function bookList()
    {
        $books = [
            [
                'id' => 0,
                'title' => '全部',
            ]
        ];
        $books = array_merge($books, ModelHelper::find('book', ['memberUserId' => $this->memberUserId()]));
        return Response::json(0, null, [
            'books' => $books
        ]);
    }

    public function bookEdit()
    {
        $id = intval(Input::get('id'));
        $title = trim(Input::get('title'));
        if (empty($title)) {
            return Response::send(-1, 'title empty');
        }
        if ($id) {
            $book = ModelHelper::load('book', ['id' => $id, 'memberUserId' => $this->memberUserId()]);
            if (empty($book)) {
                return Response::send(-1, 'book not found');
            }
        } else {
            $book = null;
        }
        $data = [];
        $data['title'] = $title;
        if ($book) {
            ModelHelper::updateOne('book', ['id' => $book['id']], $data);
        } else {
            $data['memberUserId'] = $this->memberUserId();
            ModelHelper::add('book', $data);
        }
        return Response::send(0, null);
    }

    public function bookDelete()
    {
        $id = intval(Input::get('id'));
        $book = ModelHelper::load('book', ['id' => $id, 'memberUserId' => $this->memberUserId()]);
        if (empty($book)) {
            return Response::send(-1, 'book not found');
        }
        ModelHelper::update('doc', ['bookId' => $book['id']], ['bookId' => 0]);
        ModelHelper::delete('book', ['id' => $book['id']]);
        return Response::send(0, null);
    }

    public function docList()
    {
        $page = Input::get('page');
        $pageSize = 10;
        $option = [];
        $option['where'] = [];
        $option['where']['memberUserId'] = $this->memberUserId();
        $option['order'] = [];
        $option['order'][] = ['updated_at', 'desc'];

        $bookId = Input::get('bookId');
        if ($bookId) {
            $option['where']['bookId'] = $bookId;
        }

        $keywords = Input::get('keywords');
        if ($keywords) {
            $option['whereOperate'] = ['title', 'like', '%' . $keywords . '%'];
        }

        $paginateData = ModelHelper::modelPaginate('doc', $page, $pageSize, $option);

        $docs = [];
        foreach ($paginateData['records'] as $record) {
            $docs[] = [
                'id' => $record['id'],
                'title' => $record['title'],
                'summary' => $record['summary'],
                'time' => $record['updated_at'],
                'visit' => $record['visit'],
            ];
        }

        $paginateData = ModelHelper::modelPaginate('doc', $page + 1, $pageSize, $option);
        $hasMore = empty($paginateData['records']) ? false : true;

        return Response::send(0, null, compact('docs', 'page', 'hasMore'));
    }

    public function docEdit()
    {
        $id = intval(Input::get('id'));
        $data = [];
        $data['bookId'] = intval(Input::get('bookId'));
        $data['title'] = trim(Input::get('title'));
        $data['content'] = trim(Input::get('content'));

        if (empty($data['bookId']) || empty($data['title']) || empty($data['content'])) {
            return Response::send(-1, 'save content incorrect');
        }

        if ($id) {
            $doc = ModelHelper::load('doc', ['id' => $id, 'memberUserId' => $this->memberUserId()]);
            if (empty($doc)) {
                return Response::send(-1, 'doc not found');
            }
        } else {
            $doc = null;
        }

        $data['summary'] = $data['content'];

        if ($doc) {

            if ($doc['content'] != $data['content']) {

                ModelHelper::add('doc_history', [
                    'docId' => $doc['id'],
                    'content' => $doc['content'],
                ]);

                $oldHistory = ModelHelper::model('doc_history')
                    ->where(['docId' => $doc['id'],])
                    ->select('id')
                    ->orderBy('id', 'desc')
                    ->limit(AppConstant::DOC_HISTORY_KEEP)
                    ->get()
                    ->toArray();
                $minId = $oldHistory[count($oldHistory) - 1]['id'];
                ModelHelper::model('doc_history')
                    ->where(['docId' => $doc['id'],])
                    ->where('id', '<', $minId)
                    ->delete();

            }

            $doc = ModelHelper::updateOne('doc', ['id' => $doc['id']], $data);
        } else {
            $data['memberUserId'] = $this->memberUserId();
            $data['alias'] = strtolower(Str::random(20));
            $data['visit'] = DocVisit::VISIT_PUBLIC;
            $doc = ModelHelper::add('doc', $data);
        }
        return Response::send(0, null, compact('doc'));
    }

    public function docEditVisit()
    {
        $id = intval(Input::get('id'));
        $data = [];
        $data['visit'] = InputHelper::getType('visit', DocVisit::class, DocVisit::VISIT_PUBLIC);
        $data['visitPassword'] = trim(Input::get('visitPassword'));

        $doc = ModelHelper::updateOne('doc', ['id' => $id, 'memberUserId' => $this->memberUserId()], $data);
        return Response::send(0, null);
    }

    public function docDelete()
    {
        $id = intval(Input::get('id'));
        $doc = ModelHelper::load('doc', ['id' => $id, 'memberUserId' => $this->memberUserId()]);
        if (empty($doc)) {
            return Response::send(-1, 'doc not exists');
        }
        ModelHelper::delete('doc', ['id' => $doc['id']]);
        return Response::send(0, null);
    }

    public function docLoad()
    {
        $id = intval(Input::get('id'));
        $doc = ModelHelper::load('doc', ['id' => $id, 'memberUserId' => $this->memberUserId()]);
        if (empty($doc)) {
            return Response::send(-1, 'doc not exists');
        }

        return Response::send(0, null, compact('doc'));
    }

    public function docHistory()
    {
        $id = intval(Input::get('id'));
        $doc = ModelHelper::load('doc', ['id' => $id, 'memberUserId' => $this->memberUserId()]);
        if (empty($doc)) {
            return Response::send(-1, 'doc not exists');
        }
        $id = intval(Input::get('id'));
        $histories = ModelHelper::model('doc_history')->where(['docId' => $doc['id']])->orderBy('id', 'desc')->get()->toArray();
        foreach ($histories as &$history) {
            unset($history['id'], $history['docId'], $history['updated_at']);
        }
        return Response::send(0, null, compact('histories'));
    }

}