<?php

Route::group(
    [
        'middleware' => [
            \Edwin404\Base\Support\BaseMiddleware::class,
            \App\Http\Middleware\MemberAuth::class,
        ]
    ],
    function () {

        Route::match(['get', 'post'], '', '\App\Http\Controllers\Main\IndexController@index');

        Route::match(['get', 'post'], 'login', '\App\Http\Controllers\Main\IndexController@login');
        Route::match(['get', 'post'], 'logout', '\App\Http\Controllers\Main\IndexController@logout');
        Route::match(['get', 'post'], 'register', '\App\Http\Controllers\Main\IndexController@register');
        Route::match(['get', 'post'], 'retrieve', '\App\Http\Controllers\Main\IndexController@retrieve');
        Route::match(['get', 'post'], 'retrieve/email', '\App\Http\Controllers\Main\IndexController@retrieveEmail');
        Route::match(['get', 'post'], 'retrieve/email_verify', '\App\Http\Controllers\Main\IndexController@retrieveEmailVerify');
        Route::match(['get', 'post'], 'retrieve/phone', '\App\Http\Controllers\Main\IndexController@retrievePhone');
        Route::match(['get', 'post'], 'retrieve/phone_verify', '\App\Http\Controllers\Main\IndexController@retrievePhoneVerify');
        Route::match(['get', 'post'], 'retrieve/captcha', '\App\Http\Controllers\Main\IndexController@retrieveCaptcha');
        Route::match(['get', 'post'], 'retrieve/reset', '\App\Http\Controllers\Main\IndexController@retrieveReset');
        Route::match(['get', 'post'], 'oauth_login_{oauthType}', '\App\Http\Controllers\Main\IndexController@oauthLogin');
        Route::match(['get', 'post'], 'oauth_callback_{oauthType}', '\App\Http\Controllers\Main\IndexController@oauthCallback');
        Route::match(['get', 'post'], 'oauth_bind_{oauthType}', '\App\Http\Controllers\Main\IndexController@oauthBind');


        Route::match(['get', 'post'], 'data/image_select_dialog', '\App\Http\Controllers\Main\DataController@imageSelectDialog');
        Route::match(['get', 'post'], 'data/temp_upload/{category}', '\App\Http\Controllers\Main\DataController@tempUpload');

        Route::match(['get', 'post'], 'member', '\App\Http\Controllers\Main\MemberController@index');

        Route::match(['get', 'post'], 'member/doc', '\App\Http\Controllers\Main\MemberDocController@index');
        Route::match(['get', 'post'], 'member/doc/book_list', '\App\Http\Controllers\Main\MemberDocController@bookList');
        Route::match(['get', 'post'], 'member/doc/book_edit', '\App\Http\Controllers\Main\MemberDocController@bookEdit');
        Route::match(['get', 'post'], 'member/doc/book_delete', '\App\Http\Controllers\Main\MemberDocController@bookDelete');
        Route::match(['get', 'post'], 'member/doc/doc_list', '\App\Http\Controllers\Main\MemberDocController@docList');
        Route::match(['get', 'post'], 'member/doc/doc_edit', '\App\Http\Controllers\Main\MemberDocController@docEdit');
        Route::match(['get', 'post'], 'member/doc/doc_edit_visit', '\App\Http\Controllers\Main\MemberDocController@docEditVisit');
        Route::match(['get', 'post'], 'member/doc/doc_delete', '\App\Http\Controllers\Main\MemberDocController@docDelete');
        Route::match(['get', 'post'], 'member/doc/doc_load', '\App\Http\Controllers\Main\MemberDocController@docLoad');
        Route::match(['get', 'post'], 'member/doc/doc_history', '\App\Http\Controllers\Main\MemberDocController@docHistory');

        Route::match(['get', 'post'], 'member/profile_captcha', '\App\Http\Controllers\Main\MemberProfileController@captcha');
        Route::match(['get', 'post'], 'member/profile', '\App\Http\Controllers\Main\MemberProfileController@index');
        Route::match(['get', 'post'], 'member/profile_password', '\App\Http\Controllers\Main\MemberProfileController@password');
        Route::match(['get', 'post'], 'member/profile_avatar', '\App\Http\Controllers\Main\MemberProfileController@avatar');
        Route::match(['get', 'post'], 'member/profile_email', '\App\Http\Controllers\Main\MemberProfileController@email');
        Route::match(['get', 'post'], 'member/profile_email_verify', '\App\Http\Controllers\Main\MemberProfileController@emailVerify');
        Route::match(['get', 'post'], 'member/profile_phone', '\App\Http\Controllers\Main\MemberProfileController@phone');
        Route::match(['get', 'post'], 'member/profile_phone_verify', '\App\Http\Controllers\Main\MemberProfileController@phoneVerify');
        Route::match(['get', 'post'], 'member/profile_setting', '\App\Http\Controllers\Main\MemberProfileController@setting');

        Route::match(['get', 'post'], 'member/message', '\App\Http\Controllers\Main\MemberMessageController@index');
        Route::match(['get', 'post'], 'member/message_mark_read', '\App\Http\Controllers\Main\MemberMessageController@markRead');
        Route::match(['get', 'post'], 'member/message_mark_read_all', '\App\Http\Controllers\Main\MemberMessageController@markReadAll');

        Route::match(['get', 'post'], 'r/{docAlias}', '\App\Http\Controllers\Main\DocController@index')->where(['docAlias' => '[a-z0-9]+']);
        Route::match(['get', 'post'], 'r/{docAlias}/download', '\App\Http\Controllers\Main\DocController@download')->where(['docAlias' => '[a-z0-9]+']);

    }
);

Route::match(['get', 'post'], 'placeholder/{width}x{height}', '\Edwin404\Placeholder\Controllers\PlaceholderController@index');
Route::match(['get', 'post'], 'install/ping', '\Edwin404\Tecmz\Controllers\InstallController@ping');
Route::match(['get', 'post'], 'install/execute', '\Edwin404\Tecmz\Controllers\InstallController@execute');
Route::match(['get', 'post'], 'install/lock', '\Edwin404\Tecmz\Controllers\InstallController@lock');

include __DIR__ . '/routes_admin.php';
