"use strict";var os=require("os"),gulp=require("gulp"),gutil=require("gulp-util"),sass=require("gulp-ruby-sass"),jshint=require("gulp-jshint"),uglify=require("gulp-uglifyjs"),rename=require("gulp-rename"),concat=require("gulp-concat"),notify=require("gulp-notify"),header=require("gulp-header"),minifycss=require("gulp-minify-css"),pkg=require("./package.json"),dateFormat=require("dateformatter").format,replace=require("gulp-replace");pkg.name="Editor.md",pkg.today=dateFormat;var headerComment=["/*"," * <%= pkg.name %>"," *"," * @file        <%= fileName(file) %> "," * @version     v<%= pkg.version %> "," * @description <%= pkg.description %>"," * @license     MIT License"," * @author      <%= pkg.author %>"," * {@link       <%= pkg.homepage %>}"," * @updateTime  <%= pkg.today('Y-m-d') %>"," */","\r\n"].join("\r\n"),headerMiniComment="/*! <%= pkg.name %> v<%= pkg.version %> | <%= fileName(file) %> | <%= pkg.description %> | MIT License | By: <%= pkg.author %> | <%= pkg.homepage %> | <%=pkg.today('Y-m-d') %> */\r\n",scssTask=function(e,r){r=r||"scss/";return sass(r+e+".scss",{style:"expanded",sourcemap:!1,noCache:!0}).pipe(gulp.dest("css")).pipe(header(headerComment,{pkg:pkg,fileName:function(e){return e.path.split(e.base)[1].replace("\\","")}})).pipe(gulp.dest("css")).pipe(rename({suffix:".min"})).pipe(gulp.dest("css")).pipe(minifycss()).pipe(gulp.dest("css")).pipe(header(headerMiniComment,{pkg:pkg,fileName:function(e){return e.path.split(e.base)[1].replace("\\","")}})).pipe(gulp.dest("css")).pipe(notify({message:e+".scss task completed!"}))};gulp.task("scss",function(){return scssTask("editormd")}),gulp.task("scss2",function(){return scssTask("editormd.preview")}),gulp.task("scss3",function(){return scssTask("editormd.logo")}),gulp.task("js",function(){return gulp.src("./src/editormd.js").pipe(jshint("./.jshintrc")).pipe(jshint.reporter("default")).pipe(header(headerComment,{pkg:pkg,fileName:function(e){return e.path.split(e.base)[1].replace(/[\\\/]?/,"")}})).pipe(gulp.dest("./")).pipe(rename({suffix:".min"})).pipe(uglify()).pipe(gulp.dest("./")).pipe(header(headerMiniComment,{pkg:pkg,fileName:function(e){return e.path.split(e.base+("win32"===os.platform()?"\\":"/"))[1].replace(/[\\\/]?/,"")}})).pipe(gulp.dest("./")).pipe(notify({message:"editormd.js task complete"}))}),gulp.task("amd",function(){var e=['var cmModePath  = "codemirror/mode/";','            var cmAddonPath = "codemirror/addon/";',"","            var codeMirrorModules = [",'                "jquery", "marked", "prettify",','                "katex", "raphael", "underscore", "flowchart",  "jqueryflowchart",  "sequenceDiagram",',"",'                "codemirror/lib/codemirror",','                cmModePath + "css/css",','                cmModePath + "sass/sass",','                cmModePath + "shell/shell",','                cmModePath + "sql/sql",','                cmModePath + "clike/clike",','                cmModePath + "php/php",','                cmModePath + "xml/xml",','                cmModePath + "markdown/markdown",','                cmModePath + "javascript/javascript",','                cmModePath + "htmlmixed/htmlmixed",','                cmModePath + "gfm/gfm",','                cmModePath + "http/http",','                cmModePath + "go/go",','                cmModePath + "dart/dart",','                cmModePath + "coffeescript/coffeescript",','                cmModePath + "nginx/nginx",','                cmModePath + "python/python",','                cmModePath + "perl/perl",','                cmModePath + "lua/lua",','                cmModePath + "r/r", ','                cmModePath + "ruby/ruby", ','                cmModePath + "rst/rst",','                cmModePath + "smartymixed/smartymixed",','                cmModePath + "vb/vb",','                cmModePath + "vbscript/vbscript",','                cmModePath + "velocity/velocity",','                cmModePath + "xquery/xquery",','                cmModePath + "yaml/yaml",','                cmModePath + "erlang/erlang",','                cmModePath + "jade/jade",',"",'                cmAddonPath + "edit/trailingspace", ','                cmAddonPath + "dialog/dialog", ','                cmAddonPath + "search/searchcursor", ','                cmAddonPath + "search/search", ','                cmAddonPath + "scroll/annotatescrollbar", ','                cmAddonPath + "search/matchesonscrollbar", ','                cmAddonPath + "display/placeholder", ','                cmAddonPath + "edit/closetag", ','                cmAddonPath + "fold/foldcode",','                cmAddonPath + "fold/foldgutter",','                cmAddonPath + "fold/indent-fold",','                cmAddonPath + "fold/brace-fold",','                cmAddonPath + "fold/xml-fold", ','                cmAddonPath + "fold/markdown-fold",','                cmAddonPath + "fold/comment-fold", ','                cmAddonPath + "mode/overlay", ','                cmAddonPath + "selection/active-line", ','                cmAddonPath + "edit/closebrackets", ','                cmAddonPath + "display/fullscreen",','                cmAddonPath + "search/match-highlighter"',"            ];","","            define(codeMirrorModules, factory);"].join("\r\n"),r=['if (typeof define == "function" && define.amd) {',"       $          = arguments[0];","       marked     = arguments[1];","       prettify   = arguments[2];","       katex      = arguments[3];","       Raphael    = arguments[4];","       _          = arguments[5];","       flowchart  = arguments[6];","       CodeMirror = arguments[9];","   }"].join("\r\n");gulp.src("src/editormd.js").pipe(rename({suffix:".amd"})).pipe(gulp.dest("./")).pipe(header(headerComment,{pkg:pkg,fileName:function(e){return e.path.split(e.base)[1].replace(/[\\\/]?/,"")}})).pipe(gulp.dest("./")).pipe(replace("/* Require.js define replace */",e)).pipe(gulp.dest("./")).pipe(replace("/* Require.js assignment replace */",r)).pipe(gulp.dest("./")).pipe(rename({suffix:".min"})).pipe(uglify()).pipe(gulp.dest("./")).pipe(header(headerMiniComment,{pkg:pkg,fileName:function(e){return e.path.split(e.base+("win32"===os.platform()?"\\":"/"))[1].replace(/[\\\/]?/,"")}})).pipe(gulp.dest("./")).pipe(notify({message:"amd version task complete"}))});var codeMirror={path:{src:{mode:"lib/codemirror/mode",addon:"lib/codemirror/addon"},dist:"lib/codemirror"},modes:["css","sass","shell","sql","clike","php","xml","markdown","javascript","htmlmixed","gfm","http","go","dart","coffeescript","nginx","python","perl","lua","r","ruby","rst","smartymixed","vb","vbscript","velocity","xquery","yaml","erlang","jade"],addons:["edit/trailingspace","dialog/dialog","search/searchcursor","search/search","scroll/annotatescrollbar","search/matchesonscrollbar","display/placeholder","edit/closetag","fold/foldcode","fold/foldgutter","fold/indent-fold","fold/brace-fold","fold/xml-fold","fold/markdown-fold","fold/comment-fold","mode/overlay","selection/active-line","edit/closebrackets","display/fullscreen","search/match-highlighter"]};gulp.task("cm-mode",function(){var e=[codeMirror.path.src.mode+"/meta.js"];for(var r in codeMirror.modes){var a=codeMirror.modes[r];e.push(codeMirror.path.src.mode+"/"+a+"/"+a+".js")}return gulp.src(e).pipe(concat("modes.min.js")).pipe(gulp.dest(codeMirror.path.dist)).pipe(uglify()).pipe(gulp.dest(codeMirror.path.dist)).pipe(header(headerMiniComment,{pkg:pkg,fileName:function(e){var r=e.path.split(e.base+"\\");return(r[1]?r[1]:r[0]).replace(/\\/g,"")}})).pipe(gulp.dest(codeMirror.path.dist)).pipe(notify({message:"codemirror-mode task complete!"}))}),gulp.task("cm-addon",function(){var e=[];for(var r in codeMirror.addons){var a=codeMirror.addons[r];e.push(codeMirror.path.src.addon+"/"+a+".js")}return gulp.src(e).pipe(concat("addons.min.js")).pipe(gulp.dest(codeMirror.path.dist)).pipe(uglify()).pipe(gulp.dest(codeMirror.path.dist)).pipe(header(headerMiniComment,{pkg:pkg,fileName:function(e){var r=e.path.split(e.base+"\\");return(r[1]?r[1]:r[0]).replace(/\\/g,"")}})).pipe(gulp.dest(codeMirror.path.dist)).pipe(notify({message:"codemirror-addon.js task complete"}))}),gulp.task("watch",function(){gulp.watch("scss/editormd.scss",["scss"]),gulp.watch("scss/editormd.preview.scss",["scss","scss2"]),gulp.watch("scss/editormd.logo.scss",["scss","scss3"]),gulp.watch("src/editormd.js",["js","amd"])}),gulp.task("default",function(){gulp.run("scss"),gulp.run("scss2"),gulp.run("scss3"),gulp.run("js"),gulp.run("amd"),gulp.run("cm-addon"),gulp.run("cm-mode")});