@extends('theme.default.pc.frame')

@section('pageTitle',$doc['title'])

@section('headScript')
    <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
    <link rel="stylesheet" href="@assets('assets/editor.md/css/editormd.preview.mz.css')">
    <style type="text/css">
        body {margin:0;padding:0;font-family: 'Helvetica Neue',Arial,'Hiragino Sans GB',STHeiti,'Microsoft YaHei','WenQuanYi Micro Hei',SimSun,Song,sans-serif;background: #F6F6F6;-webkit-print-color-adjust: exact;}
        body .body-container{max-width:800px;margin:0 auto;background:#FFF;}
        body .print-page-breaker{page-break-after:always;}
        #print_box{text-align:center;padding:20px 0;}
        #print_tip{text-align:center;color:#999;padding:20px 0;}
        #markdown_title{padding:150px 10px 10px 10px;font-size:30px;line-height:80px;width:auto;text-align:center;color:#2c3f51;font-weight:bold;max-width:900px;}
        #markdown_info{text-align:center;padding:50px 0 0 0;}
        #markdown_info .line{font-weight:normal;}
        #markdown_toc h2{text-align:center;border-bottom:1px solid #EEE;font-size:20px;line-height:80px;}
        #markdown_toc .markdown-body{box-sizing:border-box;}
        #header{text-align:center;}
        #header img{width:100%;}
        #markdown_view {box-sizing:border-box;}
        @media print {
            .tecmz-service-box{display:none !important;}
            #print_box{display:none;}
            #print_tip{display:none;}
            *{page-break-inside: avoid;}
        }
        @page{size: A4;margin:20mm;}
        @page:first{margin-top:10mm;}
    </style>
@endsection

@section('bodyScript')
    @parent
    <script src="@assets('assets/editor.md/lib/marked.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/prettify.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/raphael.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/underscore.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/sequence-diagram.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/flowchart.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/jquery.flowchart.min.js')"></script>
    <script src="@assets('assets/editor.md/lib/marked.min.js')"></script>
    <script src="@assets('assets/editor.md/editormd.js')"></script>
    <script type="text/javascript">
        $(function () {
            editormd.markdownToHTML("markdown_view", {
                htmlDecode : "style,script,iframe|on*",
                tocContainer: "#custom_toc_container",
                markdownSourceCode: false,
                emoji: false,
                taskList: true,
                tex: true,
                flowChart: true,
                sequenceDiagram: true,
                onload: function(div){
                    div.find('.sequence-diagram > svg, .flowchart > svg').each(function(i,o){
                        try{
                            var width = $(o).attr('width'),
                                    height = $(o).attr('height');
                            //$(o).attr('viewBox','0 0 '+height+' '+width);
                            o.setAttribute('viewBox','0 0 '+width+' '+height);
                        }catch(e){}
                    });
                }
            });
        });
    </script>
@endsection

@section('body')
    <div id="print_box">
        <button class="uk-button uk-button-large uk-button-primary" onclick="window.print();">点击打印 <i class="uk-icon-print"></i> 或 另存为PDF <i class="uk-icon-file"></i></button>
    </div>
    <div id="print_tip">
        页眉可以在 “我的资料” &gt; “<a href="/member/profile_setting" target="_blank">文档设置</a>” 中更换
    </div>
    <div class="body-container">
        <div id="header">
            <img src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fixOrDefault($_memberUser['docPrintHeader'],'theme/default/pc/image/docPrintHeader.png')}}" />
        </div>
        <div id="markdown_title">
            {{$doc['title']}}
        </div>
        <div id="markdown_info">
            <div class="line">
                时间：{{\Carbon\Carbon::now()->format('Y-m-d')}}
            </div>
        </div>
        <div class="print-page-breaker"></div>
        <div id="markdown_toc">
            <h2><i class="uk-icon-list"></i> 目录</h2>
            <div class="markdown-body editormd-preview-container" id="custom_toc_container"></div>
        </div>
        <div class="print-page-breaker"></div>
        <div id="markdown_view">
            <textarea style="display:none;">{{$doc['content']}}</textarea>
        </div>
    </div>
@endsection