<!doctype html>
<html class="no-js">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fixOrDefault(\Edwin404\Config\Facades\ConfigFacade::get('siteFavIco'),'default_favicon.ico')}}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="keywords" content="@yield('pageKeywords',\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\Edwin404\Config\Facades\ConfigFacade::get('siteDescription'))">
    <meta name="viewport" content="width=device-width, minimum-scale=0.5, maximum-scale=5, user-scalable=no">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp"/>
    <script src="@assets('assets/init.js')"></script>
    <title>@section('pageTitle')@yield('pageTitleMain') - {{\Edwin404\Config\Facades\ConfigFacade::get('siteName')}}@show</title>
    @section('headScript')
        <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
        <link rel="stylesheet" href="@assets('theme/default/pc/css/style.css')"/>
    @show
    @section('headAppend')@show
    {!! \Edwin404\Config\Facades\ConfigFacade::get('systemCounter') !!}
</head>
<body>
@section('body')

    @include('base::browserOutdated')

    <header>
        <div class="main-container @if($request_path!='/member/doc') main-container-limit @endif">
            <nav class="uk-navbar">
                <ul class="uk-navbar-nav uk-navbar-nav-right">
                    @if(empty($_memberUser))
                        <li><a href="/login">登录</a></li>
                    @else
                        <li class="uk-parent" data-uk-dropdown>
                            <a href="javascript:;" class="username">{{$_memberUser['username']}}</a>
                            <div class="uk-dropdown uk-dropdown-navbar uk-dropdown-bottom" style="top: 40px; left: 0px;">
                                <ul class="uk-nav uk-nav-navbar">
                                    {{--<li><a href="/member"><i class="uk-icon-user"></i> 个人中心</a></li>--}}
                                    <li><a href="/member/profile"><i class="uk-icon-cog"></i> 我的资料</a></li>
                                    <li><a data-confirm="确定退出?" data-href="/logout"><i class="uk-icon-sign-out"></i> 退出</a></li>
                                </ul>
                            </div>
                        </li>
                    @endif
                </ul>
                <a class="uk-navbar-brand" href="/"><img src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fixOrDefault(\Edwin404\Config\Facades\ConfigFacade::get('siteLogo'),'/placeholder/120x50')}}" /></a>
                <ul class="uk-navbar-nav">
                    @section('headerMenu')
                        <li><a href="/">首页</a></li>
                        <li><a href="/member/doc">写作模式</a></li>
                    @show
                </ul>
            </nav>
        </div>
    </header>

    @section('bodyContent')@show

    @section('footer')
        <footer>
            <div class="main-container">
                <div class="copyright">
                    <a href="http://www.miitbeian.gov.cn" target="_blank" style="color:#EEE;">{{\Edwin404\Config\Facades\ConfigFacade::get('siteBeian','[网站备案信息]')}}</a>
                    &copy;
                    {{\Edwin404\Config\Facades\ConfigFacade::get('siteDomain')}}
                </div>
            </div>
        </footer>
    @show

@show
@section('bodyScript')
    <script src="@assets('assets/main/js/basic.js')"></script>
@show
@section('bodyAppend')@show
</body>
</html>
