@extends('theme.default.pc.frame')

@section('pageTitle',\Edwin404\Config\Facades\ConfigFacade::get('siteName'))

@section('bodyScript')
    @parent
    <script>
        var swiper = new Swiper('.page-block-banner .swiper-container', {
            pagination: '.swiper-pagination',
            paginationClickable: '.swiper-pagination',
            nextButton: '.swiper-button-next',
            prevButton: '.swiper-button-prev',
            loop: true
        });
    </script>
@endsection

@section('bodyContent')


    <div class="main-container">

        <div class="page-block page-block-banner">
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    @if(empty($banners))
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x500');"></a>
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x500');"></a>
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x500');"></a>
                    @else
                        @foreach($banners as $banner)
                            <a class="swiper-slide"
                               style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($banner['image'])}});"
                               @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                        @endforeach
                    @endif
                </div>
                <div class="swiper-pagination swiper-pagination-white"></div>
                <div class="swiper-button-next swiper-button-white"></div>
                <div class="swiper-button-prev swiper-button-white"></div>
            </div>
        </div>

    </div>

    <div class="main-container main-container-limit">

        <div class="page-block page-block-feature">
            <div class="uk-grid">
                <div class="uk-width-1-4">
                    <div class="item">
                        <div class="icon">
                            <i class="uk-icon-code"></i>
                        </div>
                        <div class="title">
                            Markdown语法
                        </div>
                        <div class="desc">
                            支持Markdown基本语法和扩展语法，拥有完全可控的文档格式。
                        </div>
                    </div>
                </div>
                <div class="uk-width-1-4">
                    <div class="item">
                        <div class="icon">
                            <i class="uk-icon-mixcloud"></i>
                        </div>
                        <div class="title">
                            独立访问
                        </div>
                        <div class="desc">
                            每个文档拥有独立的访问路径，每篇文档的访问性可控，随时分享。
                        </div>
                    </div>
                </div>
                <div class="uk-width-1-4">
                    <div class="item">
                        <div class="icon">
                            <i class="uk-icon-clock-o"></i>
                        </div>
                        <div class="title">
                            版本修订
                        </div>
                        <div class="desc">
                            保存最近50次的修改记录，对历史修订版本的管理，随时恢复。
                        </div>
                    </div>
                </div>
                <div class="uk-width-1-4">
                    <div class="item">
                        <div class="icon">
                            <i class="uk-icon-book"></i>
                        </div>
                        <div class="title">
                            文档归类
                        </div>
                        <div class="desc">
                            对所有文档进行归类，方便进行管理，随时查看。
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection