@extends('theme.default.pc.frame')

@section('pageTitleMain','我的文档')

@section('headerMenu')@endsection
@section('footer')@endsection

@section('headScript')
    @parent
    <link rel="stylesheet" href="@assets('assets/editor.md/css/editormd.css')">
@endsection

@section('bodyScript')
    <script src="@assets('assets/editor.md/editormd.js')"></script>
    <script src="@assets('assets/vue/vue.js')"></script>
    <script src="@assets('assets/diff/diff_match_patch.js')"></script>
    @parent
    <script src="@assets('assets/main/js/memberDoc.js')"></script>
@endsection

@section('bodyContent')

    <div id="vueBox">

        <div id="memberDoc" class="main-container doc-container">
            <div class="left-box">
                <div class="book-box">
                    <div class="head">
                        <a href="javascript:;" v-on:click="addBook"><i class="uk-icon-plus"></i> 新建分类</a>
                    </div>
                    <div class="loading" v-show="booksLoading" v-cloak>
                        <i class="uk-icon-refresh uk-icon-spin"></i>
                    </div>
                    <div class="empty" v-show="!booksLoading && books.length==0" v-cloak>
                        暂无分类
                    </div>
                    <div class="body">
                        <div class="item" v-cloak v-for="book in books" v-bind:class="currentBook.id==book.id?'active':''" v-on:click="currentBook=book">
                            <a href="javascript:;" v-show="book.id > 0" v-on:click="editBook"><i class="uk-icon-cog"></i></a>
                            @{{ book.title }}
                        </div>
                    </div>
                </div>
                <div class="doc-list-box">
                    <div class="head">
                        <a href="javascript:;" class="add" v-show="currentDoc.id>0" v-on:click="newDoc"><i class="uk-icon-plus"></i>新建文档</a>
                        <div class="search">
                            <i class="uk-icon-search"></i>
                            <input type="text" name="" placeholder="搜索标题"/>
                        </div>
                    </div>
                    <div class="body">
                        <div class="empty" v-cloak v-show="!docsLoading && docs.length==0">
                            暂无文档
                        </div>
                        <div class="list">
                            <div class="item" v-cloak v-for="doc in docs" v-bind:class="currentDoc.id==doc.id?'active':''" v-on:click="editDoc(doc.id)">
                                <div class="visit">
                                    <i class="uk-icon-lock" v-show="doc.visit=={{\App\Types\DocVisit::VISIT_PRIVATE}}"></i>
                                    <i class="uk-icon-unlock" v-show="doc.visit=={{\App\Types\DocVisit::VISIT_PASSWORD}}"></i>
                                </div>
                                <div class="title">@{{ doc.title }}</div>
                                <div class="time"><i class="uk-icon-clock-o"></i> @{{ doc.time }}</div>
                                <div class="summary">@{{ doc.summary }}</div>
                            </div>
                        </div>
                        <div class="loading" v-cloak v-show="docsLoading" v-cloak>
                            <i class="uk-icon-refresh uk-icon-spin"></i>
                        </div>
                        <div class="tail" v-cloak v-show="!docsLoading && docsHasMore" v-on:click="loadDocList">
                            点击加载更多
                        </div>
                    </div>
                </div>
            </div>
            <div class="right-box">
                <div class="toolbar-box">
                    <div class="book">
                        <select v-cloak v-model="editingDoc.bookId">
                            <option v-cloak v-for="book in books" v-bind:value="book.id">@{{ book.title }}</option>
                        </select>
                    </div>
                    <div class="title">
                        <input type="text" v-model="editingDoc.title" placeholder="输入文档标题"/>
                    </div>
                    <div class="action">
                        <a href="javascript:;" v-cloak data-uk-tooltip title="保存" v-on:click="saveDoc"><i class="uk-icon-save"></i></a>
                        <a href="javascript:;" v-cloak v-show="editingDoc.id>0" data-uk-tooltip title="链接" target="_blank" v-bind:href="'/r/'+editingDoc.alias"><i class="uk-icon-desktop"></i></a>
                        <a href="javascript:;" v-cloak v-show="editingDoc.id>0" data-uk-tooltip title="访问设置" v-on:click="visitDoc"><i class="uk-icon-cog"></i></a>
                        <a v-cloak v-show="editingDoc.id>0" data-uk-tooltip title="下载PDF" target="_blank" v-bind:href="'/r/'+editingDoc.alias+'/download'"><i class="uk-icon-cloud-download"></i></a>
                        <a href="javascript:;" v-cloak v-show="editingDoc.id>0" data-uk-tooltip title="历史版本" v-on:click="historyDoc"><i class="uk-icon-clock-o"></i></a>
                        <a href="javascript:;" v-cloak v-show="editingDoc.id>0" data-uk-tooltip title="删除" v-on:click="deleteDoc"><i class="uk-icon-trash"></i></a>
                    </div>
                </div>
                <div class="markdown-box">
                    <div id="markdown_editor">
                        <textarea style="display:none;"></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div id="bookEditDialog" class="uk-modal">
            <div class="uk-modal-dialog" style="width:300px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    分类
                </div>
                <div class="uk-form">
                    <div class="line line-label-narrow">
                        <div class="label">名称</div>
                        <div class="field">
                            <input type="text" v-model="currentBook.title"/>
                        </div>
                    </div>
                </div>
                <div class="uk-modal-footer uk-text-right">
                    <button type="button" class="uk-button" v-show="currentBook.id>0" v-on:click="deleteBook">删除</button>
                    <button type="button" class="uk-button uk-button-primary" v-on:click="saveBook">保存</button>
                </div>
            </div>
        </div>

        <div id="docVisitEditDialog" class="uk-modal">
            <div class="uk-modal-dialog" style="width:300px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    访问设置
                </div>
                <div class="uk-form">
                    <div class="line line-label-narrow">
                        <div class="label">权限</div>
                        <div class="field">
                            <select v-model="editingDoc.visit">
                                <option>请选择</option>
                                <option value="{{\App\Types\DocVisit::VISIT_PUBLIC}}">公开</option>
                                <option value="{{\App\Types\DocVisit::VISIT_PRIVATE}}">私密</option>
                                <option value="{{\App\Types\DocVisit::VISIT_PASSWORD}}">密码访问</option>
                            </select>
                        </div>
                    </div>
                    <div class="line line-label-narrow" v-show="editingDoc.visit=={{\App\Types\DocVisit::VISIT_PASSWORD}}">
                        <div class="label">密码</div>
                        <div class="field">
                            <input type="text" v-model="editingDoc.visitPassword"/>
                        </div>
                    </div>
                </div>
                <div class="uk-modal-footer uk-text-right">
                    <button type="button" class="uk-button uk-button-primary" v-on:click="saveDocVisit">保存</button>
                </div>
            </div>

        </div>

        <div id="docHistoryDialog" class="uk-modal">
            <div class="uk-modal-dialog" style="width:600px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    历史版本
                </div>
                <div class="body">
                    <div class="history" v-for="history in docHistories">
                        <div class="head">
                            <div class="right">
                                <a href="javascript:;" data-uk-tooltip title="回退到该版本" v-on:click="revertDocHistory(history)"><i class="uk-icon-reply"></i></a>
                            </div>
                            <i class="uk-icon-clock-o"></i>
                            <time v-bind:datetime="history.created_at"></time>
                        </div>
                        <div class="content" v-html="history.contentDiff" v-bind:class="history.expand?'expand':''" v-on:click="history.expand=!history.expand"></div>
                    </div>
                </div>
            </div>

        </div>

        <div class="doc-top-tip loading">
            <i class="uk-icon-spin uk-icon-refresh"></i> 正在加载...
        </div>

        <div class="doc-top-tip success">
            <i class="uk-icon-check"></i> <span></span>
        </div>

        <div class="doc-top-tip error">
            <i class="uk-icon-warning"></i> <span></span>
        </div>

    </div>




@endsection