<?php

namespace Edwin404\Base\Support;


use Illuminate\Support\Facades\Input;

class InputHelper
{


    /**
     * @param $fieldConfig array see @example
     * @return array [code=>0,msg=>null,data=>[field1=>value2,field2=>value2,...]]
     *
     * @example
     * field1=>[用户名,string|int|float,trim,min:4,max:20,require]
     */
    public static function get($fieldConfig, $inputPool = null)
    {
        $data = [];

        if (null === $inputPool) {
            $inputPool = Input::all();
        }

        foreach ($fieldConfig as $key => $rule) {

            $data[$key] = (isset($inputPool[$key]) ? $inputPool[$key] : null);

            $name = $rule[0];
            $type = $rule[1];

            switch ($type) {
                case 'int':
                    $data[$key] = intval($data[$key]);
                    break;
                case 'float':
                    $data[$key] = floatval($data[$key]);
                    break;
                case 'string':
                    break;
            }

            $ruleCount = count($rule);
            for ($i = 2; $i < $ruleCount; $i++) {
                $args = explode(':', $rule[$i]);
                switch ($args[0]) {
                    case 'trim':
                        $data[$key] = trim($data[$key]);
                        break;
                    case 'reg':
                        if (!preg_match($args[1], $data[$key])) {
                            return Response::generate(-1, $name . '格式错误');
                        }
                        break;
                    case 'min':
                        switch ($type) {
                            case 'int':
                                if ($data[$key] < intval($args[1])) {
                                    return Response::generate(-1, $name . '最小为' . $args[1]);
                                }
                                break;
                            case 'float':
                                if ($data[$key] < floatval($args[1])) {
                                    return Response::generate(-1, $name . '最小为' . $args[1]);
                                }
                                break;
                            default:
                                if (strlen($data[$key]) < intval($args[1])) {
                                    return Response::generate(-1, $name . '最小长度为' . $args[1]);
                                }
                        }
                        break;
                    case 'max':
                        switch ($type) {
                            case 'int':
                                if ($data[$key] > intval($args[1])) {
                                    return Response::generate(-1, $name . '最大为' . $args[1]);
                                }
                                break;
                            case 'float':
                                if ($data[$key] > floatval($args[1])) {
                                    return Response::generate(-1, $name . '最大为' . $args[1]);
                                }
                                break;
                            default:
                                if (strlen($data[$key]) > intval($args[1])) {
                                    return Response::generate(-1, $name . '最大长度为' . $args[1]);
                                }
                        }
                        break;
                    case 'require':
                        if (empty($data[$key])) {
                            return Response::generate(-1, $name . '不能为空');
                        }
                        break;
                }
            }

        }

        return Response::generate(0, null, $data);
    }

    public static function getJsonArray($key, $defaultValue = [])
    {
        $data = Input::get($key);
        if (empty($data)) {
            return $defaultValue;
        }
        $data = @json_decode($data, true);
        if (empty($data)) {
            return $defaultValue;
        }
        return $data;
    }

    public static function getArray($key, $defaultValue = [])
    {
        $data = Input::get($key, []);
        if (empty($data)) {
            return $defaultValue;
        }
        if (!is_array($data)) {
            return $defaultValue;
        }
        return $data;
    }

    public static function getJson($key, $defaultValue = null)
    {
        $data = Input::get($key, '');
        $data = @json_decode($data, true);
        if (empty($data)) {
            return $defaultValue;
        }
        return $data;
    }

    public static function getType($key, $typeClass, $defaultValue = null)
    {
        $data = Input::get($key, null);
        if (empty($data)) {
            return $defaultValue;
        }
        $list = $typeClass::getList();
        foreach ($list as $k => $v) {
            if ($data == $k) {
                return $k;
            }
        }
        return $defaultValue;
    }

}