<?php

namespace Edwin404\Base\Support;


use Illuminate\Support\Facades\Cache;

class LBSHelper
{
    public static function locationByIP($ip)
    {
        $cacheKey = 'LBS.Location.ip' . $ip;
        $cached = Cache::get($cacheKey, null);
        if ($cached) {
            return $cached;
        }

        $cityQueryRet = self::getContent('http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=' . urlencode($ip));
        if (!empty($cityQueryRet)) {
            $country = empty($cityQueryRet['country']) ? '' : $cityQueryRet['country'];
            $province = empty($cityQueryRet['province']) ? '' : $cityQueryRet['province'];
            $city = empty($cityQueryRet['city']) ? '' : $cityQueryRet['city'];
            if ($country || $province || $city) {
                $cached = [
                    'country' => $country,
                    'province' => $province,
                    'city' => $city,
                ];
                Cache::forever($cacheKey, $cached);
                return $cached;
            }
        }
        $cityQueryRet = self::getContent("http://ip.taobao.com/service/getIpInfo.php?ip=" . urlencode($ip));
        $cityQuery = @json_decode($cityQueryRet, true);
        if (isset($cityQuery['code']) && $cityQuery['code'] == 0) {
            $country = empty($cityQuery['data']['country']) ? '' : $cityQuery['data']['country'];
            $province = empty($cityQuery['data']['region']) ? '' : $cityQuery['data']['region'];
            $city = empty($cityQuery['data']['city']) ? '' : $cityQuery['data']['city'];
            if ($country || $province || $city) {
                $cached = [
                    'country' => $country,
                    'province' => $province,
                    'city' => $city,
                ];
                Cache::forever($cacheKey, $cached);
                return $cached;
            }
        }
        return null;
    }

    private static function getContent($url)
    {
        return @file_get_contents($url, false, stream_context_create([
            'http' => [
                'method' => 'GET',
                'timeout' => 1
            ]
        ]));
    }
}

