<?php
namespace Edwin404\Area\Services;

use Edwin404\Base\Support\ModelHelper;

class AreaService
{
    public function listChinaByParentAreaIds($parentAreaIds)
    {
        if (!is_array($parentAreaIds)) {
            $parentAreaIds = [$parentAreaIds];
        }
        return ModelHelper::model('area_china')->whereIn('parentAreaId', $parentAreaIds)->get()->toArray();
    }

    public function listRelatedChinaByName($names)
    {
        if (!is_array($names)) {
            $names = [$names];
        }
        $list = $this->listChinaByParentAreaIds(0);
        if (empty($names)) {
            return $list;
        }

        $relatedList = [];

        $pid = 0;
        $index = 0;
        do {
            $hasMore = false;
            $list = $this->listChinaByParentAreaIds($pid);
            if (empty($list)) {
                break;
            }
            $relatedList = array_merge($relatedList, $list);
            if (isset($names[$index])) {
                foreach ($list as $item) {
                    if ($item['name'] == $names[$index]) {
                        $pid = $item['areaId'];
                        $hasMore = true;
                        break;
                    }
                }
            }
            $index++;
        } while ($hasMore);

        return $relatedList;
    }

    public function all()
    {
        return ModelHelper::model('area_china')->get()->toArray();
    }

}