<?php

namespace Edwin404\Data\Services;

use Illuminate\Support\Facades\Storage;

class DataStorageService
{
    private $storage;

    function __construct()
    {
        config(['filesystems.disks.data' => [
            'driver' => 'local',
            'root' => base_path('public/')
        ]]);
        $this->storage = Storage::disk('data');
    }

    public function get($filename)
    {
        if ($this->storage->has($filename)) {
            return $this->storage->get($filename);
        }
        return null;
    }

    public function put($filename, $content)
    {
        $this->storage->put($filename, $content);
    }

    public function move($from, $to)
    {
        $this->storage->move($from, $to);
    }

    public function delete($filename)
    {
        if ($this->storage->has($filename)) {
            $this->storage->delete($filename);
        }
    }

    public function exists($filename)
    {
        return $this->storage->has($filename);
    }

    public function size($filename)
    {
        return $this->storage->size($filename);
    }

    public function combine($filename)
    {
        $root = config('filesystems.disks.data.root');
        $out = @fopen($root . $filename, "wb");
        if (flock($out, LOCK_EX)) {
            for ($i = 0; ; $i++) {
                if (!$this->storage->has($filename . '.' . $i)) {
                    break;
                }
                $content = file_get_contents($root . $filename . '.' . $i);
                fwrite($out, $content);
                @unlink($root . $filename . '.' . $i);
            }
            flock($out, LOCK_UN);
        }
        fclose($out);
    }

}