<?php

namespace Edwin404\Pay\Controllers;


use Edwin404\Base\Support\ModelHelper;
use Edwin404\Pay\Events\OrderPayedEvent;
use Edwin404\Pay\Services\PayOrderService;
use Edwin404\Pay\Types\PayOrderStatus;
use Edwin404\Pay\Types\PayType;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Request;

class NotifyController extends Controller
{
    public function index(PayOrderService $payOrderService, $payType = '')
    {
        switch ($payType) {
            case PayType::ALIPAY:
                $payOrderService->initAlipay();
                if (!app('alipay.web')->verify()) {
                    Log::notice('alipay return -> query data verification fail.', [
                        'data' => Request::instance()->getContent()
                    ]);
                    return 'fail';
                }
                switch (Input::get('trade_status')) {
                    case 'TRADE_SUCCESS':
                    case 'TRADE_FINISHED':

                        Log::notice('alipay return -> data verification success.', [
                            'out_trade_no' => Input::get('out_trade_no'),
                            'trade_no' => Input::get('trade_no')
                        ]);

                        $ret = $payOrderService->handleOrderPay(PayType::WECHAT_MOBILE, Input::get('out_trade_no', ''));
                        if ($ret['code']) {
                            return 'fail';
                        }

                        return 'success';
                }
                return 'fail';

            case PayType::WECHAT_MOBILE:

                return PayOrderService::getWechatMobileApp()->payment->handleNotify(function ($notify, $successful) use ($payOrderService) {
                    if ($successful) {
                        $ret = $payOrderService->handleOrderPay(PayType::WECHAT_MOBILE, $notify->out_trade_no);
                        if ($ret['code']) {
                            return 'fail';
                        }
                        return true;
                    }
                    return true;
                });

            case PayType::WECHAT:

                return PayOrderService::getWechatApp()->payment->handleNotify(function ($notify, $successful) use ($payOrderService) {
                    if ($successful) {
                        $ret = $payOrderService->handleOrderPay(PayType::WECHAT, $notify->out_trade_no);
                        if ($ret['code']) {
                            return 'fail';
                        }
                        return true;
                    }
                    return true;
                });

        }
    }

}