<?php

namespace Edwin404\Tecmz\Helpers;


use Edwin404\Base\Support\ModelHelper;
use Edwin404\SmartAssets\Helper\AssetsHelper;

class AdminCmsHelper
{
    public static function memberUserViewItem($memberUserId)
    {
        $memberUser = ModelHelper::load('member_user', ['id' => $memberUserId]);
        if (empty($memberUser)) {
            return '[未知用户]';
        }
        return '<a href="javascript:;" data-dialog-request="' . action('\App\Http\Controllers\Admin\MemberController@dataView', ['id' => $memberUserId]) . '"><img src="' . AssetsHelper::fixOrDefault($memberUser['avatar'], 'assets/lib/img/avatar.png') . '" style="width:30px;height:30px;" />' . htmlspecialchars($memberUser['username']) . '</a>';
    }

    public static function thumbViewItem($image)
    {
        $url = AssetsHelper::fixOrDefault($image, 'assets/lib/img/none.png');
        return '<a href="' . $url . '" style="border:1px solid #CCC;display:inline-block;height:42px;width:42px;box-sizing:border-box;border-radius:2px;" data-image-preview><img src="' . $url . '" style="height:40px;width:40px;display:inline-block;" /></a>';
    }
}