<?php namespace Phpcmf\Model\Comment;

// 权限验证
class Auth extends \Phpcmf\Model\Auth
{

    // 判断底部链接的显示权限
    public function is_bottom_auth($mid) {


        return 1;
    }

    // 判断右侧链接的显示权限
    public function is_link_auth($mid) {

        if (\Phpcmf\Service::C()->get_cache('app-comment-'.SITE_ID, 'module', $mid)) {
            return 1;
        }

        return 0;
    }

    // 动态link名称
    public function get_name($mid) {
        return dr_comment_cname(\Phpcmf\Service::C()->get_cache('app-comment-'.SITE_ID, 'module', $mid, 'cname'));
    }


    // 重新获取后台的菜单线上权限分配
    public function get_admin_menu_data($my_menu) {

        foreach ($my_menu as $tid => $top) {
            if (!$top['left']) {
                continue; // 没有分组菜单就不要
            }
            foreach ($top['left'] as $if => $left) {
                if (!$left['link']) {
                    continue; // 没有链接菜单就不要
                }
                // 链接菜单开始
                foreach ($left['link'] as $i => $link) {
                    if ($link['mark'] && $left['mark'] == 'content-verify') {
                        // 内容模块审核部分权限判断
                        list($ac, $ab, $name, $cc, $dd) = explode('-', $link['mark']);
                        if ($ac.'-'.$ab == 'verify-module' && !\Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-content', $name)) {
                            unset($my_menu[$tid]['left'][$if]['link'][$i]);
                            continue;
                        } elseif ($ac.'-'.$ab.'-'.$name == 'comment-verify-module' && !\Phpcmf\Service::L('cache')->get('app-comment-'.SITE_ID, 'module', $cc, 'use')) {
                            // 判断模块评论菜单
                            unset($my_menu[$tid]['left'][$if]['link'][$i]);
                            continue;
                        } elseif ($ac.'-'.$ab.'-'.$name== 'comment-verify-form' && !\Phpcmf\Service::L('cache')->get('app-comment-'.SITE_ID, 'form', $cc, 'use')) {
                            // 判断网站表单评论菜单
                            unset($my_menu[$tid]['left'][$if]['link'][$i]);
                            continue;
                        } elseif ($ac.'-'.$ab.'-'.$name == 'comment-verify-mform' && !\Phpcmf\Service::L('cache')->get('app-comment-'.SITE_ID, 'mform', $cc.'-'.$dd, 'use')) {
                            // 判断模块表单评论菜单
                            unset($my_menu[$tid]['left'][$if]['link'][$i]);
                            continue;
                        }
                    }
                }
            }
        }

        return $my_menu;
    }
}