<?php
 namespace Module\News\Web\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\PageHtmlUtil; use ModStart\Module\ModuleBaseController; use ModStart\Module\ModuleManager; use Module\Ad\Util\AdUtil; use Module\Article\Util\ArticleUtil; use Module\News\Util\NewsUtil; class NewsController extends ModuleBaseController { private $api; public function __construct() { $this->api = app(\Module\News\Api\Controller\NewsController::class); } public function index() { $input = InputPackage::buildFromInput(); $paginateData = Response::tryGetData($this->api->paginate()); $dataView = []; $dataView['news'] = $paginateData['records']; $dataView['categoryId'] = $input->getInteger('categoryId'); $dataView['categories'] = NewsUtil::listCategories(); $dataView['pageHtml'] = PageHtmlUtil::render($paginateData['total'], $paginateData['pageSize'], $paginateData['page'], '?' . Request::mergeQueries(['page' => ['{page}']])); if (ModuleManager::isModuleInstalled('Ad')) { $dataView['ads'] = AdUtil::listByPositionWithCache('pcNewsListRight'); } return $this->view('news.list', $dataView); } public function views($id) { $news = NewsUtil::get($id); if (empty($news)) { return Response::send(-1, '新闻不存在'); } $news['_category'] = ModelUtil::get('news_category', ['id' => $news['categoryId']]); $newsLatest = ModelUtil::model('news')->orderBy('id', 'desc')->limit(6)->get()->toArray(); $dataView = []; $dataView['news'] = $news; $dataView['newsLatest'] = $newsLatest; if (ModuleManager::isModuleInstalled('Ad')) { $dataView['ads'] = AdUtil::listByPositionWithCache('pcNewsViewRight'); } return $this->view('news.view', $dataView); } }