<?php
 namespace Module\Product\Web\Controller; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\PageHtmlUtil; use ModStart\Module\ModuleBaseController; use ModStart\Module\ModuleManager; use Module\Ad\Util\AdUtil; use Module\Article\Util\ArticleUtil; use Module\Product\Util\ProductUtil; class ProductController extends ModuleBaseController { private $api; public function __construct() { $this->api = app(\Module\Product\Api\Controller\ProductController::class); } public function index() { $input = InputPackage::buildFromInput(); $paginateData = Response::tryGetData($this->api->paginate()); $dataView = []; $dataView['records'] = $paginateData['records']; $dataView['categoryId'] = $input->getInteger('categoryId'); $dataView['categories'] = ProductUtil::listCategories(); $dataView['pageHtml'] = PageHtmlUtil::render($paginateData['total'], $paginateData['pageSize'], $paginateData['page'], '?' . Request::mergeQueries(['page' => ['{page}']])); if (ModuleManager::isModuleInstalled('Ad')) { $dataView['ads'] = AdUtil::listByPositionWithCache('pcProductListRight'); } return $this->view('product.list', $dataView); } public function views($id) { $record = ProductUtil::get($id); if (empty($record)) { return Response::send(-1, '新闻不存在'); } $record['_category'] = ModelUtil::get('product_category', ['id' => $record['categoryId']]); $dataView = []; $dataView['record'] = $record; if (ModuleManager::isModuleInstalled('Ad')) { $dataView['ads'] = AdUtil::listByPositionWithCache('pcProductViewRight'); } return $this->view('product.view', $dataView); } }