<?php

namespace App\Repos;

use App\Library\Paginator\Adapter\QueryBuilder as PagerQueryBuilder;
use App\Models\CourseFavorite as CourseFavoriteModel;
use Phalcon\Mvc\Model;

class CourseFavorite extends Repository
{

    public function paginate($where = [], $sort = 'latest', $page = 1, $limit = 15)
    {
        $builder = $this->modelsManager->createBuilder();

        $builder->from(CourseFavoriteModel::class);

        $builder->where('1 = 1');

        if (!empty($where['course_id'])) {
            $builder->andWhere('course_id = :course_id:', ['course_id' => $where['course_id']]);
        }

        if (!empty($where['user_id'])) {
            $builder->andWhere('user_id = :user_id:', ['user_id' => $where['user_id']]);
        }

        switch ($sort) {
            default:
                $orderBy = 'id DESC';
                break;
        }

        $builder->orderBy($orderBy);

        $pager = new PagerQueryBuilder([
            'builder' => $builder,
            'page' => $page,
            'limit' => $limit,
        ]);

        return $pager->paginate();
    }

    /**
     * @param int $courseId
     * @param int $userId
     * @return CourseFavoriteModel|Model|bool
     */
    public function findCourseFavorite($courseId, $userId)
    {
        return CourseFavoriteModel::findFirst([
            'conditions' => 'course_id = :course_id: AND user_id = :user_id:',
            'bind' => ['course_id' => $courseId, 'user_id' => $userId],
        ]);
    }

}
