<?php
// +----------------------------------------------------------------------
// | ThinkCMF [ WE CAN DO IT MORE SIMPLE ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013-2019 http://www.thinkcmf.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 小夏 < 449134904@qq.com>
// +----------------------------------------------------------------------
namespace app\admin\controller;

use cmf\controller\AdminBaseController;
use think\Db;
use app\admin\model\Menu;

class MainController extends AdminBaseController
{

    /**
     *  后台欢迎页
     */
    public function index()
    {
        $dashboardWidgets = [];
        $widgets          = cmf_get_option('admin_dashboard_widgets');

        $defaultDashboardWidgets = [
            '_SystemCmfHub'           => ['name' => 'CmfHub', 'is_system' => 1],
            '_SystemCmfDocuments'     => ['name' => 'CmfDocuments', 'is_system' => 1],
            '_SystemMainContributors' => ['name' => 'MainContributors', 'is_system' => 1],
            '_SystemContributors'     => ['name' => 'Contributors', 'is_system' => 1],
            '_SystemCustom1'          => ['name' => 'Custom1', 'is_system' => 1],
            '_SystemCustom2'          => ['name' => 'Custom2', 'is_system' => 1],
            '_SystemCustom3'          => ['name' => 'Custom3', 'is_system' => 1],
            '_SystemCustom4'          => ['name' => 'Custom4', 'is_system' => 1],
            '_SystemCustom5'          => ['name' => 'Custom5', 'is_system' => 1],
        ];

        if (empty($widgets)) {
            $dashboardWidgets = $defaultDashboardWidgets;
        } else {
            foreach ($widgets as $widget) {
                if ($widget['is_system']) {
                    $dashboardWidgets['_System' . $widget['name']] = ['name' => $widget['name'], 'is_system' => 1];
                } else {
                    $dashboardWidgets[$widget['name']] = ['name' => $widget['name'], 'is_system' => 0];
                }
            }

            foreach ($defaultDashboardWidgets as $widgetName => $widget) {
                $dashboardWidgets[$widgetName] = $widget;
            }


        }

        $dashboardWidgetPlugins = [];

        $hookResults = hook('admin_dashboard');

        if (!empty($hookResults)) {
            foreach ($hookResults as $hookResult) {
                if (isset($hookResult['width']) && isset($hookResult['view']) && isset($hookResult['plugin'])) { //验证插件返回合法性
                    $dashboardWidgetPlugins[$hookResult['plugin']] = $hookResult;
                    if (!isset($dashboardWidgets[$hookResult['plugin']])) {
                        $dashboardWidgets[$hookResult['plugin']] = ['name' => $hookResult['plugin'], 'is_system' => 0];
                    }
                }
            }
        }

        $smtpSetting = cmf_get_option('smtp_setting');

        $this->assign('dashboard_widgets', $dashboardWidgets);
        $this->assign('dashboard_widget_plugins', $dashboardWidgetPlugins);
        $this->assign('has_smtp_setting', empty($smtpSetting) ? false : true);


        /*****新开发的功能 */
        //平台总人数
        $totalnums = Db::name('users')->count();
        $this->assign('totalnums', $totalnums);
        //今日新增用户数
        $daystart = strtotime(date('Y-m-d 00:00:00',time()));
        $dayend = strtotime(date('Y-m-d 23:59:59',time()));
        $where = "create_time >=".$daystart." and create_time<=".$dayend;
        $todaynums = Db::name('users')->where($where)->count();
        $this->assign('todaynums', $todaynums);
        //今日新增课程数
        $where1 = "addtime >=".$daystart." and addtime<=".$dayend;
        $addcoursenums = Db::name('course')->where($where1)->count();
        $this->assign('addcoursenums', $addcoursenums);
        //今日ip数
        $where2 = "addtime >=".$daystart." and addtime<=".$dayend;
        $ipnums = Db::name('ip_login_nums')->where($where2)->count();
        $this->assign('ipnums', $ipnums);


        //折线图
        $data_basic=$this->getBasic($daystart,$dayend,1); //新增用户
        $this->assign("data_basicj",json_encode($data_basic));
        $data_basic_c=$this->getBasic($daystart,$dayend,2);//新增课程
        $this->assign("data_basicj_c",json_encode($data_basic_c));
        $data_basic_i=$this->getBasic($daystart,$dayend,3);//今日IP数
        $this->assign("data_basicj_i",json_encode($data_basic_i));



        $configpri = getConfigPri();
 
        //ip分布图
        $where3 = "addtime>='{$daystart}' and addtime<='{$dayend}'";
        $iplist = Db::name('ip_login_nums')->field('province,count(*) as nums')->where($where3)->group('province')->select()->toArray();
        $this->assign("iplist",$iplist);

        $toolTipData = [];
        $list = curl_get('https://apis.map.qq.com/ws/district/v1/list?key='.$configpri['tx_map_key']);
            
        if($list['status'] == 0){
                foreach($list['result'][0] as $k=>$v){
                    $count = 0;
                    foreach($iplist as $ks=>$vs){
                        if($vs['province'] == $v['fullname']){
                            $count = $vs['nums'];
                        }
                    }
                    $toolTipData[]=['provinceName'=>$v['name'],'shopCount'=>$count];
                }
        }
        $this->assign("toolTipData",json_encode($toolTipData));



        $data_basic_d=$this->getBasic($daystart,$dayend,4);//今日访问量
        $this->assign("data_basicj_d",json_encode($data_basic_d));



        /* 观看渠道 */
        $login_type=Db::name('users_see_live')
               ->field("count(id) as nums,source")
               ->where("addtime>={$daystart} and addtime<={$dayend}")
               ->group("source")
               ->order("nums desc")
               ->select()
               ->toArray();
       $data_type=[
           'name'=>[],
           'v_n'=>[],
       ];
       if($login_type){

           foreach($login_type as $k=>$v){

                if($v['source'] == 'PC'){
                    $color = '#68D7FB';
                }else if($v['source'] == 'IOS'){
                    $color = '#A9F565';
                }else{
                    $color = '#F5EB6B';
                }

               $data_type['v_n'][]=['value'=>$v['nums'],'name'=>$v['source'],'itemStyle'=>['color'=>$color]];
               $data_type['name'][]=$v['source'];
           }
       }
       $this->assign("data_typej",json_encode($data_type));

        return $this->fetch();
    }

    /* 基础数据 */
    protected function getBasic($starttime,$endtime,$basic_type){
        $rs=[
            'name'=>[],
            'data'=>[],
            'nums'=>0,

        ];
        
        $start=date("Y-m-d",$starttime);
        $end=date("Y-m-d",($endtime - 60*60*24));

        $periodType='hourly';
        if($basic_type<4){
            $rs['name']=['00:00','01:00','02:00','03:00','04:00','05:00','06:00','07:00','08:00','09:00','10:00','11:00','12:00','13:00','14:00','15:00','16:00','17:00','18:00','19:00','20:00','21:00','22:00','23:00',];
        }else{
            $rs['name'] = ['10分钟以内','11~20分钟','21~30分钟','31~40分钟','41~50分钟','51到60分钟','60分钟以上'];
        }
        

        
        switch($basic_type){
            case '1': //今日新增用户数
                if($periodType=='hourly'){
                    /* hourValue */
                    foreach($rs['name'] as $k=>$v){

                        if($v == '00:00'){
                            $starttime = strtotime(date("Y-m-d 23:00:00",time()));
                            $endtime = strtotime(date("Y-m-d 23:59:59",time()));
                        }else{
                            $starttime = strtotime(date("Y-m-d {$rs['name'][$k-1]}:00",time()));
                            $endtime = strtotime(date("Y-m-d {$v}:00",time()));
                        }

                        $where = "create_time >{$starttime} and create_time<{$endtime}";
                        $count = Db::name('users')->where($where)->count();
                        
                        $rs['data'][]=$count;
                    }
                }
                break;
            case '2': //今日新增课程数
                if($periodType=='hourly'){
                    /* hourValue */
                    foreach($rs['name'] as $k=>$v){

                        if($v == '00:00'){
                            $starttime = strtotime(date("Y-m-d 23:00:00",time()));
                            $endtime = strtotime(date("Y-m-d 23:59:59",time()));
                        }else{
                            $starttime = strtotime(date("Y-m-d {$rs['name'][$k-1]}:00",time()));
                            $endtime = strtotime(date("Y-m-d {$v}:00",time()));
                        }

                        $where = "addtime >{$starttime} and addtime<{$endtime}";
                        $count = Db::name('course')->where($where)->count();
                        
                        $rs['data'][]=$count;
                    }
                }
                break;
            case '3': //今日IP数
                if($periodType=='hourly'){
                    /* hourValue */
                    foreach($rs['name'] as $k=>$v){

                        if($v == '00:00'){
                            $starttime = strtotime(date("Y-m-d 23:00:00",time()));
                            $endtime = strtotime(date("Y-m-d 23:59:59",time()));
                        }else{
                            $starttime = strtotime(date("Y-m-d {$rs['name'][$k-1]}:00",time()));
                            $endtime = strtotime(date("Y-m-d {$v}:00",time()));
                        }

                        $where = "addtime >{$starttime} and addtime<{$endtime}";
                        $count = Db::name('ip_login_nums')->where($where)->count();
                        
                        $rs['data'][]=$count;
                    }
                }
                break;
            case '4': //今日访问量
                if($periodType=='hourly'){
                    /* hourValue */
                    foreach($rs['name'] as $k=>$v){
                        if($k==0){
                            $where_end = "time>0 and time<=10";
                        }else if($k==1){
                            $where_end = "time>10 and time<=20";
                        }else if($k==2){
                            $where_end = "time>20 and time<=30";
                        }else if($k==3){
                            $where_end = "time>20 and time<=40";
                        }else if($k==4){
                            $where_end = "time>40 and time<=50";
                        }else if($k==5){
                            $where_end = "time>50 and time<=60";
                        }
                        else if($k==6){
                            $where_end = "time>60";
                        }

                        $where = "addtime >{$starttime} and addtime<{$endtime} and ".$where_end;
                        $count = Db::name('users_see_live')->where($where)->count();
                        $rs['data'][]=$count;
                    }
                }
                break;
        }
        return $rs;
        
    }
    public function dashboardWidget()
    {
        $dashboardWidgets = [];
        $widgets          = $this->request->param('widgets/a');
        if (!empty($widgets)) {
            foreach ($widgets as $widget) {
                if ($widget['is_system']) {
                    array_push($dashboardWidgets, ['name' => $widget['name'], 'is_system' => 1]);
                } else {
                    array_push($dashboardWidgets, ['name' => $widget['name'], 'is_system' => 0]);
                }
            }
        }

        cmf_set_option('admin_dashboard_widgets', $dashboardWidgets, true);

        $this->success('更新成功!');

    }

}
