<?php


namespace app\student\controller;

use cmf\controller\StudentBaseController;
use think\Db;
/**
 * 首页
 */
class IndexController extends StudentBaseController {
    
    //首页
    public function index() {

        $data = $this->request->param();

        $isBackLog = 0;
        if(isset($data['isBackLog'])){
            $isBackLog = $data['isBackLog'];
        }

        $userinfo = session('student');

        $ip = get_client_ip();
        if($userinfo){
            $gradeid = $userinfo['gradeid'];
        }else{
            $info = Db::name('ip_garde')->where(['ip'=>$ip])->find();
            if($info){
                $gradeid = $info['gardeid'];
            }else{
                $gradeid = 0;
            }
        }

        
        $url = $this->siteUrl.'/api/?s=Home.GetIndex&gradeid='.$gradeid;

        $index_info = curl_get($url);

        $list= Db::name('slide_item')->field('id,title,image,url')->where('status=1 and slide_id=5')->order('list_order asc')->select()->toArray();
        foreach($list as $k=>$v){
            $v['image'] = get_upload_path($v['image']);
            $list[$k] = $v;
        }
        $index_info['data']['info']['0']['silide'] = $list;
        $this->assign('index_info',$index_info['data']['info']['0']);

        
        $this->assign('isBackLog',$isBackLog);
        $this->assign('navid',0);
        return $this->fetch();
    }

    //选择学级
    public function SetGrade(){
        $data = $this->request->param();


        $rs = array('code'=>0,'msg'=>'设置成功','info'=>array());

        $id=isset($data['id']) ? $data['id']: '';
        $id=checkNull($id);
        $ip = get_client_ip();

        $userId = session('student.id');

        $data = array(
            'ip'=>$ip,
            'gardeid'=>$id
        );

        $info = Db::name('ip_garde')->where(['ip'=>$ip])->find();
        if($info){
            $result = Db::name('ip_garde')->where(['ip'=>$ip])->update($data);
        }else{
            $result = Db::name('ip_garde')->insert($data);
        }
        if ($userId) {
            $data = array(
                'gradeid'=>$id
            );
            $result = Db::name('users')->where(['id'=>$userId])->update($data);

            $gradeinfo = Db::name('course_grade')->where(['id'=>$id])->find();

            if($gradeinfo){
                $gradename = $gradeinfo['name'];
            }else{
                $gradename = '';
            }

            $userinfo = session('student');
            $userinfo['gradename'] = $gradename;
            $userinfo['gradeid'] = $id;
            session('student',$userinfo);

        }
        if($result){
            $rs['msg'] = '设置成功';
        }else{
            $rs['code'] = 1001;
            $rs['msg'] = '设置失败';
        }

        echo json_encode($rs);
        exit;
    }
}


