<?php
// +----------------------------------------------------------------------
// | ThinkCMF [ WE CAN DO IT MORE SIMPLE ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013-2014 http://www.thinkcmf.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: Dean <zxxjjforever@163.com>
// +----------------------------------------------------------------------
namespace app\teacher\controller;

use cmf\controller\HomeBaseController;
use think\Db;

//if (!session_id()) session_start();
/**
 * 登录
 */
class LoginController extends HomebaseController {
    
	
    //首页
	public function index() {
        $redirect = $this->request->param("redirect");
        if (empty($redirect)) {
            $redirect = $this->request->server('HTTP_REFERER');
        } else {
            if (strpos($redirect, '/') === 0 || strpos($redirect, 'http') === 0) {
            } else {
                $redirect = base64_decode($redirect);
            }
        }
        if(!empty($redirect)){
            session('login_http_referer', $redirect);
        }
        
        if (session('teacher')) { //已经登录时直接跳到首页
            return redirect(cmf_url("teacher/index/index"));
        } else {
            return $this->fetch();
        }
    }
	/* 手机验证码 */
	public function getCode(){
		
        $rs=['code'=>0,'msg'=>'','info'=>[]];
        
        $data = $this->request->param();
        $type=isset($data['type']) ? $data['type']: '0';
        $mobile=isset($data['mobile']) ? $data['mobile']: '';
        
        $mobile=checkNull($mobile);
        
        if($mobile==''){
            $this->error('请输入手机号');
        }
        
        $where['user_login']=$mobile;
        
        $checkuser = checkUser($where);	
            
        if($type==1){
            /* 忘记密码 */
            if(!$checkuser){
                $this->error('该手机号尚未注册，请先注册');
            }
            
            $s_a='forget_account';
			$s_c='forget_code';
			$s_e='forget_expiretime';
        }else{
            /* 登录 */
            if(!$checkuser){
                $this->error('该手机号尚未注册，请先注册');
            }
            
            $s_a='login_account';
			$s_c='login_code';
			$s_e='login_expiretime';
        }
        
        $nowtime=time();
        
        if(isset($_SESSION[$s_a]) && $_SESSION[$s_a]==$mobile && isset($_SESSION[$s_e]) && $_SESSION[$s_e]> $nowtime ){
            $this->error('验证码5分钟有效，请勿多次发送');
		}

		$mobile_code = random(6,1);

		//密码可以使用明文密码或使用32位MD5加密
		$result = sendCode($mobile,$mobile_code); 
        if($result['code']==0){
			$_SESSION[$s_a] = $mobile;
			$_SESSION[$s_c] = $mobile_code;
			$_SESSION[$s_e] = time() +60*5;	
		}else if($result['code']==667){
			$_SESSION[$s_a] = $mobile;
            $_SESSION[$s_c] = $result['msg'];
            $_SESSION[$s_e] = time() +60*5;
            
            $this->error("验证码为：{$result['msg']}");
		}else{
            $this->error($result['msg']);
		} 
        
        $this->success('验证码已送');
	}			

		
	/* 密码登录 */
	public function loginbypass(){
        
        $data = $this->request->param();
        $name=isset($data['name']) ? $data['name']: '';
        $pass=isset($data['pass']) ? $data['pass']: '';
        $name=checkNull($name);
        $pass=checkNull($pass);
        
        if($name==''){
            $this->error('请输入手机号');
        }
        if($pass==''){
            $this->error('请输入密码');
        }
        
		
		$user_pass=cmf_password($pass);
		
        $where['user_login']=$name;
		$userinfo=Db::name('users')->where($where)->find();
		
		if(!$userinfo || $userinfo['user_pass'] != $user_pass){
            $this->error('账号或密码错误');
		}
        
        $this->handleInfo($userinfo);
		
        $this->success('登陆成功');

	}
    
    /* 验证码登录 */
	public function loginbycode(){
        
        $data = $this->request->param();
        $name=isset($data['name']) ? $data['name']: '';
        $code=isset($data['code']) ? $data['code']: '';
        $name=checkNull($name);
        $code=checkNull($code);
        
        if($name==''){
            $this->error('请输入手机号');
        }
        if($code==''){
            $this->error('请输入验证码');
        }
        
        if( !isset($_SESSION['login_account']) || !isset($_SESSION['login_code']) ){
            $this->error('请先获取验证码');
        }
        
        if( !isset($_SESSION['login_expiretime']) || $_SESSION['login_expiretime'] < time() ){
            $this->error('验证码已过期');
        }
        
		if($name!=$_SESSION['login_account']){	
            $this->error('手机号码不一致');            
		}

		if($code!=$_SESSION['login_code']){
			$this->error('验证码错误');
		}
		
        $where['user_login']=$name;
		$userinfo=Db::name('users')->where($where)->find();
		
		
        $this->handleInfo($userinfo);
        
        $this->success('登陆成功');
	}

    /**
     * 重置密码
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function forget(){
        

	}

	/* 退出 */
	public function logout(){

		session('teacher',null);
        
        $this->success('退出登录');
	}	
    

    protected function loginByThird($type,$openid,$nickname,$avatar){
        
        $userinfo=DB::name('users')
            ->where("openid='{$openid}' and login_type='{$type}'")
            ->find();
        
        $this->handleInfo($userinfo);
        
        $href=cookie('href');
        echo "<meta http-equiv=refresh content='0; url=$href'>"; 
		
        exit;
    }
	/* 更新token 登陆信息 */
    protected function handleInfo($userinfo) {
        if(!$userinfo){
            $this->error('账号未注册');
		}
        
        if($userinfo['user_status']==0){
            $this->error('账号已被禁用');
		}
        
        if($userinfo['type']!=1){
            $this->error('您还不是讲师,无权登录');
		}

        $token=md5(md5($userinfo['id'].$userinfo['user_login'].time()));
        $userinfo['token']=$token;

        
        $this->updateToken($userinfo['id'],$userinfo['token']);
        
        addLoginIp($userinfo['id']);
		session('teacher',$userinfo);
		
        
    }
    /* 更新token 登陆信息 */
    protected function updateToken($uid,$token) {
        $nowtime=time();
        
		$expiretime=$nowtime+60*60*24*300;

		DB::name("users")
			->where("id={$uid}")
			->update(array('last_login_time' => $nowtime, "last_login_ip"=>get_client_ip(0,true) ));
            
        $isok=DB::name("users_token")
			->where("user_id={$uid}")
			->update(array("token"=>$token, "expire_time"=>$expiretime , "create_time"=>$nowtime ));
        if(!$isok){
            DB::name("users_token")
			->insert(array("user_id"=>$uid,"token"=>$token, "expire_time"=>$expiretime , "create_time"=>$nowtime ));
        }

		$token_info=array(
			'uid'=>$uid,
			'token'=>$token,
			'expire_time'=>$expiretime,
		);
		
		setcaches("token_".$uid,$token_info);
        /* 删除PUSH信息 */
        DB::name("users_pushid")->where("uid={$uid}")->delete();
        
		return 1;
    }
}


