/*
 Navicat MySQL Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50729
 Source Host           : localhost:3306
 Source Schema         : crack

 Target Server Type    : MySQL
 Target Server Version : 50729
 File Encoding         : 65001

 Date: 22/08/2020 16:24:17
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for cmf_admin_menu
-- ----------------------------
DROP TABLE IF EXISTS `cmf_admin_menu`;
CREATE TABLE `cmf_admin_menu`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父菜单id',
  `type` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '菜单类型;1:有界面可访问菜单,2:无界面可访问菜单,0:只作为菜单',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态;1:显示,0:不显示',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `app` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '应用名',
  `controller` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '控制器名',
  `action` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作名称',
  `param` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '额外参数',
  `name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '菜单名称',
  `icon` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '菜单图标',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status`(`status`) USING BTREE,
  INDEX `parent_id`(`parent_id`) USING BTREE,
  INDEX `controller`(`controller`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 272 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '后台菜单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_admin_menu
-- ----------------------------
INSERT INTO `cmf_admin_menu` VALUES (1, 0, 0, 1, 3, 'admin', 'Plugin', 'default', '', '插件中心', 'cloud', '插件中心');
INSERT INTO `cmf_admin_menu` VALUES (6, 0, 0, 1, 1, 'admin', 'Setting', 'default', '', '设置', 'cogs', '系统设置入口');
INSERT INTO `cmf_admin_menu` VALUES (7, 6, 1, 0, 50, 'admin', 'Link', 'index', '', '友情链接', '', '友情链接管理');
INSERT INTO `cmf_admin_menu` VALUES (8, 7, 1, 0, 10000, 'admin', 'Link', 'add', '', '添加友情链接', '', '添加友情链接');
INSERT INTO `cmf_admin_menu` VALUES (9, 7, 2, 0, 10000, 'admin', 'Link', 'addPost', '', '添加友情链接提交保存', '', '添加友情链接提交保存');
INSERT INTO `cmf_admin_menu` VALUES (10, 7, 1, 0, 10000, 'admin', 'Link', 'edit', '', '编辑友情链接', '', '编辑友情链接');
INSERT INTO `cmf_admin_menu` VALUES (11, 7, 2, 0, 10000, 'admin', 'Link', 'editPost', '', '编辑友情链接提交保存', '', '编辑友情链接提交保存');
INSERT INTO `cmf_admin_menu` VALUES (12, 7, 2, 0, 10000, 'admin', 'Link', 'delete', '', '删除友情链接', '', '删除友情链接');
INSERT INTO `cmf_admin_menu` VALUES (13, 7, 2, 0, 10000, 'admin', 'Link', 'listOrder', '', '友情链接排序', '', '友情链接排序');
INSERT INTO `cmf_admin_menu` VALUES (14, 7, 2, 0, 10000, 'admin', 'Link', 'toggle', '', '友情链接显示隐藏', '', '友情链接显示隐藏');
INSERT INTO `cmf_admin_menu` VALUES (15, 6, 1, 0, 10, 'admin', 'Mailer', 'index', '', '邮箱配置', '', '邮箱配置');
INSERT INTO `cmf_admin_menu` VALUES (16, 15, 2, 0, 10000, 'admin', 'Mailer', 'indexPost', '', '邮箱配置提交保存', '', '邮箱配置提交保存');
INSERT INTO `cmf_admin_menu` VALUES (17, 15, 1, 0, 10000, 'admin', 'Mailer', 'template', '', '邮件模板', '', '邮件模板');
INSERT INTO `cmf_admin_menu` VALUES (18, 15, 2, 0, 10000, 'admin', 'Mailer', 'templatePost', '', '邮件模板提交', '', '邮件模板提交');
INSERT INTO `cmf_admin_menu` VALUES (19, 15, 1, 0, 10000, 'admin', 'Mailer', 'test', '', '邮件发送测试', '', '邮件发送测试');
INSERT INTO `cmf_admin_menu` VALUES (20, 0, 1, 0, 6, 'admin', 'Menu', 'index', '', '后台菜单', '', '后台菜单管理');
INSERT INTO `cmf_admin_menu` VALUES (21, 20, 1, 0, 10000, 'admin', 'Menu', 'lists', '', '所有菜单', '', '后台所有菜单列表');
INSERT INTO `cmf_admin_menu` VALUES (22, 20, 1, 0, 10000, 'admin', 'Menu', 'add', '', '后台菜单添加', '', '后台菜单添加');
INSERT INTO `cmf_admin_menu` VALUES (23, 20, 2, 0, 10000, 'admin', 'Menu', 'addPost', '', '后台菜单添加提交保存', '', '后台菜单添加提交保存');
INSERT INTO `cmf_admin_menu` VALUES (24, 20, 1, 0, 10000, 'admin', 'Menu', 'edit', '', '后台菜单编辑', '', '后台菜单编辑');
INSERT INTO `cmf_admin_menu` VALUES (25, 20, 2, 0, 10000, 'admin', 'Menu', 'editPost', '', '后台菜单编辑提交保存', '', '后台菜单编辑提交保存');
INSERT INTO `cmf_admin_menu` VALUES (26, 20, 2, 0, 10000, 'admin', 'Menu', 'delete', '', '后台菜单删除', '', '后台菜单删除');
INSERT INTO `cmf_admin_menu` VALUES (27, 20, 2, 0, 10000, 'admin', 'Menu', 'listOrder', '', '后台菜单排序', '', '后台菜单排序');
INSERT INTO `cmf_admin_menu` VALUES (28, 20, 1, 0, 10000, 'admin', 'Menu', 'getActions', '', '导入新后台菜单', '', '导入新后台菜单');
INSERT INTO `cmf_admin_menu` VALUES (42, 1, 1, 1, 10000, 'admin', 'Plugin', 'index', '', '插件列表', '', '插件列表');
INSERT INTO `cmf_admin_menu` VALUES (43, 42, 2, 0, 10000, 'admin', 'Plugin', 'toggle', '', '插件启用禁用', '', '插件启用禁用');
INSERT INTO `cmf_admin_menu` VALUES (44, 42, 1, 0, 10000, 'admin', 'Plugin', 'setting', '', '插件设置', '', '插件设置');
INSERT INTO `cmf_admin_menu` VALUES (45, 42, 2, 0, 10000, 'admin', 'Plugin', 'settingPost', '', '插件设置提交', '', '插件设置提交');
INSERT INTO `cmf_admin_menu` VALUES (46, 42, 2, 0, 10000, 'admin', 'Plugin', 'install', '', '插件安装', '', '插件安装');
INSERT INTO `cmf_admin_menu` VALUES (47, 42, 2, 0, 10000, 'admin', 'Plugin', 'update', '', '插件更新', '', '插件更新');
INSERT INTO `cmf_admin_menu` VALUES (48, 42, 2, 0, 10000, 'admin', 'Plugin', 'uninstall', '', '卸载插件', '', '卸载插件');
INSERT INTO `cmf_admin_menu` VALUES (49, 110, 0, 1, 10000, 'admin', 'User', 'default', '', '管理组', '', '管理组');
INSERT INTO `cmf_admin_menu` VALUES (50, 49, 1, 1, 10000, 'admin', 'Rbac', 'index', '', '角色管理', '', '角色管理');
INSERT INTO `cmf_admin_menu` VALUES (51, 50, 1, 0, 10000, 'admin', 'Rbac', 'roleAdd', '', '添加角色', '', '添加角色');
INSERT INTO `cmf_admin_menu` VALUES (52, 50, 2, 0, 10000, 'admin', 'Rbac', 'roleAddPost', '', '添加角色提交', '', '添加角色提交');
INSERT INTO `cmf_admin_menu` VALUES (53, 50, 1, 0, 10000, 'admin', 'Rbac', 'roleEdit', '', '编辑角色', '', '编辑角色');
INSERT INTO `cmf_admin_menu` VALUES (54, 50, 2, 0, 10000, 'admin', 'Rbac', 'roleEditPost', '', '编辑角色提交', '', '编辑角色提交');
INSERT INTO `cmf_admin_menu` VALUES (55, 50, 2, 0, 10000, 'admin', 'Rbac', 'roleDelete', '', '删除角色', '', '删除角色');
INSERT INTO `cmf_admin_menu` VALUES (56, 50, 1, 0, 10000, 'admin', 'Rbac', 'authorize', '', '设置角色权限', '', '设置角色权限');
INSERT INTO `cmf_admin_menu` VALUES (57, 50, 2, 0, 10000, 'admin', 'Rbac', 'authorizePost', '', '角色授权提交', '', '角色授权提交');
INSERT INTO `cmf_admin_menu` VALUES (71, 6, 1, 1, 0, 'admin', 'Setting', 'site', '', '网站信息', '', '网站信息');
INSERT INTO `cmf_admin_menu` VALUES (72, 71, 2, 0, 10000, 'admin', 'Setting', 'sitePost', '', '网站信息设置提交', '', '网站信息设置提交');
INSERT INTO `cmf_admin_menu` VALUES (73, 0, 1, 0, 7, 'admin', 'Setting', 'password', '', '密码修改', '', '密码修改');
INSERT INTO `cmf_admin_menu` VALUES (74, 73, 2, 0, 10000, 'admin', 'Setting', 'passwordPost', '', '密码修改提交', '', '密码修改提交');
INSERT INTO `cmf_admin_menu` VALUES (75, 6, 1, 1, 10000, 'admin', 'Setting', 'upload', '', '上传设置', '', '上传设置');
INSERT INTO `cmf_admin_menu` VALUES (76, 75, 2, 0, 10000, 'admin', 'Setting', 'uploadPost', '', '上传设置提交', '', '上传设置提交');
INSERT INTO `cmf_admin_menu` VALUES (77, 0, 1, 0, 10000, 'admin', 'Setting', 'clearCache', '', '清除缓存', '', '清除缓存');
INSERT INTO `cmf_admin_menu` VALUES (78, 6, 1, 1, 40, 'admin', 'Slide', 'index', '', '幻灯片管理', '', '幻灯片管理');
INSERT INTO `cmf_admin_menu` VALUES (79, 78, 1, 0, 10000, 'admin', 'Slide', 'add', '', '添加幻灯片', '', '添加幻灯片');
INSERT INTO `cmf_admin_menu` VALUES (80, 78, 2, 0, 10000, 'admin', 'Slide', 'addPost', '', '添加幻灯片提交', '', '添加幻灯片提交');
INSERT INTO `cmf_admin_menu` VALUES (81, 78, 1, 0, 10000, 'admin', 'Slide', 'edit', '', '编辑幻灯片', '', '编辑幻灯片');
INSERT INTO `cmf_admin_menu` VALUES (82, 78, 2, 0, 10000, 'admin', 'Slide', 'editPost', '', '编辑幻灯片提交', '', '编辑幻灯片提交');
INSERT INTO `cmf_admin_menu` VALUES (83, 78, 2, 0, 10000, 'admin', 'Slide', 'delete', '', '删除幻灯片', '', '删除幻灯片');
INSERT INTO `cmf_admin_menu` VALUES (84, 78, 1, 0, 10000, 'admin', 'SlideItem', 'index', '', '幻灯片页面列表', '', '幻灯片页面列表');
INSERT INTO `cmf_admin_menu` VALUES (85, 84, 1, 0, 10000, 'admin', 'SlideItem', 'add', '', '幻灯片页面添加', '', '幻灯片页面添加');
INSERT INTO `cmf_admin_menu` VALUES (86, 84, 2, 0, 10000, 'admin', 'SlideItem', 'addPost', '', '幻灯片页面添加提交', '', '幻灯片页面添加提交');
INSERT INTO `cmf_admin_menu` VALUES (87, 84, 1, 0, 10000, 'admin', 'SlideItem', 'edit', '', '幻灯片页面编辑', '', '幻灯片页面编辑');
INSERT INTO `cmf_admin_menu` VALUES (88, 84, 2, 0, 10000, 'admin', 'SlideItem', 'editPost', '', '幻灯片页面编辑提交', '', '幻灯片页面编辑提交');
INSERT INTO `cmf_admin_menu` VALUES (89, 84, 2, 0, 10000, 'admin', 'SlideItem', 'delete', '', '幻灯片页面删除', '', '幻灯片页面删除');
INSERT INTO `cmf_admin_menu` VALUES (90, 84, 2, 0, 10000, 'admin', 'SlideItem', 'ban', '', '幻灯片页面隐藏', '', '幻灯片页面隐藏');
INSERT INTO `cmf_admin_menu` VALUES (91, 84, 2, 0, 10000, 'admin', 'SlideItem', 'cancelBan', '', '幻灯片页面显示', '', '幻灯片页面显示');
INSERT INTO `cmf_admin_menu` VALUES (92, 84, 2, 0, 10000, 'admin', 'SlideItem', 'listOrder', '', '幻灯片页面排序', '', '幻灯片页面排序');
INSERT INTO `cmf_admin_menu` VALUES (93, 6, 1, 1, 10000, 'admin', 'Storage', 'index', '', '文件存储', '', '文件存储');
INSERT INTO `cmf_admin_menu` VALUES (94, 93, 2, 0, 10000, 'admin', 'Storage', 'settingPost', '', '文件存储设置提交', '', '文件存储设置提交');
INSERT INTO `cmf_admin_menu` VALUES (110, 0, 0, 1, 2, 'admin', 'users', 'default', '', '用户管理', 'group', '用户管理');
INSERT INTO `cmf_admin_menu` VALUES (111, 49, 1, 1, 10000, 'admin', 'User', 'index', '', '管理员', '', '管理员管理');
INSERT INTO `cmf_admin_menu` VALUES (112, 111, 1, 0, 10000, 'admin', 'User', 'add', '', '管理员添加', '', '管理员添加');
INSERT INTO `cmf_admin_menu` VALUES (113, 111, 2, 0, 10000, 'admin', 'User', 'addPost', '', '管理员添加提交', '', '管理员添加提交');
INSERT INTO `cmf_admin_menu` VALUES (114, 111, 1, 0, 10000, 'admin', 'User', 'edit', '', '管理员编辑', '', '管理员编辑');
INSERT INTO `cmf_admin_menu` VALUES (115, 111, 2, 0, 10000, 'admin', 'User', 'editPost', '', '管理员编辑提交', '', '管理员编辑提交');
INSERT INTO `cmf_admin_menu` VALUES (116, 111, 1, 0, 10000, 'admin', 'User', 'userInfo', '', '个人信息', '', '管理员个人信息修改');
INSERT INTO `cmf_admin_menu` VALUES (117, 111, 2, 0, 10000, 'admin', 'User', 'userInfoPost', '', '管理员个人信息修改提交', '', '管理员个人信息修改提交');
INSERT INTO `cmf_admin_menu` VALUES (118, 111, 2, 0, 10000, 'admin', 'User', 'delete', '', '管理员删除', '', '管理员删除');
INSERT INTO `cmf_admin_menu` VALUES (119, 111, 2, 0, 10000, 'admin', 'User', 'ban', '', '停用管理员', '', '停用管理员');
INSERT INTO `cmf_admin_menu` VALUES (120, 111, 2, 0, 10000, 'admin', 'User', 'cancelBan', '', '启用管理员', '', '启用管理员');
INSERT INTO `cmf_admin_menu` VALUES (121, 0, 1, 0, 10000, 'user', 'AdminAsset', 'index', '', '资源管理', 'file', '资源管理列表');
INSERT INTO `cmf_admin_menu` VALUES (122, 121, 2, 0, 10000, 'user', 'AdminAsset', 'delete', '', '删除文件', '', '删除文件');
INSERT INTO `cmf_admin_menu` VALUES (162, 0, 0, 1, 4, 'portal', 'AdminIndex', 'default', '', '内容管理', 'th', '内容管理');
INSERT INTO `cmf_admin_menu` VALUES (163, 162, 1, 1, 10000, 'portal', 'AdminArticle', 'index', '', '文章管理', '', '文章列表');
INSERT INTO `cmf_admin_menu` VALUES (164, 163, 1, 0, 10000, 'portal', 'AdminArticle', 'add', '', '添加文章', '', '添加文章');
INSERT INTO `cmf_admin_menu` VALUES (165, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'addPost', '', '添加文章提交', '', '添加文章提交');
INSERT INTO `cmf_admin_menu` VALUES (166, 163, 1, 0, 10000, 'portal', 'AdminArticle', 'edit', '', '编辑文章', '', '编辑文章');
INSERT INTO `cmf_admin_menu` VALUES (167, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'editPost', '', '编辑文章提交', '', '编辑文章提交');
INSERT INTO `cmf_admin_menu` VALUES (168, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'delete', '', '文章删除', '', '文章删除');
INSERT INTO `cmf_admin_menu` VALUES (169, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'publish', '', '文章发布', '', '文章发布');
INSERT INTO `cmf_admin_menu` VALUES (170, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'top', '', '文章置顶', '', '文章置顶');
INSERT INTO `cmf_admin_menu` VALUES (171, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'recommend', '', '文章推荐', '', '文章推荐');
INSERT INTO `cmf_admin_menu` VALUES (172, 163, 2, 0, 10000, 'portal', 'AdminArticle', 'listOrder', '', '文章排序', '', '文章排序');
INSERT INTO `cmf_admin_menu` VALUES (173, 162, 1, 1, 10000, 'portal', 'AdminCategory', 'index', '', '分类管理', '', '文章分类列表');
INSERT INTO `cmf_admin_menu` VALUES (174, 173, 1, 0, 10000, 'portal', 'AdminCategory', 'add', '', '添加文章分类', '', '添加文章分类');
INSERT INTO `cmf_admin_menu` VALUES (175, 173, 2, 0, 10000, 'portal', 'AdminCategory', 'addPost', '', '添加文章分类提交', '', '添加文章分类提交');
INSERT INTO `cmf_admin_menu` VALUES (176, 173, 1, 0, 10000, 'portal', 'AdminCategory', 'edit', '', '编辑文章分类', '', '编辑文章分类');
INSERT INTO `cmf_admin_menu` VALUES (177, 173, 2, 0, 10000, 'portal', 'AdminCategory', 'editPost', '', '编辑文章分类提交', '', '编辑文章分类提交');
INSERT INTO `cmf_admin_menu` VALUES (178, 173, 1, 0, 10000, 'portal', 'AdminCategory', 'select', '', '文章分类选择对话框', '', '文章分类选择对话框');
INSERT INTO `cmf_admin_menu` VALUES (179, 173, 2, 0, 10000, 'portal', 'AdminCategory', 'listOrder', '', '文章分类排序', '', '文章分类排序');
INSERT INTO `cmf_admin_menu` VALUES (180, 173, 2, 0, 10000, 'portal', 'AdminCategory', 'toggle', '', '文章分类显示隐藏', '', '文章分类显示隐藏');
INSERT INTO `cmf_admin_menu` VALUES (181, 173, 2, 0, 10000, 'portal', 'AdminCategory', 'delete', '', '删除文章分类', '', '删除文章分类');
INSERT INTO `cmf_admin_menu` VALUES (182, 162, 1, 1, 10000, 'portal', 'AdminPage', 'index', '', '页面管理', '', '页面管理');
INSERT INTO `cmf_admin_menu` VALUES (183, 182, 1, 0, 10000, 'portal', 'AdminPage', 'add', '', '添加页面', '', '添加页面');
INSERT INTO `cmf_admin_menu` VALUES (184, 182, 2, 0, 10000, 'portal', 'AdminPage', 'addPost', '', '添加页面提交', '', '添加页面提交');
INSERT INTO `cmf_admin_menu` VALUES (185, 182, 1, 0, 10000, 'portal', 'AdminPage', 'edit', '', '编辑页面', '', '编辑页面');
INSERT INTO `cmf_admin_menu` VALUES (186, 182, 2, 0, 10000, 'portal', 'AdminPage', 'editPost', '', '编辑页面提交', '', '编辑页面提交');
INSERT INTO `cmf_admin_menu` VALUES (187, 182, 2, 0, 10000, 'portal', 'AdminPage', 'delete', '', '删除页面', '', '删除页面');
INSERT INTO `cmf_admin_menu` VALUES (188, 162, 1, 0, 10000, 'portal', 'AdminTag', 'index', '', '文章标签', '', '文章标签');
INSERT INTO `cmf_admin_menu` VALUES (189, 188, 1, 0, 10000, 'portal', 'AdminTag', 'add', '', '添加文章标签', '', '添加文章标签');
INSERT INTO `cmf_admin_menu` VALUES (190, 188, 2, 0, 10000, 'portal', 'AdminTag', 'addPost', '', '添加文章标签提交', '', '添加文章标签提交');
INSERT INTO `cmf_admin_menu` VALUES (191, 188, 2, 0, 10000, 'portal', 'AdminTag', 'upStatus', '', '更新标签状态', '', '更新标签状态');
INSERT INTO `cmf_admin_menu` VALUES (192, 188, 2, 0, 10000, 'portal', 'AdminTag', 'delete', '', '删除文章标签', '', '删除文章标签');
INSERT INTO `cmf_admin_menu` VALUES (193, 6, 1, 1, 1, 'admin', 'Setting', 'configpri', '', '私密设置', '', '');
INSERT INTO `cmf_admin_menu` VALUES (194, 193, 1, 0, 10000, 'admin', 'Setting', 'configpriPost', '', '设置', '', '');
INSERT INTO `cmf_admin_menu` VALUES (195, 0, 0, 1, 10000, 'admin', 'course', 'default', '', '知识管理', '', '');
INSERT INTO `cmf_admin_menu` VALUES (196, 195, 1, 1, 2, 'admin', 'courseclass', 'index', '', '科目分类', '', '');
INSERT INTO `cmf_admin_menu` VALUES (197, 196, 1, 0, 10000, 'admin', 'courseclass', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (198, 196, 1, 0, 10000, 'admin', 'courseclass', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (199, 196, 1, 0, 10000, 'admin', 'courseclass', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (200, 196, 1, 0, 10000, 'admin', 'courseclass', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (201, 196, 1, 0, 10000, 'admin', 'courseclass', 'listOrder', '', '排序', '', '');
INSERT INTO `cmf_admin_menu` VALUES (202, 196, 1, 0, 10000, 'admin', 'courseclass', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (203, 110, 1, 1, 10000, 'admin', 'users', 'index', 'type=0', '用户列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (204, 203, 1, 0, 10000, 'admin', 'users', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (205, 203, 1, 0, 10000, 'admin', 'users', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (206, 203, 1, 0, 10000, 'admin', 'users', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (207, 203, 1, 0, 10000, 'admin', 'users', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (208, 203, 1, 0, 10000, 'admin', 'users', 'ban', '', '禁用', '', '');
INSERT INTO `cmf_admin_menu` VALUES (209, 203, 1, 0, 10000, 'admin', 'users', 'cancelBan', '', '启用', '', '');
INSERT INTO `cmf_admin_menu` VALUES (210, 203, 1, 0, 10000, 'admin', 'users', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (211, 0, 1, 1, 10000, 'admin', 'signory', 'index', '', '专长领域', '', '');
INSERT INTO `cmf_admin_menu` VALUES (212, 211, 1, 0, 10000, 'admin', 'signory', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (213, 211, 1, 0, 10000, 'admin', 'signory', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (214, 211, 1, 0, 10000, 'admin', 'signory', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (215, 211, 1, 0, 10000, 'admin', 'signory', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (216, 211, 1, 0, 10000, 'admin', 'signory', 'listOrder', '', '排序', '', '');
INSERT INTO `cmf_admin_menu` VALUES (217, 211, 1, 0, 10000, 'admin', 'signory', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (218, 0, 1, 1, 10000, 'admin', 'identity', 'index', '', '身份标识', '', '');
INSERT INTO `cmf_admin_menu` VALUES (219, 218, 1, 0, 10000, 'admin', 'identity', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (220, 218, 1, 0, 10000, 'admin', 'identity', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (221, 218, 1, 0, 10000, 'admin', 'identity', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (222, 218, 1, 0, 10000, 'admin', 'identity', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (223, 218, 1, 0, 10000, 'admin', 'identity', 'listOrder', '', '排序', '', '');
INSERT INTO `cmf_admin_menu` VALUES (224, 218, 1, 0, 10000, 'admin', 'identity', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (225, 110, 1, 1, 10000, 'admin', 'users', 'teacher', 'type=1', '教师列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (226, 0, 1, 1, 10000, 'admin', 'feedback', 'index', '', '反馈', '', '');
INSERT INTO `cmf_admin_menu` VALUES (227, 226, 1, 0, 10000, 'admin', 'feedback', 'setstatus', '', '处理', '', '');
INSERT INTO `cmf_admin_menu` VALUES (228, 226, 1, 0, 10000, 'admin', 'feedback', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (229, 195, 1, 1, 3, 'admin', 'course', 'index', 'sort=1', '课程列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (230, 229, 1, 0, 10000, 'admin', 'course', 'add', 'sort=0', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (231, 229, 1, 0, 10000, 'admin', 'course', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (232, 229, 1, 0, 10000, 'admin', 'course', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (233, 229, 1, 0, 10000, 'admin', 'course', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (234, 229, 1, 0, 10000, 'admin', 'course', 'setstatus', '', '上下架', '', '');
INSERT INTO `cmf_admin_menu` VALUES (235, 229, 1, 0, 10000, 'admin', 'course', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (236, 195, 1, 1, 4, 'admin', 'course', 'contents', 'sort=0', '付费内容列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (237, 266, 1, 1, 1, 'admin', 'course', 'live', 'sort=2', '语音大班课', '', '');
INSERT INTO `cmf_admin_menu` VALUES (238, 195, 1, 0, 10000, 'admin', 'lession', 'index', '', '课时管理', '', '');
INSERT INTO `cmf_admin_menu` VALUES (239, 238, 1, 0, 10000, 'admin', 'lession', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (240, 238, 1, 0, 10000, 'admin', 'lession', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (241, 238, 1, 0, 10000, 'admin', 'lession', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (242, 238, 1, 0, 10000, 'admin', 'lession', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (243, 238, 1, 0, 10000, 'admin', 'lession', 'listOrder', '', '排序', '', '');
INSERT INTO `cmf_admin_menu` VALUES (244, 238, 1, 0, 10000, 'admin', 'lession', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (245, 0, 1, 1, 10000, 'admin', 'push', 'index', '', '系统消息', '', '');
INSERT INTO `cmf_admin_menu` VALUES (246, 245, 1, 0, 10000, 'admin', 'push', 'add', '', '推送', '', '');
INSERT INTO `cmf_admin_menu` VALUES (247, 245, 1, 0, 10000, 'admin', 'push', 'addPost', '', '推送提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (248, 0, 1, 1, 5, 'admin', 'orders', 'index', '', '订单管理', '', '');
INSERT INTO `cmf_admin_menu` VALUES (249, 248, 1, 0, 10000, 'admin', 'orders', 'goods', '', '商品列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (250, 248, 1, 0, 10000, 'admin', 'orders', 'setSend', '', '标记发货', '', '');
INSERT INTO `cmf_admin_menu` VALUES (251, 195, 1, 1, 1, 'admin', 'Coursegrade', 'index', '', '学级分类', '', '');
INSERT INTO `cmf_admin_menu` VALUES (252, 251, 1, 0, 10000, 'admin', 'Coursegrade', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (253, 251, 1, 0, 10000, 'admin', 'Coursegrade', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (254, 251, 1, 0, 10000, 'admin', 'Coursegrade', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (255, 251, 1, 0, 10000, 'admin', 'Coursegrade', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (256, 251, 1, 0, 10000, 'admin', 'Coursegrade', 'listOrder', '', '排序', '', '');
INSERT INTO `cmf_admin_menu` VALUES (257, 251, 1, 0, 10000, 'admin', 'Coursegrade', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (258, 195, 1, 1, 10000, 'admin', 'package', 'index', '', '套餐管理', '', '');
INSERT INTO `cmf_admin_menu` VALUES (259, 258, 1, 0, 10000, 'admin', 'package', 'add', '', '添加', '', '');
INSERT INTO `cmf_admin_menu` VALUES (260, 258, 1, 0, 10000, 'admin', 'package', 'addPost', '', '添加提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (261, 258, 1, 0, 10000, 'admin', 'package', 'edit', '', '编辑', '', '');
INSERT INTO `cmf_admin_menu` VALUES (262, 258, 1, 0, 10000, 'admin', 'package', 'editPost', '', '编辑提交', '', '');
INSERT INTO `cmf_admin_menu` VALUES (263, 258, 1, 0, 10000, 'admin', 'package', 'listOrder', '', '排序', '', '');
INSERT INTO `cmf_admin_menu` VALUES (264, 258, 1, 0, 10000, 'admin', 'package', 'del', '', '删除', '', '');
INSERT INTO `cmf_admin_menu` VALUES (265, 258, 1, 0, 10000, 'admin', 'package', 'getCourse', '', '获取课程', '', '');
INSERT INTO `cmf_admin_menu` VALUES (266, 195, 1, 1, 10000, 'admin', 'course', 'default3', '', ' 大班课列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (267, 266, 1, 1, 2, 'admin', 'course', 'live_video', 'sort=3', '视频大班课', '', '');
INSERT INTO `cmf_admin_menu` VALUES (268, 110, 1, 1, 10000, 'Admin', 'Users', 'hiddwords', '', '禁言列表', '', '');
INSERT INTO `cmf_admin_menu` VALUES (269, 0, 1, 1, 10000, 'Admin', 'Startlive', 'index', '', '开播IP统计', '', '');
INSERT INTO `cmf_admin_menu` VALUES (270, 0, 1, 1, 10000, 'Admin', 'seelivelong', 'index', '', '观看直播时长统计', '', '');
INSERT INTO `cmf_admin_menu` VALUES (271, 0, 1, 1, 10000, 'Admin', 'opencity', 'index', '', '城市人数统计', '', '');

-- ----------------------------
-- Table structure for cmf_asset
-- ----------------------------
DROP TABLE IF EXISTS `cmf_asset`;
CREATE TABLE `cmf_asset`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户id',
  `file_size` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文件大小,单位B',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '上传时间',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态;1:可用,0:不可用',
  `download_times` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '下载次数',
  `file_key` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件惟一码',
  `filename` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文件名',
  `file_path` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件路径,相对于upload目录,可以为url',
  `file_md5` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '文件md5值',
  `file_sha1` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `suffix` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '文件后缀名,不包括点',
  `more` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '其它详细信息,JSON格式',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 43 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资源表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_asset
-- ----------------------------
INSERT INTO `cmf_asset` VALUES (1, 1, 25550, 1594715968, 1, 0, 'd5a491cd3d8d071e3212c3478e8e35a13bd5853ff683704ce990de82a21bbe95', 'timg.jpg', 'admin/20200714/f5006114ce5644efa150d93a30d2f103.jpg', 'd5a491cd3d8d071e3212c3478e8e35a1', 'e5f7e10406ff06c8f5a014895d38009b54a6c4a4', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (2, 1, 173322, 1594716061, 1, 0, '398d9648f910cd9d3fde9b6d8dbae1756206c3c8553f913e40541ae8c61232fb', '20c7eabb226dc0e61180c843221bda38.jpg', 'admin/20200714/a8b3df07f86e120b4e5a04d443ecaa76.jpg', '398d9648f910cd9d3fde9b6d8dbae175', '31ea18c72de230028908afed7a70eca0303cceba', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (3, 1, 253354, 1594717739, 1, 0, '39270b1276af4c6af020cc85eb80fb2915bf97d3c21e0a997d164e5a8293eb6a', '830cc920ee5a6e5154dfca6a43bfdb32.jpg', 'admin/20200714/e1c581c727a512ab7a5df412a785d3e3.jpg', '39270b1276af4c6af020cc85eb80fb29', '97518bc000e0ea004268b44f96b48415fb687203', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (4, 1, 1775, 1595558764, 1, 0, 'c6f6be6c3d95784921f0a5f7d9c991686d996598eeeeb05b945c4ccab026abae', '服务-1@2x.png', 'admin/20200724/2f4b6bea8aca6feea2b084c75ceab942.png', 'c6f6be6c3d95784921f0a5f7d9c99168', '84ea63e59c44bf1229354cb47050c2922c6122f7', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (5, 1, 28149, 1595840430, 1, 0, 'c1eb1a0cda98e8b49c3f4330298507691ce8d62a98f78f8e71459a2339562c3d', 'u=2534506313,1688529724&fm=26&gp=0.jpg', 'admin/20200727/be4fd2d88102a3d535ffa3e48dae2bfd.jpg', 'c1eb1a0cda98e8b49c3f433029850769', 'ccd9c079411935ad3063978914eb5e0833afeed3', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (6, 1, 1441232, 1596011897, 1, 0, 'eb2f60861ad02f9cd33afb6d0f124c5c9b509b415e70a36d5c6d8d2056cd8e15', 'QQ视频20200314110802.mp4', 'admin/20200729/3b4828db631043d58d3ff02720bea36e.mp4', 'eb2f60861ad02f9cd33afb6d0f124c5c', '00b63d37bd19260c237c62cae9c1caf6212cc340', 'mp4', NULL);
INSERT INTO `cmf_asset` VALUES (7, 1, 3245878, 1596526230, 1, 0, '8b8f3bd0acee51cb34105830f8a7a13a94acc240e92bae9b15283c25e84d9ce9', '华莎 (화사) - 마리아 (Maria).mp3', 'admin/20200804/a6f6c033abc1f35b5d7df03ced2384ab.mp3', '8b8f3bd0acee51cb34105830f8a7a13a', '65e02af5a9573c36849048efb18127af3980ff12', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (8, 1, 2796, 1596616107, 1, 0, '7f65de01f89edd7dd77c7b07aad6906d8a47f4390ebd661d13f047cf5e63af70', 'kefu.png', 'admin/20200805/83782e947aa0b8ba6819e77d5e41939a.png', '7f65de01f89edd7dd77c7b07aad6906d', 'a0031c036be9fea19add40bd85f6c773ad21409f', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (9, 1, 99328, 1596616492, 1, 0, '48cc74e51eb6573315fe8731406208d6cba8563230a2288b0811a6cd2e1ae97c', '商城系统导航下拉菜单和修改.doc', 'default/20200805/e1ebb316f7ddafd776ca959aabee143f.doc', '48cc74e51eb6573315fe8731406208d6', '2a4f26a277801e3f4d8565042118f5c7f2c2e3cb', 'doc', NULL);
INSERT INTO `cmf_asset` VALUES (10, 2, 28149, 1596675363, 1, 0, 'c1eb1a0cda98e8b49c3f4330298507691ce8d62a98f78f8e71459a2339562c3d', 'u=2534506313,1688529724&fm=26&gp=0.jpg', 'default/20200806/9952e02d728fe81551f5487f2cbae51f.jpg', 'c1eb1a0cda98e8b49c3f433029850769', 'ccd9c079411935ad3063978914eb5e0833afeed3', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (11, 2, 1563, 1596675536, 1, 0, '7f77e82283b2bc657744a6f0c24c381ebde4970dae7ec48129dcc93826390031', 'image.png', 'default/20200806/68681346c5e045cfffbdaa7a23094eaa.png', '7f77e82283b2bc657744a6f0c24c381e', '4a29734396313456f5cd1cfba4a871575e45ae3f', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (12, 1, 1563, 1596677506, 1, 0, '7f77e82283b2bc657744a6f0c24c381ebde4970dae7ec48129dcc93826390031', 'image.png', 'default/20200806/85d05a8ec0bc063a9d2d68c905464290.png', '7f77e82283b2bc657744a6f0c24c381e', '4a29734396313456f5cd1cfba4a871575e45ae3f', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (13, 1, 1782, 1596677555, 1, 0, '9cc44f81461de30d70c72fb03a4187758b8644834e3a0a55e3dce5315f9cc459', '服务-2@2x.png', 'default/20200806/39082cba157187a58b57c665522e3c26.png', '9cc44f81461de30d70c72fb03a418775', 'ee04d145e5c675dc5d909e5ccd5fb499c4fc6838', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (14, 1, 2083, 1596679215, 1, 0, '6b581c61d41a990dba625c3746d0f0d8e424913c0f6cb9060f674990f937c7d7', 'user_tuandui2.png', 'admin/20200806/08e09d0281587bd243a908e84b4ffde6.png', '6b581c61d41a990dba625c3746d0f0d8', '7d2b4e8fae496fc925a68b8271bd2690fd374214', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (15, 1, 1869, 1596685952, 1, 0, 'd80d23e5b39a80745d0791b9f8f66215e448faefba07a9a6a229bafccfd3dbd3', '服务-4@2x.png', 'admin/20200806/11c31c64db15d5e1bd5926cccc000a94.png', 'd80d23e5b39a80745d0791b9f8f66215', '68e57e96a84a66f8c12ecad9672f67c1d40e6b6e', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (16, 1, 1815, 1596685964, 1, 0, '5e61330ac27cea5e5286657bbcd92a63377adc22dbbbba269096cacd870e9594', 'user_tuandui3.png', 'admin/20200806/e527ebad4e01b547f1238e64b074c5e1.png', '5e61330ac27cea5e5286657bbcd92a63', '9c792277ccecc5d405ecd3d07dbbcb77d6ac0c86', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (17, 1, 1636, 1596685977, 1, 0, 'dfa577c3cc4fba57ce3086659062af377c21440637f26b2dad6bc6ad139dd263', 'customer.png', 'admin/20200806/50b7e29d880cfcb14d3e6440c0a0bdb1.png', 'dfa577c3cc4fba57ce3086659062af37', '4f577b877136a02862a0897014b50d95997b42cb', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (18, 1, 1238, 1596685989, 1, 0, 'd30c5f9f6d431f49f51eae39cb94bfba5111afb7e92b72ed9fddec61dffa7c1d', 'user_daixaio1.png', 'admin/20200806/5f454949bdecdda4cce26c96095a2be2.png', 'd30c5f9f6d431f49f51eae39cb94bfba', 'dfb9a8efe1c9a279727d9886ac8d8fdfb08f7827', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (19, 1, 1396, 1596686029, 1, 0, '27d4c2b03b28c4516e7a197b905618fa0c889ae4b7a7b4a6ccdbb00548e8b662', 'user_daixaio2.png', 'admin/20200806/295562b63b964de736f92b0fc3825132.png', '27d4c2b03b28c4516e7a197b905618fa', 'deb606b3100f4664f2e5f0a0f3e32fa551ea2d77', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (20, 1, 1740, 1596686040, 1, 0, 'e1f76c0daac859c05a82d6210263e6005ebccb9333196df07e90fc4cd2ab52cf', 'user_dianpu2.png', 'admin/20200806/7c77d1dbe7de400bfb2db8c9184e964d.png', 'e1f76c0daac859c05a82d6210263e600', 'c47ce3f430df52217b39a7e52831a666266bf798', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (21, 1, 1532, 1596686071, 1, 0, '212a46c803054e1d9306c10096538e4475d0da62df5909eb5dc51f310f770d95', '服务-3@2x.png', 'admin/20200806/eec146718cc38e5c8c1db905e671f066.png', '212a46c803054e1d9306c10096538e44', 'b5079626372424d817985ba3f869dc3c8718957d', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (22, 1, 1948, 1596691987, 1, 0, '1416ca3c72c0128fb2e64a3a8e921e58c3d0ca13c03b1df005ec249a295497a9', 'gexing.png', 'admin/20200806/362b596ac9b45713392d8adb05263b52.png', '1416ca3c72c0128fb2e64a3a8e921e58', '224827698aaf192e1e1884731c6fb64d84785930', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (23, 1, 2289, 1596692780, 1, 0, '9e35037640ea2869bbf36621c3550c737b68c25527f7af22d02cf5191e563b92', 'user_tuandui1.png', 'admin/20200806/5c1e7fd24f8d7cacb7d0f3bc6d1b8f6c.png', '9e35037640ea2869bbf36621c3550c73', '02f583c0a2c90b83b8b1020caf490a49c5b3bfb7', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (24, 1, 461, 1596692830, 1, 0, '80d4482d0344f052f1304f11092058642e772d66b2ec53bfdb076d0c3cc82c80', '信用卡.png', 'admin/20200806/c5df108ad69ab94c56b0ace4f681d19f.png', '80d4482d0344f052f1304f1109205864', '328fd7dd36f73157cd140cb8d0fbea47fbcd9093', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (25, 1, 2356, 1596692889, 1, 0, 'ed7144f7b9efdddc837d4d5d21cb8c5b7514b3bc3a986eef8bc55eefe96d587d', 'xy_0.png', 'admin/20200806/f56679f35965288424e8f65a450921d0.png', 'ed7144f7b9efdddc837d4d5d21cb8c5b', 'cdfd2295cc4c232f06ebea8ac9c8e96837405d5e', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (26, 1, 2094, 1596699185, 1, 0, 'a05fabb33ed0a37c7a56f94301807fcaaeffc8672f82cb5444e16159739d46a9', 'fangke.png', 'admin/20200806/d72acb581da80f8e53b7084e2084ddd4.png', 'a05fabb33ed0a37c7a56f94301807fca', '5a9573e802aef12c4a653aaf305d979258c8c183', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (27, 1, 3927877, 1596701434, 1, 0, '5b2095984cc81e21a47ebb54b2426c11980ae746178cb33aaed63795396b27d7', '陈奕迅 - 一丝不挂.mp3', 'admin/20200806/e46b22eca3332266aff6dbe64bb14c4a.mp3', '5b2095984cc81e21a47ebb54b2426c11', '0b1891eb2cff27494ac07a752e35dd66a846ec5c', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (28, 1, 130335, 1596780615, 1, 0, 'f5dea32ecc92f5b8c371101412e9cde54419f60ffc196ede406d29a0fda02225', 'x_edu_journal_img1.png', 'admin/20200807/3807b92d46ff0795db39d9849f415e8b.png', 'f5dea32ecc92f5b8c371101412e9cde5', '29b2babaf899cbf1ab031952415c0b1ab13342f4', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (29, 2, 49536, 1596848738, 1, 0, '74a7f848b90af9507dbcc031a28cb87f837ce810549bdb7aa7a0806a5eff0caf', 'blob.mp3', 'default/20200808/e92241fc69ab85b1028c93c605be82d7.mp3', '74a7f848b90af9507dbcc031a28cb87f', '10ef6bb369ebd904a78f7886bb66b4c18b2f37f5', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (30, 2, 104448, 1596848759, 1, 0, 'c778ca47d175469268642a18d1bd6e58de2235f0da8ce03621ebec79d9fecf79', 'blob.mp3', 'default/20200808/517250c9e09cf5d126e2d02606f9edb6.mp3', 'c778ca47d175469268642a18d1bd6e58', '5b30aeb19e41ab29136fb56ab3418eeb0a103763', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (31, 2, 158976, 1596848919, 1, 0, '00b2fc160adfe92accbb6a15877723a0535eacd8f38fa0751bfb5c56e9aa85f4', 'blob.mp3', 'default/20200808/4e0687165059470599a84697ccc5bdc5.mp3', '00b2fc160adfe92accbb6a15877723a0', '17773eb81d5fdb02939d0df9f572b94a65e93d7c', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (32, 2, 158976, 1596849180, 1, 0, '10646e98b35509dabb03d2495e147dd245b176b69091696f66c46ea1a7aab395', 'blob.mp3', 'default/20200808/af776ba3c70a1c9175f9b21a4024aadc.mp3', '10646e98b35509dabb03d2495e147dd2', '3b76db37b7e49d90740b6a2890b1c266752a1378', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (33, 1, 306432, 1596849362, 1, 0, 'd6044505b7da2238d03669f9192e432da7462ddf8b8a600a669dbf355182efb6', 'blob.mp3', 'default/20200808/a833825eefce5836254b3cf82afb151f.mp3', 'd6044505b7da2238d03669f9192e432d', '76cf5884204a6fa80eedf1714204b9a50a4c900c', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (34, 1, 120576, 1596853836, 1, 0, '33aa52c1fbbc5f1181c54d5dc3f1aa63523536b7c31e86ea6bc3815347f2d440', 'blob.mp3', 'default/20200808/0a555b2925dffebeb18ba7bd21255775.mp3', '33aa52c1fbbc5f1181c54d5dc3f1aa63', 'a04682fbeb0c81d323dfe4645e9a011b4aa16bc1', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (35, 2, 110652, 1596857938, 1, 0, 'fe26d4af0516497ba7b61490e4f19e0dd7eaec5b9e698efa7f2717d51b32b3da', '{FE26D4AF-0516-497B-A7B6-1490E4F19E0D}.png', 'default/20200808/c0e14f4e54f7a8766de7028e4a260d48.png', 'fe26d4af0516497ba7b61490e4f19e0d', '7487dbe0801ba5e99058d1129d40fe083fc0624a', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (36, 1, 110652, 1596866427, 1, 0, 'fe26d4af0516497ba7b61490e4f19e0dd7eaec5b9e698efa7f2717d51b32b3da', '{FE26D4AF-0516-497B-A7B6-1490E4F19E0D}.png', 'default/20200808/61f803680feb7494a83c70fabe6c41be.png', 'fe26d4af0516497ba7b61490e4f19e0d', '7487dbe0801ba5e99058d1129d40fe083fc0624a', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (37, 1, 71424, 1597041890, 1, 0, '5ee2e93619acdee30d954ae8623b7cb9537b12a1702d2a7c9428622bff4ca377', 'blob.mp3', 'default/20200810/168b7f3e2758734db216786574093edc.mp3', '5ee2e93619acdee30d954ae8623b7cb9', '65c811f4df4aafba33eab9d9e6ee83e5ac1ef350', 'mp3', NULL);
INSERT INTO `cmf_asset` VALUES (38, 1, 14515, 1597111198, 1, 0, 'cdb69065f80029326aa65133e657821a5047eaea21c85d9db8a66ebc8064dfd0', '(外接项目)20200518鹏哥客户.docx', 'default/20200811/bf5d09da1b225a344d3bd54f49b23203.docx', 'cdb69065f80029326aa65133e657821a', 'b56fac7b8d2a9ae38a0cbbc1e6b43c6fe56eaac8', 'docx', NULL);
INSERT INTO `cmf_asset` VALUES (39, 2, 4183, 1597289263, 1, 0, '87ffd6ac894f03c0d36dae5ac6eacb111d059e00e51e904858c602789e3d28b1', 'ic_launcher.png', 'default/20200813/a47e0bebc7e8beb5796cf0e20fd0f73c.png', '87ffd6ac894f03c0d36dae5ac6eacb11', '65898bd5439ca0cdb56ec53fb1d9bbb36de71398', 'png', NULL);
INSERT INTO `cmf_asset` VALUES (40, 1, 12821, 1598002235, 1, 0, 'eec5973e6baa7e214b1dbc2ef04789478696afbf5bf7528e4f0a9e2e4d668b62', 'u=1982109569,4202656572&fm=26&gp=0.jpg', 'admin/20200821/250947610157d2318f74de1b575d3b0f.jpg', 'eec5973e6baa7e214b1dbc2ef0478947', '4eb79f309877ddfa02370c4e328ffa1d33a8d540', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (41, 1, 26843, 1598002290, 1, 0, 'c81d4a2d8d7d9954d4280aa829cf503c9140ad75583cc4d7b11de6171b3b7b49', 'u=3713234815,3384673869&fm=26&gp=0.jpg', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 'c81d4a2d8d7d9954d4280aa829cf503c', 'cbe54812fb4379237873520f889352c21b8fbea7', 'jpg', NULL);
INSERT INTO `cmf_asset` VALUES (42, 1, 113275, 1598002712, 1, 0, '78cc3c2a18873536d3568940cc2562e4f095a919acbb7d7a0350d20c3fbbd6d5', 'u=1458229275,3774320714&fm=26&gp=0.jpg', 'admin/20200821/8854f0533fc8a687aff663e97aee9e0c.jpg', '78cc3c2a18873536d3568940cc2562e4', '26ebbb1b395883fdbc106614964d0afac0d97758', 'jpg', NULL);

-- ----------------------------
-- Table structure for cmf_auth_access
-- ----------------------------
DROP TABLE IF EXISTS `cmf_auth_access`;
CREATE TABLE `cmf_auth_access`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `role_id` int(10) UNSIGNED NOT NULL COMMENT '角色',
  `rule_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '规则唯一英文标识,全小写',
  `type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '权限规则分类,请加应用前缀,如admin_',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `role_id`(`role_id`) USING BTREE,
  INDEX `rule_name`(`rule_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 148 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '权限授权表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_auth_access
-- ----------------------------
INSERT INTO `cmf_auth_access` VALUES (60, 2, 'admin/users/default', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (61, 2, 'admin/user/default', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (62, 2, 'admin/rbac/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (63, 2, 'admin/user/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (64, 2, 'admin/users/default1', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (65, 2, 'admin/users/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (66, 2, 'admin/users/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (67, 2, 'admin/users/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (68, 2, 'admin/users/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (69, 2, 'admin/users/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (70, 2, 'admin/users/ban', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (71, 2, 'admin/users/cancelban', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (72, 2, 'admin/users/teacher', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (73, 2, 'portal/adminindex/default', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (74, 2, 'portal/adminarticle/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (75, 2, 'portal/adminarticle/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (76, 2, 'portal/adminarticle/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (77, 2, 'portal/adminarticle/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (78, 2, 'portal/adminarticle/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (79, 2, 'portal/adminarticle/delete', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (80, 2, 'portal/adminarticle/publish', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (81, 2, 'portal/adminarticle/top', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (82, 2, 'portal/adminarticle/recommend', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (83, 2, 'portal/adminarticle/listorder', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (84, 2, 'portal/admincategory/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (85, 2, 'portal/admincategory/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (86, 2, 'portal/admincategory/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (87, 2, 'portal/admincategory/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (88, 2, 'portal/admincategory/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (89, 2, 'portal/admincategory/select', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (90, 2, 'portal/admincategory/listorder', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (91, 2, 'portal/admincategory/toggle', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (92, 2, 'portal/admincategory/delete', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (93, 2, 'portal/adminpage/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (94, 2, 'portal/adminpage/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (95, 2, 'portal/adminpage/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (96, 2, 'portal/adminpage/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (97, 2, 'portal/adminpage/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (98, 2, 'portal/adminpage/delete', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (99, 2, 'portal/admintag/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (100, 2, 'portal/admintag/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (101, 2, 'portal/admintag/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (102, 2, 'portal/admintag/upstatus', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (103, 2, 'portal/admintag/delete', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (104, 2, 'admin/menu/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (105, 2, 'admin/menu/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (106, 2, 'admin/menu/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (107, 2, 'admin/menu/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (108, 2, 'admin/menu/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (109, 2, 'admin/course/default', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (110, 2, 'admin/courseclass/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (111, 2, 'admin/courseclass/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (112, 2, 'admin/courseclass/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (113, 2, 'admin/courseclass/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (114, 2, 'admin/courseclass/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (115, 2, 'admin/courseclass/listorder', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (116, 2, 'admin/course/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (117, 2, 'admin/course/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (118, 2, 'admin/course/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (119, 2, 'admin/course/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (120, 2, 'admin/course/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (121, 2, 'admin/course/setstatus', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (122, 2, 'admin/course/contents', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (123, 2, 'admin/course/live', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (124, 2, 'admin/lession/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (125, 2, 'admin/lession/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (126, 2, 'admin/lession/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (127, 2, 'admin/lession/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (128, 2, 'admin/lession/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (129, 2, 'admin/lession/listorder', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (130, 2, 'admin/signory/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (131, 2, 'admin/signory/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (132, 2, 'admin/signory/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (133, 2, 'admin/signory/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (134, 2, 'admin/signory/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (135, 2, 'admin/signory/listorder', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (136, 2, 'admin/identity/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (137, 2, 'admin/identity/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (138, 2, 'admin/identity/addpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (139, 2, 'admin/identity/edit', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (140, 2, 'admin/identity/editpost', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (141, 2, 'admin/identity/listorder', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (142, 2, 'admin/feedback/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (143, 2, 'admin/feedback/setstatus', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (144, 2, 'admin/feedback/del', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (145, 2, 'admin/push/index', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (146, 2, 'admin/push/add', 'admin_url');
INSERT INTO `cmf_auth_access` VALUES (147, 2, 'admin/push/addpost', 'admin_url');

-- ----------------------------
-- Table structure for cmf_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `cmf_auth_rule`;
CREATE TABLE `cmf_auth_rule`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '规则id,自增主键',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否有效(0:无效,1:有效)',
  `app` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则所属app',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '权限规则分类，请加应用前缀,如admin_',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则唯一英文标识,全小写',
  `param` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '额外url参数',
  `title` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '规则描述',
  `condition` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '规则附加条件',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `name`(`name`) USING BTREE,
  INDEX `module`(`app`, `status`, `type`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 272 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '权限规则表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_auth_rule
-- ----------------------------
INSERT INTO `cmf_auth_rule` VALUES (1, 1, 'admin', 'admin_url', 'admin/Hook/index', '', '钩子管理', '');
INSERT INTO `cmf_auth_rule` VALUES (2, 1, 'admin', 'admin_url', 'admin/Hook/plugins', '', '钩子插件管理', '');
INSERT INTO `cmf_auth_rule` VALUES (3, 1, 'admin', 'admin_url', 'admin/Hook/pluginListOrder', '', '钩子插件排序', '');
INSERT INTO `cmf_auth_rule` VALUES (4, 1, 'admin', 'admin_url', 'admin/Hook/sync', '', '同步钩子', '');
INSERT INTO `cmf_auth_rule` VALUES (5, 1, 'admin', 'admin_url', 'admin/Link/index', '', '友情链接', '');
INSERT INTO `cmf_auth_rule` VALUES (6, 1, 'admin', 'admin_url', 'admin/Link/add', '', '添加友情链接', '');
INSERT INTO `cmf_auth_rule` VALUES (7, 1, 'admin', 'admin_url', 'admin/Link/addPost', '', '添加友情链接提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (8, 1, 'admin', 'admin_url', 'admin/Link/edit', '', '编辑友情链接', '');
INSERT INTO `cmf_auth_rule` VALUES (9, 1, 'admin', 'admin_url', 'admin/Link/editPost', '', '编辑友情链接提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (10, 1, 'admin', 'admin_url', 'admin/Link/delete', '', '删除友情链接', '');
INSERT INTO `cmf_auth_rule` VALUES (11, 1, 'admin', 'admin_url', 'admin/Link/listOrder', '', '友情链接排序', '');
INSERT INTO `cmf_auth_rule` VALUES (12, 1, 'admin', 'admin_url', 'admin/Link/toggle', '', '友情链接显示隐藏', '');
INSERT INTO `cmf_auth_rule` VALUES (13, 1, 'admin', 'admin_url', 'admin/Mailer/index', '', '邮箱配置', '');
INSERT INTO `cmf_auth_rule` VALUES (14, 1, 'admin', 'admin_url', 'admin/Mailer/indexPost', '', '邮箱配置提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (15, 1, 'admin', 'admin_url', 'admin/Mailer/template', '', '邮件模板', '');
INSERT INTO `cmf_auth_rule` VALUES (16, 1, 'admin', 'admin_url', 'admin/Mailer/templatePost', '', '邮件模板提交', '');
INSERT INTO `cmf_auth_rule` VALUES (17, 1, 'admin', 'admin_url', 'admin/Mailer/test', '', '邮件发送测试', '');
INSERT INTO `cmf_auth_rule` VALUES (18, 1, 'admin', 'admin_url', 'admin/Menu/index', '', '后台菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (19, 1, 'admin', 'admin_url', 'admin/Menu/lists', '', '所有菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (20, 1, 'admin', 'admin_url', 'admin/Menu/add', '', '后台菜单添加', '');
INSERT INTO `cmf_auth_rule` VALUES (21, 1, 'admin', 'admin_url', 'admin/Menu/addPost', '', '后台菜单添加提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (22, 1, 'admin', 'admin_url', 'admin/Menu/edit', '', '后台菜单编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (23, 1, 'admin', 'admin_url', 'admin/Menu/editPost', '', '后台菜单编辑提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (24, 1, 'admin', 'admin_url', 'admin/Menu/delete', '', '后台菜单删除', '');
INSERT INTO `cmf_auth_rule` VALUES (25, 1, 'admin', 'admin_url', 'admin/Menu/listOrder', '', '后台菜单排序', '');
INSERT INTO `cmf_auth_rule` VALUES (26, 1, 'admin', 'admin_url', 'admin/Menu/getActions', '', '导入新后台菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (27, 1, 'admin', 'admin_url', 'admin/Nav/index', '', '导航管理', '');
INSERT INTO `cmf_auth_rule` VALUES (28, 1, 'admin', 'admin_url', 'admin/Nav/add', '', '添加导航', '');
INSERT INTO `cmf_auth_rule` VALUES (29, 1, 'admin', 'admin_url', 'admin/Nav/addPost', '', '添加导航提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (30, 1, 'admin', 'admin_url', 'admin/Nav/edit', '', '编辑导航', '');
INSERT INTO `cmf_auth_rule` VALUES (31, 1, 'admin', 'admin_url', 'admin/Nav/editPost', '', '编辑导航提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (32, 1, 'admin', 'admin_url', 'admin/Nav/delete', '', '删除导航', '');
INSERT INTO `cmf_auth_rule` VALUES (33, 1, 'admin', 'admin_url', 'admin/NavMenu/index', '', '导航菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (34, 1, 'admin', 'admin_url', 'admin/NavMenu/add', '', '添加导航菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (35, 1, 'admin', 'admin_url', 'admin/NavMenu/addPost', '', '添加导航菜单提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (36, 1, 'admin', 'admin_url', 'admin/NavMenu/edit', '', '编辑导航菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (37, 1, 'admin', 'admin_url', 'admin/NavMenu/editPost', '', '编辑导航菜单提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (38, 1, 'admin', 'admin_url', 'admin/NavMenu/delete', '', '删除导航菜单', '');
INSERT INTO `cmf_auth_rule` VALUES (39, 1, 'admin', 'admin_url', 'admin/NavMenu/listOrder', '', '导航菜单排序', '');
INSERT INTO `cmf_auth_rule` VALUES (40, 1, 'admin', 'admin_url', 'admin/Plugin/default', '', '插件中心', '');
INSERT INTO `cmf_auth_rule` VALUES (41, 1, 'admin', 'admin_url', 'admin/Plugin/index', '', '插件列表', '');
INSERT INTO `cmf_auth_rule` VALUES (42, 1, 'admin', 'admin_url', 'admin/Plugin/toggle', '', '插件启用禁用', '');
INSERT INTO `cmf_auth_rule` VALUES (43, 1, 'admin', 'admin_url', 'admin/Plugin/setting', '', '插件设置', '');
INSERT INTO `cmf_auth_rule` VALUES (44, 1, 'admin', 'admin_url', 'admin/Plugin/settingPost', '', '插件设置提交', '');
INSERT INTO `cmf_auth_rule` VALUES (45, 1, 'admin', 'admin_url', 'admin/Plugin/install', '', '插件安装', '');
INSERT INTO `cmf_auth_rule` VALUES (46, 1, 'admin', 'admin_url', 'admin/Plugin/update', '', '插件更新', '');
INSERT INTO `cmf_auth_rule` VALUES (47, 1, 'admin', 'admin_url', 'admin/Plugin/uninstall', '', '卸载插件', '');
INSERT INTO `cmf_auth_rule` VALUES (48, 1, 'admin', 'admin_url', 'admin/Rbac/index', '', '角色管理', '');
INSERT INTO `cmf_auth_rule` VALUES (49, 1, 'admin', 'admin_url', 'admin/Rbac/roleAdd', '', '添加角色', '');
INSERT INTO `cmf_auth_rule` VALUES (50, 1, 'admin', 'admin_url', 'admin/Rbac/roleAddPost', '', '添加角色提交', '');
INSERT INTO `cmf_auth_rule` VALUES (51, 1, 'admin', 'admin_url', 'admin/Rbac/roleEdit', '', '编辑角色', '');
INSERT INTO `cmf_auth_rule` VALUES (52, 1, 'admin', 'admin_url', 'admin/Rbac/roleEditPost', '', '编辑角色提交', '');
INSERT INTO `cmf_auth_rule` VALUES (53, 1, 'admin', 'admin_url', 'admin/Rbac/roleDelete', '', '删除角色', '');
INSERT INTO `cmf_auth_rule` VALUES (54, 1, 'admin', 'admin_url', 'admin/Rbac/authorize', '', '设置角色权限', '');
INSERT INTO `cmf_auth_rule` VALUES (55, 1, 'admin', 'admin_url', 'admin/Rbac/authorizePost', '', '角色授权提交', '');
INSERT INTO `cmf_auth_rule` VALUES (56, 1, 'admin', 'admin_url', 'admin/RecycleBin/index', '', '回收站', '');
INSERT INTO `cmf_auth_rule` VALUES (57, 1, 'admin', 'admin_url', 'admin/RecycleBin/restore', '', '回收站还原', '');
INSERT INTO `cmf_auth_rule` VALUES (58, 1, 'admin', 'admin_url', 'admin/RecycleBin/delete', '', '回收站彻底删除', '');
INSERT INTO `cmf_auth_rule` VALUES (59, 1, 'admin', 'admin_url', 'admin/Route/index', '', 'URL美化', '');
INSERT INTO `cmf_auth_rule` VALUES (60, 1, 'admin', 'admin_url', 'admin/Route/add', '', '添加路由规则', '');
INSERT INTO `cmf_auth_rule` VALUES (61, 1, 'admin', 'admin_url', 'admin/Route/addPost', '', '添加路由规则提交', '');
INSERT INTO `cmf_auth_rule` VALUES (62, 1, 'admin', 'admin_url', 'admin/Route/edit', '', '路由规则编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (63, 1, 'admin', 'admin_url', 'admin/Route/editPost', '', '路由规则编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (64, 1, 'admin', 'admin_url', 'admin/Route/delete', '', '路由规则删除', '');
INSERT INTO `cmf_auth_rule` VALUES (65, 1, 'admin', 'admin_url', 'admin/Route/ban', '', '路由规则禁用', '');
INSERT INTO `cmf_auth_rule` VALUES (66, 1, 'admin', 'admin_url', 'admin/Route/open', '', '路由规则启用', '');
INSERT INTO `cmf_auth_rule` VALUES (67, 1, 'admin', 'admin_url', 'admin/Route/listOrder', '', '路由规则排序', '');
INSERT INTO `cmf_auth_rule` VALUES (68, 1, 'admin', 'admin_url', 'admin/Route/select', '', '选择URL', '');
INSERT INTO `cmf_auth_rule` VALUES (69, 1, 'admin', 'admin_url', 'admin/Setting/default', '', '设置', '');
INSERT INTO `cmf_auth_rule` VALUES (70, 1, 'admin', 'admin_url', 'admin/Setting/site', '', '网站信息', '');
INSERT INTO `cmf_auth_rule` VALUES (71, 1, 'admin', 'admin_url', 'admin/Setting/sitePost', '', '网站信息设置提交', '');
INSERT INTO `cmf_auth_rule` VALUES (72, 1, 'admin', 'admin_url', 'admin/Setting/password', '', '密码修改', '');
INSERT INTO `cmf_auth_rule` VALUES (73, 1, 'admin', 'admin_url', 'admin/Setting/passwordPost', '', '密码修改提交', '');
INSERT INTO `cmf_auth_rule` VALUES (74, 1, 'admin', 'admin_url', 'admin/Setting/upload', '', '上传设置', '');
INSERT INTO `cmf_auth_rule` VALUES (75, 1, 'admin', 'admin_url', 'admin/Setting/uploadPost', '', '上传设置提交', '');
INSERT INTO `cmf_auth_rule` VALUES (76, 1, 'admin', 'admin_url', 'admin/Setting/clearCache', '', '清除缓存', '');
INSERT INTO `cmf_auth_rule` VALUES (77, 1, 'admin', 'admin_url', 'admin/Slide/index', '', '幻灯片管理', '');
INSERT INTO `cmf_auth_rule` VALUES (78, 1, 'admin', 'admin_url', 'admin/Slide/add', '', '添加幻灯片', '');
INSERT INTO `cmf_auth_rule` VALUES (79, 1, 'admin', 'admin_url', 'admin/Slide/addPost', '', '添加幻灯片提交', '');
INSERT INTO `cmf_auth_rule` VALUES (80, 1, 'admin', 'admin_url', 'admin/Slide/edit', '', '编辑幻灯片', '');
INSERT INTO `cmf_auth_rule` VALUES (81, 1, 'admin', 'admin_url', 'admin/Slide/editPost', '', '编辑幻灯片提交', '');
INSERT INTO `cmf_auth_rule` VALUES (82, 1, 'admin', 'admin_url', 'admin/Slide/delete', '', '删除幻灯片', '');
INSERT INTO `cmf_auth_rule` VALUES (83, 1, 'admin', 'admin_url', 'admin/SlideItem/index', '', '幻灯片页面列表', '');
INSERT INTO `cmf_auth_rule` VALUES (84, 1, 'admin', 'admin_url', 'admin/SlideItem/add', '', '幻灯片页面添加', '');
INSERT INTO `cmf_auth_rule` VALUES (85, 1, 'admin', 'admin_url', 'admin/SlideItem/addPost', '', '幻灯片页面添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (86, 1, 'admin', 'admin_url', 'admin/SlideItem/edit', '', '幻灯片页面编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (87, 1, 'admin', 'admin_url', 'admin/SlideItem/editPost', '', '幻灯片页面编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (88, 1, 'admin', 'admin_url', 'admin/SlideItem/delete', '', '幻灯片页面删除', '');
INSERT INTO `cmf_auth_rule` VALUES (89, 1, 'admin', 'admin_url', 'admin/SlideItem/ban', '', '幻灯片页面隐藏', '');
INSERT INTO `cmf_auth_rule` VALUES (90, 1, 'admin', 'admin_url', 'admin/SlideItem/cancelBan', '', '幻灯片页面显示', '');
INSERT INTO `cmf_auth_rule` VALUES (91, 1, 'admin', 'admin_url', 'admin/SlideItem/listOrder', '', '幻灯片页面排序', '');
INSERT INTO `cmf_auth_rule` VALUES (92, 1, 'admin', 'admin_url', 'admin/Storage/index', '', '文件存储', '');
INSERT INTO `cmf_auth_rule` VALUES (93, 1, 'admin', 'admin_url', 'admin/Storage/settingPost', '', '文件存储设置提交', '');
INSERT INTO `cmf_auth_rule` VALUES (94, 1, 'admin', 'admin_url', 'admin/Theme/index', '', '模板管理', '');
INSERT INTO `cmf_auth_rule` VALUES (95, 1, 'admin', 'admin_url', 'admin/Theme/install', '', '安装模板', '');
INSERT INTO `cmf_auth_rule` VALUES (96, 1, 'admin', 'admin_url', 'admin/Theme/uninstall', '', '卸载模板', '');
INSERT INTO `cmf_auth_rule` VALUES (97, 1, 'admin', 'admin_url', 'admin/Theme/installTheme', '', '模板安装', '');
INSERT INTO `cmf_auth_rule` VALUES (98, 1, 'admin', 'admin_url', 'admin/Theme/update', '', '模板更新', '');
INSERT INTO `cmf_auth_rule` VALUES (99, 1, 'admin', 'admin_url', 'admin/Theme/active', '', '启用模板', '');
INSERT INTO `cmf_auth_rule` VALUES (100, 1, 'admin', 'admin_url', 'admin/Theme/files', '', '模板文件列表', '');
INSERT INTO `cmf_auth_rule` VALUES (101, 1, 'admin', 'admin_url', 'admin/Theme/fileSetting', '', '模板文件设置', '');
INSERT INTO `cmf_auth_rule` VALUES (102, 1, 'admin', 'admin_url', 'admin/Theme/fileArrayData', '', '模板文件数组数据列表', '');
INSERT INTO `cmf_auth_rule` VALUES (103, 1, 'admin', 'admin_url', 'admin/Theme/fileArrayDataEdit', '', '模板文件数组数据添加编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (104, 1, 'admin', 'admin_url', 'admin/Theme/fileArrayDataEditPost', '', '模板文件数组数据添加编辑提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (105, 1, 'admin', 'admin_url', 'admin/Theme/fileArrayDataDelete', '', '模板文件数组数据删除', '');
INSERT INTO `cmf_auth_rule` VALUES (106, 1, 'admin', 'admin_url', 'admin/Theme/settingPost', '', '模板文件编辑提交保存', '');
INSERT INTO `cmf_auth_rule` VALUES (107, 1, 'admin', 'admin_url', 'admin/Theme/dataSource', '', '模板文件设置数据源', '');
INSERT INTO `cmf_auth_rule` VALUES (108, 1, 'admin', 'admin_url', 'admin/Theme/design', '', '模板设计', '');
INSERT INTO `cmf_auth_rule` VALUES (109, 1, 'admin', 'admin_url', 'admin/User/default', '', '管理组', '');
INSERT INTO `cmf_auth_rule` VALUES (110, 1, 'admin', 'admin_url', 'admin/User/index', '', '管理员', '');
INSERT INTO `cmf_auth_rule` VALUES (111, 1, 'admin', 'admin_url', 'admin/User/add', '', '管理员添加', '');
INSERT INTO `cmf_auth_rule` VALUES (112, 1, 'admin', 'admin_url', 'admin/User/addPost', '', '管理员添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (113, 1, 'admin', 'admin_url', 'admin/User/edit', '', '管理员编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (114, 1, 'admin', 'admin_url', 'admin/User/editPost', '', '管理员编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (115, 1, 'admin', 'admin_url', 'admin/User/userInfo', '', '个人信息', '');
INSERT INTO `cmf_auth_rule` VALUES (116, 1, 'admin', 'admin_url', 'admin/User/userInfoPost', '', '管理员个人信息修改提交', '');
INSERT INTO `cmf_auth_rule` VALUES (117, 1, 'admin', 'admin_url', 'admin/User/delete', '', '管理员删除', '');
INSERT INTO `cmf_auth_rule` VALUES (118, 1, 'admin', 'admin_url', 'admin/User/ban', '', '停用管理员', '');
INSERT INTO `cmf_auth_rule` VALUES (119, 1, 'admin', 'admin_url', 'admin/User/cancelBan', '', '启用管理员', '');
INSERT INTO `cmf_auth_rule` VALUES (120, 1, 'user', 'admin_url', 'user/AdminAsset/index', '', '资源管理', '');
INSERT INTO `cmf_auth_rule` VALUES (121, 1, 'user', 'admin_url', 'user/AdminAsset/delete', '', '删除文件', '');
INSERT INTO `cmf_auth_rule` VALUES (122, 1, 'admin', 'admin_url', 'admin/users/default', '', '用户管理', '');
INSERT INTO `cmf_auth_rule` VALUES (123, 1, 'admin', 'admin_url', 'admin/users/default1', '', '用户组', '');
INSERT INTO `cmf_auth_rule` VALUES (124, 1, 'user', 'admin_url', 'user/AdminIndex/index', '', '本站用户', '');
INSERT INTO `cmf_auth_rule` VALUES (125, 1, 'user', 'admin_url', 'user/AdminIndex/ban', '', '本站用户拉黑', '');
INSERT INTO `cmf_auth_rule` VALUES (126, 1, 'user', 'admin_url', 'user/AdminIndex/cancelBan', '', '本站用户启用', '');
INSERT INTO `cmf_auth_rule` VALUES (127, 1, 'user', 'admin_url', 'user/AdminOauth/index', '', '第三方用户', '');
INSERT INTO `cmf_auth_rule` VALUES (128, 1, 'user', 'admin_url', 'user/AdminOauth/delete', '', '删除第三方用户绑定', '');
INSERT INTO `cmf_auth_rule` VALUES (129, 1, 'user', 'admin_url', 'user/AdminUserAction/index', '', '用户操作管理', '');
INSERT INTO `cmf_auth_rule` VALUES (130, 1, 'user', 'admin_url', 'user/AdminUserAction/edit', '', '编辑用户操作', '');
INSERT INTO `cmf_auth_rule` VALUES (131, 1, 'user', 'admin_url', 'user/AdminUserAction/editPost', '', '编辑用户操作提交', '');
INSERT INTO `cmf_auth_rule` VALUES (132, 1, 'user', 'admin_url', 'user/AdminUserAction/sync', '', '同步用户操作', '');
INSERT INTO `cmf_auth_rule` VALUES (162, 1, 'portal', 'admin_url', 'portal/AdminArticle/index', '', '文章管理', '');
INSERT INTO `cmf_auth_rule` VALUES (163, 1, 'portal', 'admin_url', 'portal/AdminArticle/add', '', '添加文章', '');
INSERT INTO `cmf_auth_rule` VALUES (164, 1, 'portal', 'admin_url', 'portal/AdminArticle/addPost', '', '添加文章提交', '');
INSERT INTO `cmf_auth_rule` VALUES (165, 1, 'portal', 'admin_url', 'portal/AdminArticle/edit', '', '编辑文章', '');
INSERT INTO `cmf_auth_rule` VALUES (166, 1, 'portal', 'admin_url', 'portal/AdminArticle/editPost', '', '编辑文章提交', '');
INSERT INTO `cmf_auth_rule` VALUES (167, 1, 'portal', 'admin_url', 'portal/AdminArticle/delete', '', '文章删除', '');
INSERT INTO `cmf_auth_rule` VALUES (168, 1, 'portal', 'admin_url', 'portal/AdminArticle/publish', '', '文章发布', '');
INSERT INTO `cmf_auth_rule` VALUES (169, 1, 'portal', 'admin_url', 'portal/AdminArticle/top', '', '文章置顶', '');
INSERT INTO `cmf_auth_rule` VALUES (170, 1, 'portal', 'admin_url', 'portal/AdminArticle/recommend', '', '文章推荐', '');
INSERT INTO `cmf_auth_rule` VALUES (171, 1, 'portal', 'admin_url', 'portal/AdminArticle/listOrder', '', '文章排序', '');
INSERT INTO `cmf_auth_rule` VALUES (172, 1, 'portal', 'admin_url', 'portal/AdminCategory/index', '', '分类管理', '');
INSERT INTO `cmf_auth_rule` VALUES (173, 1, 'portal', 'admin_url', 'portal/AdminCategory/add', '', '添加文章分类', '');
INSERT INTO `cmf_auth_rule` VALUES (174, 1, 'portal', 'admin_url', 'portal/AdminCategory/addPost', '', '添加文章分类提交', '');
INSERT INTO `cmf_auth_rule` VALUES (175, 1, 'portal', 'admin_url', 'portal/AdminCategory/edit', '', '编辑文章分类', '');
INSERT INTO `cmf_auth_rule` VALUES (176, 1, 'portal', 'admin_url', 'portal/AdminCategory/editPost', '', '编辑文章分类提交', '');
INSERT INTO `cmf_auth_rule` VALUES (177, 1, 'portal', 'admin_url', 'portal/AdminCategory/select', '', '文章分类选择对话框', '');
INSERT INTO `cmf_auth_rule` VALUES (178, 1, 'portal', 'admin_url', 'portal/AdminCategory/listOrder', '', '文章分类排序', '');
INSERT INTO `cmf_auth_rule` VALUES (179, 1, 'portal', 'admin_url', 'portal/AdminCategory/toggle', '', '文章分类显示隐藏', '');
INSERT INTO `cmf_auth_rule` VALUES (180, 1, 'portal', 'admin_url', 'portal/AdminCategory/delete', '', '删除文章分类', '');
INSERT INTO `cmf_auth_rule` VALUES (181, 1, 'portal', 'admin_url', 'portal/AdminIndex/default', '', '内容管理', '');
INSERT INTO `cmf_auth_rule` VALUES (182, 1, 'portal', 'admin_url', 'portal/AdminPage/index', '', '页面管理', '');
INSERT INTO `cmf_auth_rule` VALUES (183, 1, 'portal', 'admin_url', 'portal/AdminPage/add', '', '添加页面', '');
INSERT INTO `cmf_auth_rule` VALUES (184, 1, 'portal', 'admin_url', 'portal/AdminPage/addPost', '', '添加页面提交', '');
INSERT INTO `cmf_auth_rule` VALUES (185, 1, 'portal', 'admin_url', 'portal/AdminPage/edit', '', '编辑页面', '');
INSERT INTO `cmf_auth_rule` VALUES (186, 1, 'portal', 'admin_url', 'portal/AdminPage/editPost', '', '编辑页面提交', '');
INSERT INTO `cmf_auth_rule` VALUES (187, 1, 'portal', 'admin_url', 'portal/AdminPage/delete', '', '删除页面', '');
INSERT INTO `cmf_auth_rule` VALUES (188, 1, 'portal', 'admin_url', 'portal/AdminTag/index', '', '文章标签', '');
INSERT INTO `cmf_auth_rule` VALUES (189, 1, 'portal', 'admin_url', 'portal/AdminTag/add', '', '添加文章标签', '');
INSERT INTO `cmf_auth_rule` VALUES (190, 1, 'portal', 'admin_url', 'portal/AdminTag/addPost', '', '添加文章标签提交', '');
INSERT INTO `cmf_auth_rule` VALUES (191, 1, 'portal', 'admin_url', 'portal/AdminTag/upStatus', '', '更新标签状态', '');
INSERT INTO `cmf_auth_rule` VALUES (192, 1, 'portal', 'admin_url', 'portal/AdminTag/delete', '', '删除文章标签', '');
INSERT INTO `cmf_auth_rule` VALUES (193, 1, 'admin', 'admin_url', 'admin/Setting/configpri', '', '私密设置', '');
INSERT INTO `cmf_auth_rule` VALUES (194, 1, 'admin', 'admin_url', 'admin/Setting/configpriPost', '', '设置', '');
INSERT INTO `cmf_auth_rule` VALUES (195, 1, 'admin', 'admin_url', 'admin/course/default', '', '知识管理', '');
INSERT INTO `cmf_auth_rule` VALUES (196, 1, 'admin', 'admin_url', 'admin/courseclass/index', '', '科目分类', '');
INSERT INTO `cmf_auth_rule` VALUES (197, 1, 'admin', 'admin_url', 'admin/courseclass/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (198, 1, 'admin', 'admin_url', 'admin/courseclass/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (199, 1, 'admin', 'admin_url', 'admin/courseclass/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (200, 1, 'admin', 'admin_url', 'admin/courseclass/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (201, 1, 'admin', 'admin_url', 'admin/courseclass/listOrder', '', '排序', '');
INSERT INTO `cmf_auth_rule` VALUES (202, 1, 'admin', 'admin_url', 'admin/courseclass/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (203, 1, 'admin', 'admin_url', 'admin/users/index', 'type=0', '用户列表', '');
INSERT INTO `cmf_auth_rule` VALUES (204, 1, 'admin', 'admin_url', 'admin/users/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (205, 1, 'admin', 'admin_url', 'admin/users/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (206, 1, 'admin', 'admin_url', 'admin/users/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (207, 1, 'admin', 'admin_url', 'admin/users/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (208, 1, 'admin', 'admin_url', 'admin/users/ban', '', '禁用', '');
INSERT INTO `cmf_auth_rule` VALUES (209, 1, 'admin', 'admin_url', 'admin/users/cancelBan', '', '启用', '');
INSERT INTO `cmf_auth_rule` VALUES (210, 1, 'admin', 'admin_url', 'admin/users/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (211, 1, 'admin', 'admin_url', 'admin/signory/index', '', '专长领域', '');
INSERT INTO `cmf_auth_rule` VALUES (212, 1, 'admin', 'admin_url', 'admin/signory/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (213, 1, 'admin', 'admin_url', 'admin/signory/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (214, 1, 'admin', 'admin_url', 'admin/signory/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (215, 1, 'admin', 'admin_url', 'admin/signory/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (216, 1, 'admin', 'admin_url', 'admin/signory/listOrder', '', '排序', '');
INSERT INTO `cmf_auth_rule` VALUES (217, 1, 'admin', 'admin_url', 'admin/signory/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (218, 1, 'admin', 'admin_url', 'admin/identity/index', '', '身份标识', '');
INSERT INTO `cmf_auth_rule` VALUES (219, 1, 'admin', 'admin_url', 'admin/identity/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (220, 1, 'admin', 'admin_url', 'admin/identity/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (221, 1, 'admin', 'admin_url', 'admin/identity/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (222, 1, 'admin', 'admin_url', 'admin/identity/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (223, 1, 'admin', 'admin_url', 'admin/identity/listOrder', '', '排序', '');
INSERT INTO `cmf_auth_rule` VALUES (224, 1, 'admin', 'admin_url', 'admin/identity/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (225, 1, 'admin', 'admin_url', 'admin/users/teacher', 'type=1', '教师列表', '');
INSERT INTO `cmf_auth_rule` VALUES (226, 1, 'admin', 'admin_url', 'admin/feedback/index', '', '反馈', '');
INSERT INTO `cmf_auth_rule` VALUES (227, 1, 'admin', 'admin_url', 'admin/feedback/setstatus', '', '处理', '');
INSERT INTO `cmf_auth_rule` VALUES (228, 1, 'admin', 'admin_url', 'admin/feedback/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (229, 1, 'admin', 'admin_url', 'admin/course/index', 'sort=1', '课程列表', '');
INSERT INTO `cmf_auth_rule` VALUES (230, 1, 'admin', 'admin_url', 'admin/course/add', 'sort=0', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (231, 1, 'admin', 'admin_url', 'admin/course/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (232, 1, 'admin', 'admin_url', 'admin/course/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (233, 1, 'admin', 'admin_url', 'admin/course/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (234, 1, 'admin', 'admin_url', 'admin/course/setstatus', '', '上下架', '');
INSERT INTO `cmf_auth_rule` VALUES (235, 1, 'admin', 'admin_url', 'admin/course/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (236, 1, 'admin', 'admin_url', 'admin/course/contents', 'sort=0', '付费内容列表', '');
INSERT INTO `cmf_auth_rule` VALUES (237, 1, 'admin', 'admin_url', 'admin/course/live', 'sort=2', '语音大班课', '');
INSERT INTO `cmf_auth_rule` VALUES (238, 1, 'admin', 'admin_url', 'admin/lession/index', '', '课时管理', '');
INSERT INTO `cmf_auth_rule` VALUES (239, 1, 'admin', 'admin_url', 'admin/lession/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (240, 1, 'admin', 'admin_url', 'admin/lession/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (241, 1, 'admin', 'admin_url', 'admin/lession/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (242, 1, 'admin', 'admin_url', 'admin/lession/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (243, 1, 'admin', 'admin_url', 'admin/lession/listOrder', '', '排序', '');
INSERT INTO `cmf_auth_rule` VALUES (244, 1, 'admin', 'admin_url', 'admin/lession/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (245, 1, 'admin', 'admin_url', 'admin/push/index', '', '系统消息', '');
INSERT INTO `cmf_auth_rule` VALUES (246, 1, 'admin', 'admin_url', 'admin/push/add', '', '推送', '');
INSERT INTO `cmf_auth_rule` VALUES (247, 1, 'admin', 'admin_url', 'admin/push/addPost', '', '推送提交', '');
INSERT INTO `cmf_auth_rule` VALUES (248, 1, 'admin', 'admin_url', 'admin/orders/index', '', '订单管理', '');
INSERT INTO `cmf_auth_rule` VALUES (249, 1, 'admin', 'admin_url', 'admin/orders/goods', '', '商品列表', '');
INSERT INTO `cmf_auth_rule` VALUES (250, 1, 'admin', 'admin_url', 'admin/orders/setSend', '', '标记发货', '');
INSERT INTO `cmf_auth_rule` VALUES (251, 1, 'admin', 'admin_url', 'admin/Coursegrade/index', '', '学级分类', '');
INSERT INTO `cmf_auth_rule` VALUES (252, 1, 'admin', 'admin_url', 'admin/Coursegrade/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (253, 1, 'admin', 'admin_url', 'admin/Coursegrade/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (254, 1, 'admin', 'admin_url', 'admin/Coursegrade/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (255, 1, 'admin', 'admin_url', 'admin/Coursegrade/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (256, 1, 'admin', 'admin_url', 'admin/Coursegrade/listOrder', '', '排序', '');
INSERT INTO `cmf_auth_rule` VALUES (257, 1, 'admin', 'admin_url', 'admin/Coursegrade/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (258, 1, 'admin', 'admin_url', 'admin/package/index', '', '套餐管理', '');
INSERT INTO `cmf_auth_rule` VALUES (259, 1, 'admin', 'admin_url', 'admin/package/add', '', '添加', '');
INSERT INTO `cmf_auth_rule` VALUES (260, 1, 'admin', 'admin_url', 'admin/package/addPost', '', '添加提交', '');
INSERT INTO `cmf_auth_rule` VALUES (261, 1, 'admin', 'admin_url', 'admin/package/edit', '', '编辑', '');
INSERT INTO `cmf_auth_rule` VALUES (262, 1, 'admin', 'admin_url', 'admin/package/editPost', '', '编辑提交', '');
INSERT INTO `cmf_auth_rule` VALUES (263, 1, 'admin', 'admin_url', 'admin/package/listOrder', '', '排序', '');
INSERT INTO `cmf_auth_rule` VALUES (264, 1, 'admin', 'admin_url', 'admin/package/del', '', '删除', '');
INSERT INTO `cmf_auth_rule` VALUES (265, 1, 'admin', 'admin_url', 'admin/package/getCourse', '', '获取课程', '');
INSERT INTO `cmf_auth_rule` VALUES (266, 1, 'admin', 'admin_url', 'admin/course/default3', '', ' 大班课列表', '');
INSERT INTO `cmf_auth_rule` VALUES (267, 1, 'admin', 'admin_url', 'admin/course/live_video', 'sort=3', '视频大班课', '');
INSERT INTO `cmf_auth_rule` VALUES (268, 1, 'Admin', 'admin_url', 'Admin/Users/hiddwords', '', '禁言列表', '');
INSERT INTO `cmf_auth_rule` VALUES (269, 1, 'Admin', 'admin_url', 'Admin/Startlive/index', '', '开播IP统计', '');
INSERT INTO `cmf_auth_rule` VALUES (270, 1, 'Admin', 'admin_url', 'Admin/seelivelong/index', '', '观看直播时长统计', '');
INSERT INTO `cmf_auth_rule` VALUES (271, 1, 'Admin', 'admin_url', 'Admin/opencity/index', '', '城市人数统计', '');

-- ----------------------------
-- Table structure for cmf_cart
-- ----------------------------
DROP TABLE IF EXISTS `cmf_cart`;
CREATE TABLE `cmf_cart`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `typeid` bigint(20) NOT NULL DEFAULT 0,
  `isselect` tinyint(1) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_cart
-- ----------------------------
INSERT INTO `cmf_cart` VALUES (5, 2, 1, 2, 0, 1596446046);
INSERT INTO `cmf_cart` VALUES (6, 2, 0, 3, 0, 1596446057);
INSERT INTO `cmf_cart` VALUES (7, 2, 0, 9, 1, 1596507000);
INSERT INTO `cmf_cart` VALUES (8, 2, 0, 5, 0, 1596701601);
INSERT INTO `cmf_cart` VALUES (9, 7, 0, 12, 1, 1597366758);
INSERT INTO `cmf_cart` VALUES (11, 4, 0, 5, 0, 1597375287);
INSERT INTO `cmf_cart` VALUES (12, 4, 0, 26, 0, 1597395169);
INSERT INTO `cmf_cart` VALUES (13, 4, 0, 7, 0, 1597397122);

-- ----------------------------
-- Table structure for cmf_course
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course`;
CREATE TABLE `cmf_course`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `sort` int(1) NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `des` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `gradeid` int(11) NOT NULL DEFAULT 0,
  `classid` int(11) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `uptime` bigint(20) NOT NULL DEFAULT 0,
  `paytype` tinyint(1) NOT NULL DEFAULT 0,
  `payval` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `shelvestime` bigint(20) NOT NULL DEFAULT 0,
  `info` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `trialtype` tinyint(1) NOT NULL DEFAULT 0,
  `trialval` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `mode` tinyint(1) NOT NULL DEFAULT 0,
  `lessons` int(11) NOT NULL DEFAULT 0,
  `stars` int(11) NOT NULL DEFAULT 0,
  `comments` int(11) NOT NULL DEFAULT 0,
  `star` decimal(10, 1) NOT NULL DEFAULT 0.0,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `views` int(11) NOT NULL DEFAULT 0 COMMENT '学习过的人数',
  `islive` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否在直播，0否1是',
  `starttime` bigint(20) NOT NULL DEFAULT 0 COMMENT '直播时间',
  `endtime` bigint(20) NOT NULL DEFAULT 0 COMMENT '结束时间',
  `intr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '听课指南',
  `ispush` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否推送，0否1是',
  `list_order` int(11) NOT NULL DEFAULT 10000 COMMENT '序号',
  `ismaterial` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否有教材,0否1是',
  `tutoruid` bigint(20) NOT NULL DEFAULT 0 COMMENT '辅导老师ID',
  `isshup` tinyint(1) NOT NULL DEFAULT 0 COMMENT '禁言，0否1是',
  `livemode` tinyint(1) NOT NULL DEFAULT 0 COMMENT '直播模式，0摄像头1ppt2共享屏幕',
  `pptindex` int(11) NULL DEFAULT 0 COMMENT 'ppt当前序号',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status_time`(`status`, `shelvestime`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course
-- ----------------------------
INSERT INTO `cmf_course` VALUES (1, 1, 3, 5, '测试视频大班课', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '', 2, 1, 1594716080, 1596691989, 0, '', 1, 1594716080, '<p>222</p>', NULL, 0, '', 0, 0, 9, 3, 3.0, '', 1, 1, 1594716060, 1598863200, '111', 1, 10000, 0, 0, 0, 1, 0);
INSERT INTO `cmf_course` VALUES (3, 2, 1, 0, '测试', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '无', 4, 1, 1595840451, 1596686032, 1, '10', 1, 1595840451, '<p>暂无</p>', NULL, 0, '', 0, 7, 4, 5, 0.8, '', 2, 0, 0, 0, '', 1, 10000, 1, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (4, 2, 0, 1, '好', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '灌灌灌灌', 2, 1, 1596011989, 1596692920, 0, '', 1, 1596011989, '<p>订单</p>', '<p>订单</p>', 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (5, 2, 1, 0, '淡定淡定', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '456', 2, 1, 1596087533, 1596685992, 1, '10', 1, 1596087533, '<p>44</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (6, 2, 1, 0, 'ddd', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '9999', 4, 1, 1596087780, 1596685979, 1, '10', 1, 1596087780, '<p>111</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (7, 2, 2, 1, '订单', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '非官方个', 2, 2, 1596502502, 1596691977, 1, '10', 1, 1596502502, '<p>点点点</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 0, 2, 1596588600, 1596639001, '东方大道', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (8, 2, 1, 0, '密码', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '点点点', 2, 1, 1596504711, 1596685966, 2, '777', 1, 1596504711, '<p>点点点</p>', NULL, 0, '', 0, 1, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (9, 2, 0, 1, 'dddd ', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 'ddd ', 2, 1, 1596506975, 1596692908, 1, '10', 1, 1596506975, '<p>fff&nbsp; &nbsp;ffffff</p>', '<p>fff</p>', 2, '10', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (10, 2, 0, 2, '点点点', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '淡定淡定', 2, 1, 1596521344, 1596692892, 0, '', 1, 1596521344, '<p>点点点</p>', '<p>哈哈哈</p>', 0, '', 0, 0, 0, 0, 0.0, 'admin/20200729/3b4828db631043d58d3ff02720bea36e.mp4', 1, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (11, 2, 0, 2, 'uuu', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '急急急', 2, 1, 1596521667, 1596692870, 1, '10', 1, 1596521667, '<p>人</p>', '<p>点点点</p>', 2, '10', 0, 0, 0, 0, 0.0, 'admin/20200729/3b4828db631043d58d3ff02720bea36e.mp4', 0, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (12, 2, 0, 1, '点点点', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '点点点', 2, 1, 1596524390, 1596692853, 1, '10', 1, 1596524390, '<p>发发发</p>', '<p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p><br/></p><p>1</p><p>11</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>1</p><p>11</p><p>1</p><p>1</p><p>1</p><p>1</p><p><br/></p>', 2, '20', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (13, 2, 0, 3, '测试音频', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '点点点', 2, 1, 1596526272, 1596692833, 2, '123', 1, 1596526272, '<p>广发改革</p>', '<p>大打发打发</p>', 0, '', 0, 0, 0, 0, 0.0, 'admin/20200804/a6f6c033abc1f35b5d7df03ced2384ab.mp3', 1, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (14, 1, 1, 0, '孤鸿寡鹄', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '点点点', 2, 1, 1596598217, 1596685954, 0, '', 1, 1596598217, '<p>点点点</p>', NULL, 0, '', 0, 1, 0, 0, 0.0, '', 3, 0, 0, 0, '', 1, 10000, 0, 2, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (15, 2, 1, 0, 'ddd ', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 'ffff', 2, 1, 1596616111, 1596679217, 0, '', 1, 1596616111, '<p>ddd</p>', NULL, 0, '', 0, 2, 0, 0, 0.0, '', 1, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (16, 2, 1, 0, '新的测试密码', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '反反复复', 4, 1, 1596699193, 0, 2, '888', 1, 1596699193, '<p>发发发</p>', NULL, 0, '', 0, 1, 0, 0, 0.0, '', 1, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (17, 2, 2, 1, '开发语音大班课-PPT', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '暂无', 2, 1, 1596761807, 0, 0, '', 1, 1596761807, '<p>哈哈哈</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 1, 1, 1596761760, 1598835300, '暂无', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (18, 2, 2, 2, '开发语音大班课-视频', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '暂无', 2, 1, 1596761870, 0, 0, '', 1, 1596761870, '<p>暂无</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, 'admin/20200807/85fd290d8b26c9b40a456982a41cf758.mp4', 1, 1, 1596761820, 1598835300, '暂无', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (19, 2, 2, 3, '开发语音大班课-音频', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '淡定淡定', 2, 1, 1596761939, 0, 0, '', 1, 1596761939, '<p>暂无</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, 'admin/20200807/96fa744ce4fb86d5c0ed1bf7d5aad8ce.mp3', 3, 1, 1596761880, 1598835300, '暂无', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (20, 2, 3, 5, '点点点', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '灌灌灌灌', 2, 1, 1596780636, 0, 0, '', 1, 1596780636, '<p>发发发</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 3, 2, 1596857788, 1596858378, '发发发', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (22, 2, 2, 1, '公公弓拒绝', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '哦哦哦', 2, 1, 1596858945, 0, 0, '', 1, 1596858945, '<p>反反复复</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 1, 1, 1596945300, 1598846100, '发发发', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (23, 2, 3, 5, '开发测试视频大班课', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '反反复复', 2, 1, 1596866801, 0, 0, '', 1, 1596866801, '<p>嗷嗷嗷</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 3, 1, 1596866760, 1598853900, '嗷嗷嗷', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (24, 2, 1, 0, '开发测试课程', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '暂无', 2, 1, 1596873383, 0, 0, '', 1, 1596873383, '<p>哈哈</p>', NULL, 0, '', 0, 13, 4, 1, 4.0, '', 4, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (25, 8, 1, 0, '开发测试2', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '发发发', 2, 1, 1597304693, 0, 0, '', 1, 1597304693, '<p>发发发</p>', NULL, 0, '', 0, 0, 10, 2, 5.0, '', 3, 0, 0, 0, '', 1, 10000, 0, 2, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (26, 2, 1, 0, '发发发订单', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '发发发', 2, 1, 1597394970, 0, 1, '100', 1, 1597394970, '<p>刚刚</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 1, 4, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (27, 2, 0, 1, 'gh', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 'ff ', 4, 1, 1597474957, 0, 0, '', 1, 1597474957, '<p>ff&nbsp;</p>', '<p>ff&nbsp;</p>', 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 0, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (28, 2, 1, 0, '发发发', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '发发发', 2, 1, 1597632796, 0, 0, '', 1, 1597632796, '<p>方法</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);
INSERT INTO `cmf_course` VALUES (29, 2, 1, 0, '哦哦', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', '呦呦呦', 2, 1, 1597972658, 1598002907, 0, '', 1, 1597972658, '<p>呦呦呦</p>', NULL, 0, '', 0, 0, 0, 0, 0.0, '', 0, 0, 0, 0, '', 1, 10000, 0, 1, 0, 0, 0);

-- ----------------------------
-- Table structure for cmf_course_class
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_class`;
CREATE TABLE `cmf_course_class`  (
  `id` int(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `list_order` int(11) NOT NULL DEFAULT 10000,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_class
-- ----------------------------
INSERT INTO `cmf_course_class` VALUES (1, '语文', 'admin/20200714/f5006114ce5644efa150d93a30d2f103.jpg', 10000);
INSERT INTO `cmf_course_class` VALUES (2, '数学', 'admin/20200727/be4fd2d88102a3d535ffa3e48dae2bfd.jpg', 10000);

-- ----------------------------
-- Table structure for cmf_course_grade
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_grade`;
CREATE TABLE `cmf_course_grade`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` bigint(20) NOT NULL DEFAULT 0,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `list_order` int(11) NOT NULL DEFAULT 10000,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_grade
-- ----------------------------
INSERT INTO `cmf_course_grade` VALUES (1, 0, '一年级', 10000);
INSERT INTO `cmf_course_grade` VALUES (2, 1, '一班', 10000);
INSERT INTO `cmf_course_grade` VALUES (3, 0, '二年级', 10000);
INSERT INTO `cmf_course_grade` VALUES (4, 1, '二班', 10000);
INSERT INTO `cmf_course_grade` VALUES (5, 3, '人才', 10000);

-- ----------------------------
-- Table structure for cmf_course_lesson
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_lesson`;
CREATE TABLE `cmf_course_lesson`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `pid` bigint(20) NOT NULL DEFAULT 0,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `des` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `duration` int(11) NOT NULL DEFAULT 0,
  `list_order` int(11) NOT NULL DEFAULT 10000,
  `istrial` tinyint(1) NOT NULL DEFAULT 0,
  `starttime` bigint(20) NOT NULL DEFAULT 0,
  `endtime` bigint(20) NOT NULL DEFAULT 0,
  `islive` tinyint(1) NOT NULL DEFAULT 0,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `roomtoken` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `file_uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `isshup` tinyint(1) NOT NULL DEFAULT 0,
  `intr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `pptindex` int(11) NULL DEFAULT 0,
  `resourceid` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `sid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 38 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_lesson
-- ----------------------------
INSERT INTO `cmf_course_lesson` VALUES (1, 1, 2, 0, '章节一', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (2, 1, 2, 1, '章节一_1', 1, '', '11', '<p>请问</p>', 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (3, 1, 2, 1, '授课直播', 7, '', '', '', 0, 10000, 0, 1594718040, 1596275701, 2, '76651cd0c5b211ea9f09772fdf72e688', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz01ZTcyMmI0MjIxMGEwYTVhYTA3N2Y0MzlhOWQ4M2M5OWM1NmMwNDJjOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NDcxODA4NzI2MiZleHBpcmVfdGltZT0xNjI2MjU0MDg3MjYyJm5vbmNlPTE1OTQ3MTgwODcyNjIwMCZyb2xlPXJvb20mcm9vbUlkPTc2NjUxY2QwYzViMjExZWE5ZjA5NzcyZmRmNzJlNjg4JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (4, 2, 3, 0, '二次', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (5, 2, 3, 0, '点点点', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (6, 2, 3, 4, '都看得到看', 1, '', '淡定淡定', '<p>点点点</p>', 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (7, 2, 3, 5, '的点点滴滴', 2, 'admin/20200729/3b4828db631043d58d3ff02720bea36e.mp4', '', '<p>点点点</p>', 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (8, 2, 3, 4, '删除', 2, 'admin/20200806/1898a5eb9022bc4388c63bb145747fb9.mp4', 'dddd', '<p>jjjjjj</p>', 0, 10000, 1, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (9, 2, 3, 4, '直播测试', 4, '', '', '', 0, 10000, 1, 1596424020, 1596467101, 2, '', NULL, '', 0, '淡定淡定', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (10, 1, 14, 0, '订单', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (11, 1, 14, 10, '吧v', 1, '', '大发放', '<p>多福多寿阿道夫</p>', 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (12, 2, 15, 0, 'dddd', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (13, 2, 15, 12, 'fffff', 1, '', 'ffffff', '<p>ffff</p>', 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (14, 2, 15, 12, 'ddddddd', 7, '', '', '', 0, 10000, 0, 1596616440, 1598862600, 2, '6d09a930d6f611ea85b383c51c443e98', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz01YjAzN2ZjYmM4ZThjYmRjODE2ZmNhMTEzY2FjMmI5MzRjYzVmMDdmOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NjYxNjQ0NzAxMCZleHBpcmVfdGltZT0xNjI4MTUyNDQ3MDEwJm5vbmNlPTE1OTY2MTY0NDcwMTAwMCZyb2xlPXJvb20mcm9vbUlkPTZkMDlhOTMwZDZmNjExZWE4NWIzODNjNTFjNDQzZTk4JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (15, 2, 3, 5, '测试直播间', 7, '', '', '', 0, 10000, 1, 1596784200, 1597907401, 2, '255fec70d7b411ea9be4d9045066d16e', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz1jOThkZWVkZTQzY2ZkNzhmM2E0Y2RiMWEyOWFkMjFjYmI1NDgyYzcwOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NjY5NzkzMTE5MCZleHBpcmVfdGltZT0xNjI4MjMzOTMxMTkwJm5vbmNlPTE1OTY2OTc5MzExOTAwMCZyb2xlPXJvb20mcm9vbUlkPTI1NWZlYzcwZDdiNDExZWE5YmU0ZDkwNDUwNjZkMTZlJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (16, 2, 3, 5, '等级低筋粉的', 7, '', '', '', 0, 10000, 0, 1596697980, 1597302601, 2, '4cac5930d7b411ea85b383c51c443e98', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz02NGMwMWNlZTk1ODU1ZWI5ZDczNzJlYjFiYzA3OGNmYmQ3ZTBhZTgwOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NjY5Nzk5NzA4MiZleHBpcmVfdGltZT0xNjI4MjMzOTk3MDgyJm5vbmNlPTE1OTY2OTc5OTcwODIwMCZyb2xlPXJvb20mcm9vbUlkPTRjYWM1OTMwZDdiNDExZWE4NWIzODNjNTFjNDQzZTk4JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (17, 2, 8, 0, '淡定淡定', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (18, 2, 8, 17, '斤斤计较军', 1, '', '哈哈哈哈', '<p>哈哈哈哈</p>', 0, 10000, 1, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (19, 2, 16, 0, '方法发发发付', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (20, 2, 16, 19, '公公弓', 1, '', '公公弓', '<p>嘎嘎嘎嘎嘎</p>', 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (21, 2, 3, 5, '哈哈哈哈哈', 3, 'admin/20200806/e46b22eca3332266aff6dbe64bb14c4a.mp3', '哈哈哈哈', '<p>斤斤计较</p>', 0, 10000, 1, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (22, 2, 24, 0, '新的章节', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (23, 2, 24, 22, '开发测试授课直播', 7, '', '', '', 0, 10000, 0, 1596873420, 1597109886, 2, 'e42281b0d94c11eab93ae1da9406727f', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz0xMzdiNDQ0YTQ5ZTQxZDhkZGFjY2RhOWM5ZDYzYmI3OWU3YWNhNWU1OmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5Njg3MzQ4NTkxMSZleHBpcmVfdGltZT0xNjI4NDA5NDg1OTExJm5vbmNlPTE1OTY4NzM0ODU5MTEwMCZyb2xlPXJvb20mcm9vbUlkPWU0MjI4MWIwZDk0YzExZWFiOTNhZTFkYTk0MDY3MjdmJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (24, 2, 24, 22, '第二个开发测试授课直播', 7, '', '', '', 0, 10000, 0, 1597110300, 1598837700, 1, '551e7490db7411eaa7c1a314d802bece', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz1mM2MwZjFkMjBjMzY0YWIyNzNkNTY0MDRmYTFlNTkyNzM4MzBkMTg4OmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzExMDMyODE5MSZleHBpcmVfdGltZT0xNjI4NjQ2MzI4MTkxJm5vbmNlPTE1OTcxMTAzMjgxOTEwMCZyb2xlPXJvb20mcm9vbUlkPTU1MWU3NDkwZGI3NDExZWFhN2MxYTMxNGQ4MDJiZWNlJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (25, 2, 24, 22, '第三个开发授课直播', 7, '', '', '', 0, 10000, 0, 1597110452, 1598838300, 1, '8e9eea10db7411eaaa438765373f2f86', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz03NzM5ZWMwMmE0MjhjZDk2ODU4ZWZmYzkxMDFhYTViYjgwODNiNDE1OmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzExMDQyNDY2OSZleHBpcmVfdGltZT0xNjI4NjQ2NDI0NjY5Jm5vbmNlPTE1OTcxMTA0MjQ2NjkwMCZyb2xlPXJvb20mcm9vbUlkPThlOWVlYTEwZGI3NDExZWFhYTQzODc2NTM3M2YyZjg2JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (26, 2, 24, 22, '第四个', 7, '', '', '', 0, 10000, 0, 1597203300, 1598844900, 1, '1995fb20dd1611ea907ea3e91a336099', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz03Y2I4OTY1NDgwOTlmOWQzNWUyODUxMTNkYmIwNDczYTcyMzE2NDNlOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzI4OTc1NzkxMSZleHBpcmVfdGltZT0xNjI4ODI1NzU3OTExJm5vbmNlPTE1OTcyODk3NTc5MTEwMCZyb2xlPXJvb20mcm9vbUlkPTE5OTVmYjIwZGQxNjExZWE5MDdlYTNlOTFhMzM2MDk5JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (27, 2, 24, 22, '测试回放', 7, '', '', '', 0, 10000, 0, 1597296804, 1597297604, 2, '6051f0e0dd2611ea907ea3e91a336099', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz0yZjYyOGIzMGU0ODExMGVhZjAzZDMyMGY1MWU5MzNlZWI1MjZmY2QxOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzI5Njc0ODU3NyZleHBpcmVfdGltZT0xNjI4ODMyNzQ4NTc3Jm5vbmNlPTE1OTcyOTY3NDg1NzcwMCZyb2xlPXJvb20mcm9vbUlkPTYwNTFmMGUwZGQyNjExZWE5MDdlYTNlOTFhMzM2MDk5JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (28, 2, 24, 22, '测试回放1', 7, '', '', '', 0, 10000, 0, 1597297815, 1598852700, 1, 'cec6b220dd2811ea907ea3e91a336099', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz03MmM1YTJhMmM3ZDNmMmNmNDJlOTZjMzQxN2UwOWMwZjgxMWQ1MmQ4OmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzI5Nzc5Mjk1MiZleHBpcmVfdGltZT0xNjI4ODMzNzkyOTUyJm5vbmNlPTE1OTcyOTc3OTI5NTIwMCZyb2xlPXJvb20mcm9vbUlkPWNlYzZiMjIwZGQyODExZWE5MDdlYTNlOTFhMzM2MDk5JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (29, 2, 24, 22, '测试回放2', 7, '', '', '', 0, 10000, 0, 1597299306, 1597301393, 2, 'f88995c0dd2b11ea907ea3e91a336099', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz04ZTFiYjRiNmY1NzZlN2Q0ZWNlNTE1Y2EwNjY0MzhkNGY5OGU1NGNmOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzI5OTE1MTM4MyZleHBpcmVfdGltZT0xNjI4ODM1MTUxMzgzJm5vbmNlPTE1OTcyOTkxNTEzODMwMCZyb2xlPXJvb20mcm9vbUlkPWY4ODk5NWMwZGQyYjExZWE5MDdlYTNlOTFhMzM2MDk5JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, '', '');
INSERT INTO `cmf_course_lesson` VALUES (30, 2, 24, 22, '测试回放3', 7, 'record/d7543e6a154b69b8eb03d98f563b880a_2_24_30.m3u8', '', '', 0, 10000, 0, 1597301794, 1597302518, 2, '0e452fe0dd3211ea907ea3e91a336099', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz0wMTAxOTMxODlkOThkNDA5MmUyYmEzMjc3Yzg1YTIwMzkzMDBiZTVkOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzMwMTc2NDkxOCZleHBpcmVfdGltZT0xNjI4ODM3NzY0OTE4Jm5vbmNlPTE1OTczMDE3NjQ5MTgwMCZyb2xlPXJvb20mcm9vbUlkPTBlNDUyZmUwZGQzMjExZWE5MDdlYTNlOTFhMzM2MDk5JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, 'nUwUbQf9Zg6tsgtLslGnDg0lk8RYaUE09pqOuSIgwfzwU5sLdAOeX-kq98CK8q1jwbOOZ2kR9147O5HTC2LrBDh08ltZKtp91-DS1X0EulnJCXj9-GWW-47WMORbG9n-FCf3Fm0yXA0MAJgQR7X7jibaSYrrpYJcZ2Y51KUAd4ePsQK_5HcCRs-2hycdjx5EGU-an6lvrsE9c-5lOYsw3QQ9iuKCT_n1sGwMrG2UOcbqn_UDz13_mw42YlkcJGSau15ZyMUdJ46sI5uY9wX54MymzKu7KWl7gIOfPUMojK8', 'd7543e6a154b69b8eb03d98f563b880a');
INSERT INTO `cmf_course_lesson` VALUES (31, 2, 24, 22, '回放测试4', 7, 'record/6dfcdc8f5546882aa72bceb6abe33d97_2_24_31.m3u8', '', '', 0, 10000, 0, 1597302643, 1597302881, 2, '0dd39770dd3411eaa5451b1b03a1a48d', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz1iZjM0YmMzMWNkN2RlZmIwYjZmMjQyOGU5ZjU3NTVkYWI5YTE5MjJiOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzMwMjYyMzExNiZleHBpcmVfdGltZT0xNjI4ODM4NjIzMTE2Jm5vbmNlPTE1OTczMDI2MjMxMTYwMCZyb2xlPXJvb20mcm9vbUlkPTBkZDM5NzcwZGQzNDExZWFhNTQ1MWIxYjAzYTFhNDhkJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, 'nUwUbQf9Zg6tsgtLslGnDg0lk8RYaUE09pqOuSIgwfzwU5sLdAOeX-kq98CK8q1jwbOOZ2kR9147O5HTC2LrBDh08ltZKtp91-DS1X0EullAhhljkJ8tufrpCqRn2YtetvAJb5dmE_cxbFgWSk4sXnJN3Wst-LUXTcXsGKCLHaAoGNe9dxJHylb3ddtkd-9Xw_G7hMq6VJYp0gkCPAi95LtNvlsuvOXg35JN9EsrAnKqxtvf3xHQUCEIbEczXYikB7RwGebGfvvHs63UuIpfiCQXsCbx3EMjpW3t7ftj8MA', '6dfcdc8f5546882aa72bceb6abe33d97');
INSERT INTO `cmf_course_lesson` VALUES (32, 2, 24, 22, '测试回放5', 7, 'record/3d5a5d6cbb4f55dd771ab99223d41bcd_2_24_32.m3u8', '', '', 0, 10000, 0, 1597303712, 1597304185, 2, '7edc7110dd3611ea907ea3e91a336099', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz02YmMzOWZhYTY1MTI3MGI2MTYzYjhiZmQ4MGIyM2Q5NzcxNTExOTJkOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzMwMzY3MTgxMyZleHBpcmVfdGltZT0xNjI4ODM5NjcxODEzJm5vbmNlPTE1OTczMDM2NzE4MTMwMCZyb2xlPXJvb20mcm9vbUlkPTdlZGM3MTEwZGQzNjExZWE5MDdlYTNlOTFhMzM2MDk5JnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, 'nUwUbQf9Zg6tsgtLslGnDg0lk8RYaUE09pqOuSIgwfzwU5sLdAOeX-kq98CK8q1jwbOOZ2kR9147O5HTC2LrBDh08ltZKtp91-DS1X0Eullm8RmIk4uDI2Y01DsBM8HiFImdIvUO95_q0IXAA7FBq5RiyCnzh7OTIevDq9bxQ2ap4cXpWAOdg5UpBbHzbAlKa1GzlwQcks7oKztd9gI9kOkstZUBy7_9peEsy5nVVRUCN9siaiphfsqw0hKDePZLEnnP1fYQxSXNu_kef-v3j5ODIt9l_eAjIK8neOFjDfE', '3d5a5d6cbb4f55dd771ab99223d41bcd');
INSERT INTO `cmf_course_lesson` VALUES (33, 2, 24, 22, '测试回放6', 7, 'record/8c3ecc1764461541ec977ea3f1513a5c_2_24_33.m3u8', '', '', 0, 10000, 0, 1597304373, 1597304749, 2, '033a2230dd3811ea846f45885dbe6d8e', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz1iM2RhNTA5MGZiZGY2OTU0MDY2Mjk2MmY5YzE5ZWQ5N2I0MWRlMGI4OmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzMwNDMyMzM2MSZleHBpcmVfdGltZT0xNjI4ODQwMzIzMzYxJm5vbmNlPTE1OTczMDQzMjMzNjEwMCZyb2xlPXJvb20mcm9vbUlkPTAzM2EyMjMwZGQzODExZWE4NDZmNDU4ODVkYmU2ZDhlJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, 'nUwUbQf9Zg6tsgtLslGnDg0lk8RYaUE09pqOuSIgwfzwU5sLdAOeX-kq98CK8q1jwbOOZ2kR9147O5HTC2LrBDh08ltZKtp91-DS1X0Eullq9dHjSwvyoP3elR-sVzatHM5hRLRlfpnQ6R7Z9LdMKA9qnoWT-fWdEmI4nw1l5Tdjavw8TnUhZAsDZ-T_RTRl2Vdy_q4ew9nBHFKQc9RIyfX-c9-yuqLEnc6Pp4ObVwbALM_frpmVABo62p8hlJ5yDNPRUtHN5O6gSMyrE_lAlLSEUwwS3-53m_wBAqO6vkM', '8c3ecc1764461541ec977ea3f1513a5c');
INSERT INTO `cmf_course_lesson` VALUES (34, 2, 24, 22, '测试回放7', 7, 'record/53f7c3eb93433f0ad711909135f1ec4a_2_24_34.m3u8', '', '', 0, 10000, 0, 1597305315, 1597305974, 2, '0c658bb0dd3811ea846f45885dbe6d8e', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz0xYzE4MmQ3OWNmOGZkZDMxNmZkMDkyYmI1ODdjYjc0ZDVjYmFhZDhlOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzMwNDMzODY2MSZleHBpcmVfdGltZT0xNjI4ODQwMzM4NjYxJm5vbmNlPTE1OTczMDQzMzg2NjEwMCZyb2xlPXJvb20mcm9vbUlkPTBjNjU4YmIwZGQzODExZWE4NDZmNDU4ODVkYmU2ZDhlJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, 'nUwUbQf9Zg6tsgtLslGnDg0lk8RYaUE09pqOuSIgwfzwU5sLdAOeX-kq98CK8q1jwbOOZ2kR9147O5HTC2LrBDh08ltZKtp91-DS1X0EulmLyX2bsAAmBn8e7QKb9AfJeMOgyMHoPknKWNd2Mgn7okWmLK-C4ZH1doykr7W7gBSMFfcaB-49Iv_2IZi8N7lpWAWy_uVaqnsy85IQ-E5iSap4bFgeCfDChwbH1TtoUjD4LkxAQgU7AJSCHdkFz3ekuKA3Swl8mDWdi7RFLOnwlYIw8c8Pg5vqqgKn87LAOp0', '53f7c3eb93433f0ad711909135f1ec4a');
INSERT INTO `cmf_course_lesson` VALUES (35, 2, 24, 22, '测试回放8', 7, '', '', '', 0, 10000, 0, 1597383000, 1598851800, 1, '155cc5d0dd3811ea846f45885dbe6d8e', 'WHITEcGFydG5lcl9pZD1taDRpTl9YbXRMZ2FvZWpBJnNpZz01OWQ0MzA0ZDYwN2Y2OWNhOTZlOTU2MjIwYzk1MWJkZmM2M2ZjMjAxOmFrPW1oNGlOX1htdExnYW9lakEmY3JlYXRlX3RpbWU9MTU5NzMwNDM1MzcyMyZleHBpcmVfdGltZT0xNjI4ODQwMzUzNzIzJm5vbmNlPTE1OTczMDQzNTM3MjMwMCZyb2xlPXJvb20mcm9vbUlkPTE1NWNjNWQwZGQzODExZWE4NDZmNDU4ODVkYmU2ZDhlJnRlYW1JZD1tOWV5VU1GRkVlcWdGU1BCRnR6amtB', '', 0, '', 0, NULL, '');
INSERT INTO `cmf_course_lesson` VALUES (36, 8, 25, 0, '发发发', 0, '', '', NULL, 0, 10000, 0, 0, 0, 0, '', NULL, '', 0, '', 0, NULL, '');

-- ----------------------------
-- Table structure for cmf_course_package
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_package`;
CREATE TABLE `cmf_course_package`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `gradeid` bigint(20) NOT NULL DEFAULT 0,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `des` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `price` decimal(10, 2) NOT NULL DEFAULT 0.00,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `courseids` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `nums` int(11) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `list_order` int(11) NOT NULL DEFAULT 10000,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_package
-- ----------------------------
INSERT INTO `cmf_course_package` VALUES (1, 4, '测试', '麻烦的很', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 10.00, '<p>点点点</p>', '[3]', 1, 0, 10000);
INSERT INTO `cmf_course_package` VALUES (2, 4, '测试套餐', 'dfsfsf', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 100.00, '<p>就是代理季度卡僵尸粉打飞机埃里克发家史离开房间冷冻机房链接据了解链接</p><p><img src=\"/upload/admin/20200727/be4fd2d88102a3d535ffa3e48dae2bfd.jpg\" title=\"u=2534506313,1688529724&amp;fm=26&amp;gp=0.jpg\" alt=\"u=2534506313,1688529724&amp;fm=26&amp;gp=0.jpg\"/></p>', '[3],[6]', 2, 0, 10000);
INSERT INTO `cmf_course_package` VALUES (3, 2, '东方大道', '', 'admin/20200821/befc012e1dc0944cde74fa9d5a6c322a.jpg', 0.00, NULL, '[5]', 1, 0, 10000);

-- ----------------------------
-- Table structure for cmf_course_users
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_users`;
CREATE TABLE `cmf_course_users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `sort` tinyint(1) NOT NULL DEFAULT 0,
  `paytype` tinyint(1) NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `liveuid` bigint(20) NOT NULL DEFAULT 0,
  `money` decimal(20, 2) NOT NULL DEFAULT 0.00,
  `orderno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `trade_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `paytime` bigint(20) NOT NULL DEFAULT 0,
  `step` tinyint(1) NOT NULL DEFAULT 0,
  `lessons` int(11) NOT NULL DEFAULT 0,
  `ispack` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 32 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_users
-- ----------------------------
INSERT INTO `cmf_course_users` VALUES (1, 2, 0, 2, 0, 13, 2, 0.00, '', '', 1, 1596527216, 1596527216, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (2, 2, 1, 0, 0, 2, 1, 0.00, '', '', 1, 1596595977, 1596595977, 1, 1, 0);
INSERT INTO `cmf_course_users` VALUES (3, 2, 1, 0, 0, 14, 1, 0.00, '', '', 1, 1596598257, 1596598257, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (4, 2, 0, 0, 0, 10, 2, 0.00, '', '', 1, 1596599427, 1596599427, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (5, 2, 3, 0, 0, 1, 1, 0.00, '', '', 1, 1596599781, 1596599781, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (6, 2, 1, 0, 0, 15, 2, 0.00, '', '', 1, 1596616265, 1596616265, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (7, 2, 1, 2, 0, 16, 2, 0.00, '', '', 1, 1596700906, 1596700906, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (8, 2, 1, 1, 0, 3, 2, 0.00, '', '', 0, 1596701092, 1596701092, 1, 2, 0);
INSERT INTO `cmf_course_users` VALUES (9, 4, 3, 0, 0, 20, 2, 0.00, '', '', 1, 1596784813, 1596784813, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (10, 4, 2, 0, 0, 18, 2, 0.00, '', '', 1, 1596785004, 1596785004, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (11, 4, 2, 0, 0, 19, 2, 0.00, '', '', 1, 1596786512, 1596786512, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (12, 2, 2, 0, 0, 19, 2, 0.00, '', '', 1, 1596846836, 1596846836, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (13, 7, 2, 0, 0, 19, 2, 0.00, '', '', 1, 1596849040, 1596849040, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (14, 4, 2, 0, 0, 21, 2, 0.00, '', '', 1, 1596858637, 1596858637, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (15, 4, 2, 0, 0, 22, 2, 0.00, '', '', 1, 1596858952, 1596858952, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (16, 4, 2, 0, 0, 17, 2, 0.00, '', '', 1, 1596865102, 1596865102, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (17, 4, 3, 0, 0, 23, 2, 0.00, '', '', 1, 1596866816, 1596866816, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (18, 4, 1, 1, 0, 3, 2, 0.00, '', '', 0, 1596870962, 1596870962, 2, 2, 0);
INSERT INTO `cmf_course_users` VALUES (19, 4, 1, 0, 0, 24, 2, 0.00, '', '', 1, 1596873528, 1596873528, 1, 2, 0);
INSERT INTO `cmf_course_users` VALUES (20, 7, 1, 0, 0, 24, 2, 0.00, '', '', 1, 1597045933, 1597045933, 1, 4, 0);
INSERT INTO `cmf_course_users` VALUES (21, 2, 1, 0, 0, 24, 2, 0.00, '', '', 1, 1597106299, 1597106299, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (22, 7, 1, 0, 0, 14, 1, 0.00, '', '', 1, 1597109085, 1597109085, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (23, 7, 3, 0, 0, 23, 2, 0.00, '', '', 1, 1597109120, 1597109120, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (24, 4, 1, 0, 0, 25, 8, 0.00, '', '', 1, 1597649360, 1597649360, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (25, 18, 1, 0, 0, 14, 1, 0.00, '', '', 1, 1597970768, 1597970768, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (26, 18, 1, 0, 0, 25, 8, 0.00, '', '', 1, 1597970787, 1597970787, 2, 1, 0);
INSERT INTO `cmf_course_users` VALUES (27, 2, 1, 0, 0, 25, 8, 0.00, '', '', 1, 1597970849, 1597970849, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (28, 19, 3, 0, 0, 23, 2, 0.00, '', '', 1, 1597972890, 1597972890, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (29, 19, 1, 0, 0, 24, 2, 0.00, '', '', 1, 1597973908, 1597973908, 1, 2, 0);
INSERT INTO `cmf_course_users` VALUES (30, 19, 3, 0, 0, 20, 2, 0.00, '', '', 1, 1597976122, 1597976122, 2, 0, 0);
INSERT INTO `cmf_course_users` VALUES (31, 7, 3, 0, 0, 20, 2, 0.00, '', '', 1, 1597976146, 1597976146, 2, 0, 0);

-- ----------------------------
-- Table structure for cmf_course_views
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_views`;
CREATE TABLE `cmf_course_views`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `sort` tinyint(1) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `lessonid` bigint(20) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 44 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_views
-- ----------------------------
INSERT INTO `cmf_course_views` VALUES (1, 2, 0, 13, 0, 1596760807);
INSERT INTO `cmf_course_views` VALUES (2, 2, 1, 2, 3, 1596595977);
INSERT INTO `cmf_course_views` VALUES (3, 2, 1, 14, 11, 1596598257);
INSERT INTO `cmf_course_views` VALUES (4, 2, 0, 10, 0, 1596599427);
INSERT INTO `cmf_course_views` VALUES (5, 2, 3, 1, 0, 1596599781);
INSERT INTO `cmf_course_views` VALUES (6, 2, 1, 15, 13, 1596616265);
INSERT INTO `cmf_course_views` VALUES (7, 2, 1, 16, 20, 1596701025);
INSERT INTO `cmf_course_views` VALUES (8, 2, 1, 3, 8, 1596701168);
INSERT INTO `cmf_course_views` VALUES (9, 2, 1, 3, 21, 1596701461);
INSERT INTO `cmf_course_views` VALUES (10, 4, 3, 20, 0, 1596858397);
INSERT INTO `cmf_course_views` VALUES (11, 4, 2, 18, 0, 1597311819);
INSERT INTO `cmf_course_views` VALUES (12, 4, 2, 19, 0, 1597045821);
INSERT INTO `cmf_course_views` VALUES (13, 2, 2, 19, 0, 1596848431);
INSERT INTO `cmf_course_views` VALUES (14, 7, 2, 19, 0, 1597053035);
INSERT INTO `cmf_course_views` VALUES (15, 4, 2, 21, 0, 1596858815);
INSERT INTO `cmf_course_views` VALUES (16, 4, 2, 22, 0, 1596864983);
INSERT INTO `cmf_course_views` VALUES (17, 4, 2, 17, 0, 1596865600);
INSERT INTO `cmf_course_views` VALUES (18, 4, 3, 23, 0, 1597309575);
INSERT INTO `cmf_course_views` VALUES (19, 4, 1, 3, 8, 1596871190);
INSERT INTO `cmf_course_views` VALUES (20, 4, 1, 3, 21, 1596870974);
INSERT INTO `cmf_course_views` VALUES (21, 4, 1, 3, 0, 1596873310);
INSERT INTO `cmf_course_views` VALUES (22, 4, 1, 24, 0, 1597651589);
INSERT INTO `cmf_course_views` VALUES (23, 7, 1, 24, 0, 1597975120);
INSERT INTO `cmf_course_views` VALUES (24, 2, 1, 24, 0, 1597108905);
INSERT INTO `cmf_course_views` VALUES (25, 7, 1, 24, 23, 1597115549);
INSERT INTO `cmf_course_views` VALUES (26, 2, 1, 24, 23, 1597109586);
INSERT INTO `cmf_course_views` VALUES (27, 7, 1, 14, 11, 1597109085);
INSERT INTO `cmf_course_views` VALUES (28, 7, 3, 23, 0, 1597109120);
INSERT INTO `cmf_course_views` VALUES (29, 7, 1, 24, 25, 1597289148);
INSERT INTO `cmf_course_views` VALUES (30, 7, 1, 24, 24, 1597284855);
INSERT INTO `cmf_course_views` VALUES (31, 7, 1, 24, 34, 1597305412);
INSERT INTO `cmf_course_views` VALUES (32, 4, 1, 25, 0, 1597649361);
INSERT INTO `cmf_course_views` VALUES (33, 18, 1, 14, 11, 1597970772);
INSERT INTO `cmf_course_views` VALUES (34, 18, 1, 25, 37, 1597970787);
INSERT INTO `cmf_course_views` VALUES (35, 2, 1, 25, 0, 1597970873);
INSERT INTO `cmf_course_views` VALUES (36, 4, 1, 24, 34, 1597971102);
INSERT INTO `cmf_course_views` VALUES (37, 4, 1, 24, 35, 1597972369);
INSERT INTO `cmf_course_views` VALUES (38, 4, 1, 25, 37, 1597971156);
INSERT INTO `cmf_course_views` VALUES (39, 19, 3, 23, 0, 1597972890);
INSERT INTO `cmf_course_views` VALUES (40, 19, 1, 24, 23, 1597974038);
INSERT INTO `cmf_course_views` VALUES (41, 19, 1, 24, 24, 1597973933);
INSERT INTO `cmf_course_views` VALUES (42, 19, 3, 20, 0, 1597976122);
INSERT INTO `cmf_course_views` VALUES (43, 7, 3, 20, 0, 1597976146);

-- ----------------------------
-- Table structure for cmf_course_ware
-- ----------------------------
DROP TABLE IF EXISTS `cmf_course_ware`;
CREATE TABLE `cmf_course_ware`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `lessonid` bigint(20) NOT NULL DEFAULT 0,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `list_order` int(11) NOT NULL DEFAULT 10000,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `size` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_course_ware
-- ----------------------------
INSERT INTO `cmf_course_ware` VALUES (2, 2, 15, 14, '商城系统导航下拉菜单和修改.doc', 'default/20200805/e1ebb316f7ddafd776ca959aabee143f.doc', 10000, 1596616492, '97KB');
INSERT INTO `cmf_course_ware` VALUES (3, 2, 24, 25, '(外接项目)20200518鹏哥客户.docx', 'default/20200811/bf5d09da1b225a344d3bd54f49b23203.docx', 10000, 1597111198, '14.1KB');

-- ----------------------------
-- Table structure for cmf_feedback
-- ----------------------------
DROP TABLE IF EXISTS `cmf_feedback`;
CREATE TABLE `cmf_feedback`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `model` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `system` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `uptime` bigint(20) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_hook
-- ----------------------------
DROP TABLE IF EXISTS `cmf_hook`;
CREATE TABLE `cmf_hook`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '钩子类型(1:系统钩子;2:应用钩子;3:模板钩子;4:后台模板钩子)',
  `once` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否只允许一个插件运行(0:多个;1:一个)',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '钩子名称',
  `hook` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '钩子',
  `app` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '应用名(只有应用钩子才用)',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 86 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统钩子表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_hook
-- ----------------------------
INSERT INTO `cmf_hook` VALUES (2, 1, 0, '应用开始', 'app_begin', 'cmf', '应用开始');
INSERT INTO `cmf_hook` VALUES (3, 1, 0, '模块初始化', 'module_init', 'cmf', '模块初始化');
INSERT INTO `cmf_hook` VALUES (4, 1, 0, '控制器开始', 'action_begin', 'cmf', '控制器开始');
INSERT INTO `cmf_hook` VALUES (5, 1, 0, '视图输出过滤', 'view_filter', 'cmf', '视图输出过滤');
INSERT INTO `cmf_hook` VALUES (6, 1, 0, '应用结束', 'app_end', 'cmf', '应用结束');
INSERT INTO `cmf_hook` VALUES (7, 1, 0, '日志write方法', 'log_write', 'cmf', '日志write方法');
INSERT INTO `cmf_hook` VALUES (8, 1, 0, '输出结束', 'response_end', 'cmf', '输出结束');
INSERT INTO `cmf_hook` VALUES (9, 1, 0, '后台控制器初始化', 'admin_init', 'cmf', '后台控制器初始化');
INSERT INTO `cmf_hook` VALUES (10, 1, 0, '前台控制器初始化', 'home_init', 'cmf', '前台控制器初始化');
INSERT INTO `cmf_hook` VALUES (11, 1, 1, '发送手机验证码', 'send_mobile_verification_code', 'cmf', '发送手机验证码');
INSERT INTO `cmf_hook` VALUES (12, 3, 0, '模板 body标签开始', 'body_start', '', '模板 body标签开始');
INSERT INTO `cmf_hook` VALUES (13, 3, 0, '模板 head标签结束前', 'before_head_end', '', '模板 head标签结束前');
INSERT INTO `cmf_hook` VALUES (14, 3, 0, '模板底部开始', 'footer_start', '', '模板底部开始');
INSERT INTO `cmf_hook` VALUES (15, 3, 0, '模板底部开始之前', 'before_footer', '', '模板底部开始之前');
INSERT INTO `cmf_hook` VALUES (16, 3, 0, '模板底部结束之前', 'before_footer_end', '', '模板底部结束之前');
INSERT INTO `cmf_hook` VALUES (17, 3, 0, '模板 body 标签结束之前', 'before_body_end', '', '模板 body 标签结束之前');
INSERT INTO `cmf_hook` VALUES (18, 3, 0, '模板左边栏开始', 'left_sidebar_start', '', '模板左边栏开始');
INSERT INTO `cmf_hook` VALUES (19, 3, 0, '模板左边栏结束之前', 'before_left_sidebar_end', '', '模板左边栏结束之前');
INSERT INTO `cmf_hook` VALUES (20, 3, 0, '模板右边栏开始', 'right_sidebar_start', '', '模板右边栏开始');
INSERT INTO `cmf_hook` VALUES (21, 3, 0, '模板右边栏结束之前', 'before_right_sidebar_end', '', '模板右边栏结束之前');
INSERT INTO `cmf_hook` VALUES (22, 3, 1, '评论区', 'comment', '', '评论区');
INSERT INTO `cmf_hook` VALUES (23, 3, 1, '留言区', 'guestbook', '', '留言区');
INSERT INTO `cmf_hook` VALUES (24, 2, 0, '后台首页仪表盘', 'admin_dashboard', 'admin', '后台首页仪表盘');
INSERT INTO `cmf_hook` VALUES (25, 4, 0, '后台模板 head标签结束前', 'admin_before_head_end', '', '后台模板 head标签结束前');
INSERT INTO `cmf_hook` VALUES (26, 4, 0, '后台模板 body 标签结束之前', 'admin_before_body_end', '', '后台模板 body 标签结束之前');
INSERT INTO `cmf_hook` VALUES (27, 2, 0, '后台登录页面', 'admin_login', 'admin', '后台登录页面');
INSERT INTO `cmf_hook` VALUES (28, 1, 1, '前台模板切换', 'switch_theme', 'cmf', '前台模板切换');
INSERT INTO `cmf_hook` VALUES (29, 3, 0, '主要内容之后', 'after_content', '', '主要内容之后');
INSERT INTO `cmf_hook` VALUES (32, 2, 1, '获取上传界面', 'fetch_upload_view', 'user', '获取上传界面');
INSERT INTO `cmf_hook` VALUES (33, 3, 0, '主要内容之前', 'before_content', 'cmf', '主要内容之前');
INSERT INTO `cmf_hook` VALUES (34, 1, 0, '日志写入完成', 'log_write_done', 'cmf', '日志写入完成');
INSERT INTO `cmf_hook` VALUES (35, 1, 1, '后台模板切换', 'switch_admin_theme', 'cmf', '后台模板切换');
INSERT INTO `cmf_hook` VALUES (36, 1, 1, '验证码图片', 'captcha_image', 'cmf', '验证码图片');
INSERT INTO `cmf_hook` VALUES (37, 2, 1, '后台模板设计界面', 'admin_theme_design_view', 'admin', '后台模板设计界面');
INSERT INTO `cmf_hook` VALUES (38, 2, 1, '后台设置网站信息界面', 'admin_setting_site_view', 'admin', '后台设置网站信息界面');
INSERT INTO `cmf_hook` VALUES (39, 2, 1, '后台清除缓存界面', 'admin_setting_clear_cache_view', 'admin', '后台清除缓存界面');
INSERT INTO `cmf_hook` VALUES (40, 2, 1, '后台导航管理界面', 'admin_nav_index_view', 'admin', '后台导航管理界面');
INSERT INTO `cmf_hook` VALUES (41, 2, 1, '后台友情链接管理界面', 'admin_link_index_view', 'admin', '后台友情链接管理界面');
INSERT INTO `cmf_hook` VALUES (42, 2, 1, '后台幻灯片管理界面', 'admin_slide_index_view', 'admin', '后台幻灯片管理界面');
INSERT INTO `cmf_hook` VALUES (43, 2, 1, '后台管理员列表界面', 'admin_user_index_view', 'admin', '后台管理员列表界面');
INSERT INTO `cmf_hook` VALUES (44, 2, 1, '后台角色管理界面', 'admin_rbac_index_view', 'admin', '后台角色管理界面');
INSERT INTO `cmf_hook` VALUES (49, 2, 1, '用户管理本站用户列表界面', 'user_admin_index_view', 'user', '用户管理本站用户列表界面');
INSERT INTO `cmf_hook` VALUES (50, 2, 1, '资源管理列表界面', 'user_admin_asset_index_view', 'user', '资源管理列表界面');
INSERT INTO `cmf_hook` VALUES (51, 2, 1, '用户管理第三方用户列表界面', 'user_admin_oauth_index_view', 'user', '用户管理第三方用户列表界面');
INSERT INTO `cmf_hook` VALUES (52, 2, 1, '后台首页界面', 'admin_index_index_view', 'admin', '后台首页界面');
INSERT INTO `cmf_hook` VALUES (53, 2, 1, '后台回收站界面', 'admin_recycle_bin_index_view', 'admin', '后台回收站界面');
INSERT INTO `cmf_hook` VALUES (54, 2, 1, '后台菜单管理界面', 'admin_menu_index_view', 'admin', '后台菜单管理界面');
INSERT INTO `cmf_hook` VALUES (55, 2, 1, '后台自定义登录是否开启钩子', 'admin_custom_login_open', 'admin', '后台自定义登录是否开启钩子');
INSERT INTO `cmf_hook` VALUES (64, 2, 1, '后台幻灯片页面列表界面', 'admin_slide_item_index_view', 'admin', '后台幻灯片页面列表界面');
INSERT INTO `cmf_hook` VALUES (65, 2, 1, '后台幻灯片页面添加界面', 'admin_slide_item_add_view', 'admin', '后台幻灯片页面添加界面');
INSERT INTO `cmf_hook` VALUES (66, 2, 1, '后台幻灯片页面编辑界面', 'admin_slide_item_edit_view', 'admin', '后台幻灯片页面编辑界面');
INSERT INTO `cmf_hook` VALUES (67, 2, 1, '后台管理员添加界面', 'admin_user_add_view', 'admin', '后台管理员添加界面');
INSERT INTO `cmf_hook` VALUES (68, 2, 1, '后台管理员编辑界面', 'admin_user_edit_view', 'admin', '后台管理员编辑界面');
INSERT INTO `cmf_hook` VALUES (69, 2, 1, '后台角色添加界面', 'admin_rbac_role_add_view', 'admin', '后台角色添加界面');
INSERT INTO `cmf_hook` VALUES (70, 2, 1, '后台角色编辑界面', 'admin_rbac_role_edit_view', 'admin', '后台角色编辑界面');
INSERT INTO `cmf_hook` VALUES (71, 2, 1, '后台角色授权界面', 'admin_rbac_authorize_view', 'admin', '后台角色授权界面');
INSERT INTO `cmf_hook` VALUES (72, 2, 0, '文章显示之前', 'portal_before_assign_article', 'portal', '文章显示之前');
INSERT INTO `cmf_hook` VALUES (73, 2, 0, '后台文章保存之后', 'portal_admin_after_save_article', 'portal', '后台文章保存之后');
INSERT INTO `cmf_hook` VALUES (74, 2, 1, '门户后台文章管理列表界面', 'portal_admin_article_index_view', 'portal', '门户后台文章管理列表界面');
INSERT INTO `cmf_hook` VALUES (75, 2, 1, '门户后台文章添加界面', 'portal_admin_article_add_view', 'portal', '门户后台文章添加界面');
INSERT INTO `cmf_hook` VALUES (76, 2, 1, '门户后台文章编辑界面', 'portal_admin_article_edit_view', 'portal', '门户后台文章编辑界面');
INSERT INTO `cmf_hook` VALUES (77, 2, 1, '门户后台文章分类管理列表界面', 'portal_admin_category_index_view', 'portal', '门户后台文章分类管理列表界面');
INSERT INTO `cmf_hook` VALUES (78, 2, 1, '门户后台文章分类添加界面', 'portal_admin_category_add_view', 'portal', '门户后台文章分类添加界面');
INSERT INTO `cmf_hook` VALUES (79, 2, 1, '门户后台文章分类编辑界面', 'portal_admin_category_edit_view', 'portal', '门户后台文章分类编辑界面');
INSERT INTO `cmf_hook` VALUES (80, 2, 1, '门户后台页面管理列表界面', 'portal_admin_page_index_view', 'portal', '门户后台页面管理列表界面');
INSERT INTO `cmf_hook` VALUES (81, 2, 1, '门户后台页面添加界面', 'portal_admin_page_add_view', 'portal', '门户后台页面添加界面');
INSERT INTO `cmf_hook` VALUES (82, 2, 1, '门户后台页面编辑界面', 'portal_admin_page_edit_view', 'portal', '门户后台页面编辑界面');
INSERT INTO `cmf_hook` VALUES (83, 2, 1, '门户后台文章标签管理列表界面', 'portal_admin_tag_index_view', 'portal', '门户后台文章标签管理列表界面');
INSERT INTO `cmf_hook` VALUES (84, 4, 0, '门户后台文章添加编辑界面右侧栏', 'portal_admin_article_edit_view_right_sidebar', 'portal', '门户后台文章添加编辑界面右侧栏');
INSERT INTO `cmf_hook` VALUES (85, 4, 0, '门户后台文章添加编辑界面主要内容', 'portal_admin_article_edit_view_main', 'portal', '门户后台文章添加编辑界面主要内容');

-- ----------------------------
-- Table structure for cmf_hook_plugin
-- ----------------------------
DROP TABLE IF EXISTS `cmf_hook_plugin`;
CREATE TABLE `cmf_hook_plugin`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '状态(0:禁用,1:启用)',
  `hook` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '钩子名',
  `plugin` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '插件',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '系统钩子插件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_hook_plugin
-- ----------------------------
INSERT INTO `cmf_hook_plugin` VALUES (1, 10000, 1, 'fetch_upload_view', 'Qiniu');

-- ----------------------------
-- Table structure for cmf_identity
-- ----------------------------
DROP TABLE IF EXISTS `cmf_identity`;
CREATE TABLE `cmf_identity`  (
  `id` int(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `colour` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '颜色',
  `list_order` int(11) NOT NULL DEFAULT 10000 COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_identity
-- ----------------------------
INSERT INTO `cmf_identity` VALUES (1, '资深讲师', '#2D95FF', 10000);
INSERT INTO `cmf_identity` VALUES (2, '教育总监', '#FF5F19', 10000);
INSERT INTO `cmf_identity` VALUES (3, '特约讲师', '#27BD94', 10000);
INSERT INTO `cmf_identity` VALUES (5, '教育专家', '#000000', 10000);
INSERT INTO `cmf_identity` VALUES (6, '心理讲师', '#ebdd41', 10000);

-- ----------------------------
-- Table structure for cmf_ip_garde
-- ----------------------------
DROP TABLE IF EXISTS `cmf_ip_garde`;
CREATE TABLE `cmf_ip_garde`  (
  `ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'ip地址',
  `gardeid` int(11) NULL DEFAULT 0 COMMENT '年级id',
  PRIMARY KEY (`ip`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_ip_garde
-- ----------------------------
INSERT INTO `cmf_ip_garde` VALUES ('112.250.3.247', 2);
INSERT INTO `cmf_ip_garde` VALUES ('119.183.140.24', 2);
INSERT INTO `cmf_ip_garde` VALUES ('123.135.32.179', 2);
INSERT INTO `cmf_ip_garde` VALUES ('127.0.0.1', 2);
INSERT INTO `cmf_ip_garde` VALUES ('182.35.111.125', 2);
INSERT INTO `cmf_ip_garde` VALUES ('221.1.172.200', 2);
INSERT INTO `cmf_ip_garde` VALUES ('222.132.140.188', 2);
INSERT INTO `cmf_ip_garde` VALUES ('39.85.100.54', 4);

-- ----------------------------
-- Table structure for cmf_ip_login_nums
-- ----------------------------
DROP TABLE IF EXISTS `cmf_ip_login_nums`;
CREATE TABLE `cmf_ip_login_nums`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '登录ip',
  `addtime` int(11) NOT NULL COMMENT '时间',
  `province` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '省份',
  `lat` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `lng` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `city` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '城市',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 24 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_ip_login_nums
-- ----------------------------
INSERT INTO `cmf_ip_login_nums` VALUES (18, '221.1.172.200', 1597627697, '山东省', '36.18752', '117.0418', '泰安市');
INSERT INTO `cmf_ip_login_nums` VALUES (21, '221.1.172.200', 1597711067, '山东省', '36.18752', '117.0418', '泰安市');
INSERT INTO `cmf_ip_login_nums` VALUES (22, '221.1.172.200', 1597797120, '山东省', '36.18752', '117.0418', '泰安市');
INSERT INTO `cmf_ip_login_nums` VALUES (23, '119.183.140.24', 1597969858, '山东省', '36.18752', '117.0418', '泰安市');

-- ----------------------------
-- Table structure for cmf_link
-- ----------------------------
DROP TABLE IF EXISTS `cmf_link`;
CREATE TABLE `cmf_link`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态;1:显示;0:不显示',
  `rating` int(11) NOT NULL DEFAULT 0 COMMENT '友情链接评级',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '友情链接描述',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '友情链接地址',
  `name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '友情链接名称',
  `image` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '友情链接图标',
  `target` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '友情链接打开方式',
  `rel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '链接与网站的关系',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status`(`status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '友情链接表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_live_chat
-- ----------------------------
DROP TABLE IF EXISTS `cmf_live_chat`;
CREATE TABLE `cmf_live_chat`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `liveuid` bigint(20) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `lessonid` bigint(20) NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `length` int(11) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `toid` bigint(20) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `user_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 88 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_live_chat
-- ----------------------------
INSERT INTO `cmf_live_chat` VALUES (81, 2, 2, 19, 0, 0, '我是谁', '', 0, 1597045303, 0, 0, 1);
INSERT INTO `cmf_live_chat` VALUES (82, 4, 2, 19, 0, 0, 'hahah', '', 0, 1597045355, 0, 0, 0);
INSERT INTO `cmf_live_chat` VALUES (83, 4, 2, 19, 0, 0, 'ffff', '', 0, 1597045458, 0, 0, 0);
INSERT INTO `cmf_live_chat` VALUES (84, 7, 2, 19, 0, 0, '反反复复', '', 0, 1597045518, 0, 0, 0);
INSERT INTO `cmf_live_chat` VALUES (85, 2, 2, 24, 23, 0, '好的不行吧', '', 0, 1597107765, 0, 0, 0);
INSERT INTO `cmf_live_chat` VALUES (86, 7, 2, 24, 23, 0, '见见你呢', '', 0, 1597107991, 0, 0, 0);
INSERT INTO `cmf_live_chat` VALUES (87, 7, 2, 23, 0, 0, '出差', '', 0, 1597109136, 0, 0, 0);

-- ----------------------------
-- Table structure for cmf_live_kick
-- ----------------------------
DROP TABLE IF EXISTS `cmf_live_kick`;
CREATE TABLE `cmf_live_kick`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `liveuid` bigint(20) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `lessonid` bigint(20) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `operateuid` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_live_shutup
-- ----------------------------
DROP TABLE IF EXISTS `cmf_live_shutup`;
CREATE TABLE `cmf_live_shutup`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `liveuid` bigint(20) NOT NULL DEFAULT 0,
  `courseid` bigint(20) NOT NULL DEFAULT 0,
  `lessonid` bigint(20) NOT NULL DEFAULT 0,
  `addtime` bigint(20) NOT NULL DEFAULT 0,
  `operateuid` bigint(20) NOT NULL DEFAULT 0,
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `endtime` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_option
-- ----------------------------
DROP TABLE IF EXISTS `cmf_option`;
CREATE TABLE `cmf_option`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `autoload` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '是否自动加载;1:自动加载;0:不自动加载',
  `option_name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '配置名',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '配置值',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `option_name`(`option_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '全站配置表' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of cmf_option
-- ----------------------------
INSERT INTO `cmf_option` VALUES (1, 1, 'site_info', '{\"site_name\":\"\\u4e07\\u5cb3\\u6559\\u80b2\",\"site_seo_title\":\"\",\"site_seo_keywords\":\"\",\"site_seo_description\":\"\",\"site_icp\":\"\",\"site_gwa\":\"\",\"site_admin_email\":\"\",\"site_analytics\":\"\",\"site_url\":\"http:\\/\\/crack.sdwanyue.com\\/\",\"copyright\":\" \\u8fd9\\u5c31\\u662f\\u7248\\u6743\\u4fe1\\u606f\",\"apk_ver\":\"\",\"apk_url\":\"\",\"apk_des\":\"\\u7248\\u672c\\u66f4\\u65b0\\uff0c\\u662f\\u5426\\u524d\\u5f80\\u66f4\\u65b0\\uff1f\",\"ipa_ver\":\"\",\"ios_shelves\":\"\",\"ipa_url\":\"\",\"ipa_des\":\"\\u7248\\u672c\\u66f4\\u65b0\\uff0c\\u662f\\u5426\\u524d\\u5f80\\u66f4\\u65b0\\uff1f\",\"qr_url\":\"admin\\/20200821\\/8854f0533fc8a687aff663e97aee9e0c.jpg\",\"site_phone\":\"122132132\",\"wx_url\":\"admin\\/20200821\\/8854f0533fc8a687aff663e97aee9e0c.jpg\"}');
INSERT INTO `cmf_option` VALUES (2, 1, 'cmf_settings', '{\"open_registration\":\"0\",\"banned_usernames\":\"\"}');
INSERT INTO `cmf_option` VALUES (3, 1, 'cdn_settings', '{\"cdn_static_root\":\"\"}');
INSERT INTO `cmf_option` VALUES (4, 1, 'admin_settings', '{\"admin_password\":\"\",\"admin_theme\":\"admin_simpleboot3\",\"admin_style\":\"flatadmin\"}');
INSERT INTO `cmf_option` VALUES (5, 1, 'storage', '{\"storages\":{\"Qiniu\":{\"name\":\"\\u4e03\\u725b\\u4e91\\u5b58\\u50a8\",\"driver\":\"\\\\plugins\\\\qiniu\\\\lib\\\\Qiniu\"}},\"type\":\"Local\"}');
INSERT INTO `cmf_option` VALUES (6, 1, 'upload_setting', '{\"max_files\":\"20\",\"chunk_size\":\"512\",\"file_types\":{\"image\":{\"upload_max_filesize\":\"10240\",\"extensions\":\"jpg,jpeg,png,gif,bmp4\"},\"video\":{\"upload_max_filesize\":\"10240000\",\"extensions\":\"mp4\"},\"audio\":{\"upload_max_filesize\":\"1024000\",\"extensions\":\"mp3,wma,wav\"},\"file\":{\"upload_max_filesize\":\"1024000\",\"extensions\":\"txt,pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar,php\"}}}');
INSERT INTO `cmf_option` VALUES (7, 1, 'configpri', '{\"sendcode_switch\":\"0\",\"ccp_sid\":\"\",\"ccp_token\":\"\",\"ccp_appid\":\"\",\"ccp_tempid\":\"\",\"aliapp_switch\":\"1\",\"aliapp_partner\":\"\",\"aliapp_seller_id\":\"\",\"aliapp_key\":\"\",\"wx_switch\":\"1\",\"wx_appid\":\"\",\"wx_appsecret\":\"\",\"wx_mchid\":\"\",\"wx_key\":\"\",\"ios_switch\":\"0\",\"login_type\":\"QQ,wx\",\"share_type\":\"qq,qzone\",\"chatserver\":\"\",\"jpush_sandbox\":\"0\",\"jpush_key\":\"\",\"jpush_secret\":\"\",\"sound_appid\":\"\",\"netless_sdktoken\":\"\",\"wx_appid_pc\":\"\",\"wx_appsecret_pc\":\"\",\"tx_api_secretid\":\"\",\"tx_api_secretkey\":\"\",\"tx_sms_sdkappid\":\"\",\"tx_sms_sign\":\"\",\"tx_sms_tempid\":\"\",\"agora_api_id\":\"\",\"agora_api_key\":\"\",\"netless_appid\":\"\",\"tx_map_key\":\"\"}');

-- ----------------------------
-- Table structure for cmf_orders
-- ----------------------------
DROP TABLE IF EXISTS `cmf_orders`;
CREATE TABLE `cmf_orders`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `money` decimal(20, 2) NOT NULL DEFAULT 0.00 COMMENT '价格',
  `type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '支付方式，1支付宝2微信',
  `orderno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '订单号',
  `trade_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '三方订单号',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '支付状态，0待支付1已支付',
  `addtime` bigint(20) NOT NULL DEFAULT 0 COMMENT '添加时间',
  `paytime` bigint(20) NOT NULL DEFAULT 0 COMMENT '支付时间',
  `addr_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '收货人',
  `addr_mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '联系方式',
  `addr_province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '省',
  `addr_city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '市',
  `addr_area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '区',
  `addr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '详细地址',
  `issend` tinyint(1) NOT NULL DEFAULT -1 COMMENT '是否发货-1不需要0否1是',
  `sendtime` bigint(20) NOT NULL DEFAULT 0 COMMENT '发货时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 15 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_orders
-- ----------------------------
INSERT INTO `cmf_orders` VALUES (1, 4, 100.00, 1, '4_200814170106422', '', 0, 1597395666, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (2, 4, 100.00, 1, '4_200814170137671', '', 0, 1597395697, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (3, 4, 100.00, 1, '4_200814170431301', '', 0, 1597395871, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (4, 4, 100.00, 1, '4_200814171158688', '', 0, 1597396318, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (5, 4, 100.00, 2, '4_200814171203378', '', 0, 1597396323, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (6, 4, 100.00, 1, '4_200814171324876', '', 0, 1597396404, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (7, 4, 100.00, 1, '4_200814171330772', '', 0, 1597396410, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (8, 4, 100.00, 1, '4_200814171350458', '', 0, 1597396430, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (9, 4, 100.00, 1, '4_200814171501306', '', 0, 1597396501, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (10, 4, 100.00, 1, '4_200814171504568', '', 0, 1597396504, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (11, 4, 100.00, 1, '4_200814171532828', '', 0, 1597396532, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (12, 4, 100.00, 2, '4_200814171536244', '', 0, 1597396536, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (13, 4, 100.00, 2, '4_200814171613561', '', 0, 1597396573, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);
INSERT INTO `cmf_orders` VALUES (14, 4, 100.00, 1, '4_200814171615798', '', 0, 1597396575, 0, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 0);

-- ----------------------------
-- Table structure for cmf_orders_good
-- ----------------------------
DROP TABLE IF EXISTS `cmf_orders_good`;
CREATE TABLE `cmf_orders_good`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0,
  `orderno` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `typeid` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 15 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_orders_good
-- ----------------------------
INSERT INTO `cmf_orders_good` VALUES (1, 4, '4_200814170106422', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (2, 4, '4_200814170137671', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (3, 4, '4_200814170431301', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (4, 4, '4_200814171158688', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (5, 4, '4_200814171203378', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (6, 4, '4_200814171324876', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (7, 4, '4_200814171330772', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (8, 4, '4_200814171350458', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (9, 4, '4_200814171501306', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (10, 4, '4_200814171504568', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (11, 4, '4_200814171532828', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (12, 4, '4_200814171536244', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (13, 4, '4_200814171613561', 0, 26);
INSERT INTO `cmf_orders_good` VALUES (14, 4, '4_200814171615798', 0, 26);

-- ----------------------------
-- Table structure for cmf_plugin
-- ----------------------------
DROP TABLE IF EXISTS `cmf_plugin`;
CREATE TABLE `cmf_plugin`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `type` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '插件类型;1:网站;8:微信',
  `has_admin` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否有后台管理,0:没有;1:有',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态;1:开启;0:禁用',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '插件安装时间',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '插件标识名,英文字母(惟一)',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '插件名称',
  `demo_url` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '演示地址，带协议',
  `hooks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实现的钩子;以“,”分隔',
  `author` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '插件作者',
  `author_url` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '作者网站链接',
  `version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '插件版本号',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '插件描述',
  `config` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '插件配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '插件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_plugin
-- ----------------------------
INSERT INTO `cmf_plugin` VALUES (1, 1, 0, 1, 0, 'Qiniu', '七牛云存储', '', '', 'ThinkCMF', '', '1.0.1', 'ThinkCMF七牛专享优惠码:507670e8', '{\"accessKey\":\"123\",\"secretKey\":\"123\",\"protocol\":\"http\",\"domain\":\"123\",\"bucket\":\"123\",\"zone\":\"z0\"}');

-- ----------------------------
-- Table structure for cmf_portal_category
-- ----------------------------
DROP TABLE IF EXISTS `cmf_portal_category`;
CREATE TABLE `cmf_portal_category`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `parent_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类父id',
  `post_count` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类文章数',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态,1:发布,0:不发布',
  `delete_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '删除时间',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名称',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类描述',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类层级关系路径',
  `seo_title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `seo_keywords` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `seo_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `list_tpl` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类列表模板',
  `one_tpl` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '分类文章页模板',
  `more` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '扩展属性',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'portal应用 文章分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_portal_category
-- ----------------------------
INSERT INTO `cmf_portal_category` VALUES (1, 0, 0, 1, 0, 10000, '帮助中心', '讲师端帮助132', '0-1', '', '', '', 'list', 'article', '{\"thumbnail\":\"portal\\/20200415\\/6f735ef9841af07021491e56ac5f480f.jpg\"}');
INSERT INTO `cmf_portal_category` VALUES (2, 0, 0, 1, 1587887691, 10000, '常见问题', '常见问题疑难解答', '0-2', '', '', '', 'list', 'article', '{\"thumbnail\":\"\"}');
INSERT INTO `cmf_portal_category` VALUES (3, 0, 0, 1, 0, 10000, '视频课程', '', '0-3', '', '', '', 'list', 'article', '{\"thumbnail\":\"\"}');

-- ----------------------------
-- Table structure for cmf_portal_category_post
-- ----------------------------
DROP TABLE IF EXISTS `cmf_portal_category_post`;
CREATE TABLE `cmf_portal_category_post`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章id',
  `category_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '分类id',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态,1:发布;0:不发布',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `term_taxonomy_id`(`category_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'portal应用 分类文章对应表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_portal_category_post
-- ----------------------------
INSERT INTO `cmf_portal_category_post` VALUES (2, 5, 1, 10000, 1);
INSERT INTO `cmf_portal_category_post` VALUES (3, 6, 1, 10000, 1);

-- ----------------------------
-- Table structure for cmf_portal_post
-- ----------------------------
DROP TABLE IF EXISTS `cmf_portal_post`;
CREATE TABLE `cmf_portal_post`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级id',
  `post_type` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '类型,1:文章;2:页面',
  `post_format` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '内容格式;1:html;2:md',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发表者用户id',
  `post_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态;1:已发布;0:未发布;',
  `comment_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '评论状态;1:允许;0:不允许',
  `is_top` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否置顶;1:置顶;0:不置顶',
  `recommended` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否推荐;1:推荐;0:不推荐',
  `post_hits` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '查看数',
  `post_favorites` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '收藏数',
  `post_like` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '点赞数',
  `comment_count` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论数',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  `update_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `published_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '发布时间',
  `delete_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '删除时间',
  `post_title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'post标题',
  `post_keywords` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'seo keywords',
  `post_excerpt` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'post摘要',
  `post_source` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '转载文章的来源',
  `thumbnail` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '缩略图',
  `post_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '文章内容',
  `post_content_filtered` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '处理过的文章内容',
  `more` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '扩展属性,如缩略图;格式为json',
  `type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '类型，0单页1关于我们',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `type_status_date`(`post_type`, `post_status`, `create_time`, `id`) USING BTREE,
  INDEX `parent_id`(`parent_id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE,
  INDEX `create_time`(`create_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'portal应用 文章表' ROW_FORMAT = Compact;

-- ----------------------------
-- Records of cmf_portal_post
-- ----------------------------
INSERT INTO `cmf_portal_post` VALUES (1, 0, 2, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0, 1583979561, 1588229791, 1583979540, 0, '关于我们', '', '', '', '', '&lt;p&gt;关于我们&lt;/p&gt;', NULL, '{\"thumbnail\":\"\",\"template\":\"page\"}', 0);
INSERT INTO `cmf_portal_post` VALUES (2, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1583979582, 1586920802, 1583979540, 0, '联系我们', '', '', '', '', '&lt;p&gt;联系我们获取相关最新活动版本~&lt;/p&gt;', NULL, '{\"thumbnail\":\"\",\"template\":\"page\"}', 0);
INSERT INTO `cmf_portal_post` VALUES (3, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1583979582, 1587023968, 1583979540, 0, '用户协议', '', '', '', '', '&lt;p&gt;用户协议123&lt;/p&gt;', NULL, '{\"thumbnail\":\"\",\"template\":\"page\"}', 0);

-- ----------------------------
-- Table structure for cmf_portal_tag
-- ----------------------------
DROP TABLE IF EXISTS `cmf_portal_tag`;
CREATE TABLE `cmf_portal_tag`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态,1:发布,0:不发布',
  `recommended` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否推荐;1:推荐;0:不推荐',
  `post_count` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '标签文章数',
  `name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标签名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'portal应用 文章标签表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_portal_tag
-- ----------------------------
INSERT INTO `cmf_portal_tag` VALUES (1, 1, 0, 0, '化学');
INSERT INTO `cmf_portal_tag` VALUES (2, 1, 0, 0, '语文');
INSERT INTO `cmf_portal_tag` VALUES (3, 1, 0, 0, '英语');

-- ----------------------------
-- Table structure for cmf_portal_tag_post
-- ----------------------------
DROP TABLE IF EXISTS `cmf_portal_tag_post`;
CREATE TABLE `cmf_portal_tag_post`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '标签 id',
  `post_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章 id',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态,1:发布;0:不发布',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `post_id`(`post_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = 'portal应用 标签文章对应表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_recycle_bin
-- ----------------------------
DROP TABLE IF EXISTS `cmf_recycle_bin`;
CREATE TABLE `cmf_recycle_bin`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NULL DEFAULT 0 COMMENT '删除内容 id',
  `create_time` int(10) UNSIGNED NULL DEFAULT 0 COMMENT '创建时间',
  `table_name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '删除内容所在表名',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '删除内容名称',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = ' 回收站' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_recycle_bin
-- ----------------------------
INSERT INTO `cmf_recycle_bin` VALUES (1, 6, 1596008604, 'slide', 'PC首页测试', 0);

-- ----------------------------
-- Table structure for cmf_role
-- ----------------------------
DROP TABLE IF EXISTS `cmf_role`;
CREATE TABLE `cmf_role`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父角色ID',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '状态;0:禁用;1:正常',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  `update_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '更新时间',
  `list_order` float NOT NULL DEFAULT 0 COMMENT '排序',
  `name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '角色名称',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `parent_id`(`parent_id`) USING BTREE,
  INDEX `status`(`status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_role
-- ----------------------------
INSERT INTO `cmf_role` VALUES (1, 0, 1, 1329633709, 1329633709, 0, '超级管理员', '拥有网站最高管理员权限！');
INSERT INTO `cmf_role` VALUES (2, 0, 1, 1329633709, 1329633709, 0, '普通管理员', '权限由最高管理员分配！');
INSERT INTO `cmf_role` VALUES (3, 0, 1, 0, 0, 0, '来访者', '客户专用身份');

-- ----------------------------
-- Table structure for cmf_role_user
-- ----------------------------
DROP TABLE IF EXISTS `cmf_role_user`;
CREATE TABLE `cmf_role_user`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `role_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '角色 id',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `role_id`(`role_id`) USING BTREE,
  INDEX `user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户角色对应表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_route
-- ----------------------------
DROP TABLE IF EXISTS `cmf_route`;
CREATE TABLE `cmf_route`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '路由id',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `status` tinyint(2) NOT NULL DEFAULT 1 COMMENT '状态;1:启用,0:不启用',
  `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT 'URL规则类型;1:用户自定义;2:别名添加',
  `full_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '完整url',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '实际显示的url',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'url路由表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_signory
-- ----------------------------
DROP TABLE IF EXISTS `cmf_signory`;
CREATE TABLE `cmf_signory`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '名称',
  `list_order` int(11) NOT NULL DEFAULT 10000 COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_signory
-- ----------------------------
INSERT INTO `cmf_signory` VALUES (1, '数学', 10000);
INSERT INTO `cmf_signory` VALUES (3, '语文', 10000);
INSERT INTO `cmf_signory` VALUES (4, '化学', 10000);
INSERT INTO `cmf_signory` VALUES (5, '物理', 10000);
INSERT INTO `cmf_signory` VALUES (6, '英语', 10000);
INSERT INTO `cmf_signory` VALUES (7, '音乐', 10000);

-- ----------------------------
-- Table structure for cmf_slide
-- ----------------------------
DROP TABLE IF EXISTS `cmf_slide`;
CREATE TABLE `cmf_slide`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态,1:显示,0不显示',
  `delete_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '删除时间',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '幻灯片分类',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '分类备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '幻灯片表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_slide
-- ----------------------------
INSERT INTO `cmf_slide` VALUES (1, 1, 0, 'APP首页', '不可删除');
INSERT INTO `cmf_slide` VALUES (2, 1, 1587438162, '幻灯片', '');
INSERT INTO `cmf_slide` VALUES (3, 1, 1587460102, '幻灯片2', '不可删除');
INSERT INTO `cmf_slide` VALUES (4, 1, 0, 'APP轮播', '');
INSERT INTO `cmf_slide` VALUES (5, 1, 0, 'PC首页', '不可删除');
INSERT INTO `cmf_slide` VALUES (6, 1, 1596008604, 'PC首页测试', '暂无');

-- ----------------------------
-- Table structure for cmf_slide_item
-- ----------------------------
DROP TABLE IF EXISTS `cmf_slide_item`;
CREATE TABLE `cmf_slide_item`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `slide_id` int(11) NOT NULL DEFAULT 0 COMMENT '幻灯片id',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态,1:显示;0:隐藏',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '幻灯片名称',
  `image` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '幻灯片图片',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '幻灯片链接',
  `target` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '友情链接打开方式',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '幻灯片描述',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '幻灯片内容',
  `more` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '扩展信息',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `slide_id`(`slide_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '幻灯片子项表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_slide_item
-- ----------------------------
INSERT INTO `cmf_slide_item` VALUES (1, 5, 1, 10000, 'PC首页测试', 'admin/20200821/250947610157d2318f74de1b575d3b0f.jpg', '', '', '', '', NULL);
INSERT INTO `cmf_slide_item` VALUES (2, 5, 1, 10000, 'PC首页测试二', 'admin/20200821/250947610157d2318f74de1b575d3b0f.jpg', '', '', '', '', NULL);

-- ----------------------------
-- Table structure for cmf_startlive_ip
-- ----------------------------
DROP TABLE IF EXISTS `cmf_startlive_ip`;
CREATE TABLE `cmf_startlive_ip`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL COMMENT '老师id',
  `ip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '开播时的ip',
  `addtime` int(11) NOT NULL COMMENT '时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_startlive_ip
-- ----------------------------
INSERT INTO `cmf_startlive_ip` VALUES (1, 2, '221.1.172.200', 1597711067);

-- ----------------------------
-- Table structure for cmf_theme
-- ----------------------------
DROP TABLE IF EXISTS `cmf_theme`;
CREATE TABLE `cmf_theme`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '安装时间',
  `update_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '最后升级时间',
  `status` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '模板状态,1:正在使用;0:未使用',
  `is_compiled` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '是否为已编译模板',
  `theme` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主题目录名，用于主题的维一标识',
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主题名称',
  `version` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主题版本号',
  `demo_url` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '演示地址，带协议',
  `thumbnail` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '缩略图',
  `author` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主题作者',
  `author_url` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '作者网站链接',
  `lang` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '支持语言',
  `keywords` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主题关键字',
  `description` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '主题描述',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_theme
-- ----------------------------
INSERT INTO `cmf_theme` VALUES (1, 0, 0, 0, 0, 'simpleboot3', 'simpleboot3', '1.0.2', 'http://demo.thinkcmf.com', '', 'ThinkCMF', 'http://www.thinkcmf.com', 'zh-cn', 'ThinkCMF模板', 'ThinkCMF默认模板');

-- ----------------------------
-- Table structure for cmf_theme_file
-- ----------------------------
DROP TABLE IF EXISTS `cmf_theme_file`;
CREATE TABLE `cmf_theme_file`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_public` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否公共的模板文件',
  `list_order` float NOT NULL DEFAULT 10000 COMMENT '排序',
  `theme` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模板名称',
  `name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模板文件名',
  `action` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '操作',
  `file` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模板文件，相对于模板根目录，如Portal/index.html',
  `description` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模板文件描述',
  `more` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '模板更多配置,用户自己后台设置的',
  `config_more` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '模板更多配置,来源模板的配置文件',
  `draft_more` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '模板更多配置,用户临时保存的配置',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_theme_file
-- ----------------------------
INSERT INTO `cmf_theme_file` VALUES (1, 0, 10, 'simpleboot3', '文章页', 'portal/Article/index', 'portal/article', '文章页模板文件', '{\"vars\":{\"hot_articles_category_id\":{\"title\":\"Hot Articles\\u5206\\u7c7bID\",\"value\":\"1\",\"type\":\"text\",\"tip\":\"\",\"rule\":[]}}}', '{\"vars\":{\"hot_articles_category_id\":{\"title\":\"Hot Articles\\u5206\\u7c7bID\",\"value\":\"1\",\"type\":\"text\",\"tip\":\"\",\"rule\":[]}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (2, 0, 10, 'simpleboot3', '联系我们页', 'portal/Page/index', 'portal/contact', '联系我们页模板文件', '{\"vars\":{\"baidu_map_info_window_text\":{\"title\":\"\\u767e\\u5ea6\\u5730\\u56fe\\u6807\\u6ce8\\u6587\\u5b57\",\"name\":\"baidu_map_info_window_text\",\"value\":\"ThinkCMF<br\\/><span class=\'\'>\\u5730\\u5740\\uff1a\\u4e0a\\u6d77\\u5e02\\u5f90\\u6c47\\u533a\\u659c\\u571f\\u8def2601\\u53f7<\\/span>\",\"type\":\"text\",\"tip\":\"\\u767e\\u5ea6\\u5730\\u56fe\\u6807\\u6ce8\\u6587\\u5b57,\\u652f\\u6301\\u7b80\\u5355html\\u4ee3\\u7801\",\"rule\":[]},\"company_location\":{\"title\":\"\\u516c\\u53f8\\u5750\\u6807\",\"value\":\"\",\"type\":\"location\",\"tip\":\"\",\"rule\":{\"require\":true}},\"address_cn\":{\"title\":\"\\u516c\\u53f8\\u5730\\u5740\",\"value\":\"\\u4e0a\\u6d77\\u5e02\\u5f90\\u6c47\\u533a\\u659c\\u571f\\u8def0001\\u53f7\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"address_en\":{\"title\":\"\\u516c\\u53f8\\u5730\\u5740\\uff08\\u82f1\\u6587\\uff09\",\"value\":\"NO.0001 Xie Tu Road, Shanghai China\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"email\":{\"title\":\"\\u516c\\u53f8\\u90ae\\u7bb1\",\"value\":\"catman@thinkcmf.com\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"phone_cn\":{\"title\":\"\\u516c\\u53f8\\u7535\\u8bdd\",\"value\":\"021 1000 0001\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"phone_en\":{\"title\":\"\\u516c\\u53f8\\u7535\\u8bdd\\uff08\\u82f1\\u6587\\uff09\",\"value\":\"+8621 1000 0001\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"qq\":{\"title\":\"\\u8054\\u7cfbQQ\",\"value\":\"478519726\",\"type\":\"text\",\"tip\":\"\\u591a\\u4e2a QQ\\u4ee5\\u82f1\\u6587\\u9017\\u53f7\\u9694\\u5f00\",\"rule\":{\"require\":true}}}}', '{\"vars\":{\"baidu_map_info_window_text\":{\"title\":\"\\u767e\\u5ea6\\u5730\\u56fe\\u6807\\u6ce8\\u6587\\u5b57\",\"name\":\"baidu_map_info_window_text\",\"value\":\"ThinkCMF<br\\/><span class=\'\'>\\u5730\\u5740\\uff1a\\u4e0a\\u6d77\\u5e02\\u5f90\\u6c47\\u533a\\u659c\\u571f\\u8def2601\\u53f7<\\/span>\",\"type\":\"text\",\"tip\":\"\\u767e\\u5ea6\\u5730\\u56fe\\u6807\\u6ce8\\u6587\\u5b57,\\u652f\\u6301\\u7b80\\u5355html\\u4ee3\\u7801\",\"rule\":[]},\"company_location\":{\"title\":\"\\u516c\\u53f8\\u5750\\u6807\",\"value\":\"\",\"type\":\"location\",\"tip\":\"\",\"rule\":{\"require\":true}},\"address_cn\":{\"title\":\"\\u516c\\u53f8\\u5730\\u5740\",\"value\":\"\\u4e0a\\u6d77\\u5e02\\u5f90\\u6c47\\u533a\\u659c\\u571f\\u8def0001\\u53f7\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"address_en\":{\"title\":\"\\u516c\\u53f8\\u5730\\u5740\\uff08\\u82f1\\u6587\\uff09\",\"value\":\"NO.0001 Xie Tu Road, Shanghai China\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"email\":{\"title\":\"\\u516c\\u53f8\\u90ae\\u7bb1\",\"value\":\"catman@thinkcmf.com\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"phone_cn\":{\"title\":\"\\u516c\\u53f8\\u7535\\u8bdd\",\"value\":\"021 1000 0001\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"phone_en\":{\"title\":\"\\u516c\\u53f8\\u7535\\u8bdd\\uff08\\u82f1\\u6587\\uff09\",\"value\":\"+8621 1000 0001\",\"type\":\"text\",\"tip\":\"\",\"rule\":{\"require\":true}},\"qq\":{\"title\":\"\\u8054\\u7cfbQQ\",\"value\":\"478519726\",\"type\":\"text\",\"tip\":\"\\u591a\\u4e2a QQ\\u4ee5\\u82f1\\u6587\\u9017\\u53f7\\u9694\\u5f00\",\"rule\":{\"require\":true}}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (3, 0, 5, 'simpleboot3', '首页', 'portal/Index/index', 'portal/index', '首页模板文件', '{\"vars\":{\"top_slide\":{\"title\":\"\\u9876\\u90e8\\u5e7b\\u706f\\u7247\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"admin\\/Slide\\/index\",\"multi\":false},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u9876\\u90e8\\u5e7b\\u706f\\u7247\",\"tip\":\"\\u9876\\u90e8\\u5e7b\\u706f\\u7247\",\"rule\":{\"require\":true}}},\"widgets\":{\"features\":{\"title\":\"\\u5feb\\u901f\\u4e86\\u89e3ThinkCMF\",\"display\":\"1\",\"vars\":{\"sub_title\":{\"title\":\"\\u526f\\u6807\\u9898\",\"value\":\"Quickly understand the ThinkCMF\",\"type\":\"text\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u526f\\u6807\\u9898\",\"tip\":\"\",\"rule\":{\"require\":true}},\"features\":{\"title\":\"\\u7279\\u6027\\u4ecb\\u7ecd\",\"value\":[{\"title\":\"MVC\\u5206\\u5c42\\u6a21\\u5f0f\",\"icon\":\"bars\",\"content\":\"\\u4f7f\\u7528MVC\\u5e94\\u7528\\u7a0b\\u5e8f\\u88ab\\u5206\\u6210\\u4e09\\u4e2a\\u6838\\u5fc3\\u90e8\\u4ef6\\uff1a\\u6a21\\u578b\\uff08M\\uff09\\u3001\\u89c6\\u56fe\\uff08V\\uff09\\u3001\\u63a7\\u5236\\u5668\\uff08C\\uff09\\uff0c\\u4ed6\\u4e0d\\u662f\\u4e00\\u4e2a\\u65b0\\u7684\\u6982\\u5ff5\\uff0c\\u53ea\\u662fThinkCMF\\u5c06\\u5176\\u53d1\\u6325\\u5230\\u4e86\\u6781\\u81f4\\u3002\"},{\"title\":\"\\u7528\\u6237\\u7ba1\\u7406\",\"icon\":\"group\",\"content\":\"ThinkCMF\\u5185\\u7f6e\\u4e86\\u7075\\u6d3b\\u7684\\u7528\\u6237\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u5e76\\u53ef\\u76f4\\u63a5\\u4e0e\\u7b2c\\u4e09\\u65b9\\u7ad9\\u70b9\\u8fdb\\u884c\\u4e92\\u8054\\u4e92\\u901a\\uff0c\\u5982\\u679c\\u4f60\\u613f\\u610f\\u751a\\u81f3\\u53ef\\u4ee5\\u5bf9\\u5355\\u4e2a\\u7528\\u6237\\u6216\\u7fa4\\u4f53\\u7528\\u6237\\u7684\\u884c\\u4e3a\\u8fdb\\u884c\\u8bb0\\u5f55\\u53ca\\u5206\\u4eab\\uff0c\\u4e3a\\u60a8\\u7684\\u8fd0\\u8425\\u51b3\\u7b56\\u63d0\\u4f9b\\u6709\\u6548\\u53c2\\u8003\\u6570\\u636e\\u3002\"},{\"title\":\"\\u4e91\\u7aef\\u90e8\\u7f72\",\"icon\":\"cloud\",\"content\":\"\\u901a\\u8fc7\\u9a71\\u52a8\\u7684\\u65b9\\u5f0f\\u53ef\\u4ee5\\u8f7b\\u677e\\u652f\\u6301\\u4e91\\u5e73\\u53f0\\u7684\\u90e8\\u7f72\\uff0c\\u8ba9\\u4f60\\u7684\\u7f51\\u7ad9\\u65e0\\u7f1d\\u8fc1\\u79fb\\uff0c\\u5185\\u7f6e\\u5df2\\u7ecf\\u652f\\u6301SAE\\u3001BAE\\uff0c\\u6b63\\u5f0f\\u7248\\u5c06\\u5bf9\\u4e91\\u7aef\\u90e8\\u7f72\\u8fdb\\u884c\\u8fdb\\u4e00\\u6b65\\u4f18\\u5316\\u3002\"},{\"title\":\"\\u5b89\\u5168\\u7b56\\u7565\",\"icon\":\"heart\",\"content\":\"\\u63d0\\u4f9b\\u7684\\u7a33\\u5065\\u7684\\u5b89\\u5168\\u7b56\\u7565\\uff0c\\u5305\\u62ec\\u5907\\u4efd\\u6062\\u590d\\uff0c\\u5bb9\\u9519\\uff0c\\u9632\\u6cbb\\u6076\\u610f\\u653b\\u51fb\\u767b\\u9646\\uff0c\\u7f51\\u9875\\u9632\\u7be1\\u6539\\u7b49\\u591a\\u9879\\u5b89\\u5168\\u7ba1\\u7406\\u529f\\u80fd\\uff0c\\u4fdd\\u8bc1\\u7cfb\\u7edf\\u5b89\\u5168\\uff0c\\u53ef\\u9760\\uff0c\\u7a33\\u5b9a\\u7684\\u8fd0\\u884c\\u3002\"},{\"title\":\"\\u5e94\\u7528\\u6a21\\u5757\\u5316\",\"icon\":\"cubes\",\"content\":\"\\u63d0\\u51fa\\u5168\\u65b0\\u7684\\u5e94\\u7528\\u6a21\\u5f0f\\u8fdb\\u884c\\u6269\\u5c55\\uff0c\\u4e0d\\u7ba1\\u662f\\u4f60\\u5f00\\u53d1\\u4e00\\u4e2a\\u5c0f\\u529f\\u80fd\\u8fd8\\u662f\\u4e00\\u4e2a\\u5168\\u65b0\\u7684\\u7ad9\\u70b9\\uff0c\\u5728ThinkCMF\\u4e2d\\u4f60\\u53ea\\u662f\\u589e\\u52a0\\u4e86\\u4e00\\u4e2aAPP\\uff0c\\u6bcf\\u4e2a\\u72ec\\u7acb\\u8fd0\\u884c\\u4e92\\u4e0d\\u5f71\\u54cd\\uff0c\\u4fbf\\u4e8e\\u7075\\u6d3b\\u6269\\u5c55\\u548c\\u4e8c\\u6b21\\u5f00\\u53d1\\u3002\"},{\"title\":\"\\u514d\\u8d39\\u5f00\\u6e90\",\"icon\":\"certificate\",\"content\":\"\\u4ee3\\u7801\\u9075\\u5faaApache2\\u5f00\\u6e90\\u534f\\u8bae\\uff0c\\u514d\\u8d39\\u4f7f\\u7528\\uff0c\\u5bf9\\u5546\\u4e1a\\u7528\\u6237\\u4e5f\\u65e0\\u4efb\\u4f55\\u9650\\u5236\\u3002\"}],\"type\":\"array\",\"item\":{\"title\":{\"title\":\"\\u6807\\u9898\",\"value\":\"\",\"type\":\"text\",\"rule\":{\"require\":true}},\"icon\":{\"title\":\"\\u56fe\\u6807\",\"value\":\"\",\"type\":\"text\"},\"content\":{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\",\"type\":\"textarea\"}},\"tip\":\"\"}}},\"last_news\":{\"title\":\"\\u6700\\u65b0\\u8d44\\u8baf\",\"display\":\"1\",\"vars\":{\"last_news_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/Category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}}}}', '{\"vars\":{\"top_slide\":{\"title\":\"\\u9876\\u90e8\\u5e7b\\u706f\\u7247\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"admin\\/Slide\\/index\",\"multi\":false},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u9876\\u90e8\\u5e7b\\u706f\\u7247\",\"tip\":\"\\u9876\\u90e8\\u5e7b\\u706f\\u7247\",\"rule\":{\"require\":true}}},\"widgets\":{\"features\":{\"title\":\"\\u5feb\\u901f\\u4e86\\u89e3ThinkCMF\",\"display\":\"1\",\"vars\":{\"sub_title\":{\"title\":\"\\u526f\\u6807\\u9898\",\"value\":\"Quickly understand the ThinkCMF\",\"type\":\"text\",\"placeholder\":\"\\u8bf7\\u8f93\\u5165\\u526f\\u6807\\u9898\",\"tip\":\"\",\"rule\":{\"require\":true}},\"features\":{\"title\":\"\\u7279\\u6027\\u4ecb\\u7ecd\",\"value\":[{\"title\":\"MVC\\u5206\\u5c42\\u6a21\\u5f0f\",\"icon\":\"bars\",\"content\":\"\\u4f7f\\u7528MVC\\u5e94\\u7528\\u7a0b\\u5e8f\\u88ab\\u5206\\u6210\\u4e09\\u4e2a\\u6838\\u5fc3\\u90e8\\u4ef6\\uff1a\\u6a21\\u578b\\uff08M\\uff09\\u3001\\u89c6\\u56fe\\uff08V\\uff09\\u3001\\u63a7\\u5236\\u5668\\uff08C\\uff09\\uff0c\\u4ed6\\u4e0d\\u662f\\u4e00\\u4e2a\\u65b0\\u7684\\u6982\\u5ff5\\uff0c\\u53ea\\u662fThinkCMF\\u5c06\\u5176\\u53d1\\u6325\\u5230\\u4e86\\u6781\\u81f4\\u3002\"},{\"title\":\"\\u7528\\u6237\\u7ba1\\u7406\",\"icon\":\"group\",\"content\":\"ThinkCMF\\u5185\\u7f6e\\u4e86\\u7075\\u6d3b\\u7684\\u7528\\u6237\\u7ba1\\u7406\\u65b9\\u5f0f\\uff0c\\u5e76\\u53ef\\u76f4\\u63a5\\u4e0e\\u7b2c\\u4e09\\u65b9\\u7ad9\\u70b9\\u8fdb\\u884c\\u4e92\\u8054\\u4e92\\u901a\\uff0c\\u5982\\u679c\\u4f60\\u613f\\u610f\\u751a\\u81f3\\u53ef\\u4ee5\\u5bf9\\u5355\\u4e2a\\u7528\\u6237\\u6216\\u7fa4\\u4f53\\u7528\\u6237\\u7684\\u884c\\u4e3a\\u8fdb\\u884c\\u8bb0\\u5f55\\u53ca\\u5206\\u4eab\\uff0c\\u4e3a\\u60a8\\u7684\\u8fd0\\u8425\\u51b3\\u7b56\\u63d0\\u4f9b\\u6709\\u6548\\u53c2\\u8003\\u6570\\u636e\\u3002\"},{\"title\":\"\\u4e91\\u7aef\\u90e8\\u7f72\",\"icon\":\"cloud\",\"content\":\"\\u901a\\u8fc7\\u9a71\\u52a8\\u7684\\u65b9\\u5f0f\\u53ef\\u4ee5\\u8f7b\\u677e\\u652f\\u6301\\u4e91\\u5e73\\u53f0\\u7684\\u90e8\\u7f72\\uff0c\\u8ba9\\u4f60\\u7684\\u7f51\\u7ad9\\u65e0\\u7f1d\\u8fc1\\u79fb\\uff0c\\u5185\\u7f6e\\u5df2\\u7ecf\\u652f\\u6301SAE\\u3001BAE\\uff0c\\u6b63\\u5f0f\\u7248\\u5c06\\u5bf9\\u4e91\\u7aef\\u90e8\\u7f72\\u8fdb\\u884c\\u8fdb\\u4e00\\u6b65\\u4f18\\u5316\\u3002\"},{\"title\":\"\\u5b89\\u5168\\u7b56\\u7565\",\"icon\":\"heart\",\"content\":\"\\u63d0\\u4f9b\\u7684\\u7a33\\u5065\\u7684\\u5b89\\u5168\\u7b56\\u7565\\uff0c\\u5305\\u62ec\\u5907\\u4efd\\u6062\\u590d\\uff0c\\u5bb9\\u9519\\uff0c\\u9632\\u6cbb\\u6076\\u610f\\u653b\\u51fb\\u767b\\u9646\\uff0c\\u7f51\\u9875\\u9632\\u7be1\\u6539\\u7b49\\u591a\\u9879\\u5b89\\u5168\\u7ba1\\u7406\\u529f\\u80fd\\uff0c\\u4fdd\\u8bc1\\u7cfb\\u7edf\\u5b89\\u5168\\uff0c\\u53ef\\u9760\\uff0c\\u7a33\\u5b9a\\u7684\\u8fd0\\u884c\\u3002\"},{\"title\":\"\\u5e94\\u7528\\u6a21\\u5757\\u5316\",\"icon\":\"cubes\",\"content\":\"\\u63d0\\u51fa\\u5168\\u65b0\\u7684\\u5e94\\u7528\\u6a21\\u5f0f\\u8fdb\\u884c\\u6269\\u5c55\\uff0c\\u4e0d\\u7ba1\\u662f\\u4f60\\u5f00\\u53d1\\u4e00\\u4e2a\\u5c0f\\u529f\\u80fd\\u8fd8\\u662f\\u4e00\\u4e2a\\u5168\\u65b0\\u7684\\u7ad9\\u70b9\\uff0c\\u5728ThinkCMF\\u4e2d\\u4f60\\u53ea\\u662f\\u589e\\u52a0\\u4e86\\u4e00\\u4e2aAPP\\uff0c\\u6bcf\\u4e2a\\u72ec\\u7acb\\u8fd0\\u884c\\u4e92\\u4e0d\\u5f71\\u54cd\\uff0c\\u4fbf\\u4e8e\\u7075\\u6d3b\\u6269\\u5c55\\u548c\\u4e8c\\u6b21\\u5f00\\u53d1\\u3002\"},{\"title\":\"\\u514d\\u8d39\\u5f00\\u6e90\",\"icon\":\"certificate\",\"content\":\"\\u4ee3\\u7801\\u9075\\u5faaApache2\\u5f00\\u6e90\\u534f\\u8bae\\uff0c\\u514d\\u8d39\\u4f7f\\u7528\\uff0c\\u5bf9\\u5546\\u4e1a\\u7528\\u6237\\u4e5f\\u65e0\\u4efb\\u4f55\\u9650\\u5236\\u3002\"}],\"type\":\"array\",\"item\":{\"title\":{\"title\":\"\\u6807\\u9898\",\"value\":\"\",\"type\":\"text\",\"rule\":{\"require\":true}},\"icon\":{\"title\":\"\\u56fe\\u6807\",\"value\":\"\",\"type\":\"text\"},\"content\":{\"title\":\"\\u63cf\\u8ff0\",\"value\":\"\",\"type\":\"textarea\"}},\"tip\":\"\"}}},\"last_news\":{\"title\":\"\\u6700\\u65b0\\u8d44\\u8baf\",\"display\":\"1\",\"vars\":{\"last_news_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/Category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (4, 0, 10, 'simpleboot3', '文章列表页', 'portal/List/index', 'portal/list', '文章列表模板文件', '{\"vars\":[],\"widgets\":{\"hottest_articles\":{\"title\":\"\\u70ed\\u95e8\\u6587\\u7ae0\",\"display\":\"1\",\"vars\":{\"hottest_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}},\"last_articles\":{\"title\":\"\\u6700\\u65b0\\u53d1\\u5e03\",\"display\":\"1\",\"vars\":{\"last_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}}}}', '{\"vars\":[],\"widgets\":{\"hottest_articles\":{\"title\":\"\\u70ed\\u95e8\\u6587\\u7ae0\",\"display\":\"1\",\"vars\":{\"hottest_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}},\"last_articles\":{\"title\":\"\\u6700\\u65b0\\u53d1\\u5e03\",\"display\":\"1\",\"vars\":{\"last_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (5, 0, 10, 'simpleboot3', '单页面', 'portal/Page/index', 'portal/page', '单页面模板文件', '{\"widgets\":{\"hottest_articles\":{\"title\":\"\\u70ed\\u95e8\\u6587\\u7ae0\",\"display\":\"1\",\"vars\":{\"hottest_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}},\"last_articles\":{\"title\":\"\\u6700\\u65b0\\u53d1\\u5e03\",\"display\":\"1\",\"vars\":{\"last_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}}}}', '{\"widgets\":{\"hottest_articles\":{\"title\":\"\\u70ed\\u95e8\\u6587\\u7ae0\",\"display\":\"1\",\"vars\":{\"hottest_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}},\"last_articles\":{\"title\":\"\\u6700\\u65b0\\u53d1\\u5e03\",\"display\":\"1\",\"vars\":{\"last_articles_category_id\":{\"title\":\"\\u6587\\u7ae0\\u5206\\u7c7bID\",\"value\":\"\",\"type\":\"text\",\"dataSource\":{\"api\":\"portal\\/category\\/index\",\"multi\":true},\"placeholder\":\"\\u8bf7\\u9009\\u62e9\\u5206\\u7c7b\",\"tip\":\"\",\"rule\":{\"require\":true}}}}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (6, 0, 10, 'simpleboot3', '搜索页面', 'portal/search/index', 'portal/search', '搜索模板文件', '{\"vars\":{\"varName1\":{\"title\":\"\\u70ed\\u95e8\\u641c\\u7d22\",\"value\":\"1\",\"type\":\"text\",\"tip\":\"\\u8fd9\\u662f\\u4e00\\u4e2atext\",\"rule\":{\"require\":true}}}}', '{\"vars\":{\"varName1\":{\"title\":\"\\u70ed\\u95e8\\u641c\\u7d22\",\"value\":\"1\",\"type\":\"text\",\"tip\":\"\\u8fd9\\u662f\\u4e00\\u4e2atext\",\"rule\":{\"require\":true}}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (7, 1, 0, 'simpleboot3', '模板全局配置', 'public/Config', 'public/config', '模板全局配置文件', '{\"vars\":{\"enable_mobile\":{\"title\":\"\\u624b\\u673a\\u6ce8\\u518c\",\"value\":1,\"type\":\"select\",\"options\":{\"1\":\"\\u5f00\\u542f\",\"0\":\"\\u5173\\u95ed\"},\"tip\":\"\"}}}', '{\"vars\":{\"enable_mobile\":{\"title\":\"\\u624b\\u673a\\u6ce8\\u518c\",\"value\":1,\"type\":\"select\",\"options\":{\"1\":\"\\u5f00\\u542f\",\"0\":\"\\u5173\\u95ed\"},\"tip\":\"\"}}}', NULL);
INSERT INTO `cmf_theme_file` VALUES (8, 1, 1, 'simpleboot3', '导航条', 'public/Nav', 'public/nav', '导航条模板文件', '{\"vars\":{\"company_name\":{\"title\":\"\\u516c\\u53f8\\u540d\\u79f0\",\"name\":\"company_name\",\"value\":\"ThinkCMF\",\"type\":\"text\",\"tip\":\"\",\"rule\":[]}}}', '{\"vars\":{\"company_name\":{\"title\":\"\\u516c\\u53f8\\u540d\\u79f0\",\"name\":\"company_name\",\"value\":\"ThinkCMF\",\"type\":\"text\",\"tip\":\"\",\"rule\":[]}}}', NULL);

-- ----------------------------
-- Table structure for cmf_user
-- ----------------------------
DROP TABLE IF EXISTS `cmf_user`;
CREATE TABLE `cmf_user`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_type` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '用户类型;1:admin;2:会员',
  `sex` tinyint(2) NOT NULL DEFAULT 0 COMMENT '性别;0:保密,1:男,2:女',
  `birthday` int(11) NOT NULL DEFAULT 0 COMMENT '生日',
  `last_login_time` int(11) NOT NULL DEFAULT 0 COMMENT '最后登录时间',
  `score` int(11) NOT NULL DEFAULT 0 COMMENT '用户积分',
  `coin` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '金币',
  `balance` decimal(10, 2) NOT NULL DEFAULT 0.00 COMMENT '余额',
  `create_time` int(11) NOT NULL DEFAULT 0 COMMENT '注册时间',
  `user_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '用户状态;0:禁用,1:正常,2:未验证',
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `user_pass` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '登录密码;cmf_password加密',
  `user_nickname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户昵称',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户登录邮箱',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户个人网址',
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户头像',
  `signature` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '个性签名',
  `last_login_ip` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '最后登录ip',
  `user_activation_key` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '激活码',
  `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '中国手机不带国家代码，国际手机号格式为：国家代码-手机号',
  `more` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '扩展属性',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_login`(`user_login`) USING BTREE,
  INDEX `user_nickname`(`user_nickname`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_user
-- ----------------------------
INSERT INTO `cmf_user` VALUES (1, 1, 0, 0, 1598078614, 0, 0, 0.00, 1582608854, 1, 'admin', '###873b66711c2919068139c6f593b46278', 'admin', 'admin@qq.com', '', '', '', '119.183.140.24', '', '', NULL);

-- ----------------------------
-- Table structure for cmf_user_token
-- ----------------------------
DROP TABLE IF EXISTS `cmf_user_token`;
CREATE TABLE `cmf_user_token`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '用户id',
  `expire_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT ' 过期时间',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'token',
  `device_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '设备类型;mobile,android,iphone,ipad,web,pc,mac,wxapp',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户客户端登录 token 表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_user_token
-- ----------------------------
INSERT INTO `cmf_user_token` VALUES (1, 1, 1610245288, 1594693288, '2d27efe1b8e479d4c7fe057bab50bf4cce1052ae7a81902763fe28ed8d934468', 'web');

-- ----------------------------
-- Table structure for cmf_users
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users`;
CREATE TABLE `cmf_users`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `sex` tinyint(2) NOT NULL DEFAULT 0 COMMENT '性别;0:保密,1:男,2:女',
  `birthday` bigint(20) NOT NULL DEFAULT 0 COMMENT '生日',
  `last_login_time` bigint(20) NOT NULL DEFAULT 0 COMMENT '最后登录时间',
  `coin` decimal(20, 2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '金币',
  `consumption` decimal(20, 2) NOT NULL DEFAULT 0.00 COMMENT '累计消费',
  `create_time` bigint(20) NOT NULL DEFAULT 0 COMMENT '注册时间',
  `user_status` tinyint(3) UNSIGNED NOT NULL DEFAULT 1 COMMENT '用户状态;0:禁用,1:正常,2:未验证',
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `user_pass` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '登录密码;cmf_password加密',
  `user_nickname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户昵称',
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户头像',
  `avatar_thumb` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户小头像，200X200以下',
  `signature` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '个性签名',
  `last_login_ip` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '最后登录ip',
  `mobile` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '中国手机不带国家代码，国际手机号格式为：国家代码-手机号',
  `login_type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '第三方标识,0PC，1QQ，2微信，3新浪，4facebook，5twitter',
  `openid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '三方openid',
  `school` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '院校',
  `experience` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '教育经历',
  `feature` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '教育特点',
  `source` tinyint(1) NOT NULL DEFAULT 0 COMMENT '注册设备，0web1android2IOS3小程序',
  `type` tinyint(1) NOT NULL DEFAULT 0 COMMENT '会员类型，0学员1教师',
  `signoryid` int(11) NOT NULL DEFAULT 0 COMMENT '专长ID',
  `identity` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '身份标识',
  `courses` int(11) NOT NULL DEFAULT 0 COMMENT '课程数',
  `list_order` int(11) NOT NULL DEFAULT 10000 COMMENT '序号',
  `gradeid` bigint(20) NOT NULL DEFAULT 0 COMMENT '学级分类ID',
  `issuper` tinyint(4) NULL DEFAULT 0 COMMENT '是不是超管 0否 1是',
  `looklivetime` int(11) NULL DEFAULT 0 COMMENT '观看直播总时长',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_login`(`user_login`) USING BTREE,
  INDEX `user_nickname`(`user_nickname`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 20 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users
-- ----------------------------
INSERT INTO `cmf_users` VALUES (1, 1, 0, 1598084123, 0.00, 0.00, 1594715844, 1, '18815385964', '###b0c3c67ad76d079ba89fb328c73b4de4', '皮皮侠', '/default.png', '/default_thumb.png', '', '127.0.0.1', '18815385964', 0, '', '', NULL, NULL, 0, 1, 1, '3', 0, 10000, 0, 0, 0);
INSERT INTO `cmf_users` VALUES (2, 1, 0, 1597969858, 0.00, 0.00, 1595555758, 1, '', '###a6f9db49ff72760b44dabc6f14fb8fb0', '测试鑫', 'default/20200806/014ce46a833237320fdeee6d16bf7427.jpg?imageView2/2/w/600/h/600', 'default/20200806/014ce46a833237320fdeee6d16bf7427.jpg?imageView2/2/w/150/h/150', '', '119.183.140.24', '', 0, '', '', '这是我的教育经历', '', 0, 1, 3, '1', 0, 10000, 2, 0, 0);
INSERT INTO `cmf_users` VALUES (4, 0, 0, 1597971091, 0.00, 0.00, 1596003156, 1, '', '###a6f9db49ff72760b44dabc6f14fb8fb0', 'ffff', '/default.png', '/default_thumb.png', '', '119.183.140.24', '', 0, '', '', NULL, NULL, 0, 1, 4, '', 0, 10000, 2, 0, 18);
INSERT INTO `cmf_users` VALUES (6, 0, 0, 1596435043, 0.00, 0.00, 1596423746, 1, '', '###b0c3c67ad76d079ba89fb328c73b4de4', '', '/default.png', '/default_thumb.png', '', '39.85.100.54', '', 0, '', '', NULL, NULL, 0, 0, 0, '', 0, 10000, 2, 0, 0);
INSERT INTO `cmf_users` VALUES (7, 0, 0, 1597971255, 0.00, 0.00, 1596674624, 1, '', '###a6f9db49ff72760b44dabc6f14fb8fb0', '新名字1', 'default/20200821/55ea610cfbf89a32e58468a4e0fa06ad.jpg?imageView2/2/w/600/h/600', 'default/20200821/55ea610cfbf89a32e58468a4e0fa06ad.jpg?imageView2/2/w/200/h/200', '', '119.183.140.24', '', 0, '', '', NULL, NULL, 0, 0, 0, '', 0, 10000, 2, 1, 6);
INSERT INTO `cmf_users` VALUES (8, 1, 0, 1597304788, 0.00, 0.00, 1597304640, 1, '', '###a6f9db49ff72760b44dabc6f14fb8fb0', '测试', '/default.png', '/default_thumb.png', '', '182.35.111.125', '', 0, '', '', NULL, NULL, 0, 1, 1, '', 0, 10000, 0, 0, 0);
INSERT INTO `cmf_users` VALUES (9, 0, 0, 1597458357, 0.00, 0.00, 1597458357, 1, '', '###a6f9db49ff72760b44dabc6f14fb8fb0', '', '/default.png', '/default_thumb.png', '', '222.132.140.188', '', 0, '', '', NULL, NULL, 0, 0, 0, '', 0, 10000, 2, 0, 0);

-- ----------------------------
-- Table structure for cmf_users_addrs
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_addrs`;
CREATE TABLE `cmf_users_addrs`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT 0 COMMENT '用户id',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '收货人',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '联系方式',
  `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '省',
  `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '市',
  `area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '区',
  `addr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '详细地址',
  `isdef` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否默认地址，0否1是',
  `addtime` bigint(20) NOT NULL DEFAULT 0 COMMENT '时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users_addrs
-- ----------------------------
INSERT INTO `cmf_users_addrs` VALUES (1, 4, '方法发发发付', '方法', '山西省', '大同市', '矿区', '方法', 0, 1597394329);
INSERT INTO `cmf_users_addrs` VALUES (2, 4, '刚刚', '刚刚', '山西省', '阳泉市', '郊区', 'VG个', 0, 1597395406);
INSERT INTO `cmf_users_addrs` VALUES (3, 4, '方法发发发付方法', '方法', '河北省', '唐山市', '古冶区', '方法', 1, 1597396947);

-- ----------------------------
-- Table structure for cmf_users_attention
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_attention`;
CREATE TABLE `cmf_users_attention`  (
  `uid` bigint(20) NOT NULL DEFAULT 0 COMMENT '用户ID',
  `touid` bigint(20) NOT NULL DEFAULT 0 COMMENT '对方ID',
  `addtime` int(11) NOT NULL DEFAULT 0 COMMENT '时间'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users_attention
-- ----------------------------
INSERT INTO `cmf_users_attention` VALUES (2, 4, 1596701540);
INSERT INTO `cmf_users_attention` VALUES (4, 8, 1597396923);
INSERT INTO `cmf_users_attention` VALUES (2, 1, 1597970725);

-- ----------------------------
-- Table structure for cmf_users_auth
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_auth`;
CREATE TABLE `cmf_users_auth`  (
  `uid` int(11) UNSIGNED NOT NULL,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '联系电话',
  `cer_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '身份证号',
  `front_view` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '证件正面',
  `back_view` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '证件反面',
  `handset_view` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '手持证件正面照',
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '原因',
  `addtime` int(12) NOT NULL DEFAULT 0 COMMENT '提交时间',
  `uptime` int(12) NOT NULL DEFAULT 0 COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT 0 COMMENT '状态，0审核中1通过2拒绝',
  PRIMARY KEY (`uid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_users_city
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_city`;
CREATE TABLE `cmf_users_city`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `city` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users_city
-- ----------------------------
INSERT INTO `cmf_users_city` VALUES (1, 2, '泰安市');
INSERT INTO `cmf_users_city` VALUES (2, 4, '泰安市');
INSERT INTO `cmf_users_city` VALUES (3, 7, '泰安市');
INSERT INTO `cmf_users_city` VALUES (4, 2, '济南市');
INSERT INTO `cmf_users_city` VALUES (5, 18, '泰安市');
INSERT INTO `cmf_users_city` VALUES (8, 19, '泰安市');

-- ----------------------------
-- Table structure for cmf_users_coinrecord
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_coinrecord`;
CREATE TABLE `cmf_users_coinrecord`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '收支类型,0支出，1收入',
  `action` tinyint(4) NOT NULL DEFAULT 0 COMMENT '收支行为，1余额下单2订单退回3赠送礼物',
  `uid` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户ID',
  `touid` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '对方ID',
  `actionid` int(11) NOT NULL DEFAULT 0 COMMENT '行为对应ID',
  `nums` int(11) NOT NULL DEFAULT 0 COMMENT '数量',
  `total` int(11) NOT NULL DEFAULT 0 COMMENT '总价',
  `addtime` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '添加时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `action_uid_addtime`(`action`, `uid`, `addtime`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cmf_users_pushid
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_pushid`;
CREATE TABLE `cmf_users_pushid`  (
  `uid` bigint(20) UNSIGNED NOT NULL COMMENT '用户ID',
  `pushid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '用户对应极光registration_id',
  PRIMARY KEY (`uid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users_pushid
-- ----------------------------
INSERT INTO `cmf_users_pushid` VALUES (4, '140fe1da9e2380947bb');
INSERT INTO `cmf_users_pushid` VALUES (18, '140fe1da9e2380947bb');
INSERT INTO `cmf_users_pushid` VALUES (19, '140fe1da9e2380947bb');

-- ----------------------------
-- Table structure for cmf_users_see_live
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_see_live`;
CREATE TABLE `cmf_users_see_live`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL COMMENT '用户id',
  `addtime` int(11) NOT NULL COMMENT '开始看直播的时间',
  `endtime` int(11) NOT NULL DEFAULT 0 COMMENT '退出直播间的时间',
  `source` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'PC' COMMENT '设备',
  `time` int(11) NOT NULL DEFAULT 0 COMMENT '总时长 分钟',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users_see_live
-- ----------------------------
INSERT INTO `cmf_users_see_live` VALUES (3, 4, 1597651589, 1597651657, 'PC', 8);
INSERT INTO `cmf_users_see_live` VALUES (5, 18, 1597970787, 0, 'Android', 0);
INSERT INTO `cmf_users_see_live` VALUES (6, 4, 1597972369, 1597972394, 'Android', 12);
INSERT INTO `cmf_users_see_live` VALUES (7, 7, 1597976146, 1597976153, 'PC', 6);
INSERT INTO `cmf_users_see_live` VALUES (8, 19, 1597976122, 1597976127, 'Android', 36);

-- ----------------------------
-- Table structure for cmf_users_token
-- ----------------------------
DROP TABLE IF EXISTS `cmf_users_token`;
CREATE TABLE `cmf_users_token`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '用户id',
  `expire_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT ' 过期时间',
  `create_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '创建时间',
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT 'token',
  `device_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '设备类型;mobile,android,iphone,ipad,web,pc,mac,wxapp',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 12 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户客户端登录 token 表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of cmf_users_token
-- ----------------------------
INSERT INTO `cmf_users_token` VALUES (1, 1, 1624004123, 1598084123, '45bad62a78e9818b43e7dfcec6dc81a7', '');
INSERT INTO `cmf_users_token` VALUES (2, 2, 1623889858, 1597969858, '3a1a894ea296b8bea49e5f9b53d72a71', '');
INSERT INTO `cmf_users_token` VALUES (3, 4, 1610931091, 1597971091, '438d7f2db15638ee566a4358707e0e8f', '');
INSERT INTO `cmf_users_token` VALUES (5, 6, 1622355043, 1596435043, 'ae6c565cdc028eec74163b8c0a7e577a', '');
INSERT INTO `cmf_users_token` VALUES (6, 7, 1623891255, 1597971255, '02343230f7178c6cd956fe5df245779d', '');
INSERT INTO `cmf_users_token` VALUES (7, 8, 1623224788, 1597304788, '043f51439066fc2c21f47ee087d5e0ac', '');
INSERT INTO `cmf_users_token` VALUES (8, 9, 1623378357, 1597458357, '59ebdf4aee06cc9e41970bfc3a20bd5e', '');
INSERT INTO `cmf_users_token` VALUES (11, 1, 1624004123, 1598084123, '45bad62a78e9818b43e7dfcec6dc81a7', '');

-- ----------------------------
-- Table structure for cmf_verification_code
-- ----------------------------
DROP TABLE IF EXISTS `cmf_verification_code`;
CREATE TABLE `cmf_verification_code`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '表id',
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '当天已经发送成功的次数',
  `send_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '最后发送成功时间',
  `expire_time` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT '验证码过期时间',
  `code` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '最后发送成功的验证码',
  `account` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '手机号或者邮箱',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '手机邮箱数字验证码表' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
