<?php

namespace App\Api;

use PhalApi\Api;
use App\Domain\Course as Domain_Course;

/**
 * 课程
 */
 
class Course extends Api {

	public function getRules() {
		return array(
            'getClassCourse' => array(
				'gradeid' => array('name' => 'gradeid', 'type' => 'int', 'desc' => '学级分类ID'),
				'classid' => array('name' => 'classid', 'type' => 'int', 'desc' => '科目分类ID'),
				'p' => array('name' => 'p', 'type' => 'int', 'desc' => '页码'),
			),

            'getList' => array(
                'gradeid' => array('name' => 'gradeid', 'type' => 'int', 'desc' => '学级分类ID'),
				'type' => array('name' => 'type', 'type' => 'int', 'desc' => '类型，0精选内容1好课推荐2直播课堂'),
				'p' => array('name' => 'p', 'type' => 'int', 'desc' => '页码'),
			),

            'search' => array(
                'gradeid' => array('name' => 'gradeid', 'type' => 'int', 'desc' => '学级分类ID'),
				'keyword' => array('name' => 'keyword', 'type' => 'string', 'desc' => '关键词'),
				'p' => array('name' => 'p', 'type' => 'int', 'desc' => '页码'),
			),

            'getDetail' => array(
				'courseid' => array('name' => 'courseid', 'type' => 'int', 'desc' => '课程ID'),
			),

            'checkPass' => array(
				'courseid' => array('name' => 'courseid', 'type' => 'int', 'desc' => '课程ID'),
				'pass' => array('name' => 'pass', 'type' => 'string', 'desc' => '密码'),
			),

            'buy' => array(
				'courseid' => array('name' => 'courseid', 'type' => 'int', 'desc' => '课程ID'),
				'payid' => array('name' => 'payid', 'type' => 'int', 'desc' => '支付方式ID'),
			),

            'getLessonList' => array(
				'courseid' => array('name' => 'courseid', 'type' => 'int', 'desc' => '课程ID'),
			),

            'getMyCourse' => array(
				'type' => array('name' => 'type', 'type' => 'int', 'desc' => '类型0全部1未开始2学习中3已学完'),
				'keyword' => array('name' => 'keyword', 'type' => 'string', 'desc' => '关键词'),
				'p' => array('name' => 'p', 'type' => 'int', 'desc' => '页码'),
			),
            
            'getTeacherCourse' => array(
                'gradeid' => array('name' => 'gradeid', 'type' => 'int', 'desc' => '学级分类ID'),
				'touid' => array('name' => 'touid', 'type' => 'int', 'desc' => '讲师ID'),
				'p' => array('name' => 'p', 'type' => 'int', 'desc' => '页码'),
			),

            'getMyBuy' => array(
				'sort' => array('name' => 'sort', 'type' => 'int', 'desc' => '数据类型 0内容 2直播'),
				'p' => array('name' => 'p', 'type' => 'int', 'desc' => '页码'),
			),

            'setGrade' => array(
                'gradeid' => array('name' => 'gradeid', 'type' => 'int', 'desc' => '学级分类ID'),
			),
		);
	}



	/**
	 * 某讲师课程
	 * @desc 用于获取某讲师课程列表
	 * @return int code 操作码，0表示成功
	 * @return array info 同其他课程列表
	 * @return string msg 提示信息
	 */
	public function getTeacherCourse() {
		$rs = array('code' => 0, 'msg' => '', 'info' => array());
		
		$uid=\App\checkNull($this->uid);
		$token=\App\checkNull($this->token);
		$gradeid=\App\checkNull($this->gradeid);
		$touid=\App\checkNull($this->touid);
		$p=\App\checkNull($this->p);
        
        $checkToken=\App\checkToken($uid,$token);
		if($checkToken==700){
			$rs['code'] = $checkToken;
			$rs['msg'] = \PhalApi\T('您的登陆状态失效，请重新登陆！');
			return $rs;
		}
        
		$nowtime=time();
        $where=[
            // 'gradeid'=>$gradeid,
            'status>=?'=>1,
            'shelvestime<?'=>$nowtime,
            'uid'=>$touid,
        ];
        
        
        $domain = new Domain_Course();
		$list = $domain->getList($p,$where);
        
        $rs['info']=$list;
        
		return $rs;
	}


}
