<?php
namespace App\Domain;

use App\Model\Course as Model_Course;
use App\Domain\Teacher as Domain_Teacher;
use App\Domain\User as Domain_User;
use App\Model\User as Model_User;
use App\Domain\Package as Domain_Package;
use App\Domain\Cart as Domain_Cart;

class Course {
    
    
    /* 课程科目分类 */
    public function getClass(){
		
		$key='getcourseclass';
        $list=\App\getcaches($key);
		if(!$list){
			$model = new Model_Course();
			$list=$model->getClass();
			\App\setcaches($key,$list);
		}
        
        
        foreach($list as $k=>$v){
            $v['thumb']=\App\get_upload_path($v['thumb']);
            unset($v['list_order']);
            $list[$k]=$v;
        }
        
        return $list;
    }
    
    /* 内容形式 */
    protected function getTypes($k=''){
        $type=[
            '1'=>'图文',
            '2'=>'视频',
            '3'=>'音频',
        ];
        if($k==''){
            return $type;
        }
        return isset($type[$k])? $type[$k] : '' ;
    }
    
     /* 处理课程信息 */
    protected function handelInfo($v){
        $v['thumb']=\App\get_upload_path($v['thumb']);
        $nowtime=time();
        $payval='免费';
        $lesson='';
        $sort=$v['sort'];
        /* 内容 */
        if($sort==0){
            $lesson=$this->getTypes($v['type']);
        }
        
        /* 课程 */
        if($sort==1){
            if($v['lessons']>0){
                $lesson=$v['lessons'].'课时';
            }
        }
        
        /* 直播 */
        if($sort>=2){
            if($v['islive']==0){
                $lesson=\App\handelsvctm($v['starttime']);
            }
            if($v['islive']==1){
                $lesson='正在直播';
            }
            if($v['islive']==2){
                $lesson='直播结束';
            }
        }
        
        $paytype=$v['paytype'];
        if($paytype==1){
            //$payval=number_format($v['payval'],2);
            $payval=$v['payval'];
        }
        
        if($paytype==2){
            $payval='密码';
        }
        
        
        $v['payval']=$payval;
        $v['lesson']=$lesson;
        unset($v['status']);
        unset($v['shelvestime']);
        unset($v['lessons']);
        unset($v['starttime']);
        
        if(isset($v['addtime'])){
            $v['add_time']=date('Y-m-d',$v['addtime']);
        }
        
        return $v;
    }   

    /* 课程列表 */
    public function getList($p=1,$where='',$order='list_order asc,id desc',$nums=0){
        
        $nowtime=time();
        
        $model = new Model_Course();
        $list=$model->getList($where,$order,$p,$nums);
        
        foreach($list as $k=>$v){
            $v=$this->handelInfo($v);
            
            $userinfo=\App\getUserInfo($v['uid']);
            $v['user_nickname']=$userinfo['user_nickname'];
            $v['avatar']=$userinfo['avatar'];
            
            $list[$k]=$v;
        }
        
        return $list;
    }

    /* 密码 */
    public function checkPass($uid,$pass,$courseid){
		
        $rs = array('code' => 0, 'msg' => \PhalApi\T('操作成功'), 'info' => array());
        
        $where=[
            'id'=>$courseid
        ];
        $model = new Model_Course();
        $info=$model->getDetail($where);
        if(!$info){
            $rs['code'] = 1002;
			$rs['msg'] = \PhalApi\T('课程不存在');
			return $rs;
        }
        
        if($info['paytype']==0){
            $rs['code'] = 1003;
			$rs['msg'] = \PhalApi\T('当前课程免费');
			return $rs;
        }
        
        if($info['paytype']==1){
            $rs['code'] = 1003;
			$rs['msg'] = \PhalApi\T('当前课程为付费内容');
			return $rs;
        }
        
        if($pass!=$info['payval']){
            $rs['code'] = 1003;
			$rs['msg'] = \PhalApi\T('密码错误');
			return $rs;
        }
        
        $where2=[
            'uid'=>$uid,
            'courseid'=>$courseid,
        ];
        $payinfo=$model->getBuy($where2);
        if(!$payinfo){
            $data=[
                'uid'=>$uid,
                'sort'=>$info['sort'],
                'paytype'=>$info['paytype'],
                'courseid'=>$courseid,
                'liveuid'=>$info['uid'],
                'status'=>1,
                'addtime'=>time(),
                'paytime'=>time(),
            ];
            $model->addBuy($data);
        }else{
            $data=[
                'sort'=>$info['sort'],
                'paytype'=>$info['paytype'],
                'status'=>1,
                'paytime'=>time(),
            ];
            $model->upBuy($where2,$data);
        }
        
        return $rs;
    }
    
    /* 课时列表 */
    public function getLessonList($uid,$courseid){
        
        $nowtime=time();
        $model = new Model_Course();
        
        $where2=['id'=>$courseid];
        $info=$model->getDetail($where2);
        if(!$info){
            return [];
        }
        
        $mode=$info['mode'];
        
        $where=['uid'=>$uid,'courseid'=>$courseid];
        $viewlist=$model->getView($where);
        
        $nums=count($viewlist);
        $lastid=0;
        if($viewlist){
            $lastid=$viewlist[0]['lessonid'];
        }
        
        $ispay=1;
        

        if($info['paytype']!=0){
            $where2=['uid'=>$uid,'courseid'=>$courseid,'status'=>1];
            $isbuy=$model->getBuy($where2);
            if(!$isbuy){
                $ispay=0;
            }
        }
        
        $where=['courseid'=>$courseid];
        $list=$model->getLessonList($where);
        
        $list=$this->handelLesson($list,0);
        $num=0;
        foreach($list as $k=>$v){
            foreach($v['list'] as $k1=>$v1){
                
                $isenter='1';
                if($ispay!=1){
                    /* 未购买不能进 */
                    $isenter='0';
                }

                if($mode==1 && $num>$nums){
                    /* 待解锁 不能进 */
                    $isenter='0';
                }

                if($v1['istrial']==1){
                    /* 试学 可进 */
                    $isenter='1';
                }
                
                if($v1['type']>=4 && $v1['islive']==0){
                    /* 未直播  不能进 */
                    $isenter='0';
                }
                $v1['isenter']=$isenter;
                
                
                $status='0';
                if($v1['istrial']==1){
                    /* 试学 */
                    $status='1';
                }
                
                foreach($viewlist as $k2=>$v2){
                    if($v2['lessonid']==$v1['id']){
                        /* 已学完 */
                        $status='2';
                    }
                }
                if($v1['islive']==1){
                    /* 在直播 */
                    $status='3';
                }
                
                if($mode==1 && $num>$nums){
                    /* 待解锁 */
                    $status='4';
                }
                $v1['status']=$status;
                
                
                $islast='0';
                if($lastid==$v1['id']){
                    $islast='1';
                }
                
                $v1['islast']=$islast;
                
                
                
                $time='';
                if($v1['type']>=4){
                    //if($v1['islive']==0){
                        $time=date('m月d日 H:i',$v1['starttime']);
                    //}
                }
                $v1['time_date']=$time;
                $v1['url']=\App\encryption(\App\get_upload_path($v1['url']));
                
                $v['list'][$k1]=$v1;
                $num++;
            }
            $list[$k]=$v;
        }
        
        
        return $list;
    }
    
    /* 处理课时数组 */
    protected function handelLesson($list=[],$pid=0){
        $rs=[];
        foreach($list as $k=>$v){
            if($v['pid']==$pid){
                unset($list[$k]);
                $v['list']=$this->handelLesson($list,$v['id']);
                $rs[]=$v;
            }
        }
        
        return $rs;
    }
}
