<?php
namespace App\Model;

use PhalApi\Model\NotORMModel as NotORM;

class Course extends NotORM {

    
    /* 课程列表 */
    public function getList($where,$order,$p,$nums) {
        
        if($p<1){
            $p=1;
        }
        
        if($nums==0){
            $nums=20;
        }
        $start=($p-1) * $nums;

        $list=\PhalApi\DI()->notorm->course
				->select('id,uid,sort,type,name,thumb,paytype,payval,status,starttime,lessons,islive,ismaterial,views,des')
                ->where($where)
                ->order($order)
                ->limit($start,$nums)
				->fetchAll();
        
        return $list;
    }
    
    
    /* 课程详情 */
    public function getDetail($where) {

        $info=\PhalApi\DI()->notorm->course
				->select('*')
                ->where($where)
				->fetchOne();
        return $info;
    }
    
    
    /* 更新星级、评论 */
    public function upStar($where,$stars=1,$comments=1) {

        $rs=\PhalApi\DI()->notorm->course
                ->where($where)
				->update(['stars' => new \NotORM_Literal("stars + {$stars}"),'comments' => new \NotORM_Literal("comments + {$comments}")]);
        if($rs){
            $info=\PhalApi\DI()->notorm->course
                ->select('stars,comments')
                ->where($where)
                ->fetchOne();
                
            $star=\App\getStarLevel($info['stars'],$info['comments']);
            
            \PhalApi\DI()->notorm->course
                ->where($where)
				->update(['star' => $star]);
        }
        
        
        return $rs;
    }


    /* 课时列表 */
    public function getLessonList($where) {
        
        $list=\PhalApi\DI()->notorm->course_lesson
				->select('id,uid,courseid,pid,type,name,des,url,istrial,islive,starttime')
                ->where($where)
                ->order('list_order asc')
				->fetchAll();
        
        return $list;
    }
    

}
