
$(function(){
    /* 基础 */
    // 基于准备好的dom，初始化echarts实例
    var echarts_basic = echarts.init(document.getElementById('echarts_basic'));
    // 指定图表的配置项和数据
    var echarts_basic_option = {
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: data_basic.name
        },
        yAxis: {
            type: 'value'
        },
        series: [
            {
                type:'line',
                symbolSize: 8,
                itemStyle:{
                    color:'#00b7ee',
                },
                data:data_basic.data
            }
        ]
    };
    // 使用刚指定的配置项和数据显示图表。
    echarts_basic.setOption(echarts_basic_option);   


    /* 新增课程 */
    // 基于准备好的dom，初始化echarts实例
    var echarts_basic_c = echarts.init(document.getElementById('echarts_basic_c'));
    // 指定图表的配置项和数据
    var echarts_basic_option_c = {
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: data_basic_c.name
        },
        yAxis: {
            type: 'value'
        },
        series: [
            {
                type:'line',
                symbolSize: 8,
                itemStyle:{
                    color:'#00b7ee',
                },
                data:data_basic_c.data
            }
        ]
    };
    // 使用刚指定的配置项和数据显示图表。
    echarts_basic_c.setOption(echarts_basic_option_c);   


    /* 今日IP数 */
    // 基于准备好的dom，初始化echarts实例
    var echarts_basic_i = echarts.init(document.getElementById('echarts_basic_i'));
    // 指定图表的配置项和数据
    var echarts_basic_option_i = {
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: data_basic_i.name
        },
        yAxis: {
            type: 'value'
        },
        series: [
            {
                type:'line',
                symbolSize: 8,
                itemStyle:{
                    color:'#00b7ee',
                },
                data:data_basic_i.data
            }
        ]
    };
    // 使用刚指定的配置项和数据显示图表。
    echarts_basic_i.setOption(echarts_basic_option_i);  



    /* 今日IP数 */
    // 基于准备好的dom，初始化echarts实例
    var echarts_basic_d = echarts.init(document.getElementById('echarts_basic_d'));
    // 指定图表的配置项和数据
    var echarts_basic_option_d = {
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            containLabel: true
        },
        xAxis: {
            type: 'value'
        },
        yAxis: {
            type: 'category',
            boundaryGap: false,
            minInterval : 1,
            boundaryGap : [ 0, 0.1 ],
            data: data_basic_d.name
        },
        series: [
            {
                type:'bar',
                symbolSize: 8,
                itemStyle:{
                    color:'#00b7ee',
                },
                data:data_basic_d.data
            }
        ]
    };
    // 使用刚指定的配置项和数据显示图表。
    echarts_basic_d.setOption(echarts_basic_option_d);  


    /* g观看渠道 */
    // 基于准备好的dom，初始化echarts实例
    var echarts_look = echarts.init(document.getElementById('echarts_look'));
    // 指定图表的配置项和数据
    var echarts_look_option = {
        tooltip : {  
            trigger: 'item',  
            formatter: "{c}"  
        },
        legend: {  
            orient : 'vertical',  
            left : '70%', 
            top:40,
            itemWidth:10,
            itemHeight:10,
            formatter: '{name}',
            textStyle:{
                color: '#000000',
                fontSize:16
            },
            data:data_type.name
        }
        ,   
        calculable : true,  
        series : [
            {  
                type:'pie',  
                radius : '70%',//饼图的半径大小  
                center: ['35%', '40%'],//饼图的位置 
                label:{            //饼图图形上的文本标签
                    show:true,
                    position:'inner', //标签的位置
                    textStyle : {
                        fontWeight : 300 ,
                        fontSize : 16    //文字的字体大小
                    },
                    formatter:'{d}%'
                },
                data:data_type.v_n
            }
        ]
    };
    // 使用刚指定的配置项和数据显示图表。
    echarts_look.setOption(echarts_look_option);
})





// 金额转换万字单位 start
function unitConvert(num) {
    if (num) {
        var moneyUnits = ["", "万"],
            dividend = 10000,
            curentNum = num, //转换数字
            curentUnit = moneyUnits[0]; //转换单位 
        for (var i = 0; i < 2; i++) {
            curentUnit = moneyUnits[i];
            if (strNumSize(curentNum) < 5) {
                return num;
            }
        }
        curentNum = curentNum / dividend;
        var m = {
            num: 0,
            unit: ""
        }
        m.num = curentNum.toFixed(2);
        m.unit = curentUnit;
        return m.num + m.unit;
    }
}

function strNumSize(tempNum) {
    var stringNum = tempNum.toString()
    var index = stringNum.indexOf(".")
    var newNum = stringNum
    if (index != -1) {
        newNum = stringNum.substring(0, index)
    }
    return newNum.length;
}

// 金额转换万字单位 end
var myChart = echarts.init(document.getElementById('china-map'));

var provinces = ['shanghai', 'hebei', 'shanxi', 'neimenggu', 'liaoning', 'jilin', 'heilongjiang', 'jiangsu', 'zhejiang', 'anhui', 'fujian', 'jiangxi', 'shandong', 'henan', 'hubei', 'hunan', 'guangdong', 'guangxi', 'hainan', 'sichuan', 'guizhou', 'yunnan', 'xizang', 'shanxi1', 'gansu', 'qinghai', 'ningxia', 'xinjiang', 'beijing', 'tianjin', 'chongqing', 'xianggang', 'aomen'];
var provincesText = ['上海', '河北', '山西', '内蒙古', '辽宁', '吉林', '黑龙江', '江苏', '浙江', '安徽', '福建', '江西', '山东', '河南', '湖北', '湖南', '广东', '广西', '海南', '四川', '贵州', '云南', '西藏', '陕西', '甘肃', '青海', '宁夏', '新疆', '北京', '天津', '重庆', '香港', '澳门'];
// 全国省份数据
var seriesData = [];
for (var i = 0; i < toolTipData.length; i++) {
    seriesData[i] = {};
    seriesData[i].name = toolTipData[i].provinceName;
    seriesData[i].value = toolTipData[i].shopCount;
}
var max = Math.max.apply(Math, seriesData.map(function(o) {
        return o.value
    })),
    min = 0; // 侧边最大值最小值
var maxSize4Pin = 40,
    minSize4Pin = 30;

var mapName = '';

function getGeoCoordMap(name) {
    name = name ? name : 'china';
    /*获取地图数据*/
    var geoCoordMap = {};
    myChart.showLoading(); // loading start
    var mapFeatures = echarts.getMap(name).geoJson.features;
    myChart.hideLoading(); // loading end
    mapFeatures.forEach(function(v) {
        var name = v.properties.name; // 地区名称
        geoCoordMap[name] = v.properties.cp; // 地区经纬度
    });
    return geoCoordMap;
}

function convertData(data) { // 转换数据
    var geoCoordMap = getGeoCoordMap(mapName);
    var res = [];
    for (var i = 0; i < data.length; i++) {
        var geoCoord = geoCoordMap[data[i].name]; // 数据的名字对应的经纬度
        if (geoCoord) { // 如果数据data对应上，
            res.push({
                name: data[i].name,
                value: geoCoord.concat(data[i].value),
            });
        }
    }
    return res;
};
// 初始化echarts-map
initEcharts("china", "");
function initEcharts(pName, Chinese_) {
    var tmpSeriesData = pName === "china" ? seriesData : seriesDataPro;
    var tmp = pName === "china" ? toolTipData : provinceData;
    var option = {
        visualMap: { //视觉映射组件
            show: true,
            min: min,
            max: max, // 侧边滑动的最大值，从数据中获取
            left: '5%',
            top: '96%',
            inverse: true, //是否反转 visualMap 组件
            itemHeight:200,  //图形的高度，即长条的高度
            text: ['高', '低'], // 文本，默认为数值文本
            calculable: false, //是否显示拖拽用的手柄（手柄能拖拽调整选中范围）
            seriesIndex: 1, //指定取哪个系列的数据，即哪个系列的 series.data,默认取所有系列
            orient: "horizontal",
            inRange: {
                color: ['#dbfefe', '#1066d5'] // 蓝绿
            }
        },
        geo: {
            show: true,
            map: pName,
            roam: false,
            label: {
                normal: {
                    show: false
                },
                emphasis: {
                    show: false,
                }
            },
            itemStyle: {
                normal: {
                    areaColor: '#3c8dbc', // 没有值得时候颜色
                    borderColor: '#097bba',
                },
                emphasis: {
                    areaColor: '#fbd456', // 鼠标滑过选中的颜色
                }
            }
        },
        series: [{
                name: '散点',
                type: 'scatter',
                coordinateSystem: 'geo',
                data: tmpSeriesData,
                symbolSize: '1',
                label: {
                    normal: {
                        show: true,
                        formatter: '{b}',
                        position: 'right'
                    },
                    emphasis: {
                        show: true
                    }
                },
                itemStyle: {
                    normal: {
                        color: '#895139' // 字体颜色
                    }
                }
            },
            {
                name: Chinese_ || pName,
                type: 'map',
                mapType: pName,
                roam: false, //是否开启鼠标缩放和平移漫游
                data: tmpSeriesData,
                // top: "3%",//组件距离容器的距离
                // geoIndex: 0,
                // aspectScale: 0.75,       //长宽比
                // showLegendSymbol: false, // 存在legend时显示
                selectedMode: 'single',
                label: {
                    normal: {
                        show: true, //显示省份标签
                        textStyle: {
                            color: "#895139"
                        } //省份标签字体颜色
                    },
                    emphasis: { //对应的鼠标悬浮效果
                        show: true,
                        textStyle: {
                            color: "#323232"
                        }
                    }
                },
                itemStyle: {
                    normal: {
                        borderWidth: .5, //区域边框宽度
                        borderColor: '#0550c3', //区域边框颜色
                        areaColor: "#0b7e9e", //区域颜色
                    },
                    emphasis: {
                        borderWidth: .5,
                        borderColor: '#4b0082',
                        areaColor: "#ece39e",
                    }
                }
            },
            {
                name: '点',
                type: 'scatter',
                coordinateSystem: 'geo',
                symbol: 'pin', //气泡
                symbolSize: function(val) {
                    var a = (maxSize4Pin - minSize4Pin) / (max - min);
                    var b = minSize4Pin - a * min;
                    b = maxSize4Pin - a * max;
                    return a * val[2] + b;
                },
                label: {
                    normal: {
                        show: true,
                        formatter: function(params) {
                            return params.data.value[2];
                        },
                        textStyle: {
                            color: '#fff',
                            fontSize: 9
                        }
                    }
                },
                itemStyle: {
                    normal: {
                        color: 'red' //标志颜色'#F62157'
                    }
                },
                zlevel: 6,
                data: convertData(tmpSeriesData),
            },
        ]
    };
    // 针对海南放大
    if (pName == '海南') {
        option.series[1].center = [109.844902, 19.0392];
        option.series[1].layoutCenter = ['50%', '50%'];
        option.series[1].layoutSize = "300%";
    } else { //非显示海南时，将设置的参数恢复默认值
        option.series[1].center = undefined;
        option.series[1].layoutCenter = undefined;
        option.series[1].layoutSize = undefined;
    }
    myChart.setOption(option);
    /* 响应式 */
    $(window).resize(function() {
        myChart.resize();
    });
}

// 展示对应的省
function showProvince(pName, Chinese_) {
    //这写省份的js都是通过在线构建工具生成的，保存在本地，需要时加载使用即可，最好不要一开始全部直接引入。
    loadBdScript('$' + pName + 'JS', './js/map/province/' + pName + '.js', function() {
        initEcharts(Chinese_);
    });
}

// 加载对应的JS
function loadBdScript(scriptId, url, callback) {
    var script = document.createElement("script");
    script.type = "text/javascript";
    if (script.readyState) { //IE
        script.onreadystatechange = function() {
            if (script.readyState === "loaded" || script.readyState === "complete") {
                script.onreadystatechange = null;
                callback();
            }
        };
    } else { // Others
        script.onload = function() {
            callback();
        };
    }
    script.src = url;
    script.id = scriptId;
    document.getElementsByTagName("head")[0].appendChild(script);
};