    function handelRes(data){
        if(data.url!=''){
            layer.msg(data.msg,{},function(){
                location.href=data.url;
            });
        }else{
            layer.msg(data.msg);
        }
    }
    
    function nodejsInit(){
        $.ajax({
            url:'/teacher/liveing/setNodeInfo',
            type:'POST',
            data:{user_type:_DATA.roominfo.user_type},
            dataType:'json',
            success:function(data){
                if(data.code==0){
                    handelRes(data);
                    return !1;
                }
                
                var socket_data={uid:_DATA.userinfo.id,token:_DATA.userinfo.token,stream:stream,roomnum:_DATA.roominfo.liveuid};
                Socket.nodejsInit(socket_data);
            },
            error:function(e){
                layer.msg('信息错误');
            }
        })
    }
    //进入声网房间
    function joinAgora(type=0){
        //先检查一下是否和现在的浏览器相匹配
        var isgo=AgoraRTC.checkSystemRequirements();
        if(!isgo){
            alert('当前浏览器不支持，请更换浏览器或者升级该浏览器，如:谷歌浏览器');
            return ;
        }
        var client = AgoraRTC.createClient({mode: 'live', codec: "h264"});

        rtc.client=client;

        //加载声网回调
        handleEvents(rtc);
        //初始化房间
        rtc.client.init(option.appID, function () {
            // 初始化成功房间后老师和学生加入房间
            rtc.client.join(option.token, option.channel,parseInt(_DATA.userinfo.id) , function (uid) {
                console.log("join channel: " + option.channel + " success, uid: " + uid);
                rtc.params.uid = uid;
                if(type==1){
                    startPush();
                }
                
            }, function(err) {
                layer.msg('进入房间失败请稍后重试');
                console.error("client join failed", err)
            })
            
        }, function (err) {
            console.log("AgoraRTC client init failed", err);

            layer.msg('房间初始化失败，请稍后重试');
        });

    }

    //声网的一些回调
    function handleEvents (rtc) {
        //本地推流回调
        rtc.client.on("stream-published", function(evt) {
            // console.log('本地流推了');
            // console.log(evt.stream);
            // console.log(evt.stream.getId());
            $('.body_left_top_status').html('上课中');
            $('.body_right_video_wait').css('display','none');
            $('.body_right_video_caozuo').css('display','block');
            $('.live_start').hide();
            $('.live_resume').hide();
            $('.live_end').show();
            if(_DATA.roominfo.user_type==1){
                
                if(!whiteWebSdk){
                    joinWhite();
                }
                
                var ispush=1;
                timeInterval.rttInterval(ispush);
                
                if(ismuteAudio){
                    rtc.localStream.muteAudio();
                    var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"1","source":"PC","touid":"'+_DATA.userinfo.id+'"}],"retcode":"000000","retmsg":"OK"}';
                    Socket.emitData('broadcast',msg);
                }
                
                if(ismuteVideo){
                    rtc.localStream.muteVideo();
                    var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"3","source":"PC","touid":"'+_DATA.userinfo.id+'"}],"retcode":"000000","retmsg":"OK"}';
                    Socket.emitData('broadcast',msg);
                }
                
                /* 录制 */
                $.ajax({
                    type: "POST",
                    url:'/teacher/liveing/createRecord',
                    data:{courseid:courseid,lessonid:lessonid},
                    dataType:'json',
                    error: function(request)
                    {
                        console.log('请求错误');
                    },
                    success: function(data)
                    {
                        console.log(data);
                    }
                })
            }
        })

        //异地推流成功后回调
        rtc.client.on("stream-added", function(evt) {
            // console.log('异地流推了');
            // console.log(evt);
            var remoteStream = evt.stream;
            var id = remoteStream.getId();

            // console.log('异地流推了');
            // console.log(id);
            //接受远端流

            if(id==999999999){ //共享屏幕推流
                if( _DATA.roominfo.user_type!=1 ){ //如果你不是老师就接受流
                    rtc.client.subscribe(remoteStream, function (err) {
                        console.log("stream subscribe failed", err);
                    })
                }
            }else{
                if (id !== _DATA.userinfo.id) {
                    //console.log('不是自己推流');
                    rtc.client.subscribe(remoteStream, function (err) {
                        console.log("stream subscribe failed", err);
                    })
                }
            }
        })

        //接受远端成功回调之后播放流
        rtc.client.on("stream-subscribed", function (evt) {
            //console.log(evt);
            var remoteStream = evt.stream;
            var id = remoteStream.getId();
            console.log('接受远端流--'+id);
            if(id!=999999999){
                rtc.remoteStreams.push(remoteStream);
                //获取信息之后再播放
                if(id==_DATA.teacherinfo.id){
                    /* 讲师的流 */
                    if(_DATA.roominfo.user_type!=1){
                        $('.body_right_video_wait').hide();
                        remoteStream.play("local_stream",{fit: "contain"},function(errState){
                            var isPlay=checkBrowser.myBrowser();
                            if (errState && errState.status !== "aborted" && isPlay==false){
                                // 播放失败，一般为浏览器策略阻止。引导用户用手势触发恢复播放。
                                layer.confirm('由于浏览器的限制，需要手动点击播放，建议使用最新谷歌浏览器进行观看直播', {
                                    title:'提示',
                                    btn: ['播放','取消'] //按钮
                                }, function(index){
                                    layer.close(index);
                                    remoteStream.resume().then(
                                        function (result) {
                                            console.log('恢复成功：' + result);
                                        }).catch(
                                            function (reason) {
                                            layer.msg('播放失败，建议使用最新谷歌浏览器');
                                            console.log('恢复失败：' + reason);
                                        });
                                }, function(){
                                });
                            
                            }
                        });
                    }
                }else{
                    Linkmic.getLinkInfo(id,remoteStream);
                }
                
                console.log('stream-subscribed remote-uid: ', id);
                
            }else{  //老师共享屏幕的流
                // console.log(evt);
                rtc.remoteStreams_screen.push(remoteStream);
                
                //获取信息之后再播放
                teacherscreen.upScreen(1);
                
                remoteStream.play("screen",{fit: "contain"},function(errState){
                    var isPlay=checkBrowser.myBrowser();
                    if (errState && errState.status !== "aborted" && isPlay==false){
                        // 播放失败，一般为浏览器策略阻止。引导用户用手势触发恢复播放。
                        layer.confirm('由于浏览器的限制，需要手动点击播放，建议使用最新谷歌浏览器进行观看直播', {
                            title:'提示',
                            btn: ['播放','取消'] //按钮
                        }, function(index){
                            layer.close(index);
                            remoteStream.resume().then(
                                function (result) {
                                    console.log('恢复成功：' + result);
                                }).catch(
                                    function (reason) {
                                    layer.msg('播放失败，建议使用最新谷歌浏览器');
                                    console.log('恢复失败：' + reason);
                                });
                        }, function(){
                        });
                    
                    }
                });
                console.log('stream-subscribed remote-uid: ', id);
            }

        })

        //推流结束回调
        rtc.client.on("stream-removed", function (evt) {
            var remoteStream = evt.stream;
            var id = remoteStream.getId();

            remoteStream.stop();
            if(id!=999999999){
                if(id==_DATA.teacherinfo.id){
                    $('.body_right_video_wait').css('display','block');
                    if(_DATA.roominfo.user_type==1){
                        var ispush=0;
                        timeInterval.rttInterval(ispush,remoteStream);
                    }
                }
                
                rtc.remoteStreams = rtc.remoteStreams.filter(function (stream) {
                    return stream.getId() != id
                })
                
                rtc.client.unsubscribe(remoteStream, function (err) {
                    console.log("stream unsubscribe failed", err);
                })
    
            
                //进行样式修改
                if(id!=_DATA.teacherinfo.id){
                    Linkmic.delView(id);
                }
            }else{ //共享屏幕推流结束
                rtc.remoteStreams_screen = rtc.remoteStreams_screen.filter(function (stream) {
                    return stream.getId() != id
                })
    
                rtc.client.unsubscribe(remoteStream, function (err) {
                    console.log("stream unsubscribe failed", err);
                })
                
                teacherscreen.upScreen(0);
            } 
        })

        //关闭音频轨道回调
        rtc.client.on("mute-audio", function(evt) {
            var uid = evt.uid;
            console.log("mute audio:" + uid);
            //alert("mute audio:" + uid);
        });

        //开启音频轨道回调
        rtc.client.on("unmute-audio", function (evt) {
            var uid = evt.uid;
            console.log("unmute audio:" + uid);
            
        });

        //关闭视频轨道回调
        rtc.client.on("mute-video", function (evt) {
            var uid = evt.uid;
            console.log("mute video" + uid);
        })

        
        //开启视频轨道回调
        rtc.client.on("unmute-video", function (evt) {
            var uid = evt.uid;
            console.log("unmute video:" + uid);
        })

        //有用户离开房间
        rtc.client.on("peer-leave", function(evt) {
            //console.log('有人离线了');
            var uid = evt.uid;
            var reason = evt.reason;

            console.log("remote user left ", uid, "reason: ", reason);
            for(var i=0;i<rtc.remoteStreams.length;i++){
                if(rtc.remoteStreams[i].getId()==uid){ //掉线的这个人正在连麦
                    rtc.remoteStreams[i].stop();
                    if(uid==_DATA.teacherinfo.id){ //老师掉线了
                        $('.body_right_video_wait').css('display','block');
                        layer.msg('老师离开了房间');

                    }else{ //学生的话需要进行操作
                        Linkmic.delView(uid);

                    }
                    
                    rtc.client.unsubscribe( rtc.remoteStreams[i], function (err) {
                        console.log("stream unsubscribe failed", err);
                    })
    
                    break;
                }
            }

            rtc.remoteStreams = rtc.remoteStreams.filter(function (stream) {
                return stream.getId() != uid
            })
            
            //如果在共享屏幕需要停止推流
            //老师离线了
            if(rtc.remoteStreams_screen!='' && uid==999999999){
                //学生相应的做出操作
                teacherscreen.upScreen(0);

                rtc.client.unsubscribe( rtc.remoteStreams_screen[0], function (err) {
                    console.log("stream unsubscribe failed", err);
                })

                rtc.remoteStreams_screen = rtc.remoteStreams_screen.filter(function (stream) {
                    return stream.getId() != 999999999
                })
            }
        });
    }

    //白板重置大小
    function refreshViewSize() {
        // 将 room 变量暴露在全局变量时的操作。
        if(whiteroom.length>0){
            whiteroom && whiteroom.refreshViewSize();
        }

    };
    //进入白板房间
    function joinWhite(){

        //这是进入白板房间
        var uuid=_DATA.roominfo.uuid;
        var roomToken=_DATA.roominfo.roomtoken;
        var appid=_DATA.roominfo.netless_appid;

        // 更多初始化 sdk 参数，请查看[初始化参数]文档
        whiteWebSdk = new WhiteWebSdk({
            appIdentifier: appid
        });

        var isteach= _DATA.roominfo.user_type==1? true:false;

        if(isteach){
            $('.body_left_bottom_top_button').show();
            $('#caozuo').show();
        }
        
        /* 其他人看操作白板的光标是用户的头像 */
        function createCursorElement(iconURL) {
            var containerElement = document.createElement("div");
            var iconURLElement = document.createElement("img");
            containerElement.append(iconURLElement);
            iconURLElement.setAttribute("src", iconURL);
            iconURLElement.setAttribute("class", 'whiteboard_img');
            return containerElement;
        }
        var roomMembers = [];
        var cursorAdapter = {
            createCursor: function(memberId) {
                    return {x: 16, y: 16, width: 20, height: 20};
            },
            onAddedCursor: function(cursor) {
                for (var i = 0; i < roomMembers.length; i ++) {
                    var roomMember = roomMembers[i];
                    if (roomMember.memberId === cursor.memberId) {
                        // 其中 iconURL、color 应该由用户自定义到 payload 中
                        var payload = roomMember.payload;
                        var cursorElement = createCursorElement(payload.avatar);
                   
                        cursor.divElement.append(cursorElement);
                        break;
                    }
                }
            },
            onRemovedCursor: function(cursor) {
                // 清理工作
            },
        };
        
        /* 其他人看操作白板的光标是用户的头像 */
        
        // 更多初始化 房间 参数，请查看[初始化参数]文档
        whiteWebSdk.joinRoom({
            uuid: uuid,
            roomToken: roomToken,
            cursorAdapter:cursorAdapter,
            userPayload: {
                // userPayload 可以根据业务自行自定义
                // nickname: "your-nick-name",
                avatar: _DATA.userinfo.avatar,
              },
            isWritable:isteach //老师进来可以写
        },
        {
            onRoomStateChanged: function(modifyState) {
                if (modifyState.roomMembers) {
                    roomMembers = modifyState.roomMembers;
                }
            }
        }
        ).then(function(room) {
            //将 room 实例绑定在全局变量中。后续所有 API 实例，都会直接调用 room
            window.whiteroom = room;
            // console.log('132');
            // console.log(whiteroom.state.sceneState);
            
            whiteroom.bindHtmlElement(document.getElementById("whiteboard"));
            
            whiteroom.file_uuid= _DATA.roominfo.file_uuid;  //老师之前上传的最后一个文档转图片的uuid

            //老师进来之后先把教具改成铅笔
            if(isteach){
                whiteroom.setMemberState({
                    currentApplianceName: "pencil",
                    strokeColor: [52, 68, 90],
                    strokeWidth: 4,
                    textSize: 8,
                });
                $('.body_left_bottom_top_c_img').eq(1).attr('src','/static/teacher/images/white/pencil1.png');
                whiteinfo.strokeWidth=4;
                whiteinfo.strokeColor=[52, 68, 90];
                whiteinfo.textSize=15;
                whiteinfo.currentApplianceName='pencil';
            }
            window.addEventListener("resize", refreshViewSize);
            
            // console.log(whiteroom.scenePathType('/'+whiteroom.file_uuid));
            
            // whiteroom.setScenePath('/'+whiteroom.file_uuid+'/');
            
            // console.log(whiteroom.state.sceneState);
            setTimeout(function(){
                //判断是不是在初始白板页面，不是需要添加东西
                if(whiteroom.state.sceneState.scenePath!='/init'){
                    addPptPage();
                }else{
                    if(whiteroom.file_uuid!=''){
                        addPagePpt();
                    }
                }
            },1000)
        })      

    }
    
    //预览
    function preview(type=0){
        //创建流
        var localStream = AgoraRTC.createStream({
            streamID: option.uid,
            audio:true,
            video:true,
            screen:false,
            microphoneId: selectedMicrophoneId,
            cameraId: selectedCameraId
        });
        rtc.localStream=localStream;
        //初始化流
        rtc.localStream.init(function () {
            console.log("init local stream success");
            rtc.localStream.play("local_stream",{fit: "contain"},function(errState){
                var isPlay=checkBrowser.myBrowser();
                if (errState && errState.status !== "aborted" && isPlay==false){
                    layer.msg('由于浏览器的限制，需要手动点击老师画面进入播放');
                    var html='<img class="body_right_video_play" src="/static/teacher/images/white/play.png">';
                    $('#local_stream').append(html);
                    
                    document.querySelector("#local_stream").onclick=function(){
                        rtc.localStream.resume().then(
                            function (result) {
                                $('#local_stream .body_right_video_play').hide();
                                console.log('恢复成功：' + result);
                            }).catch(
                            function (reason) {
                                layer.msg('播放失败，建议使用最新谷歌浏览器');
                                console.log('恢复失败：' + reason);
                        });
                    }
                }else{
                    $('#local_stream .body_right_video_play').hide();
                }
            });
            
            $('.body_right_video_wait').hide();
            
            if(type==1){
                startPush();
            }

        }, function (err) {
            layer.msg('请检查麦克风和摄像头是否正常');
            console.error("init local stream failed ", err);
            Live.clear();
        })
    }
    //开始推流上课
    function startPush(){
        //成功之后推流
        if (!rtc.client) {
            layer.msg('房间初始化失败，请重新进入房间');
            return;
        }
        // if (rtc.published) {
        //     layer.msg('你已经推流了，请结束推流后重新开播');
        //     return;
        // }
        // var oldState = rtc.published;

        // publish localStream
        rtc.client.publish(rtc.localStream, function (err) {
            //rtc.published = oldState;
            layer.msg('本地推流失败请重新进入房间进行推流');
            console.log("publish failed");
            console.error(err);
            Live.clear();
            return ;
        })
        //rtc.published = true;
    }

    //结束推流下课
    function endPush(){
        // console.log(rtc.localStream);
        rtc.client.unpublish(rtc.localStream, function(err) {
            console.log(err);
        })  
        $('.body_right_video_wait').show();
        $('.body_right_video_caozuo').hide();

        //结束下课然后断流
        if(rtc.localStream){
            rtc.localStream.stop();
            rtc.localStream.close();
        }

        // while (rtc.remoteStreams.length > 0) {
        //     var stream = rtc.remoteStreams.shift();
        //     var id = stream.getId();
        //     var isplay=stream.isPlaying();
        //     if(isplay){
        //         stream.stop();
        //     }
        //     //removeView(id);
        // }
        rtc.localStream = null;
        //rtc.remoteStreams = [];
        //rtc.client = null;
        console.log("client end push success");

        //如果正在共享屏幕
        if(rtc.localStream_screen){
            teacherscreen.stopScreen();
        }
    }

    //进入房间后先进行各种初始化和进入房间
    function init(){
        
        /* 加入socket */
        nodejsInit();
    
        Ware.init();
        Exam.init();
        Robans.init();
        Student.init();
        Linkmic.init();
        Live.init();
    
        //非主播直接进入
        if(_DATA.roominfo.user_type!=1){
            joinWhite();
            
            joinAgora();
        }
        // joinWhite();
        //修改禁言状态
        if(_DATA.roominfo.isshup==0){
            $(":checkbox[id='stopspeak']").prop("checked",false);
        }else{
            $(":checkbox[id='stopspeak']").prop("checked",true);
        }
    }
    
    /* 课件处理 */
    var Ware={
        js_ware:$('#js_ware'),
        js_ware_add:$('#js_ware_add'),
        classfile:$('.classfile'),
        init:function(){
            var _this=this;
            _this.js_ware.on('click',function(){
                _this.getWare();
            })
            
            _this.js_ware_add.on('click',function(){
                $('#upload').empty();
                var input = '<input type="file" id="ware_file" name="file" />';
                $('#upload').html(input);
                var index='ware_file';
                var iptt=document.getElementById(index);
                if(window.addEventListener) { // Mozilla, Netscape, Firefox
                    iptt.addEventListener('change',function(){
                        _this.addWare();
                    },false);
                }else{
                    iptt.attachEvent('onchange',function(){
                        _this.addWare();
                    });
                }
                $('#'+index).click();
            })
            
            _this.classfile.on('click','.js_ware_del',function(){
                var _that=$(this);
                layer.confirm('确定要删除该课件么',{},function(){
                    _this.delWare(_that);
                })
            })
            
            //点击关闭课件列表
             _this.classfile.on('click','.classfilen_top_close',function(){
                _this.classfile.hide();
            })
        },
        getWare:function(){
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getWare',
                data:{courseid:courseid,lessonid:lessonid},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    

                    var html='';
                    var list=data.data;

                    for(var i=0;i<list.length;i++){
                        var v=list[i];
                        html+='<div class="classfilen_bottom_list_li">\
                                    <div class="classfilen_bottom_list_li_avatar">'+v.name+'</div>\
                                    <div class="classfilen_bottom_list_li_name">'+v.size+'</div>\
                                    <div class="classfilen_bottom_list_li_edit">\
                                        <a style="color:#38DAA6" target="_blank" href="'+v.url+'"><span data-url="'+v.url+'" data-name="'+v.name+'">打开</span></a>&nbsp;&nbsp;\
                                        <a style="color:#38DAA6" href="javascript:void(0)"><span data-id="'+v.id+'" class="js_ware_del">删除</span></a>\
                                    </div>\
                                </div>';
                    }
                    
                    $('.classfilen_bottom_list').html(html);
                    $('.classfile').show();
                }
            })
        },
        addWare:function(){
            var file = $('#upload').find('#ware_file')[0].files[0];
            var location=$('#upload').find('#ware_file').val();
            var point = location.lastIndexOf(".");  
            var type = location.substr(point);  

            if(type!=".ppt" && type!=".doc" && type!=".docx" && type!=".xls" && type!=".xlsx"){  
                layer.msg('课件只能上传ppt word excel');
                return !1;
            }
            var formData = new FormData(); 
            formData.append('file', file);
            formData.append('courseid', courseid);
            formData.append('lessonid', lessonid);
            
            $.ajax({ 
                url: '/teacher/liveing/addWare',
                type: 'post', 
                data: formData, 
                dataType:'json',
                cache: false, 
                processData: false, 
                contentType: false, 
                success:function(data){
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    var v=data.data;
                    var html='<div class="classfilen_bottom_list_li">\
                                    <div class="classfilen_bottom_list_li_avatar">'+v.name+'</div>\
                                    <div class="classfilen_bottom_list_li_name">'+v.size+'</div>\
                                    <div class="classfilen_bottom_list_li_edit">\
                                        <a style="color:#38DAA6" target="_blank" href="'+v.url+'"><span data-url="'+v.url+'" data-name="'+v.name+'">打开</span></a>&nbsp;&nbsp;\
                                        <a style="color:#38DAA6" href="javascript:void(0)"><span data-id="'+v.id+'" class="js_ware_del">删除</span></a>\
                                    </div>\
                                </div>';
                    
                    $('.classfilen_bottom_list').append(html);
                },
                error:function(e){
                    layer.msg("网络错误");
                }
            })
        },
        delWare:function(_that){
            var id=_that.data('id');
            
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/delWare',
                data:{courseid:courseid,lessonid:lessonid,id:id},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    layer.closeAll();
                    _that.parents('.classfilen_bottom_list_li').remove();
                }
            })
        },
        downWare:function(){
            
        }
    }
    
    /* 课堂测试 */
    var Exam={
        js_exam:$('#js_exam'),
        js_exam_create:$('#js_exam_create'),
        js_exam_list:$('#js_exam_list'),
        js_exam_addbd:$('#js_exam_addbd'),
        js_exam_question:$('#js_exam_question'),
        js_exam_score:$('#js_exam_score'),
        exam_release:$('.exam_release'),
        choices:['A','B','C','D'],
        judges:['正确','错误'],
        init:function(){
            var _this=this;
            _this.js_exam.on('click',function(){
                _this.getExam();
            })
            
            _this.js_exam_create.on('click',function(){
                _this.js_exam_addbd.show();
            })
            
            
            //套题列表
            _this.js_exam_list.on('click','.top_close',function(){
                _this.js_exam_list.hide();
            })
            
            /* 详情 */
            _this.js_exam_list.on('click','.js_exam_d',function(){
                var _that=$(this);
                var examid=_that.parent().data('id');
                _this.getQuest(examid);
            })
            /* 发布 */
            _this.js_exam_list.on('click','.js_exam_s',function(){
                var _that=$(this);
                var examid=_that.parent().data('id');
                
                _this.exam_release.find('.exam_release_btn').data('id',examid);
                
                var dateTimeInput = $("input.js-datetime");
                if (dateTimeInput.length) {
                    Wind.use('datePicker', function () {
                        dateTimeInput.datePicker({
                            //min:new Date(),
                            time: true
                        });
                    });
                }
                
                layer.open({
                      type: 1,
                      title:'结束时间',
                      skin: 'layui-layer-rim', //加上边框
                      area: ['420px', '240px'], //宽高
                      content: _this.exam_release
                });
                
            })
            /* 发布弹窗 */
            _this.exam_release.on('click','.exam_release_btn',function(){
                var _that=$(this);
                var examid=_that.data('id');
                var endtime=_this.exam_release.find('.js-datetime').val();
                if(endtime==''){
                    layer.msg('请选择结束时间');
                    return !1;
                }
                
                _this.release(examid,endtime);
            })
            
            /* 试题-查看成绩 */
            _this.js_exam_list.on('click','.js_exam_c',function(){
                var _that=$(this);
                var examid=_that.parent().data('id');
                _this.getExamScore(examid);
            })
            
            
            /* 题目列表 */
            _this.js_exam_question.on('click','.top_close',function(){
                _this.js_exam_question.hide();
            })
            
            
            /* 答题用户列表 */
            _this.js_exam_score.on('click','.top_close',function(){
                _this.js_exam_score.hide();
            })
            
            /* 用户列表-查看成绩 */
            _this.js_exam_score.on('click','.js_exam_score_list .li_btn',function(){
                var _that=$(this);
                var examid=_that.data('examid');
                var touid=_that.data('uid');
                var toname=_that.data('toname');
                _this.getQuest(examid,touid,toname);
            })
            
            
            /* 新增列表 */
            _this.js_exam_addbd.on('click','.top_close',function(){
                _this.clear();
            })
            
            _this.js_exam_addbd.on('click','.js_exam_add_choice',function(){
                _this.addChioce();
            })
            _this.js_exam_addbd.on('click','.js_exam_add_judge',function(){
                _this.addJudge();
            })
            _this.js_exam_addbd.on('click','.js_exam_add_write',function(){
                _this.addWrite();
            })
            
            _this.js_exam_addbd.on('click','.li_bd_btn_judge',function(){
                var _that=$(this);
                if(_that.hasClass('on')){
                    return !1;
                }
                _that.siblings().removeClass('on');
                _that.addClass('on');
            })
            
            _this.js_exam_addbd.on('click','.exam_add_btn',function(){
                _this.addExam();
            })
        },
        getExam:function(){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getExam',
                data:{courseid:courseid,lessonid:lessonid},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    

                    var html='';
                    var list=data.data;
                    
                    

                    for(var i=0;i<list.length;i++){
                        var v=list[i];
                        html+='<li>\
                                    <div class="li_t">'+v.name+'</div>\
                                    <div class="li_i">\
                                        选择题 '+v.choicenums+' | 判断题 '+v.judgenums+' | 书写题 '+v.writenums+'\
                                    </div>\
                                    <div class="li_b" data-id="'+v.id+'">\
                                        <span class="js_exam_d">详情</span>';
                        if(v.status==0){
                            html+='<span class="js_exam_s">发布</span>';
                        }
                        if(v.status==1){
                            html+='<span class="no">已发布</span>';
                            html+='<span class="js_exam_c">查看成绩</span>';
                        }
                            
                        html+='     </div>\
                                </li>';
                    }
                    
                    if(html==''){
                        html='<div class="exam_list_bd_no">\
                                            本堂暂无测试，可新建测试\
                                        </div>';
                    }else{
                        html='<ul>'+html+'</ul>';
                    }
                    
                    _this.js_exam_list.find('.exam_list_bd').html(html);
                    _this.js_exam_list.show(); 
                }
            })
        },
        addChioce:function(){
            var _this=this;
            var nums=_this.js_exam_addbd.find('.exam_add_choice_list li').length;
            nums+=1;
            var html='<li>\
                        <div class="li_t">\
                            <span>'+nums+'</span>\
                            <input type="text" placeholder="请填写问题内容" class="js_input_name">\
                        </div>';
                        for(var i=0;i<4;i++){
                            html+='<div class="li_t">\
                                <span>'+_this.choices[i]+'</span>\
                                <input type="text" placeholder="请填写答案" class="js_input_answer">\
                                <div class="li_select">\
                                    <input type="radio" value="'+i+'" class="js_input_radio" name="choice_'+nums+'" id="choice_'+nums+'_'+i+'">\
                                    <label for="choice_'+nums+'_'+i+'">设为正确答案</label>\
                                </div>\
                            </div>';
                        }
                        
                        
                html+='</li>';
            _this.js_exam_addbd.find('.exam_add_choice_list').append(html);
        },
        addJudge:function(){
            var _this=this;
            var nums=_this.js_exam_addbd.find('.exam_add_judge_list li').length;
            nums+=1;
            var html='<li>\
                        <div class="li_t">\
                            <span>'+nums+'</span>\
                            <input type="text" placeholder="请填写问题内容" class="js_input_name">\
                        </div>\
                        <div class="li_t">\
                            <div class="li_bd_btn_judge" data-val="1">正确</div>\
                            <div class="li_bd_btn_judge" data-val="0">错误</div>\
                        </div>\
                    </li>';
            _this.js_exam_addbd.find('.exam_add_judge_list').append(html);
        },
        addWrite:function(){
            var _this=this;
            var nums=_this.js_exam_addbd.find('.exam_add_write_list li').length;
            nums+=1;
            var html='<li>\
                        <div class="li_t">\
                            <span>'+nums+'</span>\
                            <input type="text" placeholder="请填写问题内容" class="js_input_name">\
                        </div>\
                    </li>';
            _this.js_exam_addbd.find('.exam_add_write_list').append(html);
            
        },
        addExam:function(){
            var _this=this;
            var istips=false;
            var istips2=true;
            /* 测试题名 */
            var title=_this.js_exam_addbd.find('.js_input_title').val();
            if(title==''){
                layer.msg('请填写测试标题');
                return !1;
            }
            /* 选择题处理 */
            var choices=[];
            var choices_add=[];
            _this.js_exam_addbd.find('.exam_add_choice_list li').each(function(){
                var _that=$(this);
                var name=_that.find('.js_input_name').val();
                if(name==''){
                    istips=true;
                    // return !1;
                }
                var answers=[];
                _that.find('.js_input_answer').each(function(){
                    var answer=$(this).val();
                    if(answer==''){
                        istips=true;
                        // return !1;
                    }
                    answers.push(answer);
                })
                var isok=_that.find('.js_input_radio:checked').val();
                if(isok==undefined){
                    istips=true;
                    isok='';
                    // return !1;
                }
                istips2=false;
                var topic={name:name,answers:answers,isok:isok};
                choices.push(topic);
            });
            
            var choices_nums=choices.length;
            for(var i=0;i<choices_nums;i++){
                var v=choices[i];
                var is_a_kong=0;
                var is_a_tian=0;
                if(v.name==''){
                    is_a_kong=1;
                }else{
                    is_a_tian=1;
                }
                
                for(var j=0;j<v.answers.length;j++){
                    var v1=v.answers[j];
                    if(v1==''){
                        is_a_kong=1;
                    }else{
                        is_a_tian=1;
                    }
                }
                
                if(v.isok==='' ){
                    is_a_kong=1;
                }else{
                    is_a_tian=1;
                }
                
                if(is_a_tian && is_a_kong){
                    layer.msg('请填写完整信息');
                    return !1;
                }
                
                if(is_a_tian==1){
                    choices_add.push(v);
                }
                
            }
            
            // if(istips){
                // layer.msg('请填写完整信息');
                // return !1;
            // }
            /* 判断题处理 */
            var judges=[];
            var judges_add=[];
            _this.js_exam_addbd.find('.exam_add_judge_list li').each(function(){
                var _that=$(this);
                var name=_that.find('.js_input_name').val();
                if(name==''){
                    istips=true;
                    // return !1;
                }
                var isok=_that.find('.li_bd_btn_judge.on').data('val');
                if(isok==null){
                    istips=true;
                    isok='';
                    // return !1;
                }
                istips2=false;
                var topic={name:name,isok:isok};
                judges.push(topic);
            });
            
            var judges_nums=judges.length;
            for(var i=0;i<judges_nums;i++){
                var v=judges[i];
                var is_a_kong=0;
                var is_a_tian=0;
                if(v.name==''){
                    is_a_kong=1;
                }else{
                    is_a_tian=1;
                }

                if(v.isok==='' ){
                    is_a_kong=1;
                }else{
                    is_a_tian=1;
                }
                
                if(is_a_tian && is_a_kong){
                    layer.msg('请填写完整信息');
                    return !1;
                }
                
                if(is_a_tian==1){
                    judges_add.push(v);
                }
                
            }
            
            // if(istips){
                // layer.msg('请填写完整信息');
                // return !1;
            // }
            
            /* 书写题处理 */
            var writes=[];
            var writes_add=[];
            _this.js_exam_addbd.find('.exam_add_write_list li').each(function(){
                var _that=$(this);
                var name=_that.find('.js_input_name').val();
                if(name==''){
                    istips=true;
                    // return !1;
                }
                istips2=false;
                var topic={name:name};
                writes.push(topic);
            });
            
            var writes_nums=writes.length;
            for(var i=0;i<writes_nums;i++){
                var v=writes[i];
                if(v.name!==''){
                    writes_add.push(v);
                }

            }
            
            // if(istips){
                // layer.msg('请填写完整信息');
                // return !1;
            // }
            if(choices_add.length==0 && judges_add.length==0 && writes_add.length==0){
                layer.msg('至少添加一个题目');
                return !1;
            }
            
            
            var field={choices:choices_add,judges:judges_add,writes:writes_add};
            
            var formData = new FormData(); 
            formData.append('courseid', courseid);
            formData.append('lessonid', lessonid);
            formData.append('title', title);
            formData.append('field', encodeURIComponent(JSON.stringify(field)) );
            
            $.ajax({ 
                url: '/teacher/liveing/addExam',
                type: 'post', 
                data: formData, 
                dataType:'json',
                cache: false, 
                processData: false, 
                contentType: false, 
                success:function(data){
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    layer.msg(data.msg,{},function(){
                        _this.clear();
                        
                        
                        _this.getExam();
                    });
                },
                error:function(e){
                    layer.msg("网络错误");
                }
            })
        },
        clear:function(){
            var _this=this;
            _this.js_exam_addbd.hide();
            _this.js_exam_addbd.find(".exam_add_choice_list").html('');
            _this.js_exam_addbd.find(".exam_add_judge_list").html('');
            _this.js_exam_addbd.find(".exam_add_write_list").html('');
            _this.js_exam_addbd.find("input").val('');
            _this.addChioce();
            _this.addJudge();
            _this.addWrite();
        },
        getQuest:function(examid,touid=0,toname=''){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getQuestion',
                data:{courseid:courseid,lessonid:lessonid,examid:examid,touid:touid},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    var title='课堂测试';
                    if(toname){
                        title=toname+'的'+title;
                    }
                    
                    _this.js_exam_question.find('.top_name').html(title);
                    
                    var html='';
                    var rs=data.data;
                    var l_choice=rs.choice;
                    var l_judge=rs.judge;
                    var l_write=rs.write;
                    
                    if(l_choice){
                        html+='<div class="exam_quest_t">选择题</div>\
                                    <div class="exam_quest_list">\
                                        <ul>';
                        for(var i=0;i<l_choice.length;i++){
                            var v=l_choice[i];
                            html+='<li>\
                                        <div class="li_t">'+(i+1)+'.'+v.name+'</div>\
                                        <div class="li_bd">';
                                        for(j=0;j<4;j++){
                                            
                                            var css=(touid && v.answer[j].ischoice==1) || (!touid && v.answer[j].isok==1) ? 'on':'';
                                            html+='<div class="li_bd_btn '+css+'">'+_this.choices[j]+' '+v.answer[j].name+'</div><br>';
                                        }
                             html+='    </div>\
                                    </li>';
                        }
                        
                        html+='</ul>\
                                    </div>';
                    }
                    
                    if(l_judge){
                        html+='<div class="exam_quest_t">判断题</div>\
                                <div class="exam_quest_list">\
                                    <ul>';
                        for(var i=0;i<l_judge.length;i++){
                            var v=l_judge[i];
                            html+='<li>\
                                        <div class="li_t">'+(i+1)+'.'+v.name+'</div>\
                                        <div class="li_bd">';
                                        
                                        var ischoice=v.answer[0].ischoice;
                                        if(ischoice==0){
                                            ischoice=1;
                                        }else if(ischoice==1){
                                            ischoice=0;
                                        }
                                        
                                        var isok=v.answer[0].isok;
                                        if(isok==0){
                                            isok=1;
                                        }else if(isok==1){
                                            isok=0;
                                        }
                                        
                                        for(j=0;j<2;j++){
                                            var css=(touid && ischoice ==j) || (!touid && isok==j) ? 'on':'';
                                            html+='<div class="li_bd_btn judge '+css+'">'+_this.judges[j]+'</div><br>';
                                        }
                                            
                            html+='      </div>\
                                    </li>';
                        }
                        
                        html+='</ul>\
                                    </div>';
                    }
                    
                    if(l_write){
                        html+='<div class="exam_quest_t">书写题</div>\
                                    <div class="exam_quest_list">\
                                        <ul>';
                        for(var i=0;i<l_write.length;i++){
                            var v=l_write[i];
                            html+='<li>\
                                            <div class="li_t">'+(i+1)+'.'+v.name+'</div>\
                                            <div class="li_bd">\
                                                <div class="li_bd_con">\
                                                        '+v.answer[0].ischoice+'\
                                                    </div>\
                                            </div>\
                                        </li>';
                        }
                        
                        html+='</ul>\
                                    </div>';
                    }
                    
                    _this.js_exam_question.find('.exam_quest').html(html);
                    _this.js_exam_question.show(); 
                }
            })
        },
        getExamScore:function(examid){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getExamScore',
                data:{courseid:courseid,lessonid:lessonid,examid:examid},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    

                    var html='';
                    var list=data.data;
                    
                    

                    for(var i=0;i<list.length;i++){
                        var v=list[i];
                        html+='<li>\
                                    <div class="li_img"><img src="'+v.userinfo.avatar+'"></div>\
                                    <div class="li_name">'+v.userinfo.user_nickname+'</div>\
                                    <div class="li_btn" data-uid="'+v.uid+'" data-examid="'+examid+'" data-toname="'+v.userinfo.user_nickname+'">查看成绩</div>\
                                </li>';
                    }
                    
                    
                    _this.js_exam_score.find('.js_exam_score_list').html(html);
                    _this.js_exam_score.show(); 
                }
            })
        },
        release:function(examid,endtime){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/releaseExam',
                data:{courseid:courseid,lessonid:lessonid,examid:examid,endtime:endtime},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    layer.closeAll();
                    _this.getExam();
                    
                    var msg = '{"msg":[{"_method_":"exam","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","action":"0","source":"PC"}],"retcode":"000000","retmsg":"OK"}';
                
                    Socket.emitData('broadcast',msg);
                }
            })
        }
    }
    
    /* 抢答题 */
    var Robans={
        js_robans:$('#js_robans'),
        js_robans_create:$('#js_robans_create'),
        js_robans_list:$('#js_robans_list'),
        js_robans_addbd:$('#js_robans_addbd'),
        js_robans_score:$('#js_robans_score'),
        robans_release:$('.robans_release'),
        choices:['A','B','C','D'],
        init:function(){
            var _this=this;
            _this.js_robans.on('click',function(){
                _this.getRobans();
            })
            
            _this.js_robans_create.on('click',function(){
                _this.js_robans_addbd.show();
            })
            
            
            //套题列表
            _this.js_robans_list.on('click','.top_close',function(){
                _this.js_robans_list.hide();
            })
            
            /* 详情 */
            _this.js_robans_list.on('click','.js_exam_d',function(){
                var _that=$(this);
                var examid=_that.parent().siblings('.li_i').find('.li_i_l').toggle();
            })
            /* 发布 */
            _this.js_robans_list.on('click','.js_exam_s',function(){
                var _that=$(this);
                var examid=_that.parent().data('id');
                
                _this.release(examid);
            })

            
            /* 试题-查看成绩 */
            _this.js_robans_list.on('click','.js_exam_c',function(){
                var _that=$(this);
                var examid=_that.parent().siblings('.robanswer').toggle();
            })
            
            
            /* 新增列表 */
            _this.js_robans_addbd.on('click','.top_close',function(){
                _this.js_robans_addbd.hide();
            })
            
            _this.js_robans_addbd.on('click','.exam_add_btn',function(){
                _this.addRobans();
            })
        },
        getRobans:function(){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getRobans',
                data:{courseid:courseid,lessonid:lessonid},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    

                    var html='';
                    var list=data.data;
                    
                    for(var i=0;i<list.length;i++){
                        var v=list[i];
                        html+='<li>\
                                    <div class="li_t">'+v.name+'</div>\
                                    <div class="li_i">';
                        html+=          '<div class="li_i_l">';          
                                        for(j=0;j<4;j++){
                                            var css=v.answer[j].isok==1 ? 'on':'';
                                            html+='<div class="li_bd_btn '+css+'">'+_this.choices[j]+' '+v.answer[j].name+'</div><br>';
                                        } 
                        html+=          '</div>';  
                        html+=      '</div>\
                                    <div class="li_b" data-id="'+v.id+'">\
                                        <span class="js_exam_d">详情</span>';
                        if(v.status==0){
                            html+='<span class="js_exam_s">发布</span>';
                        }
                        if(v.status==1){
                            html+='<span class="no">已发布</span>';
                            
                        }
                        if(v.robuid>0){
                            html+='<span class="js_exam_c">查看成绩</span>';
                        }
                            
                        html+='     </div>';
                        if(v.robuid>0){
                            html+='<div class="robanswer">'+v.userinfo.user_nickname+' 选择了答案'+_this.choices[v.robanswer]+',';
                            if(v.isright==1){
                                html+='回答正确';
                            }else{
                                html+='回答错误';
                            }
                            html+='</div>';
                        }
                        html+='</li>';
                    }
                    
                    if(html==''){
                        html='<div class="exam_list_bd_no">\
                                            当前暂无题目，请新建题目\
                                        </div>';
                    }else{
                        html='<ul>'+html+'</ul>';
                    }
                    
                    _this.js_robans_list.find('.exam_list_bd').html(html);
                    _this.js_robans_list.show(); 
                }
            })
        },
        
        addRobans:function(){
            var _this=this;
            var istips=false;
            
            /* 选择题处理 */
            var s_choices=[]
            var choices=[];
            _this.js_robans_addbd.find('.exam_add_choice_list li').each(function(){
                var _that=$(this);
                var name=_that.find('.js_input_name').val();
                if(name==''){
                    istips=true;
                    return !1;
                }
                var answers=[];
                _that.find('.js_input_answer').each(function(){
                    var answer=$(this).val();
                    if(answer==''){
                        istips=true;
                        return !1;
                    }
                    answers.push(answer);
                })
                
                s_choices.push(answers);
                var isok=_that.find('.js_input_radio:checked').val();
                if(isok==undefined){
                    istips=true;
                    return !1;
                }
                var topic={name:name,answers:answers,isok:isok};
                choices.push(topic);
            });
            
            if(istips){
                layer.msg('请填写完整信息');
                return !1;
            }
            
            var field={choices:choices};
            
            
            var formData = new FormData(); 
            formData.append('courseid', courseid);
            formData.append('lessonid', lessonid);
            formData.append('field', encodeURIComponent(JSON.stringify(field)) );
            
            $.ajax({ 
                url: '/teacher/liveing/addRobans',
                type: 'post', 
                data: formData, 
                dataType:'json',
                cache: false, 
                processData: false, 
                contentType: false, 
                success:function(data){
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    layer.msg(data.msg,{},function(){
                        _this.js_robans_addbd.hide();
                        _this.js_robans_addbd.find("input[type=text]").val('');
                        _this.js_robans_addbd.find("input[type=radio]").attr("checked", false);
                        _this.getRobans();
                    });
                },
                error:function(e){
                    layer.msg("网络错误");
                }
            })
        },
        release:function(examid){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/releaseRobans',
                data:{courseid:courseid,lessonid:lessonid,examid:examid},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("网络错误");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    layer.closeAll();
                    _this.getRobans();
                    
                    var examid=data.data.id;
                    var name=data.data.name;
                    var answers=data.data.answers;
                    
                    var msg = '{"msg":[{"_method_":"robans","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","examid":"'+examid+'","name":"'+name+'","type":"1","answer":'+JSON.stringify(answers)+',"action":"0","source":"PC"}],"retcode":"000000","retmsg":"OK"}';
                
                    Socket.emitData('broadcast',msg);
                }
            })
        }
    }
    
    /* 学生列表 */
    var Student={
        student_list:$('.student_list'),
        js_student_btn:$('.js_student_btn'),
        js_student_hand:$('.js_student_hand'),

        shut_type:0,
        shut_tan:$('.shut_tan'),
        shutcontent_content_div1_val:$('.shutcontent_content_div1_val'),
        studentlistsuper_top_nums:$('.studentlistsuper_top_nums'),
        touid:0,
        init:function(){
            var _this=this;
            _this.js_student_btn.on('click',function(){
               _this.getList();
            });
            
            //点击关闭学生列表
            _this.student_list.on('click','.studentlist_top_close',function(){
                _this.student_list.hide();
                $('.body_left_bottom_bottom_list1').show();
                $('.body_left_bottom_bottom_list2').hide();
            })
            
            /* 上下麦操作 */
            _this.student_list.on('click','.js_linkmic',function(){
                
                var _that=$(this);
                var touid=_that.parents('.studentlist_bottom_list_li').data('uid'); //用户id
                var type=_that.data('type');
                _this.Linkmic(touid,type);
            })
            
            /* 拒绝上麦 */
            _this.student_list.on('click','.js_refuse_linkmic',function(){
                var _that=$(this);
                var touid=_that.parents('.studentlist_bottom_list_li').data('uid'); //用户id
                
                var msg = '{"msg":[{"_method_":"LinkMic","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","action":"3","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
                Socket.emitData('broadcast',msg);
                _this.getList();
            })

            //选择禁言类型
            //自定义禁言
            _this.shut_tan.on('click','.shutcontent_content_div1_img',function(){
                _this.shut_tan.find('.shutcontent_content_div2_img').attr('src','/static/student/images/liveing/shutno.png');
                $(this).attr('src','/static/student/images/liveing/shutyes.png');
                _this.shut_type = 0;
            })
            //永久禁言
            _this.shut_tan.on('click','.shutcontent_content_div2_img',function(){
                _this.shut_tan.find('.shutcontent_content_div1_img').attr('src','/static/student/images/liveing/shutno.png');
                $(this).attr('src','/static/student/images/liveing/shutyes.png');
                _this.shut_type = 1;
            })

            //取消禁言框
            _this.shut_tan.on('click','.shutcontent_content_no',function(){
                _this.shut_tan.hide();
            })

            //确定禁言
            _this.shut_tan.on('click','.shutcontent_content_ok',function(){
                var time =_this.shutcontent_content_div1_val.val();
                if(_this.shut_type ==0){ //自定义禁言


                    if((/^(\+|-)?\d+$/.test( time )) == false || time<=0){
                        layer.msg('请输入正确数字');
                        return ;
                    }

                    _this.startShutup(_this.touid,0,time);

                }else{ // 永久禁言
                    _this.startShutup(_this.touid,1,0);
                }

            })    
            
            /* 禁言、取消禁言 */
            _this.student_list.on('click','.js_shutup',function(){
                
                var _that=$(this);
                // var touid=_that.parents('.studentlist_bottom_list_li').data('uid'); //用户id
                
                // var type=_that.data('type');
                // _this.Shutup(_that,touid,type);

                _this.touid = _that.parents('.studentlist_bottom_list_li').data('uid'); //用户id
                _this.student_list.hide();
                $('.body_left_bottom_bottom_list1').show();
                $('.body_left_bottom_bottom_list2').hide();

                var user_nickname = _that.data('user_nickname');

                _this.shut_tan.show();
                _this.student_list_super.hide();
                _this.studentlistsuper_top_nums.html(user_nickname);




            })
            
            /* 踢人 */
            _this.student_list.on('click','.js_kick',function(){
                var _that=$(this);
                var touid=_that.parents('.studentlist_bottom_list_li').data('uid'); //用户id
                
                _this.Kick(_that,touid);
            })
            
            /* 白板授权 */
            _this.student_list.on('click','.js_write',function(){
                var _that=$(this);
                var touid=_that.parents('.studentlist_bottom_list_li').data('uid'); //用户id
                
                var type=_that.data('type');
                _this.setWrite(_that,touid,type);
            })
        },
        //选择好禁言时长后进行禁言
        startShutup:function(touid,shuttype,time){
            var _this = this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/setShutup',
                data:{courseid:courseid,lessonid:lessonid,stream:stream,touid:touid,type:1,shuttype:shuttype,time:time},
                dataType:'json',
                error: function(request)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    layer.msg(data.msg);
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    _this.shutcontent_content_div1_val.val('');
                    _this.shut_tan.hide();
                    
                    var msg = '{"msg":[{"_method_":"Shutup","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","action":"1","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
                    
                    Socket.emitData('broadcast',msg);
                }
            })
        },
        addHand:function(){
            var _this=this;
            _this.js_student_hand.show();
        },
        delHand:function(){
            var _this=this;
            _this.js_student_hand.hide();
        },
        getList:function(){
            var _this=this;
            _this.delHand();
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getUserLists',
                data:{courseid:courseid,lessonid:lessonid,stream:stream},
                dataType:'json',
                error: function(e)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    var html='';
                    var list=data.data.list;
                    var type_s={0:'台下',1:'台上',2:'<span style="color:#FF4F4F">举手</span>'};
                   
                        
                    for(var i=0;i<list.length;i++){
                        var v=list[i];
                        html+='<div class="studentlist_bottom_list_li" data-uid="'+v.id+'">\
                                    <div class="studentlist_bottom_list_li_avatar">\
                                        <img src="'+v.avatar+'">\
                                    </div>\
                                    <div class="studentlist_bottom_list_li_name">'+v.user_nickname+'</div>';
                        
                            html+='<div class="studentlist_bottom_list_li_status">'+type_s[v.type]+'</div>';
                            
                        if(v.type==1){
                            if(v.iswrite==1){
                                 html+='<div class="studentlist_bottom_list_li_status"><span class="write_c js_write" data-type="0">取消授权</span></div>';
                            }else{
                                 html+='<div class="studentlist_bottom_list_li_status"><span class="write_c write_a js_write" data-type="1">授权</span></div>';
                            }
                        }else{
                            html+='<div class="studentlist_bottom_list_li_status"></div>';
                        }
                        
                       
                            html+='<div class="studentlist_bottom_list_li_edit">';
                            if(v.type==2){
                                html+= '<span class="js_linkmic" data-type="1">上台</span>';
                                html+= '<span class="js_refuse_linkmic">拒绝</span>';
                            }else if(v.type==1){
                                html+= '<span class="js_linkmic" data-type="0">下台</span>';
                            }else{
                                html+= '';
                            }
                                    
                            if(v.isshut==1){
                                html+='<span  class="js_shutup" data-uid="'+v['id']+'" data-user_nickname="'+v['user_nickname']+'" data-type="0">取消禁言</span>';
                            }else{
                                html+='<span  class="js_shutup" data-uid="'+v['id']+'" data-user_nickname="'+v['user_nickname']+'" data-type="1">禁言</span>';
                            }
                            
                                html+='<span  class="js_kick">踢出</span>';
                            html+='</div>\
                                </div>';
                    }

                    
                    $('.studentlist_bottom_list').html(html);
                       
                    _this.student_list.show();
                    
                    
                    $('.body_left_bottom_bottom_list1').hide();
                    $('.body_left_bottom_bottom_list2').show();
                    
                    var nums=data.data.nums;
                    _this.student_list.find('.studentlist_top_nums').html(data.data.nums);
                }
            })
        },
        Shutup:function(_that,touid,type){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/setShutup',
                data:{courseid:courseid,lessonid:lessonid,stream:stream,touid:touid,type:type},
                dataType:'json',
                error: function(request)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    var action=0;
                    if(type==1){
                        var action=1;
                        _that.html('取消禁言');
                        _that.data('type','0');
                    }else{
                        _that.html('禁言');
                        _that.data('type','1');
                    }

                    
                    var msg = '{"msg":[{"_method_":"Shutup","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","action":"'+action+'","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
                    
                    Socket.emitData('broadcast',msg);
                }
            })
        },
        Kick:function(_that,touid){
            var _this=this;
            
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/kick',
                data:{courseid:courseid,lessonid:lessonid,touid:touid},
                dataType:'json',
                error: function(request)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    _that.parents('.studentlist_bottom_list_li').remove();

                    
                    var msg = '{"msg":[{"_method_":"Kick","action":"1","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
                    Socket.emitData('broadcast',msg);	
                }
            })
        },
        Linkmic:function(touid,type){
            var _this=this;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/setLinkmic',
                data:{courseid:courseid,lessonid:lessonid,stream:stream,touid:touid,type:type},
                dataType:'json',
                error: function(request)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    var action=5;
                    if(type==1){
                        action=2;
                    }
                    
                    var msg = '{"msg":[{"_method_":"LinkMic","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","action":"'+action+'","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
                    Socket.emitData('broadcast',msg);
                    
                    layer.msg(data.msg,{},function(){
                        _this.getList();
                    });
                    
                    
                }
            })
        },
        setWrite:function(_that,touid,type){
            var action=5;
            if(type==1){
                action=1;
                _that.data('type',0);
                _that.removeClass('write_a');
                _that.html('取消授权');
            }else{
                _that.data('type',1);
                _that.addClass('write_a');
                _that.html('授权');
            }
            
            var msg = '{"msg":[{"_method_":"setWhite","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","action":"'+action+'","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
            Socket.emitData('broadcast',msg);
        }
        
    };

    /* 连麦 */
    var Linkmic={
        list:$('.linkmic_list'),
        init:function(){
            var _this=this;
            _this.list.on('click','.mic',function(){
               var _that=$(this);
               _this.setMic(_that);
            });
            
            _this.list.on('click','.camera',function(){
               var _that=$(this);
               _this.setCamera(_that);
            });
        },
        listToggle:function(type=0){
            var _this=this;
            
            if(type==1){
                _this.list.show();
            }else{
                _this.list.hide();
            }
            refreshViewSize();
        },
        upSize:function(){
            var _this=this;
            var list_w=_this.list.width();
            var max=Math.floor(list_w/200);
            
            var list_li=_this.list.find(".list_li");
            var nums=list_li.length;
            
            if(nums<max){
                list_li.css({'width':'200px'});
            }else{
                var w_n=Math.floor(list_w/nums);
                if(w_n<100){
                    list_li.css({'width':'100px'});
                }else{
                    list_li.css({'width': w_n+'px'});
                }
                
            }
            
        },
        //获取连麦的一些信息
        getLinkInfo:function(id,remoteStream){
            var _this=this;
            //拿着用户的id获取信息去
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/getLinkInfo',
                data:{id:id},
                dataType:'json',
                error: function(request)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    var userinfo=data.data;
                    _this.addView(id,userinfo.user_nickname,remoteStream);
                }
            })
        },
        addView:function(touid,name,remoteStream){
            var _this=this;
        
            var touid_div=_this.list.find("#linkmic_"+touid);
            if(!touid_div.length){
                var html='<div class="list_li"  id="linkmic_'+touid+'" data-uid="'+touid+'">\
                            <div class="list_li_bg"></div>\
                            <div class="list_li_name">'+name+'</div>\
                            <div class="list_li_play"></div>\
                            <div class="list_li_c">\
                                <span class="mic on"></span>\
                                <span class="camera on"></span>\
                            </div>\
                        </div>';

                _this.list.append(html);
            }
            
            var list_li=_this.list.find(".list_li");
            var nums=list_li.length;
            if(nums==1){
                _this.listToggle(1);
            }
            
            _this.upSize();
            if(remoteStream){
                var _that=_this.list.find("#linkmic_"+touid);
                remoteStream.play("linkmic_"+touid,{fit: "contain"},function(errState){
                    var isPlay=checkBrowser.myBrowser();
                    if (errState && errState.status !== "aborted" && isPlay==false){
                        top.layer.msg('由于浏览器的限制，需要手动点击学生画面进入播放');
                        _that.find('.list_li_play').show();
                        _that.onclick=function(){
                            remoteStream.resume().then(
                                function (result) {
                                    _that.find('.list_li_play').hide();
                                    _that.find("#player_"+touid).css({'position':'absolute','top':'0'});
                                    console.log('恢复成功：' + result);
                                }).catch(
                                function (reason) {
                                    layer.msg('播放失败，建议使用最新谷歌浏览器');
                                    console.log('恢复失败：' + reason);
                            });
                        }
                    }else{
                        _that.find("#player_"+touid).css({'position':'absolute','top':'0'});
                    }
                });
            }
        },
        delView:function(touid){
            var _this=this;
            var touid_div=_this.list.find("#linkmic_"+touid);
            if(touid_div.length){
                touid_div.remove();
            }
            var list_li=_this.list.find(".list_li");
            var nums=list_li.length;
            if(!nums){
                _this.listToggle();
                return 1;
            }
            
            _this.upSize();
        },
        setMic:function(_that){
            var action=0;
            var touid=_that.parents('.list_li').data('uid');
            if(_that.hasClass('on')){
                _that.removeClass('on');
                action=1;
            }else{
                _that.addClass('on');
                action=2;
            }
            
            var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"'+action+'","ct":"","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
            Socket.emitData('broadcast',msg);
            
            /* for(var i=0;i<rtc.remoteStreams.length;i++){
                if(rtc.remoteStreams[i].getId()==touid){ //音频轨道处理
                    if(action==1){
                        rtc.remoteStreams[i].unmuteAudio();
                    }
                    if(action==2){
                        rtc.remoteStreams[i].muteAudio();
                    }
                    
                }
            } */
        },
        setCamera:function(_that){
            var action=0;
            var touid=_that.parents('.list_li').data('uid');
            if(_that.hasClass('on')){
                _that.removeClass('on');
                _that.parents('.list_li').find('list_li_bg').addClass('on');
                action=3;
            }else{
                _that.addClass('on');
                _that.parents('.list_li').find('list_li_bg').removeClass('on');
                action=4;
            }
            
            
            var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"'+action+'","ct":"","source":"PC","touid":"'+touid+'"}],"retcode":"000000","retmsg":"OK"}';
            Socket.emitData('broadcast',msg);
            
            /* for(var i=0;i<rtc.remoteStreams.length;i++){
                if(rtc.remoteStreams[i].getId()==touid){ //视频轨道处理
                    if(action==3){
                        rtc.remoteStreams[i].unmuteVideo();
                    }
                    if(action==4){
                        rtc.remoteStreams[i].muteVideo();
                    }
                    
                }
            } */
        }
    };

    /* 直播 */
    var Live={
        live_issubmit:0,
        live_start:$('.live_start'),
        live_resume:$('.live_resume'),
        live_end:$('.live_end'),
        live_later:$('.live_later'),
        init:function(){
            var _this=this;
            _this.live_start.on('click',function(){
                var _that=$(this);
                if(_that.data('status')==1){
                    return !1;
                }
                _that.data('status','1');
                _this.start();
            })
            
            _this.live_resume.on('click',function(){
               var _that=$(this);
                if(_that.data('status')==1){
                    return !1;
                }
                _that.data('status','1');
                _this.startLive();
            })
            
            _this.live_end.on('click',function(){
                var _that=$(this);
                if(_that.data('status')==1){
                    return !1;
                }
                _that.data('status','1');
                _this.end();
            })
            
        },
        clear:function(){
            var _this=this;
            _this.live_start.data('status',0);
            _this.live_resume.data('status',0);
            _this.live_end.data('status',0);
        },
        start:function(){
            var _this=this;
            if(_this.live_issubmit){
                return !1;
            }
            
            if(!selectedMicrophoneId || !selectedCameraId || selectedMicrophoneId=='' || selectedCameraId==''){
                layer.msg('请检查麦克风和摄像头是否正常');
                return !1;
            }
            _this.live_issubmit=1;
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/startlive',
                data:{courseid:courseid,lessonid:lessonid},
                dataType:'json',
                error: function(e)
                {
                    _this.live_issubmit=0;
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                    _this.live_issubmit=0;
                    if(data.code==0){
                        handelRes(data);
                        return !1;
                    }
                    
                    
                    _this.startLive();
                }
            })
        },
        end:function(){
            var _this=this;
            if(_this.live_issubmit){
                return !1;
            }
            var endclass=layer.confirm(' 下课后，本堂课无法在继续上课，是否确认下课', {
                title:'提示',
                btn: ['是','否'] //按钮
            }, function(){
                layer.close(endclass);
                
                _this.live_issubmit=1;
                
                $.ajax({
                    type: "POST",
                    url:'/teacher/liveing/endlive',
                    data:{courseid:courseid,lessonid:lessonid},
                    dataType:'json',
                    error: function(request)
                    {
                        _this.live_issubmit=0;
                        layer.msg("数据请求失败");
                    },
                    success: function(data)
                    {
                        _this.live_issubmit=0;
                        if(data.code==0){
                            handelRes(data);
                            return !1;
                        }
                        
                        var msg = '{"msg":[{"_method_":"StartEndLive","action":"18"}],"retcode":"000000","retmsg":"OK"}';
                        Socket.emitData('broadcast',msg);	
                        
                        layer.msg(data.msg,{},function(){
                            location.href='/teacher/course/lesson?courseid='+courseid;
                        });  
                    }
                })
            }, function(){
           

            });
        },
        startLive:function(){
            
            
            joinAgora(1);
        }
        
    };
    
$(function(){
    Wind.css('layer');
    Wind.use('layer',function(){
        if(_DATA.roominfo.user_type==1){
            /* 讲师检测设备 */
            stratCheck();
        }
    });
    
    init();
    
    
    $(".js_check_ok").click(function(){
        closeCheck();
        preview();
    })

    /*****这下面都是一些课堂操作 */
    //把鼠标放到教具上
    $('.body_left_bottom_top_c_img').each(function(){
        var _this=$(this);
        var type=_this.data('type');
        _this.mouseover(function(){
            if(type=='selector'){
                laytips=layer.tips('选择器', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='pencil'){
                laytips=layer.tips('铅笔', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='rectangle'){
                laytips=layer.tips('矩形', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='ellipse'){
                laytips=layer.tips('椭圆', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='eraser'){
                laytips=layer.tips('橡皮', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='text'){
                laytips=layer.tips('文字', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='choosecolor'){
                laytips=layer.tips('吸色器', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='fontsize'){
                laytips=layer.tips('线条粗细', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='file'){
                laytips=layer.tips('文档转换', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='insertImage'){
                laytips=layer.tips('上传图片', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

            if(type=='del'){
                laytips=layer.tips('清屏', _this, {
                    tips: [1, '#38DAA6'],
                });
            }

        })
    })

    //把鼠标移开教具
    $('.body_left_bottom_top_c_img').each(function(){
        var _this=$(this);
        _this.mouseout(function(){
            layer.close(laytips);
        })
    })

    //把鼠标放到上传文档上
    $('.body_left_bottom_top_c_img_file').each(function(i){
        var _this=$(this);
        _this.mouseover(function(){
            if(i==0){
                laytipsfile=layer.tips('上传文档', _this, {
                    tips: [1, '#38DAA6'],
                });
            }
            if(i==1){
                laytipsfile=layer.tips('上传图片', _this, {
                    tips: [1, '#38DAA6'],
                });
            }
        })
    })

    //把鼠标移开上传文档上
    $('.body_left_bottom_top_c_img_file').each(function(){
        var _this=$(this);
        _this.mouseout(function(){
            layer.close(laytipsfile);
        })
    })
    //修改教具
    $('.body_left_bottom_top_c_img').click(function(){

        var _this=$(this);
        var type=_this.data('type');

        if(type!='fontsize' && type!='del' && type!='insertImage' && type!='file'){
            $('.body_left_bottom_top_c_img').eq(0).attr('src','/static/teacher/images/white/selector.png');
            $('.body_left_bottom_top_c_img').eq(1).attr('src','/static/teacher/images/white/pencil.png');
            $('.body_left_bottom_top_c_img').eq(2).attr('src','/static/teacher/images/white/ju.png');
            $('.body_left_bottom_top_c_img').eq(3).attr('src','/static/teacher/images/white/yuan.png');
            $('.body_left_bottom_top_c_img').eq(4).attr('src','/static/teacher/images/white/t.png');
            $('.body_left_bottom_top_c_img').eq(5).attr('src','/static/teacher/images/white/er.png');
            $('.body_left_bottom_top_c_img').eq(6).attr('src','/static/teacher/images/white/xi.png');
            $('.body_left_bottom_top_c_img').eq(7).attr('src','/static/teacher/images/white/b.png');
            //$('.body_left_bottom_top_c_img').eq(8).attr('src','/static/teacher/images/white/del.png');          
        }



        //选择selector
        if(type=='selector'){
            _this.attr('src','/static/teacher/images/white/selector1.png');
        }

        //选择铅笔
        if(type=='pencil'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                _this.attr('src','/static/teacher/images/white/pencil2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                _this.attr('src','/static/teacher/images/white/pencil1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                _this.attr('src','/static/teacher/images/white/pencil3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                _this.attr('src','/static/teacher/images/white/pencil4.png');
            }
        }

        //选择矩形
        if(type=='rectangle'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                _this.attr('src','/static/teacher/images/white/ju1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                _this.attr('src','/static/teacher/images/white/ju2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                _this.attr('src','/static/teacher/images/white/ju3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                _this.attr('src','/static/teacher/images/white/ju4.png');
            }
        }
        
        //选择圆形
        if(type=='ellipse'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                _this.attr('src','/static/teacher/images/white/yuan1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                _this.attr('src','/static/teacher/images/white/yuan2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                _this.attr('src','/static/teacher/images/white/yuan3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                _this.attr('src','/static/teacher/images/white/yuan4.png');
            }
        }

                
        //选择字
        if(type=='text'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                _this.attr('src','/static/teacher/images/white/t1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                _this.attr('src','/static/teacher/images/white/t2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                _this.attr('src','/static/teacher/images/white/t3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                _this.attr('src','/static/teacher/images/white/t4.png');
            }
        }     

        //选择橡皮
        if(type=='eraser'){
            _this.attr('src','/static/teacher/images/white/er1.png');
        }

        //选择字体颜色
        if(type=='choosecolor'){
            $('.white_fontsize').css('display','none');
            $('.white_choosecolor').css('display','block');

            
            _this.attr('src','/static/teacher/images/white/xi1.png');
            return ;
        }


        //选择字体粗细
        if(type=='fontsize'){
            $('.white_fontsize').css('display','block');
            $('.white_choosecolor').css('display','none');

            _this.attr('src','/static/teacher/images/white/b1.png');
            return ;
        }

        //清屏
        if(type=='del'){
            whiteroom.cleanCurrentScene(true);
            return ;
        }
        
        whiteinfo.currentApplianceName=type; //保存教具类型
        whiteroom.setMemberState({
            currentApplianceName: type,
            strokeColor:  whiteinfo.strokeColor,
            strokeWidth: whiteinfo.strokeWidth,
            textSize: whiteinfo.textSize,
        });
    })

    //选择颜色
    $('.white_choosecolor_color').click(function(){

        var color=$(this).data('color');
        whiteinfo.strokeColor=color;
        $('.white_choosecolor').css('display','none');
        $('.body_left_bottom_top_c_img').eq(6).attr('src','/static/teacher/images/white/xi.png');

        //选择铅笔
        if(whiteinfo.currentApplianceName=='pencil'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                $('.body_left_bottom_top_c_img').eq(1).attr('src','/static/teacher/images/white/pencil2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                $('.body_left_bottom_top_c_img').eq(1).attr('src','/static/teacher/images/white/pencil1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                $('.body_left_bottom_top_c_img').eq(1).attr('src','/static/teacher/images/white/pencil3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                $('.body_left_bottom_top_c_img').eq(1).attr('src','/static/teacher/images/white/pencil4.png');
            }
        }

        //选择矩形
        if( whiteinfo.currentApplianceName=='rectangle'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                $('.body_left_bottom_top_c_img').eq(2).attr('src','/static/teacher/images/white/ju1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                $('.body_left_bottom_top_c_img').eq(2).attr('src','/static/teacher/images/white/ju2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                $('.body_left_bottom_top_c_img').eq(2).attr('src','/static/teacher/images/white/ju3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                $('.body_left_bottom_top_c_img').eq(2).attr('src','/static/teacher/images/white/ju4.png');
            }
        }
        
        //选择圆形
        if( whiteinfo.currentApplianceName=='ellipse'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                $('.body_left_bottom_top_c_img').eq(3).attr('src','/static/teacher/images/white/yuan1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                $('.body_left_bottom_top_c_img').eq(3).attr('src','/static/teacher/images/white/yuan2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                $('.body_left_bottom_top_c_img').eq(3).attr('src','/static/teacher/images/white/yuan3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                $('.body_left_bottom_top_c_img').eq(3).attr('src','/static/teacher/images/white/yuan4.png');
            }
        }

                
        //选择字
        if(whiteinfo.currentApplianceName=='text'){
            if(JSON.stringify(whiteinfo.strokeColor) == '[22,156,142]'){
                $('.body_left_bottom_top_c_img').eq(4).attr('src','/static/teacher/images/white/t1.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == '[52,68,90]'){
                $('.body_left_bottom_top_c_img').eq(4).attr('src','/static/teacher/images/white/t2.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[246,89,50]"){
                $('.body_left_bottom_top_c_img').eq(4).attr('src','/static/teacher/images/white/t3.png');
            }else if(JSON.stringify(whiteinfo.strokeColor) == "[51,161,245]"){
                $('.body_left_bottom_top_c_img').eq(4).attr('src','/static/teacher/images/white/t4.png');
            }
        }   

        whiteroom.setMemberState({
            currentApplianceName: whiteinfo.currentApplianceName,
            strokeColor:  whiteinfo.strokeColor,
            strokeWidth: whiteinfo.strokeWidth,
            textSize: whiteinfo.textSize,
        });

    })

    //选择字体粗细
    $('.white_fontsize_size').click(function(){
        var size=$(this).data('size');
        whiteinfo.strokeWidth=size;
        $('.white_fontsize').css('display','none');
        $('.body_left_bottom_top_c_img').eq(7).attr('src','/static/teacher/images/white/b.png');

        whiteroom.setMemberState({
            currentApplianceName: whiteinfo.currentApplianceName,
            strokeColor:  whiteinfo.strokeColor,
            strokeWidth: whiteinfo.strokeWidth,
            textSize: whiteinfo.textSize,
        });
    })


    //全体禁言
    $('#stopspeak').click(function(){

        var ischecked=$(this).is(':checked');
        var isshup='';
        if(ischecked==true){ //表示要进行禁言
            if(_DATA.roominfo.isshup==1){
                layer.msg('禁言中，请不要重复禁言');
                $(":checkbox[id='stopspeak']").prop("checked",true);
                return ;
            }

            isshup=1;
        }else{ //要进行取消禁言
            if(_DATA.roominfo.isshup==0){
                layer.msg('非禁言，请不要重复非禁言');
                $(":checkbox[id='stopspeak']").prop("checked",false);
                return ;
            }

            isshup=0;
        }

        $.ajax({
            type: "POST",
            url:'/teacher/liveing/roomShutup',
            data:{courseid:courseid,lessonid:lessonid,type:isshup},
            dataType:'json',
            error: function(request)
            {
                layer.msg("数据请求失败");
            },
            success: function(data)
            {
                if(data.code==0){
                    if(isshup==0){
                        $(":checkbox[id='stopspeak']").prop("checked",false);
                    }else{
                        $(":checkbox[id='stopspeak']").prop("checked",true);
                    }
                    
                    handelRes(data);
                    return !1;
                }
                layer.msg(data.msg);

                _DATA.roominfo.isshup=isshup;

                if(isshup==1){
                    var msg='已开启禁言';
                }else{
                    var msg='已关闭禁言';
                }
                
                var msg = '{"msg":[{"_method_":"roomShutup","action":"'+isshup+'","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'"}],"retcode":"000000","retmsg":"OK"}';
                
                Socket.emitData('broadcast',msg);	
            }
        })
    })

    //点击发言
    $('.body_right_send_button').click(function(){
        var value=$('.body_right_send_msg').val();
        if(value==''){
            layer.msg('请输入要发言的内容');
            return ;
        }

        if(!$.trim(value)){
            layer.msg('不能只发送空格');
            return ;
        }

        $('.body_right_send_msg').val('');

        var msg = '{"msg":[{"_method_":"SendMsg","action":1,"content":"'+value+'","uid":"'+_DATA.userinfo.id+'","avatar":"'+_DATA.userinfo.avatar+'","user_nickname":"'+_DATA.userinfo.user_nickname+'","user_type":"'+_DATA.roominfo.user_type+'"}],"retcode":"000000","retmsg":"OK"}';
        Socket.emitData('broadcast',msg);	

    })
    
    //老师点击关自己的麦
    $('body').on('click','.body_right_video_mai_open',function(){
        var _this=$(this);

        rtc.localStream.muteAudio();
        ismuteAudio=true;
        
        _this.css('display','none');
        $('.body_right_video_mai_close').css('display','block');
        
        var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"1","source":"PC","touid":"'+_DATA.userinfo.id+'"}],"retcode":"000000","retmsg":"OK"}';
        Socket.emitData('broadcast',msg);
    })

    //老师点击关自己摄像头
    $('body').on('click','.body_right_video_video_open',function(){
        var _this=$(this);

        rtc.localStream.muteVideo();
        ismuteVideo=true;
        
        _this.css('display','none');
        
        $('.body_right_video_bg').addClass('on');
        
        $('.body_right_video_video_close').css('display','block');
        
        var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"3","source":"PC","touid":"'+_DATA.userinfo.id+'"}],"retcode":"000000","retmsg":"OK"}';
        Socket.emitData('broadcast',msg);
    })


    //老师点击开自己的麦
    $('body').on('click','.body_right_video_mai_close',function(){
        var _this=$(this);
        
        rtc.localStream.unmuteAudio();
        ismuteAudio=false;
        
        _this.css('display','none');
        $('.body_right_video_mai_open').css('display','block');
        
        var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"2","source":"PC","touid":"'+_DATA.userinfo.id+'"}],"retcode":"000000","retmsg":"OK"}';
        Socket.emitData('broadcast',msg);
    })

    //老师点击开自己的摄像头
    $('body').on('click','.body_right_video_video_close',function(){
        var _this=$(this);

        rtc.localStream.unmuteVideo();
        ismuteVideo=false;
        
        _this.css('display','none');
        $('.body_right_video_video_open').css('display','block');
        
        $('.body_right_video_bg').removeClass('on');
        
        var msg = '{"msg":[{"_method_":"setLiveModel","uid":"'+_DATA.userinfo.id+'","action":"4","source":"PC","touid":"'+_DATA.userinfo.id+'"}],"retcode":"000000","retmsg":"OK"}';
        Socket.emitData('broadcast',msg);

    })


    //老师点击共享屏幕
    $('.body_left_bottom_bottom_gongxiang1').click(function(){

        if(!rtc.localStream){
            layer.msg('还没有上课');
            return ;
        }
        teacherscreen.setScreen();

        $('.body_left_bottom_bottom_gongxiang1').css('display','none');
        $('.body_left_bottom_bottom_gongxiang2').css('display','block');
                    
    })
    
    //老师点击取消共享屏幕
    $('.body_left_bottom_bottom_gongxiang2').click(function(){

        if(!rtc.localStream_screen){
            //layer.msg('没有共享屏幕');
            return ;
        }
        teacherscreen.stopScreen();

        $('.body_left_bottom_bottom_gongxiang1').show();
        $('.body_left_bottom_bottom_gongxiang2').hide();
                    
    })
	
    /* 切换PPT */
    $('.ppt_preview').on('click','.ppt_view',function(){
        var _this=$(this);
        var li=_this.parent();
        if(li.hasClass('on')){
            return !1;
        }
        
        var page=li.data('page');
        whiteroom.setSceneIndex(page);
        
        li.siblings().removeClass('on');
        li.addClass('on');
        
        upPage();
    })
    
    /* 关闭预览 */
    $('.ppt_preview').on('click','.ppt_preview_t_c',function(){
        var _this=$(this);
        
        $('.ppt_preview').removeClass("on");
    })
    
    /* 删除 */
    $('.ppt_preview').on('click','.ppt_btn_del',function(){
        var _this=$(this);
        var li=_this.parent().parent();
        
        var page=li.data('page');
        var path=li.data('path');
        // console.log(path);
        whiteroom.removeScenes(path);
        
        if(whiteroom.state.sceneState.scenePath=='/init'){
            /* 当前ppt已全部删除 */
            $.ajax({
                type: "POST",
                url:'/teacher/liveing/upfileuuid',
                data:{courseid:courseid,lessonid:lessonid,file_uuid:''},
                error: function(request)
                {
                    layer.msg("数据请求失败");
                },
                success: function(data)
                {
                }
            })
            hidePagePpt();
        }else{
            pptpreview();
            upPage(); 
        }
        
    })
    var pre_laytips=null;
    $('#whiteboard').on('mouseover','.whiteboard_preview',function(){
        var _this=$(this);
        if(!pre_laytips){
            pre_laytips=layer.tips('预览', _this, {
                tips: [1, '#38DAA6'],
            });
        }
        
    })
    $('#whiteboard').on('mouseout','.whiteboard_preview',function(){
        layer.close(pre_laytips);
        pre_laytips=null;
    })
    
})

/**下面这些是老师的共享屏幕操作 */
var teacherscreen={
    //老师开始生成共享屏幕的房间和流
    setScreen:function(){
        var _this=this;

        if(!rtc.localStream){
            layer.msg('还没有开课');
            return ;
        }
        //老师停止推流
        rtc.client.unpublish(rtc.localStream, function(err) {
            console.log(err);
        })  
        
        // $('.body_right_video_wait').css('display','block');
        $('.body_right_video_caozuo').hide();

        //结束下课然后断流
        if(rtc.localStream){
            // stop stream
            rtc.localStream.stop();
            // close stream
            rtc.localStream.close();
        }
        rtc.localStream = null;

        _this.upScreen(1);
        var client_screen = AgoraRTC.createClient({mode: 'live', codec: "h264"});

        rtc.client_screen=client_screen;
        //加载声网回调
        this.handleEventsScreen(rtc);
        //初始化房间
        rtc.client_screen.init(option.appID, function () {
            //console.log("初始化共享屏幕房间成功");
            // 初始化成功房间后添加一个共享屏幕机器人
            rtc.client_screen.join(option.token, option.channel,999999999, function (uid) {
                console.log("join channel_screen: " + option.channel_screen + " success, uid: " + uid);
                rtc.params_screen.uid = uid;

                //加入房间之后老师直接推共享屏幕的流
                //创建流
                var localStream_screen = AgoraRTC.createStream({
                    streamID: 999999999,
                    audio:true,
                    video:false,
                    screen:true
                });
                rtc.localStream_screen=localStream_screen;

                _this.handleEventsScreenStream(rtc);
                //初始化流
                rtc.localStream_screen.init(function () {
                    console.log("init localStream_screen stream success");
                    rtc.localStream_screen.play("screen",{fit: "contain"},function(errState){
                        var isPlay=checkBrowser.myBrowser();
                        if (errState && errState.status !== "aborted" && isPlay==false){
                            // 播放失败，一般为浏览器策略阻止。引导用户用手势触发恢复播放。
                            layer.confirm('由于浏览器的限制，需要手动点击播放，建议使用最新谷歌浏览器进行观看直播', {
                                title:'提示',
                                btn: ['播放','取消'] //按钮
                            }, function(index){
                                layer.close(index);
                                rtc.localStream_screen.resume().then(
                                    function (result) {
                                        console.log('恢复成功：' + result);
                                    }).catch(
                                    function (reason) {
                                        layer.msg('播放失败，建议使用最新谷歌浏览器');
                                        console.log('恢复失败：' + reason);
                                });
                            }, function(){
                            });
                        }
                    });
                    //成功之后推流
                    if (!rtc.client_screen) {
                        layer.msg('房间初始化失败，请重新进入房间');
                        return;
                    }
                    // if (rtc.published) {
                    //     layer.msg('你已经推流了，请结束推流后重新开播');
                    //     return;
                    // }
                    // var oldState = rtc.published;

                    // publish localStream
                    rtc.client_screen.publish(rtc.localStream_screen, function (err) {
                        //rtc.published = oldState;
                        layer.msg('本地推流失败请重新开始共享屏幕房间进行推流');
                        console.log("publish_screen failed");
                        console.error(err);

                        return ;
                    })

                    //rtc.published = true;
                }, function (err) {
                    //layer.msg('请检查浏览器是否支持，建议使用谷歌浏览器进行操作');
                    _this.stopScreen();
                    console.error("init local_screen stream failed ", err);
                })
            }, function(err) {
                layer.msg('进入共享屏幕房间失败请稍后重试');
                _this.stopScreen();
                console.error("client_screen join failed", err)
            })
            
        }, function (err) {
            _this.stopScreen();
            console.log("AgoraRTC client_screen init failed", err);

            layer.msg('共享屏幕房间初始化失败，请稍后重试');
        });
    },

    //共享屏幕的一些声网回调
    handleEventsScreen:function(rtc) {
        //本地推流回调
        rtc.client_screen.on("stream-published", function(evt) {
            // console.log('本地共享屏幕流推了');
            // console.log(evt.stream);
            // console.log('本地共享屏幕流推了');

            //共享屏幕推流之后发送socket给学生，让他们进来
            var msg = '{"msg":[{"_method_":"ShareScreen","action":"0","uid":"'+_DATA.userinfo.id+'","ct":"","source":"PC","channel_screen":"'+option.channel_screen+'"}],"retcode":"000000","retmsg":"OK"}';
            Socket.emitData('broadcast',msg);
        })

        //异地推流成功后回调
        rtc.client_screen.on("stream-added", function(evt) {
            // // console.log('异地流推了');
            // // console.log(evt);
            // var remoteStream = evt.stream;
            // var id = remoteStream.getId();
    
            // // console.log('异地流推了');
            // // console.log(id);
            // //接受远端流
            // if (id !== _DATA.userinfo.id) {
            //     console.log('不是自己推流');

            //     //先提前生成div否则会可能报错
            //     rtc.client_screen.subscribe(remoteStream, function (err) {
            //         console.log("stream subscribe failed", err);
            //     })
            // }
        })

        //接受远端成功回调之后播放流
        rtc.client_screen.on("stream-subscribed", function (evt) {
            // console.log(evt);
            // var remoteStream = evt.stream;
            // var id = remoteStream.getId();
            // rtc.remoteStreams_screen.push(remoteStream);
            // //获取信息之后再播放
        })

        //推流结束回调
        rtc.client_screen.on("stream-removed", function (evt) {
            // var remoteStream = evt.stream;
            // var id = remoteStream.getId();
            // remoteStream.stop();
            // rtc.remoteStreams_screen = rtc.remoteStreams_screen.filter(function (stream) {
            //     return stream.getId() != id
            // })

            // rtc.client_screen.unsubscribe(remoteStream, function (err) {
            //     console.log("stream unsubscribe failed", err);
            // })
        })

        //有用户离开房间
        rtc.client_screen.on("peer-leave", function(evt) {
            
        });
        
        
    },

    //屏幕共享回调
    handleEventsScreenStream:function(rtc){
        var _this=this;
        //屏幕共享停止回调
        rtc.localStream_screen.on("stopScreenSharing",function(){
            
            //共享屏幕结束推流之后发送socket给学生，让他们出去
            var msg = '{"msg":[{"_method_":"ShareScreen","action":"1","uid":"'+_DATA.userinfo.id+'","ct":"","source":"PC","channel_screen":"'+option.channel_screen+'"}],"retcode":"000000","retmsg":"OK"}';
            Socket.emitData('broadcast',msg);	
            _this.stopScreen();
        })
    },

    //共享屏幕结束后的一些操作
    stopScreen:function(){
        var _this=this;
        //老师离开房间
        if(rtc.localStream_screen){
            // stop stream
            rtc.localStream_screen.stop();
            // close stream
            rtc.localStream_screen.close();
        }
        rtc.localStream_screen = null;

        rtc.remoteStreams_screen = [];

        _this.upScreen(0);
        rtc.client_screen.leave(function () {

        }, function (err) {
            console.log("channel leave failed");
            console.error(err);
        })

        //rtc.client = null;
        // console.log("client_screen end push success");
        console.log('屏幕共享停止了');
        
        $('.body_left_bottom_bottom_gongxiang1').show();
        $('.body_left_bottom_bottom_gongxiang2').hide();


        //屏幕共享停止之后，老师重新推流
        preview(1);
    },
    upScreen:function(type=0){
        if(type==1){
            $('#screen').show();
            $('#caozuo').hide();
        }else{
            $('#screen').hide().html('');
            $('#caozuo').show();
        }
    }
}

/**定时器 */
var timeInterval={
    //上课时间定时器
    classInterval:function(data){
        clearInterval(classIntavl);
        //展示上课时间
        $('.body_left_top_status').html('');
        var html='已上课 <span id="h">'+data.info.arr.h+'</span>:<span id="m">'+data.info.arr.m+'</span>:<span id="s">'+data.info.arr.s+'</span>';
        $('.body_left_top_status').html(html);

        classIntavl=setInterval(function(){
            var oldh=$('#h').text();
            var oldm=$('#m').text();
            var olds=$('#s').text();
            var newh=oldh;
            var newm=oldm;
            var news=olds;
            if(parseInt(olds)==59){
                news='00';
                newm=parseInt(oldm)+1;

                if(newm==60){
                    newm='00';
                    newh=parseInt(oldh)+1;
                }
            }

            if(parseInt(olds)<59){
                news=parseInt(olds)+1;
            }

            $('#h').text(newh);
            $('#m').text(newm);
            $('#s').text(news);
        },1000);
    },

    //网络延迟定时器
    rttInterval:function(ispush,remoteStream){

        clearInterval(RTTyan);
        if(ispush==1){
            RTTyan=setInterval(function(){
                rtc.client.getTransportStats(function (stats) {
                    var RTT=stats.RTT || "--";
                    $('#RTT').html(RTT)
                });
            },1000)
        }else{
            RTTyan=setInterval(function(){
                remoteStream.getStats(function (stats) {
                    var RTT=stats.accessDelay || "--";
                    $('#RTT').html(RTT)
                });
            },1000)
        }
    },
}

/*判断浏览器版本**/
var checkBrowser={

    myBrowser:function(){
        var isPlay=true;
        var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串
        if (userAgent.indexOf("Chrome") > -1){ //谷歌浏览器


            var arr = navigator.userAgent.split(' '); 
            var chromeVersion = '';
            for(var i=0;i < arr.length;i++){
                if(/chrome/i.test(arr[i]))
                chromeVersion = arr[i]
            }
            if(chromeVersion){
                if(Number(chromeVersion.split('/')[1].split('.')[0])>70){
                    isPlay=false;
                }
            }
        }
        if (userAgent.indexOf("Safari") > -1) {
            isPlay=false;
        }
        return isPlay;
    }
}

/**上传图片的一些操作 */
function selectFilePhoto(){
    //触发 文件选择的click事件  
    $("#file_photo").trigger("click");
}

function getFilePathPhoto(){
    var file = document.getElementById('file_photo').files[0]; 

    if(!file){
        layer.msg('请上传图片');
        return ;
    }

    if (!(/image/.test(file.type))) {
        layer.msg('请上传图片');
        return ;
    }

    var formData = new FormData(); 
    formData.append('file', file);
    
    $('#file_photo').val('');

    $.ajax({ 
        type: 'post', 
        url: '/teacher/liveing/addPhoto', //上传文件的请求路径必须是绝对路劲
        data: formData, 
        dataType:'json',
        cache: false, 
        processData: false, 
        contentType: false, 
        success:function(data){
            if(data.code==0){
                handelRes(data);
                return !1;
            }

            var img_url = data.data.thumb;
            var img = new Image();
            img.src = img_url;
            img.onload = function(){
                var timestamp=new Date().getTime();
                // 方法1 插入图片占位信息
                // 通过 uuid 来保证，completeImageUpload 更新的是同一张图片地址
                whiteroom.insertImage({
                    uuid: timestamp,
                    centerX: 0, 
                    centerY: 0, 
                    width:img.width, 
                    height:img.height
                });
                // 方法2 传入图片占位 uuid，以及图片网络地址。
                whiteroom.completeImageUpload(timestamp, img_url);
            };
        },
        error:function(e){

        }
    })
}


/**上传文档的一些操作 */
function selectFileFile(){
    //触发 文件选择的click事件  
    $("#file_file").trigger("click");
}

function getFilePathFile(){
    var file = document.getElementById('file_file').files[0]; 

    if(!file){
        layer.msg('请上传文件');
        return ;
    }
    var formData = new FormData(); 
    formData.append('file', file);
    
    $('#file_file').val('');
    var index = layer.load(1, {
        shade: [0.1,'#000'] //0.1透明度的黑色背景
    });
    $.ajax({ 
        type: 'post', 
        url: '/teacher/liveing/addFiles', //上传文件的请求路径必须是绝对路劲
        data: formData, 
        dataType:'json',
        cache: false, 
        processData: false, 
        contentType: false, 
        success:function(data){
            if(data.code==0){
                layer.close(index);
                handelRes(data);
                return !1;
            }
            
            if(!whiteWebSdk){
                whiteWebSdk = new WhiteWebSdk();
            }
            
            // roomToken 鉴权使用
            var pptConverter = whiteWebSdk.pptConverter(""+_DATA.roominfo.roomtoken);
            getscencs();
            // 请求转码，获得每一个页面的数据
            async function getscencs(){
                var res = await pptConverter.convert({
                    // 需要进行转换资源的网络地址，请确保可以正常访问
                    url: data.data.url,
                    // 转换类型
                    kind: "static", 
                    // 转换进度监听
                    onProgressUpdated: progress => {
                      // console.log(progress);
                    },
                    checkProgressInterval: 1500,
                    checkProgressTimeout: 5 * 60 * 1000,
                });
                layer.close(index);
                // console.log(res);
                var file_uuid=res.uuid;
                $.ajax({
                    type: "POST",
                    url:'/teacher/liveing/upfileuuid',
                    data:{courseid:courseid,lessonid:lessonid,file_uuid:file_uuid},
                    error: function(request)
                    {
                        layer.msg("数据请求失败");
                    },
                    success: function(data)
                    {
                    }
                })
                
                whiteroom.file_uuid=file_uuid; //文档转图片的唯一id
                whiteroom.putScenes('/'+file_uuid, res.scenes);
                whiteroom.setScenePath('/'+file_uuid+'/'+res.scenes[0].name);
                
                addPptPage();
               
            }
        },error(){

        }
    })
}

/**PPT等文档翻页 */
function pageNext(){
    
    var page=parseInt(whiteroom.state.sceneState.index)+1;
    var maxpages=whiteroom.state.sceneState.scenes.length;
    
    //if(whiteroom.state.sceneState.scenePath=='/init'){}
    if(page+1 >  maxpages ){
        layer.msg('已经到最后一页了');
    }else{
        // whiteroom.setSceneIndex(pages);
        whiteroom.pptNextStep(); // 下一步（下一页）
        upPage();
    }
}

function pageTop(){
    
    var page=parseInt(whiteroom.state.sceneState.index)+1;
    
    if(page==1){
        layer.msg('已经到第一页了');
    }else{
        
        whiteroom.pptPreviousStep() // 上一步（上一页）
        upPage();
    }
    
}


function backWhite(){
    whiteroom.setScenePath('/init');
    addPagePpt();
}


function backWhitePpt(){
    whiteroom.setScenePath('/'+whiteroom.file_uuid+'/1');
    whiteroom.setSceneIndex(0);
    addPptPage();
    
}
function addPagePpt(){
    
    $('.ppt_preview').removeClass('on');
    
    $('#whiteboard').find('.whiteboard_page').remove();
    $('#whiteboard').find('.whiteboard_page_ppt').remove();
     
    var html='<div class="whiteboard_page_ppt">\
                <a href="javascript:void(0)"><img class="whiteboard_page_white" onclick="backWhitePpt()" src="/static/teacher/images/white/white.png"></a>\
            </div>';

    $('#whiteboard').append(html);
}
function hidePagePpt(){
    $('.ppt_preview').removeClass('on');
    
    $('#whiteboard').find('.whiteboard_page').remove();
    $('#whiteboard').find('.whiteboard_page_ppt').remove();
}
function addPptPage(){
    
    $('.ppt_preview').removeClass('on');
    
    $('#whiteboard').find('.whiteboard_page').remove();
    $('#whiteboard').find('.whiteboard_page_ppt').remove();

    var page=parseInt(whiteroom.state.sceneState.index)+1;

    var maxpages=whiteroom.state.sceneState.scenes.length;
    var html='<div class="whiteboard_page">\
                <a href="javascript:void(0)"><img class="whiteboard_page_left" onclick="pageTop()" src="/static/teacher/images/white/left.png"></a>\
                <a href="javascript:void(0)" class="whiteboard_preview" onclick="pptpreview(1)" ><img  src="/static/teacher/images/white/ppt_preview.png">\
                <span class="whiteboard_page_1">'+page+'</span>\
                <span class="whiteboard_page_2">/</span>\
                <span class="whiteboard_page_3">'+maxpages+'</span></a>\
                <a href="javascript:void(0)"><img class="whiteboard_page_right" onclick="pageNext()" src="/static/teacher/images/white/right.png"></a>\
                <a href="javascript:void(0)"><img class="whiteboard_page_white" onclick="backWhite()" src="/static/teacher/images/white/white.png"></a>\
            </div>';

    $('#whiteboard').append(html);
}

function upPage(){
    var index=parseInt(whiteroom.state.sceneState.index);
    var page=index+1;
    var maxpages=whiteroom.state.sceneState.scenes.length;
    
    $('.whiteboard_page_1').text(page);
    $('.whiteboard_page_3').text(maxpages);
    
    if(!$('.ppt_preview').is(":hidden")){
        $('.ppt_preview').find('.ppt_preview_m ul li').removeClass('on').eq(index).addClass('on');
    }
}

function pptpreview(type=0){
    if(type==1){
        if($('.ppt_preview').hasClass("on")){
            $('.ppt_preview').removeClass('on');
            return !1;
        }
    }
    var sceneState=whiteroom.state.sceneState;
    console.log(sceneState);
    var list=sceneState.scenes;
    var index=sceneState.index;
    var nums=list.length;
    var html='';
    for(var i=0;i<nums;i++){
        var v=list[i];
        var n=i+1;
        var css='';
        if(index==i){
            css="on";
        }
        html+='<li class="'+css+'" data-page="'+i+'" data-path="/'+whiteroom.file_uuid+'/'+v.name+'">\
                    <div class="ppt_nums">'+n+'</div>\
                    <div class="ppt_view"><img src="'+v.ppt.src+'"></div>\
                    <div class="ppt_btn">\
                        <span class="ppt_btn_del">X</span>\
                    </div>\
                </li>';
    }
    
    $('.ppt_preview').find('.ppt_preview_m ul').html(html);
    $('.ppt_preview').addClass("on");
}




















