<?php
 namespace App\Http\Controllers\Main; use App\Http\Controllers\BaseController; use App\Types\EventOrderItemStatus; use App\Types\EventOrderStatus; use App\Types\EventStatus; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\InputPackage; use TechOnline\Laravel\Http\Response; use TechOnline\Utils\RandomUtil; use TechSoft\Laravel\EXField\EXFieldUtil; use TechSoft\Laravel\Shop\Util\ShopUtil; class EventController extends BaseController { public function index($id) { $event = ModelUtil::get('event', ['id' => $id]); if (empty($event)) { return Response::send(-1, 'no record', null, '/'); } $event['_category'] = ModelUtil::get('event_category', ['id' => $event['categoryId']]); ModelUtil::decodeRecordJson($event, 'photos'); ModelUtil::decodeRecordJson($event, 'param'); EXFieldUtil::unbuildTableFieldRow($event); return $this->_view('event.index', compact('event')); } public function submit($id) { if (!$this->memberUserId()) { return Response::send(-1, '还没有登录', null, '/login?redirect=' . urlencode('/event/' . $id)); } $event = ModelUtil::get('event', ['id' => $id]); if (empty($event)) { return Response::send(-1, 'no record', null, '/'); } for ($i = 1; $i < 5; $i++) { ModelUtil::decodeRecordJson($event, 'fieldCustom' . $i); } if ($event['status'] != EventStatus::APPLYING) { return Response::send(-1, '当前状态不能报名'); } if ($event['applyTimeLimit'] && (time() < strtotime($event['applyStartTime']) || time() > strtotime($event['applyEndTime']))) { return Response::send(-1, '已经不能报名'); } $input = InputPackage::buildFromInput(); $eventOrderItem = []; for ($i = 1; $i < 5; $i++) { if (empty($event['fieldCustom' . $i])) { continue; } $eventOrderItem['fieldCustom' . $i] = $input->getTrimString('fieldCustom' . $i); if (empty($eventOrderItem['fieldCustom' . $i])) { return Response::send(-1, $event['fieldCustom' . $i]['title'] . '不能为空'); } } try { ModelUtil::transactionBegin(); $event = ModelUtil::getWithLock('event', ['id' => $id]); if ($event['applyNumberLimit']) { $payedTotal = ModelUtil::count('event_order_item', ['eventId' => $event['id'], 'orderStatus' => EventOrderStatus::WAIT_PAY]); $unpayedTotal = ModelUtil::count('event_order_item', ['eventId' => $event['id'], 'orderStatus' => EventOrderStatus::COMPLETED]); if ($payedTotal + $unpayedTotal >= $event['applyNumberMax']) { ModelUtil::transactionCommit(); return Response::send(-1, '报名人数已满'); } } $order = []; $order['sn'] = ShopUtil::generateSN(); $order['memberUserId'] = $this->memberUserId(); $order['status'] = EventOrderStatus::WAIT_PAY; $order['totalFee'] = $event['price']; $order['payFee'] = $event['price']; $order = ModelUtil::insert('event_order', $order); $eventOrderItem['memberUserId'] = $this->memberUserId(); $eventOrderItem['orderId'] = $order['id']; $eventOrderItem['eventId'] = $event['id']; $eventOrderItem['checkCode'] = RandomUtil::number(10); $eventOrderItem['orderStatus'] = $order['status']; $eventOrderItem['status'] = EventOrderItemStatus::WAIT_SIGN_IN; ModelUtil::insert('event_order_item', $eventOrderItem); ModelUtil::transactionCommit(); return Response::send(0, null, null, '/member/order_pay/' . $order['id']); } catch (\Exception $e) { ModelUtil::transactionRollback(); throw $e; } } }