<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEvent extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('categoryId')->comment('类别ID')->nullable();

            /** @see \App\Types\EventShowStatus */
            $table->tinyInteger('showStatus')->comment('在线状态')->nullable();

            /** @see \App\Types\EventStatus */
            $table->tinyInteger('status')->comment('正在报名')->nullable();

            $table->timestamp('time')->comment('课程时间')->nullable();

            $table->tinyInteger('applyTimeLimit')->comment('报名开始截止时间限制')->nullable();
            $table->timestamp('applyStartTime')->comment('报名开始时间')->nullable();
            $table->timestamp('applyEndTime')->comment('报名截止时间')->nullable();

            $table->boolean('applyNumberLimit')->comment('报名人数限制')->nullable();
            $table->integer('applyNumberMax')->comment('最大报名人数')->nullable();

            $table->decimal('price', 20, 2)->comment('报名价格,0表示免费')->nullable();

            $table->string('title', 100)->comment('名称')->nullable();
            $table->string('summary', 500)->comment('简要描述')->nullable();
            $table->string('cover', 100)->comment('头图')->nullable();
            $table->string('photos', 2000)->comment('宣传照片')->nullable();

            $table->text('param')->comment('课程属性')->nullable();

            $table->text('applyText')->comment('报名说明')->nullable();
            $table->text('applySuccessText')->comment('报名成功说明')->nullable();

            /** 这个字段已废弃 */
            $table->text('applyInfo')->comment('报名需要填写的字段')->nullable();

            $table->text('content')->comment('内容描述')->nullable();

            $table->index(['categoryId']);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
