<?php
namespace App\Http\Controllers\Admin;

use App\Types\EventShowStatus;
use App\Types\EventStatus;
use Edwin404\Admin\Cms\Field\FieldAttr;
use Edwin404\Admin\Cms\Field\FieldCategory;
use Edwin404\Admin\Cms\Field\FieldDate;
use Edwin404\Admin\Cms\Field\FieldDatetime;
use Edwin404\Admin\Cms\Field\FieldFields;
use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldImages;
use Edwin404\Admin\Cms\Field\FieldRichtext;
use Edwin404\Admin\Cms\Field\FieldSelect;
use Edwin404\Admin\Cms\Field\FieldSwitch;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;

class EventController extends AdminCheckController
{
    private $cmsConfigData = [
        'model' => 'event',
        'pageTitle' => '课程',
        'group' => 'data',
        'maxLevel' => 1,
        'canAdd' => true,
        'canEdit' => true,
        'canDelete' => true,
        'canView' => true,
        'canSort' => true,
        'fields' => [
            'categoryId' => ['type' => FieldCategory::class, 'title' => '分类', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'model' => 'event_category'],
            'title' => ['type' => FieldText::class, 'title' => '名称', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
            'time' => ['type' => FieldDatetime::class, 'title' => '课程时间', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => EventShowStatus::class],
            'showStatus' => ['type' => FieldSelect::class, 'title' => '显示', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => EventShowStatus::class],
            'status' => ['type' => FieldSelect::class, 'title' => '课程状态', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'optionType' => EventStatus::class],
            'applyTimeLimit' => ['type' => FieldSwitch::class, 'title' => '限制报名时间', 'add' => true, 'edit' => true, 'view' => true,],
            'applyStartTime' => ['type' => FieldDatetime::class, 'title' => '开始报名时间', 'add' => true, 'edit' => true, 'view' => true,],
            'applyEndTime' => ['type' => FieldDatetime::class, 'title' => '结束报名时间', 'add' => true, 'edit' => true, 'view' => true,],
            'applyNumberLimit' => ['type' => FieldSwitch::class, 'title' => '限制报名人数', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,],
            'applyNumberMax' => ['type' => FieldText::class, 'title' => '最大报名人数', 'add' => true, 'edit' => true, 'view' => true,],
            'price' => ['type' => FieldText::class, 'title' => '价格', 'list' => true, 'add' => true, 'edit' => true, 'view' => true, 'desc' => '0表示免费'],
            'summary' => ['type' => FieldTextarea::class, 'title' => '课程简要说明', 'add' => true, 'edit' => true, 'view' => true,],
            'cover' => ['type' => FieldImage::class, 'title' => '课程封面', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,],
            'photos' => ['type' => FieldImages::class, 'title' => '课程轮播图片', 'list' => true, 'add' => true, 'edit' => true, 'view' => true,],
            'param' => ['type' => FieldAttr::class, 'title' => '课程属性', 'add' => true, 'edit' => true, 'view' => true, 'desc' => '如参加地点,注意事项等'],
            'applyText' => ['type' => FieldRichtext::class, 'title' => '申请说明', 'add' => true, 'edit' => true, 'view' => true, 'desc' => '在用户申请之前显示给用户'],
            'applySuccessText' => ['type' => FieldRichtext::class, 'title' => '申请成功说明', 'add' => true, 'edit' => true, 'view' => true, 'desc' => '在用户申请并付款成功之后显示给用户'],
            'applyInfo' => ['type' => FieldFields::class, 'title' => '报名字段', 'add' => true, 'edit' => true, 'view' => true,],
            'content' => ['type' => FieldRichtext::class, 'title' => '课程说明', 'add' => true, 'edit' => true, 'view' => true,],
        ]
    ];

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigData);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        return $basicCms->executeAdd($this, $this->cmsConfigData);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        return $basicCms->executeEdit($this, $this->cmsConfigData);
    }

    public function dataDelete(BasicCms $basicCms)
    {
        return $basicCms->executeDelete($this, $this->cmsConfigData);
    }

    public function dataView(BasicCms $basicCms)
    {
        return $basicCms->executeView($this, $this->cmsConfigData);
    }

}