<?php
namespace App\Http\Controllers\Admin;

use Edwin404\Admin\Cms\Field\FieldDatetime;
use Edwin404\Admin\Cms\Field\FieldEmpty;
use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;

class ForumThreadController extends AdminCheckController
{
    private $cmsConfigData = [
        'model' => 'forum_thread',
        'pageTitle' => '帖子列表',
        'group' => 'data',
        'canView' => true,
        'fields' => [
            'title' => ['type' => FieldText::class, 'title' => '名称', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
            'created_at' => ['type' => FieldDatetime::class, 'title' => '时间', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
//            'desc' => ['type' => FieldText::class, 'title' => '描述', 'list' => true, 'add' => true, 'edit' => true, 'view' => true],
//            '_admin' => ['type' => FieldEmpty::class, 'title' => '分类管理员', 'list' => true,],
        ]
    ];

    public function dataProcessView(&$item, &$record)
    {
        $item['title'] = '<a href="' . action('\App\Http\Controllers\Main\ThreadController@index', ['id' => $record['id']]) . '" target="_blank">' . htmlspecialchars($record['title']) . '</a>';
    }

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigData);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        return $basicCms->executeAdd($this, $this->cmsConfigData);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        return $basicCms->executeEdit($this, $this->cmsConfigData);
    }

    public function dataDelete(BasicCms $basicCms)
    {
        return $basicCms->executeDelete($this, $this->cmsConfigData);
    }

    public function dataView(BasicCms $basicCms)
    {
        return $basicCms->executeView($this, $this->cmsConfigData);
    }


}