<?php

namespace App\Http\Controllers\Admin;


use App\Types\EventOrderStatus;
use Edwin404\Admin\Cms\Field\FieldDatetime;
use Edwin404\Admin\Cms\Field\FieldEmpty;
use Edwin404\Admin\Cms\Field\FieldSelect;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\InputHelper;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Shop\Services\GoodsService;
use Edwin404\Shop\Types\OrderStatus;
use Edwin404\SmartAssets\Helper\AssetsHelper;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;

class OrderController extends AdminCheckController
{
    private $cmsConfigBasic = [
        'model' => 'event_order',
        'pageTitle' => '订单管理',
        'group' => 'data',
        'canView' => true,
        'fields' => [
            'created_at' => ['type' => FieldDatetime::class, 'title' => '时间', 'list' => true,],
            'sn' => ['type' => FieldText::class, 'title' => '订单号', 'list' => true, 'search' => true,],
            'totalFee' => ['type' => FieldText::class, 'title' => '总价格', 'list' => true,],
            'payFee' => ['type' => FieldText::class, 'title' => '支付价格', 'list' => true,],
            'status' => ['type' => FieldSelect::class, 'title' => '状态', 'list' => true, 'edit' => true, 'add' => true, 'search' => true, 'optionType' => OrderStatus::class],
            '_memberUser' => ['type' => FieldEmpty::class, 'title' => '用户', 'list' => true,],
            '_event' => ['type' => FieldEmpty::class, 'title' => '商品', 'list' => true,],
        ]
    ];

    public function dataProcessView(&$item, &$record)
    {
        $statusColorMap = [
            EventOrderStatus::WAIT_PAY => '<span class="uk-text-muted">待付款</span>',
            EventOrderStatus::WAIT_SIGN_IN => '<span class="uk-text-warning">等待参与</span>',
            EventOrderStatus::COMPLETED => '<span class="uk-text-success">已完成</span>',
            EventOrderStatus::ABSENT => '<span class="uk-text-warning">缺席未参与</span>',
            EventOrderStatus::EXPIRED => '<span class="uk-text-muted">已过期</span>',
        ];
        if (isset($statusColorMap[$record['status']])) {
            $item['status'] = $statusColorMap[$record['status']];
        }

    }

    public function dataProcessViewField($key, &$record)
    {
        switch ($key) {
            case '_memberUser':
                $memberUser = ModelHelper::load('member_user', ['id' => $record['memberUserId']]);
                if (empty($memberUser)) {
                    return '[未知用户]';
                }
                return '<a href="javascript:;" data-dialog-request="' . action('\App\Http\Controllers\Admin\MemberController@dataView', ['id' => $record['memberUserId']]) . '"><img src="' . AssetsHelper::fix($memberUser['avatar']) . '" style="width:30px;height:30px;" />' . htmlspecialchars($memberUser['username']) . '</a>';
            case '_event':
                $event = ModelHelper::load('event', ['id' => $record['eventId']]);
                return '<a href="/event/' . $event['id'] . '" target="_blank">' . $event['title'] . '</a>';
        }
    }

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);
    }

    public function dataView()
    {
        $orderId = intval(Input::get('_id'));
        $order = ModelHelper::load('event_order', ['id' => $orderId]);

        if (Request::isMethod('post')) {

            if (Session::get('_adminUserId', null) && env('ADMIN_DEMO_USER_ID', 0) && Session::get('_adminUserId', null) == env('ADMIN_DEMO_USER_ID', 0)) {
                return Response::send(-1, '演示账号禁止该操作');
            }

            $data = [];
            $data['status'] = InputHelper::getType('status', OrderStatus::class, null);
            $payFee = trim(Input::get('payFee'));
            if ($order['status'] == EventOrderStatus::WAIT_PAY && $payFee) {
                $data['payFee'] = $payFee;
            }

            ModelHelper::updateOne('event_order', ['id' => $order['id']], $data);

            return Response::send(-1, null, null, '[js]window.parent.lister.load(false);$.dialogClose();');
        }

        ModelHelper::decodeRecordJson($order, 'applyInfo');

        $order['_event'] = ModelHelper::load('event', ['id' => $order['eventId']]);

        return view('admin.order.view', compact('order'));
    }

}