<?php

namespace App\Http\Controllers\Main;

use App\Http\Controllers\Support\BaseController;
use App\Types\EventShowStatus;
use Edwin404\Banner\Services\BannerService;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\PageHelper;
use Edwin404\Forum\Services\ForumService;
use Edwin404\Tecmz\Traits\MemberAccountTrait;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\View;

class CategoryController extends BaseController
{
    public function index($id = 0)
    {
        $page = intval(Input::get('page', 1));
        $pageSize = 12;
        $option = [];
        $option['order'] = ['id', 'desc'];
        $option['where'] = [];
        $option['where']['showStatus'] = EventShowStatus::SHOW;
        if ($id) {
            $option['where'] ['categoryId'] = $id;
        }

        $eventCategories = ModelHelper::find('event_category', ['pid' => 0]);

        $paginateData = ModelHelper::modelPaginate('event', $page, $pageSize, $option);
        $events = $paginateData['records'];
        $pageHtml = PageHelper::render($paginateData['total'], $pageSize, $page, View::shared('request_path') . '?page={page}');

        $currentCategory = null;
        if ($id) {
            $currentCategory = ModelHelper::load('event_category', ['id' => $id]);
        }

        return $this->_view('category.index', compact('eventCategories', 'events', 'pageHtml', 'currentCategory'));
    }

}