<?php

Route::group(
    [
        'middleware' => [
            \Edwin404\Base\Support\BaseMiddleware::class,
            \App\Http\Middleware\MemberAuth::class,
        ]
    ],
    function () {

        Route::any('', '\App\Http\Controllers\Main\IndexController@index');

        Route::any('login', '\App\Http\Controllers\Main\IndexController@login');
        Route::any('logout', '\App\Http\Controllers\Main\IndexController@logout');
        Route::any('register', '\App\Http\Controllers\Main\IndexController@register');
        Route::any('retrieve', '\App\Http\Controllers\Main\IndexController@retrieve');
        Route::any('retrieve/email', '\App\Http\Controllers\Main\IndexController@retrieveEmail');
        Route::any('retrieve/email_verify', '\App\Http\Controllers\Main\IndexController@retrieveEmailVerify');
        Route::any('retrieve/phone', '\App\Http\Controllers\Main\IndexController@retrievePhone');
        Route::any('retrieve/phone_verify', '\App\Http\Controllers\Main\IndexController@retrievePhoneVerify');
        Route::any('retrieve/captcha', '\App\Http\Controllers\Main\IndexController@retrieveCaptcha');
        Route::any('retrieve/reset', '\App\Http\Controllers\Main\IndexController@retrieveReset');
        Route::any('oauth_login_{oauthType}', '\App\Http\Controllers\Main\IndexController@oauthLogin');
        Route::any('oauth_callback_{oauthType}', '\App\Http\Controllers\Main\IndexController@oauthCallback');
        Route::any('oauth_bind_{oauthType}', '\App\Http\Controllers\Main\IndexController@oauthBind');
        Route::any('oauth_wechat_proxy', '\App\Http\Controllers\Main\IndexController@oauthWechatProxy');

        Route::get('sso/client', '\App\Http\Controllers\Main\IndexController@ssoClient');
        Route::get('sso/server', '\App\Http\Controllers\Main\IndexController@ssoServer');
        Route::get('sso/server_success', '\App\Http\Controllers\Main\IndexController@ssoServerSuccess');
        Route::get('sso/server_logout', '\App\Http\Controllers\Main\IndexController@ssoServerLogout');

        Route::any('data/image_select_dialog', '\App\Http\Controllers\Main\DataController@imageSelectDialog');
        Route::any('data/temp_upload/{category}', '\App\Http\Controllers\Main\DataController@tempUpload');

        Route::any('category', '\App\Http\Controllers\Main\CategoryController@index');
        Route::any('category/{id}', '\App\Http\Controllers\Main\CategoryController@index')->where(['id' => '[0-9]+']);

        Route::any('event/{id}', '\App\Http\Controllers\Main\EventController@index')->where(['id' => '[0-9]+']);
        Route::any('event/{id}/submit', '\App\Http\Controllers\Main\EventController@submit')->where(['id' => '[0-9]+']);

        Route::any('member/order', '\App\Http\Controllers\Main\MemberOrderController@index');
        Route::any('member/order_pay/{id}', '\App\Http\Controllers\Main\MemberOrderController@pay')->where(['id' => '[0-9]+']);
        Route::any('member/order_pay_watch/{id}', '\App\Http\Controllers\Main\MemberOrderController@payWatch')->where(['id' => '[0-9]+']);
        Route::any('member/order_detail/{id}', '\App\Http\Controllers\Main\MemberOrderController@detail')->where(['id' => '[0-9]+']);

        Route::any('member', '\App\Http\Controllers\Main\MemberController@index');

        Route::any('member/profile_captcha', '\App\Http\Controllers\Main\MemberProfileController@captcha');
        Route::any('member/profile', '\App\Http\Controllers\Main\MemberProfileController@index');
        Route::any('member/profile_password', '\App\Http\Controllers\Main\MemberProfileController@password');
        Route::any('member/profile_avatar', '\App\Http\Controllers\Main\MemberProfileController@avatar');
        Route::any('member/profile_email', '\App\Http\Controllers\Main\MemberProfileController@email');
        Route::any('member/profile_email_verify', '\App\Http\Controllers\Main\MemberProfileController@emailVerify');
        Route::any('member/profile_phone', '\App\Http\Controllers\Main\MemberProfileController@phone');
        Route::any('member/profile_phone_verify', '\App\Http\Controllers\Main\MemberProfileController@phoneVerify');

        Route::any('member/message', '\App\Http\Controllers\Main\MemberMessageController@index');
        Route::any('member/message_mark_read', '\App\Http\Controllers\Main\MemberMessageController@markRead');
        Route::any('member/message_mark_read_all', '\App\Http\Controllers\Main\MemberMessageController@markReadAll');

        Route::any('article/{id}', '\App\Http\Controllers\Main\ArticleController@index')->where(['id' => '[0-9]+']);

    }
);

if (file_exists(__DIR__ . '/routes_custom.php')) {
    include __DIR__ . '/routes_custom.php';
}

Route::any('placeholder/{width}x{height}', '\Edwin404\Placeholder\Controllers\PlaceholderController@index');
Route::any('install/ping', '\Edwin404\Tecmz\Controllers\InstallController@ping');
Route::any('install/execute', '\Edwin404\Tecmz\Controllers\InstallController@execute');
Route::any('install/lock', '\Edwin404\Tecmz\Controllers\InstallController@lock');

Route::any('pay/return/{payType}', '\Edwin404\Pay\Controllers\ReturnController@index');
Route::any('pay/notify/{payType}', '\Edwin404\Pay\Controllers\NotifyController@index');

Route::any('detect_device', '\App\Http\Controllers\Main\IndexController@detectDevice');

include __DIR__ . '/routes_admin.php';
