<?php

Route::group(
    [
        'prefix' => env('ADMIN_PATH', '/admin/'),
        'middleware' => [
            \Edwin404\Admin\Http\Middleware\AdminWebAuth::class,
        ]
    ], function () {

    // 公用
    include __DIR__ . '/../../vendor/edwin404/laravel-admin/src/Config/routes.php';
    Route::any('', '\App\Http\Controllers\Admin\IndexController@index');
    Route::any('system/data/image_select_dialog', '\Edwin404\Admin\Http\Controllers\DataController@imageSelectDialog');
    Route::any('system/data/temp_data_upload/{category}', '\Edwin404\Admin\Http\Controllers\DataController@tempDataUpload');
    // 公用

    Route::any('event_category/list', '\App\Http\Controllers\Admin\EventCategoryController@dataList');
    Route::any('event_category/view', '\App\Http\Controllers\Admin\EventCategoryController@dataView');
    Route::any('event_category/edit', '\App\Http\Controllers\Admin\EventCategoryController@dataEdit');
    Route::any('event_category/add', '\App\Http\Controllers\Admin\EventCategoryController@dataAdd');
    Route::any('event_category/delete', '\App\Http\Controllers\Admin\EventCategoryController@dataDelete');
    Route::any('event_category/sort', '\App\Http\Controllers\Admin\EventCategoryController@dataSort');

    Route::any('event/list', '\App\Http\Controllers\Admin\EventController@dataList');
    Route::any('event/view', '\App\Http\Controllers\Admin\EventController@dataView');
    Route::any('event/edit', '\App\Http\Controllers\Admin\EventController@dataEdit');
    Route::any('event/add', '\App\Http\Controllers\Admin\EventController@dataAdd');
    Route::any('event/delete', '\App\Http\Controllers\Admin\EventController@dataDelete');

    Route::any('member/list', '\App\Http\Controllers\Admin\MemberController@dataList');
    Route::any('member/view', '\App\Http\Controllers\Admin\MemberController@dataView');
    Route::any('member/edit', '\App\Http\Controllers\Admin\MemberController@dataEdit');
    Route::any('member/add', '\App\Http\Controllers\Admin\MemberController@dataAdd');
    Route::any('member/delete', '\App\Http\Controllers\Admin\MemberController@dataDelete');
    Route::any('member/export', '\App\Http\Controllers\Admin\MemberController@dataExport');

    Route::any('order/list', '\App\Http\Controllers\Admin\OrderController@dataList');
    Route::any('order/view', '\App\Http\Controllers\Admin\OrderController@dataView');
    Route::any('order/edit', '\App\Http\Controllers\Admin\OrderController@dataEdit');
    Route::any('order/delete', '\App\Http\Controllers\Admin\OrderController@dataDelete');

    Route::any('banner/list', '\App\Http\Controllers\Admin\BannerController@dataList');
    Route::any('banner/view', '\App\Http\Controllers\Admin\BannerController@dataView');
    Route::any('banner/edit', '\App\Http\Controllers\Admin\BannerController@dataEdit');
    Route::any('banner/add', '\App\Http\Controllers\Admin\BannerController@dataAdd');
    Route::any('banner/delete', '\App\Http\Controllers\Admin\BannerController@dataDelete');

    Route::any('article/list', '\App\Http\Controllers\Admin\ArticleController@dataList');
    Route::any('article/view', '\App\Http\Controllers\Admin\ArticleController@dataView');
    Route::any('article/edit', '\App\Http\Controllers\Admin\ArticleController@dataEdit');
    Route::any('article/add', '\App\Http\Controllers\Admin\ArticleController@dataAdd');
    Route::any('article/delete', '\App\Http\Controllers\Admin\ArticleController@dataDelete');

    Route::any('config/setting', '\App\Http\Controllers\Admin\ConfigController@setting');
    Route::any('config/email', '\App\Http\Controllers\Admin\ConfigController@email');
    Route::any('config/sms', '\App\Http\Controllers\Admin\ConfigController@sms');
    Route::any('config/visit', '\App\Http\Controllers\Admin\ConfigController@visit');
    Route::any('config/register', '\App\Http\Controllers\Admin\ConfigController@register');
    Route::any('config/pay_alipay', '\App\Http\Controllers\Admin\ConfigController@payAlipay');
    Route::any('config/pay_wechat_mobile', '\App\Http\Controllers\Admin\ConfigController@payWechatMobile');
    Route::any('config/pay_wechat', '\App\Http\Controllers\Admin\ConfigController@payWechat');
    Route::any('config/oauth_qq', '\App\Http\Controllers\Admin\ConfigController@oauthQQ');
    Route::any('config/oauth_wechat', '\App\Http\Controllers\Admin\ConfigController@oauthWechat');
    Route::any('config/oauth_weibo', '\App\Http\Controllers\Admin\ConfigController@oauthWeibo');
    Route::any('config/retrieve', '\App\Http\Controllers\Admin\ConfigController@retrieve');
    Route::any('config/contact', '\App\Http\Controllers\Admin\ConfigController@contact');

    Route::any('config/sso_server', '\App\Http\Controllers\Admin\ConfigController@ssoServer');
    Route::any('config/sso_client', '\App\Http\Controllers\Admin\ConfigController@ssoClient');

});
