<?php

namespace App\Listeners;

use App\Constant\PayConstant;
use App\Types\EventOrderStatus;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Pay\Events\OrderPayedEvent;
use Edwin404\Shop\Types\OrderStatus;
use Illuminate\Support\Facades\Log;

class PayListener
{
    public function onOrderPayed(OrderPayedEvent $event)
    {
        Log::info('order payed -> ' . print_r($event, true));

        $biz = $event->biz;
        $bizId = $event->bizId;

        switch ($biz) {
            case PayConstant::BIZ_ORDER:
                ModelHelper::updateOne('event_order', ['id' => $bizId], ['status' => EventOrderStatus::WAIT_SIGN_IN]);
                break;
        }

    }

    public function subscribe($events)
    {
        $events->listen(
            OrderPayedEvent::class,
            '\App\Listeners\PayListener@onOrderPayed'
        );
    }
}