@extends('admin::frameDialog')

@section('pageTitle','订单详情')

@section('dialogBody')

    <div class="admin-form">
        <form action="?" method="post" data-ajax-form class="uk-form">
            <input type="hidden" name="_id" value="{{\Illuminate\Support\Facades\Input::get('_id','')}}" />
            <table>
                <tbody>
                <tr>
                    <td>
                        <div class="line">
                            <div class="label">
                                订单号
                            </div>
                            <div class="value">
                                {{$order['sn']}} / {{$order['created_at']}}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="line">
                            <div class="label">
                                状态
                            </div>
                            <div class="field">
                                <select name="status">
                                    @foreach(\App\Types\EventOrderStatus::getList() as $k=>$v)
                                        <option value="{{$k}}" @if($k==$order['status']) selected @endif >{{$v}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="line">
                            <div class="label">订单信息</div>
                            <div class="value">

                                <table class="uk-table" style="border:2px solid #CCC;">
                                    <thead style="border-bottom:2px solid #CCC;">
                                        <tr>
                                            <th width="300">项目</th>
                                            <th>信息</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <a style="width:60px;height:60px;float:left;display:block;margin-right:10px;" class="cover-1-1" href="/event/{{$order['_event']['id']}}" target="_blank">
                                                    <img src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($order['_event']['cover'])}}" />
                                                </a>
                                                <a class="title" href="/event/{{$order['_event']['id']}}" target="_blank">
                                                    {{$order['_event']['title']}}
                                                </a>
                                            </td>
                                            <td>
                                                @if(!empty($order['applyInfo']))
                                                    <div class="buyInfo">
                                                        @foreach($order['applyInfo'] as $item)
                                                            {{$item['name']}}:{{$item['value']}}
                                                            <br />
                                                        @endforeach
                                                    </div>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="5" class="uk-text-right" style="font-style:normal;">
                                                <div>
                                                    总计：{{$order['totalFee']}}
                                                </div>
                                                <div style="display:none;" data-payFee-edit>
                                                    修改支付价格：
                                                    <input type="text" name="payFee" value="" placeholder="留空表示不修改" />
                                                </div>
                                                <div>
                                                    实际支付：{{$order['payFee']}}
                                                    @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                                        <a href="javascript:;" onclick="$(this).hide();$('[data-payFee-edit]').show();"><i class="uk-icon-edit"></i></a>
                                                    @endif
                                                </div>
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>


                            </div>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
        </form>
    </div>

@endsection
