@extends('theme.default.m.frame')

@if($currentCategory)
    @section('pageTitleMain',$currentCategory['title'])
@else
    @section('pageTitleMain','课程')
@endif

@section('bodyContent')

    <div class="page-block">
        <div class="body">
            <div class="main-container">
                <div class="category-list">
                    <div class="filter">
                        <a href="/category" @if($request_path=='/category') class="active" @endif>全部</a>
                        @foreach($eventCategories as $eventCategory)
                            <a href="/category/{{$eventCategory['id']}}" @if($request_path=='/category/'.$eventCategory['id']) class="active" @endif>{{$eventCategory['title']}}</a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-block">
        <div class="body" style="background:none;">
            <div class="category-event-list">
                <div class="list">
                    @if(empty($events))
                        <div class="empty">
                            暂无记录~
                        </div>
                    @else
                        <div class="uk-grid">
                            @foreach($events as $event)
                                <div class="uk-width-1-1">
                                    <a href="/event/{{$event['id']}}" class="item">
                                        <div class="cover" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($event['cover'])}}"></div>
                                        <div class="title uk-text-truncate">
                                            @if($event['status']==\App\Types\EventStatus::APPLYING)
                                                [正在报名]
                                            @else
                                                [{{\Edwin404\Base\Support\TypeHelper::name(\App\Types\EventStatus::class,$event['status'])}}]
                                            @endif
                                            {{$event['title']}}
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="page-container">
        {!! $pageHtml !!}
    </div>



@endsection